/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSCustomPropertyValue;
import io.sf.carte.doc.style.css.ExtendedCSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class BackgroundBuilder
extends ShorthandBuilder {
    private StyleValue bgimage;
    private StyleValue bgposition;
    private StyleValue bgsize;
    private StyleValue bgrepeat;
    private StyleValue bgattachment;
    private StyleValue bgclip;
    private StyleValue bgorigin;
    private boolean appended = false;

    BackgroundBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("background", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 8;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        buf.append(this.getShorthandName()).append(':');
        this.bgimage = this.getCSSValue("background-image");
        this.bgposition = this.computeMultipleSubproperty("background-image", "background-position");
        this.bgsize = this.computeMultipleSubproperty("background-image", "background-size");
        this.bgrepeat = this.computeMultipleSubproperty("background-image", "background-repeat");
        this.bgattachment = this.computeMultipleSubproperty("background-image", "background-attachment");
        this.bgclip = this.computeMultipleSubproperty("background-image", "background-clip");
        this.bgorigin = this.computeMultipleSubproperty("background-image", "background-origin");
        short type = this.bgimage.getCssValueType();
        if (type == 2 && ((ValueList)this.bgimage).isCommaSeparated()) {
            if (!this.appendLayeredBackground(buf, declaredSet, ((ValueList)this.bgimage).getLength())) {
                return false;
            }
        } else {
            byte inheritcheck = this.checkForInherit();
            if (inheritcheck == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                return true;
            }
            if (inheritcheck == 2) {
                return false;
            }
            byte check = this.checkForUnset(buf);
            if (check == 1) {
                buf.append("unset");
                this.appendPriority(buf, important);
                return true;
            }
            if (check == 2) {
                return false;
            }
            if (!this.appendBackgroundImage(buf, this.bgimage)) {
                return false;
            }
            if (!this.appendSingleLayer(buf, declaredSet)) {
                return false;
            }
            if (!this.appended) {
                buf.append("none");
            }
        }
        this.appendPriority(buf, important);
        return true;
    }

    private StyleValue computeMultipleSubproperty(String masterProperty, String propertyName) {
        return this.getParentStyle().computeBoundProperty(masterProperty, propertyName, this.getCSSValue(propertyName));
    }

    private byte checkForInherit() {
        return this.checkForInherit(this.bgimage, this.bgposition, this.bgsize, this.bgrepeat, this.bgattachment, this.bgclip, this.bgorigin, this.getCSSValue("background-color"));
    }

    private byte checkForInherit(StyleValue bimg, StyleValue bpos, StyleValue bsize, StyleValue brepeat, StyleValue battach, StyleValue bclip, StyleValue borigin, StyleValue bcolor) {
        byte check = this.checkForInherit(bimg, bpos, bsize, brepeat, battach, bclip, borigin);
        if (check == 2) {
            return 2;
        }
        if (this.isInherit(bcolor) ? check == 0 : check == 1) {
            return 2;
        }
        return check;
    }

    private byte checkForInherit(StyleValue bimg, StyleValue bpos, StyleValue bsize, StyleValue brepeat, StyleValue battach, StyleValue bclip, StyleValue borigin) {
        int count = 0;
        if (this.isInherit(bimg)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(bpos)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(bsize)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(brepeat)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(battach)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(bclip)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(borigin)) {
            count = (byte)(count + 1);
        }
        switch (count) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkForInherit(StringBuilder buf, int layerIdx, int lastIndex) {
        if (layerIdx != lastIndex) {
            return this.checkForInherit(((ValueList)this.bgimage).item(layerIdx), ((ValueList)this.bgposition).item(layerIdx), ((ValueList)this.bgsize).item(layerIdx), ((ValueList)this.bgrepeat).item(layerIdx), ((ValueList)this.bgattachment).item(layerIdx), ((ValueList)this.bgclip).item(layerIdx), ((ValueList)this.bgorigin).item(layerIdx));
        }
        return this.checkForInherit(((ValueList)this.bgimage).item(layerIdx), ((ValueList)this.bgposition).item(layerIdx), ((ValueList)this.bgsize).item(layerIdx), ((ValueList)this.bgrepeat).item(layerIdx), ((ValueList)this.bgattachment).item(layerIdx), ((ValueList)this.bgclip).item(layerIdx), ((ValueList)this.bgorigin).item(layerIdx), this.getCSSValue("background-color"));
    }

    private byte checkForUnset(StringBuilder buf) {
        return this.checkForCssKeyword("unset", buf);
    }

    private byte checkForCssKeyword(String keyword, StringBuilder buf) {
        int ucount = 0;
        if (BackgroundBuilder.isCssKeywordValue(keyword, this.bgposition)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, this.bgsize)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, this.bgrepeat)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, this.bgattachment)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, this.bgclip)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, this.bgorigin)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, this.getCSSValue("background-color"))) {
            ucount = (byte)(ucount + 1);
        }
        switch (ucount) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkForUnset(StringBuilder buf, int layerIdx, int lastIndex) {
        return this.checkForCssKeyword("unset", buf, layerIdx, lastIndex);
    }

    private byte checkForCssKeyword(String keyword, StringBuilder buf, int layerIdx, int lastIndex) {
        int fullset;
        int ucount = 0;
        if (BackgroundBuilder.isCssKeywordValue(keyword, ((ValueList)this.bgposition).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, ((ValueList)this.bgsize).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, ((ValueList)this.bgrepeat).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, ((ValueList)this.bgattachment).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, ((ValueList)this.bgclip).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssKeywordValue(keyword, ((ValueList)this.bgorigin).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (layerIdx != lastIndex) {
            fullset = 6;
        } else {
            fullset = 7;
            if (BackgroundBuilder.isCssKeywordValue(keyword, this.getCSSValue("background-color"))) {
                ucount = (byte)(ucount + 1);
            }
        }
        if (ucount == 0) {
            return 0;
        }
        if (ucount == fullset) {
            return 1;
        }
        return 2;
    }

    private boolean isUnsetValue(StyleValue cssValue) {
        return BackgroundBuilder.isCssKeywordValue("unset", cssValue);
    }

    private void appendText(StringBuilder buf, String text) {
        if (this.appended) {
            buf.append(' ');
        } else {
            this.appended = true;
        }
        buf.append(text);
    }

    private boolean appendLayeredBackground(StringBuilder buf, Set<String> declaredSet, int listlen) {
        int szm1 = listlen - 1;
        if (!this.appendLayer(buf, declaredSet, 0, szm1)) {
            return false;
        }
        for (int i = 1; i <= szm1; ++i) {
            this.appended = false;
            buf.append(',');
            if (this.appendLayer(buf, declaredSet, i, szm1)) continue;
            return false;
        }
        return true;
    }

    private boolean appendLayer(StringBuilder buf, Set<String> declaredSet, int index, int lastIndex) {
        StyleValue clip;
        StyleValue origin;
        StyleValue sizeval;
        byte check = this.checkForInherit(buf, index, lastIndex);
        if (check == 1) {
            this.appendText(buf, "inherit");
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkForUnset(buf, index, lastIndex);
        if (check == 1) {
            this.appendText(buf, "unset");
            return true;
        }
        if (check == 2) {
            return false;
        }
        if (declaredSet.contains("background-image") && !this.appendBackgroundImage(buf, ((ValueList)this.bgimage).item(index))) {
            return false;
        }
        ValueList list = (ValueList)this.bgposition;
        StyleValue posval = declaredSet.contains("background-position") ? list.item(index) : null;
        if (!this.appendBackgroundPositionSize(buf, posval, sizeval = declaredSet.contains("background-size") ? ((ValueList)this.bgsize).item(index) : null)) {
            return false;
        }
        if (declaredSet.contains("background-repeat") && !this.appendBackgroundRepeat(buf, ((ValueList)this.bgrepeat).item(index))) {
            return false;
        }
        if (declaredSet.contains("background-attachment") && !this.appendBackgroundAttachment(buf, (list = (ValueList)this.bgattachment).item(index))) {
            return false;
        }
        boolean bcset = declaredSet.contains("background-clip");
        if ((declaredSet.contains("background-origin") || bcset) && !this.appendBackgroundOriginClip(buf, origin = ((ValueList)this.bgorigin).item(index), clip = bcset ? ((ValueList)this.bgclip).item(index) : null)) {
            return false;
        }
        if (declaredSet.contains("background-color") && index == lastIndex && !this.appendBackgroundColor(buf, this.getCSSValue("background-color"))) {
            return false;
        }
        int buflen = buf.length();
        if (buflen == 11 || buf.charAt(buflen - 1) == ',') {
            buf.append("none");
        }
        return true;
    }

    private boolean appendSingleLayer(StringBuilder buf, Set<String> declaredSet) {
        StyleValue clip;
        StyleValue origin;
        StyleValue sizeval;
        StyleValue posval = declaredSet.contains("background-position") ? this.valueOrFirstItem(this.bgposition) : null;
        if (!this.appendBackgroundPositionSize(buf, posval, sizeval = declaredSet.contains("background-size") ? this.valueOrFirstItem(this.bgsize) : null)) {
            return false;
        }
        if (declaredSet.contains("background-repeat") && !this.appendBackgroundRepeat(buf, this.valueOrFirstItem(this.bgrepeat))) {
            return false;
        }
        if (declaredSet.contains("background-attachment") && !this.appendBackgroundAttachment(buf, this.valueOrFirstItem(this.bgattachment))) {
            return false;
        }
        boolean bcset = declaredSet.contains("background-clip");
        if ((declaredSet.contains("background-origin") || bcset) && !this.appendBackgroundOriginClip(buf, origin = this.valueOrFirstItem(this.bgorigin), clip = bcset ? this.valueOrFirstItem(this.bgclip) : null)) {
            return false;
        }
        if (declaredSet.contains("background-color")) {
            StyleValue value = this.getCSSValue("background-color");
            if (value.getCssValueType() == 2) {
                return false;
            }
            if (!this.appendBackgroundColor(buf, value)) {
                return false;
            }
        }
        return true;
    }

    private StyleValue valueOrFirstItem(StyleValue value) {
        ValueList list;
        if (value.getCssValueType() == 2 && (list = (ValueList)value).isCommaSeparated()) {
            return list.item(0);
        }
        return value;
    }

    private boolean appendBackgroundImage(StringBuilder buf, StyleValue value) {
        if (!this.isUnsetValue(value) && this.possibleBackgroundImage(value)) {
            this.appended = this.appendRelativeURI(buf, this.appended, value);
            return true;
        }
        return false;
    }

    private boolean possibleBackgroundImage(StyleValue value) {
        if (value.getCssValueType() == 1) {
            PrimitiveValue primi = (PrimitiveValue)value;
            short type = primi.getPrimitiveType();
            if (type == 21) {
                String s = primi.getStringValue();
                return "none".equalsIgnoreCase(s) || "initial".equalsIgnoreCase(s);
            }
            if (this.isImagePrimitiveValue(primi)) {
                return true;
            }
        }
        return false;
    }

    private boolean appendBackgroundPositionSize(StringBuilder buf, StyleValue posvalue, StyleValue sizevalue) {
        boolean appended = false;
        if (posvalue != null) {
            short type = posvalue.getCssValueType();
            String text = posvalue.getCssText().toLowerCase(Locale.ROOT);
            if (this.isUnsetValue(posvalue)) {
                return false;
            }
            if (type == 1) {
                this.appendText(buf, text);
                appended = true;
            } else if (type == 2) {
                ValueList list = (ValueList)posvalue;
                if (list.isCommaSeparated() || text.indexOf(92) != -1) {
                    return false;
                }
                if (!("0% 0%".equals(text) || "left top".equals(text) || "top left".equals(text) || "initial".equals(text))) {
                    if (list.getLength() != 2 || !"center".equals(list.item(1).getCssText())) {
                        this.appendText(buf, text);
                    } else {
                        this.appendText(buf, list.item(0).getCssText());
                    }
                    appended = true;
                }
            }
        }
        if (sizevalue != null) {
            if (!this.isUnsetValue(sizevalue) && !this.isUnknownIdentifier("background-size", sizevalue)) {
                String text = sizevalue.getMinifiedCssText("background-size").toLowerCase(Locale.ROOT);
                if (!("auto".equals(text) || "auto auto".equals(text) || "initial".equals(text))) {
                    if (!appended) {
                        if (posvalue == null) {
                            posvalue = this.getCSSValue("background-position");
                        }
                        this.appendText(buf, posvalue.getMinifiedCssText("background-position"));
                    }
                    buf.append('/').append(text);
                    appended = true;
                }
            } else {
                return false;
            }
        }
        if (appended) {
            this.appended = true;
        }
        return true;
    }

    private boolean appendBackgroundRepeat(StringBuilder buf, StyleValue value) {
        short type = value.getCssValueType();
        String text = value.getCssText().toLowerCase(Locale.ROOT);
        if (this.isUnsetValue(value) || text.indexOf(92) != -1) {
            return false;
        }
        if (type == 1) {
            if (!"repeat".equals(text) && !"initial".equals(text)) {
                this.appendText(buf, text);
            }
        } else if (type == 2) {
            ValueList list = (ValueList)value;
            if (list.isCommaSeparated()) {
                return false;
            }
            if (!"repeat repeat".equals(text)) {
                if ("no-repeat no-repeat".equals(text)) {
                    this.appendText(buf, "no-repeat");
                } else if ("space space".equals(text)) {
                    this.appendText(buf, "space");
                } else if ("round round".equals(text)) {
                    this.appendText(buf, "round");
                } else if ("repeat no-repeat".equals(text)) {
                    this.appendText(buf, "repeat-x");
                } else if ("no-repeat repeat".equals(text)) {
                    this.appendText(buf, "repeat-y");
                } else {
                    this.appendText(buf, text);
                }
            }
        }
        return true;
    }

    private boolean appendBackgroundAttachment(StringBuilder buf, StyleValue value) {
        if (!this.isUnsetValue(value) && !this.isUnknownIdentifier("background-attachment", value)) {
            String text = value.getMinifiedCssText("background-attachment").toLowerCase(Locale.ROOT);
            if (!"scroll".equals(text) && !"initial".equals(text)) {
                this.appendText(buf, text);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean appendBackgroundOriginClip(StringBuilder buf, StyleValue origin, StyleValue clip) {
        boolean clipIsInitial = false;
        String cliptext = clip.getMinifiedCssText("background-clip").toLowerCase(Locale.ROOT);
        if ("border-box".equals(cliptext) || "initial".equals(cliptext)) {
            clipIsInitial = true;
        }
        if (!this.isUnsetValue(origin) && !this.isUnknownIdentifier("background-origin", origin)) {
            String text = origin.getCssText().toLowerCase(Locale.ROOT);
            if (clip != null && !clipIsInitial || !"padding-box".equals(text) && !"initial".equals(text)) {
                this.appendText(buf, text);
            }
        } else {
            return false;
        }
        if (!this.isUnsetValue(clip) && !this.isUnknownIdentifier("background-clip", clip)) {
            if (!clipIsInitial) {
                this.appendText(buf, cliptext);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean appendBackgroundColor(StringBuilder buf, StyleValue value) {
        if (!this.isUnsetValue(value) && this.isValidColor(value)) {
            String text = value.getMinifiedCssText("background-color").toLowerCase(Locale.ROOT);
            if (!("transparent".equals(text) || "rgba(0,0,0,0)".equals(text) || "rgb(0 0 0/0)".equals(text) || "initial".equals(text))) {
                this.appendText(buf, text);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isValidColor(ExtendedCSSValue value) {
        if (value.getCssValueType() == 1) {
            CSSPrimitiveValue primi = (CSSPrimitiveValue)((Object)value);
            short ptype = primi.getPrimitiveType();
            if (ptype == 25) {
                return true;
            }
            if (ptype == 21) {
                String s = primi.getStringValue().toLowerCase(Locale.ROOT);
                return ColorIdentifiers.getInstance().isColorIdentifier(s) || "transparent".equals(s) || "initial".equals(s);
            }
            if (ptype == 128) {
                CSSCustomPropertyValue custom = (CSSCustomPropertyValue)primi;
                ExtendedCSSValue fallback = custom.getFallback();
                if (fallback != null) {
                    return this.isValidColor(fallback);
                }
            } else if (ptype == 127) {
                String fname = primi.getStringValue();
                return "color".equalsIgnoreCase(fname);
            }
        }
        return false;
    }
}

