/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.css.CSSPrimitiveValue;

class BackgroundShorthandSetter
extends ShorthandSetter {
    private StringBuilder layerBuffer = null;
    private StringBuilder miniLayerBuffer = null;
    private int layerCount = 0;
    private final ValueList lstImage = ValueList.createCSValueList();
    private final ValueList lstPosition = ValueList.createCSValueList();
    private final ValueList lstSize = ValueList.createCSValueList();
    private final ValueList lstRepeat = ValueList.createCSValueList();
    private final ValueList lstClip = ValueList.createCSValueList();
    private final ValueList lstOrigin = ValueList.createCSValueList();
    private final ValueList lstAttachment = ValueList.createCSValueList();

    BackgroundShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "background");
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        this.currentValue = shorthandValue;
        this.setPriority(important);
        this.countLayers(shorthandValue);
    }

    void countLayers(LexicalUnit shorthandValue) {
        this.layerCount = 0;
        int valueCount = 0;
        for (LexicalUnit value = shorthandValue; value != null; value = value.getNextLexicalUnit()) {
            if (value.getLexicalUnitType() == 0) {
                if (valueCount <= 0) continue;
                ++this.layerCount;
                valueCount = 0;
                continue;
            }
            ++valueCount;
        }
        if (valueCount > 0) {
            ++this.layerCount;
        }
    }

    @Override
    StringBuilder getValueItemBuffer() {
        return this.layerBuffer;
    }

    @Override
    StringBuilder getValueItemBufferMini() {
        return this.miniLayerBuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean assignSubproperties() {
        LinkedList<LexicalUnit> unknownValues = null;
        this.layerBuffer = new StringBuilder(64);
        this.miniLayerBuffer = new StringBuilder(64);
        String[] subparray = this.getShorthandSubproperties();
        int i = 0;
        while (true) {
            StyleValue keyword;
            HashSet<String> subp;
            block27: {
                block26: {
                    boolean validLayer;
                    if (i < this.layerCount && this.currentValue != null) {
                        validLayer = false;
                        subp = new HashSet<String>(subparray.length);
                        subp.addAll(Arrays.asList((Object[])subparray.clone()));
                    } else {
                        this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                        this.setListSubpropertyValue("background-image", this.lstImage);
                        this.setListSubpropertyValue("background-position", this.lstPosition);
                        this.setListSubpropertyValue("background-size", this.lstSize);
                        this.setListSubpropertyValue("background-origin", this.lstOrigin);
                        this.setListSubpropertyValue("background-clip", this.lstClip);
                        this.setListSubpropertyValue("background-repeat", this.lstRepeat);
                        this.setListSubpropertyValue("background-attachment", this.lstAttachment);
                        if (!this.isPropertySet("background-color")) {
                            StyleValue iniVal = this.defaultPropertyValue("background-color");
                            this.setSubpropertyValue("background-color", iniVal);
                        }
                        this.flush();
                        return true;
                    }
                    block7: while (this.currentValue != null) {
                        String sv;
                        if (this.currentValue.getLexicalUnitType() == 0) {
                            if (validLayer) {
                                this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                                this.layerBuffer.setLength(0);
                                this.miniLayerBuffer.setLength(0);
                                if (++i != this.layerCount) {
                                    this.layerBuffer.append(',');
                                    this.miniLayerBuffer.append(',');
                                }
                                if (unknownValues != null) {
                                    this.reportUnknownValues(subp, unknownValues);
                                    unknownValues = null;
                                }
                            } else {
                                unknownValues = null;
                                break;
                            }
                            this.currentValue = this.currentValue.getNextLexicalUnit();
                            break;
                        }
                        if (this.currentValue.getLexicalUnitType() == 12) break block26;
                        if (this.currentValue.getLexicalUnitType() == 35 && ("initial".equals(sv = this.currentValue.getStringValue().toLowerCase(Locale.ROOT)) || "unset".equals(sv))) {
                            keyword = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                            break block27;
                        }
                        switch (this.assignLayerValue(i, subp)) {
                            case 1: {
                                if (i != this.layerCount - 1) {
                                    validLayer = false;
                                    break block7;
                                }
                            }
                            case 0: {
                                validLayer = true;
                                break;
                            }
                            case 2: {
                                if (unknownValues == null) {
                                    unknownValues = new LinkedList<LexicalUnit>();
                                }
                                unknownValues.add(this.currentValue);
                                this.nextCurrentValue();
                            }
                            case 3: {
                                validLayer = false;
                                break block7;
                            }
                        }
                    }
                    if (unknownValues != null) {
                        this.handleLayerUnknownValues(subp, unknownValues);
                        unknownValues = null;
                    }
                    if (!validLayer) {
                        this.layerBuffer.setLength(0);
                        this.miniLayerBuffer.setLength(0);
                        StringBuilder msgbuf = new StringBuilder(64);
                        msgbuf.append("Invalid layer found: ").append(i);
                        if (this.currentValue != null) {
                            msgbuf.append(' ').append(this.currentValue.toString());
                        }
                        this.reportDeclarationError("background", msgbuf.toString());
                        return false;
                    }
                    if (subp.size() <= 0) continue;
                    this.resetUnsetProperties(subp);
                    continue;
                }
                while (this.currentValue != null) {
                    boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    if (!commaFound) continue;
                }
                this.clearLayer(subp, ++i);
                InheritValue inherit = InheritValue.getValue().asSubproperty();
                this.addSingleValueLayer(inherit);
                this.layerBuffer.setLength(0);
                this.miniLayerBuffer.setLength(0);
                if (i != 1) {
                    this.layerBuffer.append(',');
                    this.miniLayerBuffer.append(',');
                }
                this.appendValueItemString(inherit);
                this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                this.layerBuffer.setLength(0);
                this.miniLayerBuffer.setLength(0);
                if (i == this.layerCount) continue;
                this.layerBuffer.append(',');
                this.miniLayerBuffer.append(',');
                continue;
            }
            while (this.currentValue != null) {
                boolean commaFound = this.currentValue.getLexicalUnitType() == 0;
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (!commaFound) continue;
            }
            this.clearLayer(subp, ++i);
            this.addSingleValueLayer(keyword);
            this.layerBuffer.setLength(0);
            this.miniLayerBuffer.setLength(0);
            if (i != 1) {
                this.layerBuffer.append(',');
                this.miniLayerBuffer.append(',');
            }
            this.appendValueItemString(keyword);
            this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
            this.layerBuffer.setLength(0);
            this.miniLayerBuffer.setLength(0);
            if (i == this.layerCount) continue;
            this.layerBuffer.append(',');
            this.miniLayerBuffer.append(',');
        }
    }

    private void clearLayer(Set<String> subp, int i) {
        if (!subp.contains("background-image") && this.lstImage.getLength() == i) {
            this.lstImage.remove(i - 1);
        }
        if (!subp.contains("background-position") && this.lstPosition.getLength() == i) {
            this.lstPosition.remove(i - 1);
        }
        if (!subp.contains("background-size") && this.lstSize.getLength() == i) {
            this.lstSize.remove(i - 1);
        }
        if (!subp.contains("background-origin") && this.lstOrigin.getLength() == i) {
            this.lstOrigin.remove(i - 1);
        }
        if (!subp.contains("background-clip") && this.lstClip.getLength() == i) {
            this.lstClip.remove(i - 1);
        }
        if (!subp.contains("background-repeat") && this.lstRepeat.getLength() == i) {
            this.lstRepeat.remove(i - 1);
        }
        if (!subp.contains("background-attachment") && this.lstAttachment.getLength() == i) {
            this.lstAttachment.remove(i - 1);
        }
    }

    private void addSingleValueLayer(StyleValue keyword) {
        this.lstImage.add(keyword);
        this.lstPosition.add(keyword);
        this.lstSize.add(keyword);
        this.lstRepeat.add(keyword);
        this.lstOrigin.add(keyword);
        this.lstClip.add(keyword);
        this.lstAttachment.add(keyword);
        if (this.currentValue == null) {
            this.setSubpropertyValue("background-color", keyword);
        }
    }

    private byte assignLayerValue(int i, Set<String> subp) {
        int retVal;
        if (subp.contains("background-color") && BaseCSSStyleDeclaration.testColor(this.currentValue)) {
            StyleValue cssValue = this.createCSSValue("background-color", this.currentValue);
            this.setSubpropertyValue("background-color", cssValue);
            subp.remove("background-color");
            retVal = 1;
            this.nextCurrentValue();
        } else if (subp.contains("background-image") && this.testBackgroundImage(i, subp)) {
            this.nextCurrentValue();
            retVal = 0;
        } else if (subp.contains("background-position") && this.testBackgroundPosition(this.lstPosition)) {
            subp.remove("background-position");
            this.nextCurrentValue();
            retVal = 0;
            if (this.currentValue != null && 4 == this.currentValue.getLexicalUnitType()) {
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.testBackgroundSize(i, subp)) {
                    this.nextCurrentValue();
                } else {
                    StyleDeclarationErrorHandler eh = this.styleDeclaration.getStyleDeclarationErrorHandler();
                    if (eh != null) {
                        eh.shorthandSyntaxError("background", "Size not found after slash");
                    }
                    retVal = 3;
                }
            }
        } else if (subp.contains("background-attachment") && this.testIdentifierProperty(i, subp, "background-attachment", this.lstAttachment)) {
            this.nextCurrentValue();
            subp.remove("background-attachment");
            retVal = 0;
        } else if (subp.contains("background-repeat") && this.testBackgroundRepeat(this.lstRepeat)) {
            subp.remove("background-repeat");
            retVal = 0;
        } else if (subp.contains("background-origin") && this.testIdentifierProperty(i, subp, "background-origin", this.lstOrigin)) {
            LexicalUnit lastValue = this.currentValue;
            this.nextCurrentValue();
            subp.remove("background-origin");
            if (this.currentValue != null && this.testIdentifierProperty(i, subp, "background-clip", this.lstClip)) {
                this.nextCurrentValue();
            } else {
                StyleValue value = this.createCSSValue("background-clip", lastValue);
                this.lstClip.add(value);
            }
            subp.remove("background-clip");
            retVal = 0;
        } else {
            retVal = 2;
        }
        return (byte)retVal;
    }

    private void handleLayerUnknownValues(Set<String> subp, List<LexicalUnit> unknownValues) {
        if (subp.size() == 1 && unknownValues.size() == 1 && this.lastChanceLayerAssign(subp.iterator().next(), unknownValues.get(0))) {
            subp.clear();
            return;
        }
        this.reportUnknownValues(subp, unknownValues);
    }

    private boolean lastChanceLayerAssign(String property, LexicalUnit lUnit) {
        if (lUnit.getLexicalUnitType() == 41 && "var".equalsIgnoreCase(lUnit.getFunctionName())) {
            StyleValue cssValue = this.createCSSValue(property, lUnit);
            this.setSubpropertyValue(property, cssValue);
            return true;
        }
        return false;
    }

    private void reportUnknownValues(Set<String> subp, List<LexicalUnit> unknownValues) {
        BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
        if (prule != null) {
            StyleDeclarationErrorHandler eh = prule.getStyleDeclarationErrorHandler();
            if (unknownValues.size() == 1 && unknownValues.get(0).getLexicalUnitType() == 35) {
                eh.unknownIdentifier("background", unknownValues.get(0).getStringValue());
            } else {
                eh.unassignedShorthandValues("background", subp.toArray(new String[0]), unknownValues.toArray(new LexicalUnit[0]));
            }
        }
    }

    private void resetUnsetProperties(Set<String> subp) {
        for (String pname : subp) {
            StyleValue cssVal = this.defaultPropertyValue(pname);
            if ("background-image".equals(pname)) {
                this.lstImage.add(cssVal);
                continue;
            }
            if ("background-position".equals(pname)) {
                this.lstPosition.add(cssVal);
                continue;
            }
            if ("background-size".equals(pname)) {
                ValueList list = ValueList.createWSValueList();
                list.add(cssVal);
                list.add(cssVal);
                this.lstSize.add(list);
                continue;
            }
            if ("background-origin".equals(pname)) {
                this.lstOrigin.add(cssVal);
                continue;
            }
            if ("background-clip".equals(pname)) {
                this.lstClip.add(cssVal);
                continue;
            }
            if ("background-repeat".equals(pname)) {
                this.lstRepeat.add(cssVal);
                continue;
            }
            if (!"background-attachment".equals(pname)) continue;
            this.lstAttachment.add(cssVal);
        }
    }

    private void setListSubpropertyValue(String pname, ValueList list) {
        if (list.getLength() == 1) {
            StyleValue val = list.item(0);
            if (val.getCssValueType() == 1) {
                ((PrimitiveValue)val).setSubproperty(true);
            } else if (val.getCssValueType() == 0) {
                val = ((InheritValue)val).asSubproperty();
            } else if (val.getCssValueType() == 2) {
                ((ValueList)val).setSubproperty(true);
            }
            this.setSubpropertyValue(pname, val);
        } else {
            list.setSubproperty(true);
            this.setSubpropertyValue(pname, list);
        }
    }

    @Override
    protected void nextCurrentValue() {
        this.appendValueItemString();
        this.currentValue = this.currentValue.getNextLexicalUnit();
    }

    private boolean testBackgroundImage(int i, Set<String> subp) {
        if (this.isImage()) {
            this.lstImage.add(this.createCSSValue("background-image", this.currentValue));
            subp.remove("background-image");
            return true;
        }
        if (this.currentValue.getLexicalUnitType() == 35 && "none".equals(this.currentValue.getStringValue())) {
            this.lstImage.add(this.createCSSValue("background-image", this.currentValue));
            subp.remove("background-image");
            return true;
        }
        return false;
    }

    private boolean testBackgroundPosition(ValueList posList) {
        if (this.currentValue.getLexicalUnitType() == 35 && this.testIdentifiers("background-position") || ValueFactory.isSizeSACUnit(this.currentValue)) {
            ValueList list = ValueList.createWSValueList();
            StyleValue value = this.createCSSValue("background-position", this.currentValue);
            list.add(value);
            int count = 1;
            LexicalUnit nlu = this.currentValue.getNextLexicalUnit();
            while (nlu != null && count < 4) {
                if (nlu.getLexicalUnitType() == 35 && this.getShorthandDatabase().isIdentifierValue("background-position", nlu.getStringValue()) || ValueFactory.isSizeSACUnit(nlu)) {
                    value = this.createCSSValue("background-position", nlu);
                    list.add(value);
                    count = (short)(count + 1);
                    this.nextCurrentValue();
                    nlu = this.currentValue.getNextLexicalUnit();
                    continue;
                }
                nlu = null;
            }
            if (list.getLength() == 1) {
                posList.add(list.item(0));
            } else if (this.checkPositionProperty(list)) {
                posList.add(list);
            } else {
                BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
                if (prule != null) {
                    CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for background-position");
                    ex.setValueText(list.getCssText());
                    prule.getStyleDeclarationErrorHandler().wrongValue("background-position", ex);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkPositionProperty(ValueList list) {
        int count = list.getLength();
        if (count == 2) {
            return true;
        }
        if (count == 4) {
            return ((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(3))).getPrimitiveType() != 21;
        }
        if (((CSSPrimitiveValue)((Object)list.item(0))).getPrimitiveType() != 21) {
            return false;
        }
        if (((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() != 21) {
            return true;
        }
        return ((CSSPrimitiveValue)((Object)list.item(1))).getPrimitiveType() != 21 && ((CSSPrimitiveValue)((Object)list.item(2))).getPrimitiveType() == 21;
    }

    private boolean testBackgroundSize(int i, Set<String> subp) {
        if (this.currentValue.getLexicalUnitType() == 35 && this.testIdentifiers("background-size") || ValueFactory.isSizeSACUnit(this.currentValue)) {
            ValueList list = ValueList.createWSValueList();
            StyleValue value = this.createCSSValue("background-size", this.currentValue);
            list.add(value);
            this.layerBuffer.append(" /");
            this.miniLayerBuffer.append('/');
            LexicalUnit nlu = this.currentValue.getNextLexicalUnit();
            if (nlu != null && (nlu.getLexicalUnitType() == 35 && this.getShorthandDatabase().isIdentifierValue("background-size", nlu.getStringValue()) || ValueFactory.isSizeSACUnit(nlu))) {
                value = this.createCSSValue("background-size", nlu);
                list.add(value);
                this.nextCurrentValue();
            }
            if (list.getLength() == 1) {
                this.lstSize.add(list.item(0));
            } else {
                this.lstSize.add(list);
            }
            subp.remove("background-size");
            return true;
        }
        return false;
    }

    private boolean testBackgroundRepeat(ValueList rptList) {
        if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("background-repeat")) {
            StyleValue value = this.createCSSValue("background-repeat", this.currentValue);
            String s = value.getCssText();
            this.nextCurrentValue();
            if (s.equals("repeat-y") || s.equals("repeat-x")) {
                rptList.add(value);
            } else if (this.currentValue != null && 35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("background-repeat")) {
                ValueList list = ValueList.createWSValueList();
                list.add(value);
                list.add(this.createCSSValue("background-repeat", this.currentValue));
                rptList.add(list);
                this.nextCurrentValue();
            } else {
                rptList.add(value);
            }
            return true;
        }
        return false;
    }

    private boolean testIdentifierProperty(int layer, Set<String> subp, String subpropertyName, ValueList lst) {
        if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subpropertyName)) {
            StyleValue value = this.createCSSValue(subpropertyName, this.currentValue);
            lst.add(value);
            return true;
        }
        return false;
    }
}

