/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CompatStyleDeclaration;
import io.sf.carte.doc.style.css.om.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.LexicalPropertyListener;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.doc.style.css.om.WrappedCSSStyleDeclaration;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.StyleValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public abstract class BaseCSSDeclarationRule
extends BaseCSSRule
implements CSSDeclarationRule {
    private AbstractCSSStyleDeclaration declaration = null;
    private StyleDeclarationErrorHandler sdErrorHandler = null;

    protected BaseCSSDeclarationRule(AbstractCSSStyleSheet parentSheet, short type, byte origin) {
        super(parentSheet, type, origin);
        this.declaration = parentSheet.createStyleDeclaration(this);
    }

    BaseCSSDeclarationRule() {
        super(null, (short)1, (byte)0);
        this.declaration = new BaseCSSStyleDeclaration(this);
        this.sdErrorHandler = new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public AbstractCSSStyleDeclaration getStyle() {
        return this.declaration;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        CSSParser parser;
        this.clear();
        try {
            parser = (CSSParser)this.createSACParser();
        }
        catch (ClassCastException e) {
            parser = new CSSParser();
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        PropertyDocumentHandler handler = this.createPropertyDocumentHandler();
        handler.setLexicalPropertyListener(this.getLexicalPropertyListener());
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            parser.parseDeclarationRule(source);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    void clear() {
        this.declaration.clear();
    }

    PropertyDocumentHandler createPropertyDocumentHandler() {
        return new DeclarationRuleDocumentHandler();
    }

    LexicalPropertyListener getLexicalPropertyListener() {
        return this.declaration;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.sdErrorHandler == null) {
            this.sdErrorHandler = this.getParentStyleSheet().getStyleSheetFactory().createStyleDeclarationErrorHandler(this);
        }
        return this.sdErrorHandler;
    }

    boolean hasErrorsOrWarnings() {
        return this.sdErrorHandler != null && (this.sdErrorHandler.hasErrors() || this.sdErrorHandler.hasWarnings());
    }

    public void setStyleDeclarationErrorHandler(StyleDeclarationErrorHandler handler) {
        this.sdErrorHandler = handler;
    }

    public int hashCode() {
        int prime = 31;
        int result = Short.hashCode(this.getType());
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseCSSDeclarationRule other = (BaseCSSDeclarationRule)obj;
        return !(this.declaration == null ? other.declaration != null : !this.declaration.equals(other.declaration));
    }

    @Override
    public BaseCSSDeclarationRule clone(AbstractCSSStyleSheet parentSheet) throws IllegalArgumentException {
        BaseCSSDeclarationRule rule;
        Constructor<?> ctor;
        Class[] parameterTypes = new Class[]{AbstractCSSStyleSheet.class, Byte.TYPE};
        try {
            ctor = this.getClass().getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        Object[] initargs = new Object[]{parentSheet, this.getOrigin()};
        try {
            rule = (BaseCSSDeclarationRule)ctor.newInstance(initargs);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return rule;
    }

    void setWrappedStyle(BaseCSSStyleDeclaration style, String oldHrefContext) {
        this.declaration = !(style instanceof CompatStyleDeclaration) ? new StyleWrapper(style, oldHrefContext) : new CompatStyleWrapper((CompatStyleDeclaration)style, oldHrefContext);
    }

    class DeclarationRuleDocumentHandler
    extends PropertyDocumentHandler
    implements CSSParser.DeclarationRuleHandler {
        DeclarationRuleDocumentHandler() {
        }

        @Override
        public void startAtRule(String name, String pseudoSelector) {
        }

        @Override
        public void endAtRule() {
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            block2: {
                try {
                    super.property(name, value, important);
                }
                catch (DOMException e) {
                    if (BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler() == null) break block2;
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler().wrongValue(name, ex);
                }
            }
        }

        @Override
        public void warning(CSSParseException exception) throws CSSException {
            BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler().sacWarning(exception, BaseCSSDeclarationRule.this.getStyle().getLength() - 1);
        }

        @Override
        public void error(CSSParseException exception) throws CSSException {
            BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler().sacError(exception, BaseCSSDeclarationRule.this.getStyle().getLength() - 1);
        }

        @Override
        public void fatalError(CSSParseException exception) throws CSSException {
            BaseCSSDeclarationRule.this.getStyleDeclarationErrorHandler().sacFatalError(exception, BaseCSSDeclarationRule.this.getStyle().getLength() - 1);
        }
    }

    private class StyleWrapper
    extends WrappedCSSStyleDeclaration {
        private StyleWrapper(BaseCSSStyleDeclaration copiedObject, String oldHrefContext) {
            super(copiedObject, oldHrefContext);
        }

        @Override
        public BaseCSSDeclarationRule getParentRule() {
            return BaseCSSDeclarationRule.this;
        }
    }

    private class CompatStyleWrapper
    extends CompatStyleDeclaration {
        private final String hrefcontext;
        private final String oldHrefContext;

        private CompatStyleWrapper(CompatStyleDeclaration copiedObject, String oldHrefContext) {
            super(copiedObject);
            this.hrefcontext = WrappedCSSStyleDeclaration.getHrefContext(this.getParentRule());
            this.oldHrefContext = oldHrefContext;
        }

        @Override
        protected StyleValue getCSSValue(String propertyName) {
            StyleValue value = super.getCSSValue(propertyName);
            if (value != null) {
                value = WrappedCSSStyleDeclaration.wrapCSSValue(value, this.oldHrefContext, this.hrefcontext);
            }
            return value;
        }

        @Override
        public BaseCSSDeclarationRule getParentRule() {
            return BaseCSSDeclarationRule.this;
        }
    }
}

