/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

abstract class BaseCSSRule
extends AbstractCSSRule {
    private AbstractCSSStyleSheet parentSheet = null;
    private AbstractCSSRule parentRule = null;
    private final short ruleType;
    private final byte ruleOrigin;
    List<String> precedingComments = null;

    protected BaseCSSRule(AbstractCSSStyleSheet parentSheet, short type, byte origin) {
        this.parentSheet = parentSheet;
        this.ruleType = type;
        this.ruleOrigin = origin;
    }

    @Override
    public short getType() {
        return this.ruleType;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parentSheet;
    }

    @Override
    void setParentStyleSheet(AbstractCSSStyleSheet parentSheet) {
        this.parentSheet = parentSheet;
    }

    protected Parser createSACParser() throws DOMException {
        Parser parser = this.getParentStyleSheet() != null ? this.getParentStyleSheet().getStyleSheetFactory().createSACParser() : SACParserFactory.createSACParser();
        return parser;
    }

    @Override
    public AbstractCSSRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public void setParentRule(AbstractCSSRule parent) {
        this.parentRule = parent;
    }

    @Override
    public byte getOrigin() {
        return this.ruleOrigin;
    }

    @Override
    public void enablePrecedingComments(int initialSize) {
        if (this.precedingComments == null) {
            this.precedingComments = new ArrayList<String>(initialSize);
        }
    }

    @Override
    public List<String> getPrecedingComments() {
        return this.precedingComments;
    }

    @Override
    void setPrecedingComments(List<String> precedingComments) {
        this.precedingComments = precedingComments;
    }

    @Override
    public String getMinifiedCssText() {
        return this.getCssText();
    }

    protected StyleFormattingContext getStyleFormattingContext() {
        AbstractCSSStyleSheet sheet = this.getParentStyleSheet();
        StyleFormattingContext context = sheet != null ? sheet.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext() : new DefaultStyleFormattingContext();
        return context;
    }

    protected URL getURL(String uri) throws MalformedURLException {
        URL url;
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        if (uri.indexOf("://") < 0) {
            String phref = this.getParentStyleSheet().getHref();
            if (phref == null) {
                throw new MalformedURLException("Relative URI but no href for parent style sheet.");
            }
            URL pUrl = new URL(phref);
            url = new URL(pUrl, uri);
        } else {
            url = new URL(uri);
        }
        return url;
    }
}

