/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.AgentUtil;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.nsac.PositionalCondition2;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.CompatStyleDeclaration;
import io.sf.carte.doc.style.css.om.CounterStyleRule;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.FontFeatureValuesRule;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.KeyframesRule;
import io.sf.carte.doc.style.css.om.MarginRule;
import io.sf.carte.doc.style.css.om.MediaList;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.NamespaceRule;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.doc.style.css.om.StandAloneErrorHandler;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import io.sf.carte.doc.style.css.om.UnknownRule;
import io.sf.carte.doc.style.css.om.ViewportRule;
import io.sf.carte.doc.style.css.om.WrappedCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;

public abstract class BaseCSSStyleSheet
extends AbstractCSSStyleSheet {
    private AbstractCSSStyleSheet parent = null;
    private String href = null;
    private final AbstractCSSRule ownerRule;
    private final byte sheetOrigin;
    final CSSRuleArrayList cssRules;
    private int currentInsertionIndex = 0;
    private MediaQueryList destinationMedia;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private boolean disabled = false;
    private SheetErrorHandler sheetErrorHandler = null;
    private static final int MAX_IMPORT_RECURSION = 8;

    protected BaseCSSStyleSheet(String title, MediaQueryList media, AbstractCSSRule ownerRule, byte origin) {
        super(title);
        this.ownerRule = ownerRule;
        this.destinationMedia = media == null ? MediaList.createUnmodifiable() : media;
        this.sheetOrigin = origin;
        this.cssRules = new CSSRuleArrayList(64);
    }

    protected void copyAllTo(BaseCSSStyleSheet myCopy) {
        this.copyFieldsTo(myCopy);
        this.copyRulesTo(myCopy);
    }

    protected void copyFieldsTo(BaseCSSStyleSheet myCopy) {
        myCopy.currentInsertionIndex = this.currentInsertionIndex;
        myCopy.setDisabled(this.getDisabled());
        myCopy.namespaces = this.namespaces;
        if (this.parent != null) {
            myCopy.setParentStyleSheet(this.parent);
        }
    }

    protected void copyRulesTo(BaseCSSStyleSheet myCopy) {
        myCopy.cssRules.ensureCapacity(this.cssRules.getLength());
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myCopy.cssRules.add(((AbstractCSSRule)it.next()).clone(myCopy));
        }
    }

    @Override
    public abstract BaseCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public AbstractCSSRule getOwnerRule() {
        return this.ownerRule;
    }

    @Override
    public Node getOwnerNode() {
        return null;
    }

    @Override
    public MediaQueryList getMedia() {
        return this.destinationMedia;
    }

    @Override
    protected void setMedia(MediaQueryList media) throws DOMException {
        if (media.hasErrors()) {
            throw new DOMException(11, "Media query has errors");
        }
        this.destinationMedia = media;
    }

    @Override
    public byte getOrigin() {
        return this.sheetOrigin;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index > this.getCssRules().getLength() || index < 0) {
            throw new DOMException(1, "Invalid index: " + index);
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(rule);
        source.setCharacterStream((Reader)re);
        Parser psr = this.getStyleSheetFactory().createSACParser();
        CSSDocumentHandler handler = this.createDocumentHandler(this.getOrigin(), true);
        psr.setDocumentHandler((DocumentHandler)handler);
        psr.setErrorHandler((org.w3c.css.sac.ErrorHandler)handler);
        this.currentInsertionIndex = index - 1;
        try {
            if (psr instanceof Parser2) {
                ((Parser2)psr).parseRule(source, handler);
            } else {
                psr.parseRule(source);
            }
        }
        catch (CSSNamespaceParseException e) {
            DOMException ex = new DOMException(14, e.getMessage());
            ex.initCause((Throwable)((Object)e));
            throw ex;
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        if (this.currentInsertionIndex != index && handler.outOfRuleException != null) {
            DOMException ex = ((Object)((Object)handler.outOfRuleException)).getClass() == CSSNamespaceParseException.class ? new DOMException(14, handler.outOfRuleException.getMessage()) : new DOMException(12, handler.outOfRuleException.getMessage());
            ex.initCause(handler.outOfRuleException);
            throw ex;
        }
        return this.currentInsertionIndex;
    }

    @Override
    public void addRule(AbstractCSSRule cssrule) throws DOMException {
        if (cssrule.getType() == 10) {
            CSSNamespaceRule nsrule = (CSSNamespaceRule)((Object)cssrule);
            if (this.namespaces.containsKey(nsrule.getNamespaceURI())) {
                throw new DOMException(14, "Rule for this namespace URI already exists: " + nsrule.getNamespaceURI());
            }
            this.registerNamespace(nsrule);
        }
        cssrule.setParentStyleSheet(this);
        this.addLocalRule(cssrule);
    }

    @Override
    protected void registerNamespace(CSSNamespaceRule nsrule) {
        this.namespaces.put(nsrule.getNamespaceURI(), nsrule.getPrefix());
    }

    @Override
    protected void unregisterNamespace(String namespaceURI) {
        this.namespaces.remove(namespaceURI);
    }

    protected void addLocalRule(CSSRule cssrule) {
        this.currentInsertionIndex = this.cssRules.insertRule(cssrule, ++this.currentInsertionIndex);
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        ExtendedCSSRule rule;
        try {
            rule = (ExtendedCSSRule)this.cssRules.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMException(1, e.getMessage());
        }
        if (rule.getType() == 10 && this.containsRuleWithNamespace(((CSSNamespaceRule)rule).getNamespaceURI())) {
            throw new DOMException(14, "There are style rules with ");
        }
        this.cssRules.remove(index);
    }

    private boolean containsRuleWithNamespace(String namespaceURI) {
        for (ExtendedCSSRule rule : this.cssRules) {
            CSSStyleDeclarationRule stylerule;
            if (rule.getType() != 1 || !BaseCSSStyleSheet.selectorListHasNamespace((stylerule = (CSSStyleDeclarationRule)rule).getSelectorList(), namespaceURI)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addStyleSheet(AbstractCSSStyleSheet sheet) {
        if (!sheet.getDisabled()) {
            org.w3c.dom.stylesheets.MediaList mediaList = sheet.getMedia();
            if (mediaList.isAllMedia()) {
                CSSRuleArrayList otherRules = sheet.getCssRules();
                this.addRuleList(otherRules, sheet, 0);
            } else if (!mediaList.isNotAllMedia()) {
                CSSRuleArrayList otherRules = sheet.getCssRules();
                MediaRule mrule = this.createMediaRule((MediaQueryList)mediaList);
                this.addToMediaRule(mrule, otherRules, sheet, 0);
                this.addLocalRule(mrule);
            }
            this.getErrorHandler().mergeState(sheet.getErrorHandler());
        }
    }

    private void addRuleList(CSSRuleArrayList otherRules, AbstractCSSStyleSheet sheet, int importCount) {
        int orl = otherRules.getLength();
        for (int i = 0; i < orl; ++i) {
            AbstractCSSRule oRule = (AbstractCSSRule)otherRules.item(i);
            if (oRule.getType() != 3) {
                this.addLocalRule(oRule.clone(sheet));
                continue;
            }
            if (++importCount == 8) {
                DOMException ex = new DOMException(3, "Too many nested imports");
                String cssText = oRule.getCssText();
                sheet.getErrorHandler().badAtRule(ex, cssText);
                this.getErrorHandler().badAtRule(ex, cssText);
                return;
            }
            ImportRule imp = (ImportRule)oRule.clone(sheet);
            AbstractCSSStyleSheet impSheet = imp.getStyleSheet();
            CSSRuleArrayList impRules = impSheet.getCssRules();
            MediaQueryList media = imp.getMedia();
            if (media.isAllMedia()) {
                this.addRuleList(impRules, impSheet, importCount);
                continue;
            }
            if (media.isNotAllMedia()) continue;
            MediaRule mrule = this.createMediaRule(imp.getMedia());
            this.addToMediaRule(mrule, impRules, impSheet, importCount);
            this.addLocalRule(mrule);
        }
    }

    private void addToMediaRule(MediaRule mrule, CSSRuleArrayList otherRules, AbstractCSSStyleSheet sheet, int importCount) {
        int orl = otherRules.getLength();
        for (int i = 0; i < orl; ++i) {
            AbstractCSSRule oRule = (AbstractCSSRule)otherRules.item(i);
            if (oRule.getType() != 3) {
                mrule.addRule(oRule.clone(sheet));
                continue;
            }
            if (++importCount == 8) {
                DOMException ex = new DOMException(3, "Too many nested imports");
                String cssText = oRule.getCssText();
                sheet.getErrorHandler().badAtRule(ex, cssText);
                this.getErrorHandler().badAtRule(ex, cssText);
                return;
            }
            ImportRule imp = (ImportRule)oRule.clone(sheet);
            AbstractCSSStyleSheet impSheet = imp.getStyleSheet();
            CSSRuleArrayList impRules = impSheet.getCssRules();
            MediaQueryList media = imp.getMedia();
            if (mrule.getMedia().equals(media)) {
                this.addToMediaRule(mrule, impRules, impSheet, importCount);
                continue;
            }
            MediaRule nestedMRule = this.createMediaRule(media);
            this.addToMediaRule(nestedMRule, impRules, impSheet, importCount);
            mrule.addRule(nestedMRule);
        }
    }

    private static boolean selectorListHasNamespace(SelectorList selist, String namespaceURI) {
        for (int i = 0; i < selist.getLength(); ++i) {
            if (!BaseCSSStyleSheet.selectorHasNamespace(selist.item(i), namespaceURI)) continue;
            return true;
        }
        return false;
    }

    private static boolean selectorHasNamespace(Selector sel, String namespaceURI) {
        switch (sel.getSelectorType()) {
            case 1: 
            case 4: {
                return namespaceURI.equals(((ElementSelector)sel).getNamespaceURI());
            }
            case 0: {
                ConditionalSelector csel = (ConditionalSelector)sel;
                return BaseCSSStyleSheet.selectorHasNamespace((Selector)csel.getSimpleSelector(), namespaceURI) || BaseCSSStyleSheet.conditionHasNamespace(csel.getCondition(), namespaceURI);
            }
            case 10: 
            case 11: 
            case 14: {
                DescendantSelector dsel = (DescendantSelector)sel;
                return BaseCSSStyleSheet.selectorHasNamespace(dsel.getAncestorSelector(), namespaceURI) || BaseCSSStyleSheet.selectorHasNamespace((Selector)dsel.getSimpleSelector(), namespaceURI);
            }
            case 12: 
            case 13: {
                SiblingSelector ssel = (SiblingSelector)sel;
                return BaseCSSStyleSheet.selectorHasNamespace(ssel.getSelector(), namespaceURI) || BaseCSSStyleSheet.selectorHasNamespace((Selector)ssel.getSiblingSelector(), namespaceURI);
            }
        }
        return false;
    }

    private static boolean conditionHasNamespace(Condition condition, String namespaceURI) {
        switch (condition.getConditionType()) {
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: {
                AttributeCondition acond = (AttributeCondition)condition;
                return namespaceURI.equals(acond.getNamespaceURI());
            }
            case 0: 
            case 1: {
                CombinatorCondition ccond = (CombinatorCondition)condition;
                return BaseCSSStyleSheet.conditionHasNamespace(ccond.getFirstCondition(), namespaceURI) || BaseCSSStyleSheet.conditionHasNamespace(ccond.getSecondCondition(), namespaceURI);
            }
            case 3: {
                SelectorList oflist = ((PositionalCondition2)condition).getOfList();
                if (oflist == null) break;
                return BaseCSSStyleSheet.selectorListHasNamespace(oflist, namespaceURI);
            }
            case 17: {
                ArgumentCondition argcond = (ArgumentCondition)condition;
                SelectorList selist = argcond.getSelectors();
                if (selist == null) break;
                return BaseCSSStyleSheet.selectorListHasNamespace(selist, namespaceURI);
            }
        }
        return false;
    }

    @Override
    public CounterStyleRule createCounterStyleRule(String name) {
        CounterStyleRule rule = new CounterStyleRule(this, this.getOrigin());
        rule.setName(name);
        return rule;
    }

    @Override
    public FontFaceRule createFontFaceRule() {
        return new FontFaceRule(this, this.getOrigin());
    }

    @Override
    public FontFeatureValuesRule createFontFeatureValuesRule(String[] fontFamily) {
        FontFeatureValuesRule rule = new FontFeatureValuesRule(this, this.getOrigin());
        rule.setFontFamily(fontFamily);
        return rule;
    }

    @Override
    public ImportRule createImportRule(MediaQueryList mediaList, String href) {
        if (href == null) {
            throw new NullPointerException("Null @import URI");
        }
        return new ImportRule(this, ((MediaListAccess)((Object)mediaList)).unmodifiable(), href, this.getOrigin());
    }

    @Override
    public KeyframesRule createKeyframesRule(String keyframesName) {
        KeyframesRule rule = new KeyframesRule((AbstractCSSStyleSheet)this, this.getOrigin());
        rule.setName(keyframesName);
        return rule;
    }

    @Override
    public MarginRule createMarginRule(String name) {
        return new MarginRule((AbstractCSSStyleSheet)this, this.getOrigin(), name);
    }

    @Override
    public MediaRule createMediaRule(MediaQueryList mediaList) {
        return new MediaRule((AbstractCSSStyleSheet)this, mediaList, this.getOrigin());
    }

    @Override
    public NamespaceRule createNamespaceRule(String prefix, String namespaceUri) {
        if (prefix == null || namespaceUri == null) {
            throw new DOMException(15, "Null parameter");
        }
        return new NamespaceRule(this, this.getOrigin(), prefix, namespaceUri);
    }

    @Override
    public PageRule createPageRule() {
        return new PageRule(this, this.getOrigin());
    }

    @Override
    public StyleRule createStyleRule() {
        return new StyleRule(this, this.getOrigin());
    }

    @Override
    public SupportsRule createSupportsRule() {
        return new SupportsRule((AbstractCSSStyleSheet)this, this.getOrigin());
    }

    @Override
    public ViewportRule createViewportRule() {
        return new ViewportRule(this, this.getOrigin());
    }

    @Override
    public UnknownRule createUnknownRule() {
        return new UnknownRule(this, this.getOrigin());
    }

    @Override
    protected BaseCSSStyleDeclaration createStyleDeclaration(BaseCSSDeclarationRule rule) {
        if (rule.getType() == 5) {
            return new WrappedCSSStyleDeclaration(rule);
        }
        BaseCSSStyleSheetFactory factory = this.getStyleSheetFactory();
        if (!factory.hasCompatValueFlags()) {
            return new BaseCSSStyleDeclaration(rule);
        }
        return new CompatStyleDeclaration(rule);
    }

    @Override
    public BaseCSSStyleDeclaration createStyleDeclaration() {
        return new BaseCSSStyleDeclaration();
    }

    @Override
    public boolean hasRuleErrorsOrWarnings() {
        return BaseCSSStyleSheet.hasRuleErrorsOrWarnings(this.cssRules);
    }

    private static boolean hasRuleErrorsOrWarnings(CSSRuleArrayList rules) {
        for (ExtendedCSSRule rule : rules) {
            BaseCSSDeclarationRule stylerule;
            if (!(rule instanceof BaseCSSDeclarationRule ? (stylerule = (BaseCSSDeclarationRule)rule).hasErrorsOrWarnings() : rule instanceof GroupingRule && BaseCSSStyleSheet.hasRuleErrorsOrWarnings(((GroupingRule)rule).getCssRules()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public SheetErrorHandler getErrorHandler() {
        if (this.sheetErrorHandler == null) {
            this.sheetErrorHandler = this.getStyleSheetFactory().createSheetErrorHandler(this);
        }
        return this.sheetErrorHandler;
    }

    @Override
    protected ErrorHandler getDocumentErrorHandler() {
        Node owner = null;
        for (AbstractCSSStyleSheet parent = this; parent != null && (owner = parent.getOwnerNode()) == null; parent = ((AbstractCSSStyleSheet)parent).getParentStyleSheet()) {
        }
        ErrorHandler eh = owner != null ? ((CSSDocument)owner.getOwnerDocument()).getErrorHandler() : StandAloneErrorHandler.getInstance(this);
        return eh;
    }

    @Override
    public String getType() {
        return "text/css";
    }

    @Override
    protected String getNamespacePrefix(String uri) {
        return this.namespaces.get(uri);
    }

    @Override
    protected boolean hasDefaultNamespace() {
        return this.namespaces.containsValue("");
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parent;
    }

    @Override
    protected void setParentStyleSheet(AbstractCSSStyleSheet parent) {
        this.parent = parent;
        this.sheetErrorHandler = parent.getErrorHandler();
    }

    @Override
    public String getHref() {
        if (this.href == null && this.ownerRule != null) {
            return this.ownerRule.getParentStyleSheet().getHref();
        }
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public boolean loadStyleSheet(URL url, String referrerPolicy) throws DOMException, IOException {
        boolean result;
        final URLConnection ucon = this.openConnection(url, referrerPolicy);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    ucon.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        InputStream is = ucon.getInputStream();
        String contentEncoding = ucon.getContentEncoding();
        String conType = ucon.getContentType();
        Reader re = AgentUtil.inputStreamToReader(is, conType, contentEncoding, "utf-8");
        InputSource source = new InputSource(re);
        try {
            this.setHref(url.toExternalForm());
            result = this.parseStyleSheet(source);
        }
        catch (DOMException e) {
            this.getDocumentErrorHandler().linkedSheetError(e, this);
            throw e;
        }
        catch (IOException e) {
            this.getDocumentErrorHandler().linkedSheetError(e, this);
            throw e;
        }
        catch (CSSException e) {
            this.getDocumentErrorHandler().linkedSheetError((Exception)((Object)e), this);
            throw e;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (ucon instanceof HttpURLConnection) {
            ((HttpURLConnection)ucon).disconnect();
        }
        return result;
    }

    public CSSRuleArrayList getRulesForProperty(String longhandPropertyName) {
        CSSRuleArrayList list = new CSSRuleArrayList();
        BaseCSSStyleSheet.scanRulesForPropertyDeclaration(this.cssRules, longhandPropertyName, list);
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private static void scanRulesForPropertyDeclaration(CSSRuleArrayList rules, String propertyName, CSSRuleArrayList subset) {
        for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: 
                case 6: {
                    CSSStyleDeclarationRule stylerule = (CSSStyleDeclarationRule)rule;
                    if (!((BaseCSSStyleDeclaration)stylerule.getStyle()).isPropertySet(propertyName)) break;
                    subset.add(stylerule);
                    break;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)rule;
                    BaseCSSStyleSheet.scanRulesForPropertyDeclaration(grouping.getCssRules(), propertyName, subset);
                }
            }
        }
    }

    @Override
    public Selector[] getSelectorsForProperty(String longhandPropertyName) {
        LinkedList<Selector> selectors = new LinkedList<Selector>();
        BaseCSSStyleSheet.scanRulesForPropertyDeclaration(this.cssRules, longhandPropertyName, selectors);
        if (selectors.isEmpty()) {
            return null;
        }
        return selectors.toArray(new Selector[0]);
    }

    private static void scanRulesForPropertyDeclaration(CSSRuleArrayList rules, String propertyName, LinkedList<Selector> selectors) {
        block4: for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: 
                case 6: {
                    CSSStyleDeclarationRule stylerule = (CSSStyleDeclarationRule)rule;
                    if (!((BaseCSSStyleDeclaration)stylerule.getStyle()).isPropertySet(propertyName)) break;
                    SelectorList list = stylerule.getSelectorList();
                    for (int i = 0; i < list.getLength(); ++i) {
                        selectors.add(list.item(i));
                    }
                    continue block4;
                }
                case 4: 
                case 12: {
                    GroupingRule grouping = (GroupingRule)rule;
                    BaseCSSStyleSheet.scanRulesForPropertyDeclaration(grouping.getCssRules(), propertyName, selectors);
                }
            }
        }
    }

    public Selector[] getSelectorsForPropertyValue(String propertyName, String declaredValue) {
        LinkedList<Selector> selectors = new LinkedList<Selector>();
        BaseCSSStyleSheet.scanRulesForValue(this.cssRules, propertyName, declaredValue, selectors);
        if (selectors.isEmpty()) {
            return null;
        }
        return selectors.toArray(new Selector[0]);
    }

    private static void scanRulesForValue(CSSRuleArrayList rules, String propertyName, String value, LinkedList<Selector> selectors) {
        block4: for (CSSRule rule : rules) {
            switch (rule.getType()) {
                case 1: 
                case 6: {
                    CSSStyleDeclarationRule stylerule = (CSSStyleDeclarationRule)rule;
                    if (!value.equalsIgnoreCase(stylerule.getStyle().getPropertyValue(propertyName))) break;
                    SelectorList list = stylerule.getSelectorList();
                    for (int i = 0; i < list.getLength(); ++i) {
                        selectors.add(list.item(i));
                    }
                    continue block4;
                }
                case 4: {
                    MediaRule mediarule = (MediaRule)rule;
                    BaseCSSStyleSheet.scanRulesForValue((CSSRuleArrayList)mediarule.getCssRules(), propertyName, value, selectors);
                }
            }
        }
    }

    protected String getTargetMedium() {
        return null;
    }

    @Override
    public String toMinifiedString() {
        return this.getCssRules().toMinifiedString();
    }

    public String toString() {
        StyleFormattingContext context = this.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext();
        BufferSimpleWriter sw = new BufferSimpleWriter(this.getCssRules().getLength() * 20 + 32);
        try {
            this.getCssRules().writeCssText(sw, context);
            context.endRuleList(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String toStyleString() {
        StyleFormattingContext context = this.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext();
        BufferSimpleWriter sw = new BufferSimpleWriter(this.getCssRules().getLength() * 20 + 92);
        try {
            sw.write("<style type=\"text/css\"");
            if (!this.destinationMedia.isAllMedia()) {
                sw.write(" media=\"");
                sw.write(this.destinationMedia.getMediaText());
                sw.write('\"');
            }
            if (this.getTitle() != null) {
                sw.write(" title=\"");
                sw.write(this.getTitle());
                sw.write('\"');
            }
            sw.write('>');
            sw.newLine();
            this.getCssRules().writeCssText(sw, context);
            context.endRuleList(sw);
            sw.newLine();
            sw.write("</style>");
            sw.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    CSSDocumentHandler createDocumentHandler(byte origin, boolean ignoreComments) {
        return new CSSDocumentHandler(origin, ignoreComments);
    }

    @Override
    public boolean parseStyleSheet(InputSource source) throws DOMException, IOException {
        return this.parseStyleSheet(source, false);
    }

    @Override
    public boolean parseStyleSheet(InputSource source, boolean ignoreComments) throws DOMException, IOException {
        if (this.sheetErrorHandler != null) {
            this.sheetErrorHandler.reset();
        }
        byte origin = this.getOrigin();
        for (AbstractCSSRule rule : this.getCssRules()) {
            byte ruleo = rule.getOrigin();
            if (ruleo >= origin) continue;
            origin = ruleo;
        }
        Parser parser = this.getStyleSheetFactory().createSACParser();
        CSSDocumentHandler handler = this.createDocumentHandler(origin, ignoreComments);
        parser.setDocumentHandler((DocumentHandler)handler);
        parser.setErrorHandler((org.w3c.css.sac.ErrorHandler)handler);
        try {
            parser.parseStyleSheet(source);
        }
        catch (CSSNamespaceParseException e) {
            DOMException ex = new DOMException(14, e.getMessage());
            ex.initCause((Throwable)((Object)e));
            throw ex;
        }
        catch (CSSException e) {
            DOMException ex;
            switch (e.getCode()) {
                case 1: {
                    ex = new DOMException(9, e.getMessage());
                    break;
                }
                case 2: {
                    ex = new DOMException(12, e.getMessage());
                    break;
                }
                default: {
                    ex = new DOMException(15, e.getMessage());
                }
            }
            ex.initCause(e);
            throw ex;
        }
        catch (RuntimeException e) {
            String message = e.getMessage();
            String href = this.getHref();
            if (href != null) {
                message = "Error in stylesheet at " + href + ": " + message;
            }
            DOMException ex = new DOMException(11, message);
            ex.initCause(e);
            throw ex;
        }
        return !this.getErrorHandler().hasSacErrors();
    }

    boolean match(MediaQueryList media, SACMediaList sacMedia) {
        if (media.isAllMedia()) {
            return true;
        }
        if (sacMedia == null) {
            return !media.isNotAllMedia();
        }
        MediaQueryList otherqlist = this.getStyleSheetFactory().createMediaList(sacMedia, null);
        if (otherqlist.isAllMedia()) {
            return true;
        }
        return media.matches(otherqlist);
    }

    class CSSDocumentHandler
    implements DocumentHandler,
    org.w3c.css.sac.ErrorHandler,
    Parser2.NamespaceMap {
        private AbstractCSSRule currentRule = null;
        private final byte sheetOrigin;
        private final LinkedList<String> comments;
        private boolean ignoreRulesForMedia = false;
        private boolean ignoreImports = false;
        private CSSParseException outOfRuleException = null;

        CSSDocumentHandler(byte origin, boolean ignoreComments) {
            this.sheetOrigin = origin;
            this.comments = !ignoreComments ? new LinkedList() : null;
        }

        public void startDocument(InputSource source) throws CSSException {
            this.currentRule = null;
            this.ignoreRulesForMedia = false;
            this.ignoreImports = false;
            this.resetCommentStack();
        }

        public void endDocument(InputSource source) throws CSSException {
            this.resetCommentStack();
        }

        public void comment(String text) throws CSSException {
            if ((this.currentRule == null || this.currentRule instanceof GroupingRule) && this.comments != null) {
                this.comments.add(text);
            }
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            BaseCSSRule rule;
            String firstchars;
            int tentNameLen = atRule.length();
            if (tentNameLen > 21) {
                tentNameLen = 21;
            }
            if ((firstchars = atRule.trim().substring(0, tentNameLen).toLowerCase(Locale.ROOT)).startsWith("@supports")) {
                rule = BaseCSSStyleSheet.this.createSupportsRule();
            } else if (firstchars.startsWith("@keyframes ")) {
                rule = new KeyframesRule((AbstractCSSStyleSheet)BaseCSSStyleSheet.this, BaseCSSStyleSheet.this.getOrigin());
            } else if (firstchars.startsWith("@viewport")) {
                rule = BaseCSSStyleSheet.this.createViewportRule();
            } else if (firstchars.startsWith("@counter-style ")) {
                rule = new CounterStyleRule(BaseCSSStyleSheet.this, BaseCSSStyleSheet.this.getOrigin());
            } else if (firstchars.equals("@font-feature-values ")) {
                rule = new FontFeatureValuesRule(BaseCSSStyleSheet.this, BaseCSSStyleSheet.this.getOrigin());
            } else {
                rule = BaseCSSStyleSheet.this.createUnknownRule();
                if (atRule.charAt(1) != '-') {
                    BaseCSSStyleSheet.this.getErrorHandler().unknownRule(atRule);
                }
            }
            try {
                ((AbstractCSSRule)rule).setCssText(atRule);
            }
            catch (DOMException e) {
                BaseCSSStyleSheet.this.getErrorHandler().badAtRule(e, atRule);
                return;
            }
            this.setCommentsToRule(rule);
            if (this.currentRule != null) {
                this.addToCurrentRule(rule);
            } else {
                BaseCSSStyleSheet.this.addLocalRule(rule);
                this.resetCurrentRule();
            }
        }

        private void addToCurrentRule(AbstractCSSRule rule) {
            try {
                ((GroupingRule)this.currentRule).addRule(rule);
            }
            catch (ClassCastException e) {
                DOMException ex = new DOMException(12, "Found @-rule inside a non-grouping rule of type: " + this.currentRule.getType());
                BaseCSSStyleSheet.this.getErrorHandler().badAtRule(ex, rule.getCssText());
            }
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            BaseCSSStyleSheet.this.namespaces.put(uri, prefix);
            if (!this.ignoreRulesForMedia) {
                NamespaceRule rule = BaseCSSStyleSheet.this.createNamespaceRule(prefix, uri);
                if (this.currentRule != null) {
                    this.addToCurrentRule(rule);
                } else {
                    BaseCSSStyleSheet.this.addLocalRule(rule);
                }
                this.resetCurrentRule();
            } else {
                this.resetCommentStack();
            }
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException, DOMException {
            if (this.ignoreImports) {
                SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                if (eh != null) {
                    eh.ignoredImport(uri);
                }
                this.resetCommentStack();
                return;
            }
            if (BaseCSSStyleSheet.this.match(BaseCSSStyleSheet.this.destinationMedia, media)) {
                MediaQueryList mql = BaseCSSStyleSheet.this.getStyleSheetFactory().createMediaList(media, BaseCSSStyleSheet.this.getOwnerNode());
                if (!mql.isNotAllMedia()) {
                    if (this.currentRule == null) {
                        ImportRule imp = BaseCSSStyleSheet.this.createImportRule(mql, uri);
                        this.setCommentsToRule(imp);
                        BaseCSSStyleSheet.this.addLocalRule(imp);
                    }
                } else {
                    BaseCSSStyleSheet.this.getErrorHandler().badMediaList(media);
                }
            } else {
                this.resetCommentStack();
            }
        }

        public void startMedia(SACMediaList media) throws CSSException {
            SheetErrorHandler eh;
            this.ignoreImports = true;
            MediaQueryList mlist = BaseCSSStyleSheet.this.getStyleSheetFactory().createMediaList(media, BaseCSSStyleSheet.this.getOwnerNode());
            if (mlist.hasErrors() && (eh = BaseCSSStyleSheet.this.getErrorHandler()) != null) {
                eh.badMediaList(media);
            }
            if (this.currentRule != null) {
                if (this.currentRule.getType() == 4) {
                    MediaRule rule = new MediaRule((AbstractCSSStyleSheet)BaseCSSStyleSheet.this, mlist, this.sheetOrigin);
                    ((GroupingRule)this.currentRule).addRule(rule);
                    this.currentRule = rule;
                    this.setCommentsToRule(this.currentRule);
                    this.ignoreRulesForMedia = false;
                } else {
                    eh = BaseCSSStyleSheet.this.getErrorHandler();
                    if (eh != null) {
                        eh.sacMalfunction("Unexpected media rule inside of: " + this.currentRule.getCssText());
                        this.ignoreRulesForMedia = true;
                        return;
                    }
                }
            } else if (mlist.isNotAllMedia() && !BaseCSSStyleSheet.this.getStyleSheetFactory().hasCompatValueFlags()) {
                this.resetCommentStack();
                this.ignoreRulesForMedia = true;
            } else {
                this.currentRule = new MediaRule((AbstractCSSStyleSheet)BaseCSSStyleSheet.this, mlist, this.sheetOrigin);
                this.setCommentsToRule(this.currentRule);
                this.ignoreRulesForMedia = false;
            }
        }

        public void endMedia(SACMediaList media) throws CSSException {
            if (this.ignoreRulesForMedia) {
                this.ignoreRulesForMedia = false;
                this.resetCommentStack();
            } else if (this.currentRule != null) {
                AbstractCSSRule pRule = this.currentRule.getParentRule();
                if (pRule == null) {
                    BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                    this.resetCurrentRule();
                } else {
                    this.resetCurrentRule();
                    this.currentRule = pRule;
                }
            }
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                if (this.currentRule instanceof PageRule) {
                    MarginRule marginRule = BaseCSSStyleSheet.this.createMarginRule(name);
                    marginRule.setParentRule(this.currentRule);
                    this.currentRule = marginRule;
                } else {
                    PageRule pageRule = BaseCSSStyleSheet.this.createPageRule();
                    pageRule.setParentRule(this.currentRule);
                    this.currentRule = pageRule;
                    String selector = name != null ? (pseudo_page != null ? name + ' ' + pseudo_page : name) : pseudo_page;
                    if (selector != null) {
                        Parser parser = BaseCSSStyleSheet.this.getStyleSheetFactory().createSACParser();
                        InputSource source = new InputSource((Reader)new StringReader(selector));
                        try {
                            pageRule.setSelectorList(parser.parseSelectors(source));
                        }
                        catch (IOException iOException) {}
                    } else {
                        pageRule.setSelectorText("");
                    }
                }
                this.setCommentsToRule(this.currentRule);
            } else {
                this.resetCommentStack();
            }
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                if (this.currentRule != null) {
                    AbstractCSSRule pRule = this.currentRule.getParentRule();
                    if (this.currentRule instanceof PageRule) {
                        if (pRule == null) {
                            BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                            this.resetCurrentRule();
                        } else {
                            ((GroupingRule)pRule).addRule(this.currentRule);
                            this.resetCommentStack();
                            this.currentRule = pRule;
                        }
                    } else {
                        PageRule pageRule = (PageRule)pRule;
                        pageRule.addMarginRule((MarginRule)this.currentRule);
                        this.resetCommentStack();
                    }
                    this.currentRule = pRule;
                }
            } else {
                this.resetCommentStack();
            }
        }

        public void startFontFace() throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                FontFaceRule rule = new FontFaceRule(BaseCSSStyleSheet.this, this.sheetOrigin);
                rule.setParentRule(this.currentRule);
                this.currentRule = rule;
            }
            this.setCommentsToRule(this.currentRule);
        }

        public void endFontFace() throws CSSException {
            if (!this.ignoreRulesForMedia) {
                if (this.currentRule != null) {
                    AbstractCSSRule pRule = this.currentRule.getParentRule();
                    if (pRule == null) {
                        BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                        this.resetCurrentRule();
                    } else {
                        this.addCurrentRuleToRule(pRule);
                        this.resetCommentStack();
                        this.currentRule = pRule;
                    }
                }
            } else {
                this.resetCommentStack();
            }
        }

        private void addCurrentRuleToRule(AbstractCSSRule rule) {
            try {
                ((GroupingRule)rule).addRule(this.currentRule);
            }
            catch (ClassCastException e) {
                DOMException ex = new DOMException(12, "Found @-rule inside a non-grouping rule of type: " + rule.getType());
                BaseCSSStyleSheet.this.getErrorHandler().badAtRule(ex, this.currentRule.getCssText());
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                StyleRule styleRule = BaseCSSStyleSheet.this.createStyleRule();
                if (this.currentRule != null) {
                    styleRule.setParentRule(this.currentRule);
                }
                this.currentRule = styleRule;
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
                this.setCommentsToRule(this.currentRule);
            } else {
                this.resetCommentStack();
            }
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            if (!this.ignoreRulesForMedia && this.currentRule != null && this.currentRule.getType() == 1) {
                BaseCSSRule pRule = (BaseCSSRule)this.currentRule.getParentRule();
                if (((StyleRule)this.currentRule).getStyle().getLength() == 0) {
                    SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                    if (eh != null) {
                        eh.emptyStyleRule(((StyleRule)this.currentRule).getSelectorText());
                    }
                } else if (pRule == null) {
                    if (this.currentRule != null) {
                        BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                    }
                } else {
                    ((GroupingRule)pRule).addRule(this.currentRule);
                }
                this.currentRule = pRule;
            }
            this.resetCommentStack();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                String importantString = null;
                importantString = important ? "important" : null;
                if (this.currentRule != null) {
                    try {
                        ((BaseCSSStyleDeclaration)((BaseCSSDeclarationRule)this.currentRule).getStyle()).setProperty(name, value, importantString);
                    }
                    catch (RuntimeException e) {
                        CSSPropertyValueException ex = new CSSPropertyValueException(e);
                        ex.setValueText(value.toString());
                        ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().wrongValue(name, ex);
                    }
                } else {
                    BaseCSSStyleSheet.this.getErrorHandler().sacMalfunction("Unexpected property " + name + ": " + value.toString());
                }
            }
        }

        private void resetCurrentRule() {
            if (this.currentRule != null) {
                this.currentRule = null;
            }
            this.resetCommentStack();
        }

        private void setCommentsToRule(AbstractCSSRule rule) {
            if (this.comments != null && !this.comments.isEmpty()) {
                ArrayList<String> ruleComments = new ArrayList<String>(this.comments.size());
                ruleComments.addAll(this.comments);
                rule.setPrecedingComments(ruleComments);
            }
            this.resetCommentStack();
        }

        private void resetCommentStack() {
            if (this.comments != null) {
                this.comments.clear();
            }
        }

        @Override
        public String getNamespaceURI(String nsPrefix) {
            for (Map.Entry entry : BaseCSSStyleSheet.this.namespaces.entrySet()) {
                String prefix = (String)entry.getValue();
                if (!nsPrefix.equals(prefix)) continue;
                return (String)entry.getKey();
            }
            return null;
        }

        public void warning(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof BaseCSSDeclarationRule && ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                AbstractCSSStyleDeclaration style = ((BaseCSSDeclarationRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacWarning(exception, previousIndex);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacWarning(exception);
            }
        }

        public void error(CSSParseException exception) throws CSSException {
            if (this.currentRuleCanHandleError()) {
                int previousIndex = -1;
                AbstractCSSStyleDeclaration style = ((BaseCSSDeclarationRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacError(exception, previousIndex);
                BaseCSSStyleSheet.this.getErrorHandler().mapError(exception, this.currentRule);
            } else {
                this.nonRuleErrorHandling(exception);
            }
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            if (this.currentRuleCanHandleError()) {
                int previousIndex = -1;
                AbstractCSSStyleDeclaration style = ((BaseCSSDeclarationRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler().sacFatalError(exception, previousIndex);
                BaseCSSStyleSheet.this.getErrorHandler().mapError(exception, this.currentRule);
            } else {
                this.nonRuleErrorHandling(exception);
            }
        }

        private boolean currentRuleCanHandleError() {
            return this.currentRule != null && this.currentRule instanceof BaseCSSDeclarationRule && ((BaseCSSDeclarationRule)this.currentRule).getStyleDeclarationErrorHandler() != null;
        }

        private void nonRuleErrorHandling(CSSParseException exception) {
            BaseCSSStyleSheet.this.getErrorHandler().handleSacError(exception);
            if (this.outOfRuleException == null) {
                this.outOfRuleException = exception;
            }
            if (this.currentRule != null) {
                this.currentRule = this.currentRule.getParentRule();
            }
        }
    }
}

