/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.agent.HeadlessDeviceFactory;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.ExtendedCSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SACParserFactory;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingFactory;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.DefaultSheetErrorHandler;
import io.sf.carte.doc.style.css.om.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingFactory;
import io.sf.carte.doc.style.css.om.LenientSystemDefaultValue;
import io.sf.carte.doc.style.css.om.MediaList;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaQueryListImpl;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

public abstract class BaseCSSStyleSheetFactory
extends AbstractCSSStyleSheetFactory {
    private static final String HTML_DEFAULT_SHEET = "/io/sf/carte/doc/style/css/html.css";
    private static final String HTML_DEFAULT_SHEET_QUIRKS = "/io/sf/carte/doc/style/css/html-quirks.css";
    private ClassLoader classLoader = null;
    private StyleFormattingFactory formattingFactory;
    private final EnumSet<Parser2.Flag> parserFlags;
    private byte flags = 0;
    private boolean lenientSystemValues = true;
    private AbstractCSSStyleSheet userImportantSheet = null;
    private AbstractCSSStyleSheet userNormalSheet = null;
    private DeviceFactory deviceFactory = null;

    protected BaseCSSStyleSheetFactory() {
        this(EnumSet.noneOf(Parser2.Flag.class));
    }

    protected BaseCSSStyleSheetFactory(EnumSet<Parser2.Flag> parserFlags) {
        this.parserFlags = parserFlags;
        this.setDeviceFactory(new HeadlessDeviceFactory());
        this.setStyleFormattingFactory(this.createDefaultStyleFormattingFactory());
    }

    protected StyleFormattingFactory createDefaultStyleFormattingFactory() {
        return new DefaultStyleFormattingFactory();
    }

    protected abstract BaseDocumentCSSStyleSheet createDocumentStyleSheet(byte var1);

    @Override
    public AbstractCSSStyleSheet createStyleSheet(String title, MediaQueryList media) {
        if (media == null) {
            media = MediaList.createUnmodifiable();
        }
        return this.createLinkedStyleSheet(null, title, media);
    }

    @Override
    protected abstract AbstractCSSStyleSheet createRuleStyleSheet(AbstractCSSRule var1, String var2, MediaQueryList var3);

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    @Override
    public StyleFormattingFactory getStyleFormattingFactory() {
        return this.formattingFactory;
    }

    @Override
    public void setStyleFormattingFactory(StyleFormattingFactory factory) {
        this.formattingFactory = factory;
    }

    @Override
    public void setUserStyleSheet(Reader re) throws IOException {
        if (re != null) {
            InputSource source = new InputSource(re);
            BaseDocumentCSSStyleSheet cssSheet = this.createDocumentStyleSheet((byte)9);
            ((AbstractCSSStyleSheet)cssSheet).parseStyleSheet(source);
            this.userImportantSheet = this.createDocumentStyleSheet((byte)3);
            this.userNormalSheet = this.createDocumentStyleSheet((byte)9);
            this.userNormalSheet.getCssRules().ensureCapacity(((AbstractCSSStyleSheet)cssSheet).getCssRules().getLength());
            BaseCSSStyleSheetFactory.prioritySplit(cssSheet, this.userImportantSheet, this.userNormalSheet);
        } else {
            this.userImportantSheet = null;
            this.userNormalSheet = null;
        }
    }

    @Override
    protected AbstractCSSStyleSheet getUserImportantStyleSheet() {
        return this.userImportantSheet;
    }

    @Override
    protected AbstractCSSStyleSheet getUserNormalStyleSheet() {
        return this.userNormalSheet;
    }

    static void prioritySplit(AbstractCSSStyleSheet cssSheet, AbstractCSSStyleSheet importantSheet, AbstractCSSStyleSheet normalSheet) {
        AbstractCSSStyleDeclaration userImportantStyle = cssSheet.createStyleDeclaration();
        AbstractCSSStyleDeclaration userNormalStyle = cssSheet.createStyleDeclaration();
        CSSRuleArrayList rules = cssSheet.getCssRules();
        int rl = rules.getLength();
        for (int i = 0; i < rl; ++i) {
            AbstractCSSRule r = (AbstractCSSRule)rules.item(i);
            if (r.getType() == 1) {
                BaseCSSStyleDeclaration style;
                CSSStyleDeclarationRule newrule;
                userImportantStyle.clear();
                userNormalStyle.clear();
                StyleRule rule = (StyleRule)r;
                CSSStyleDeclaration st = rule.getStyle();
                ((AbstractCSSStyleDeclaration)st).prioritySplit(userImportantStyle, userNormalStyle);
                if (!userImportantStyle.isEmpty()) {
                    newrule = importantSheet.createStyleRule();
                    newrule.setSelectorList(rule.getSelectorList());
                    style = (BaseCSSStyleDeclaration)newrule.getStyle();
                    style.setProperties((BaseCSSStyleDeclaration)userImportantStyle);
                    importantSheet.addRule(newrule);
                }
                if (userNormalStyle.isEmpty()) continue;
                newrule = normalSheet.createStyleRule();
                newrule.setSelectorList(rule.getSelectorList());
                style = (BaseCSSStyleDeclaration)newrule.getStyle();
                style.setProperties((BaseCSSStyleDeclaration)userNormalStyle);
                normalSheet.addRule(newrule);
                continue;
            }
            normalSheet.addRule(r.clone(normalSheet));
        }
    }

    protected BaseDocumentCSSStyleSheet htmlDefaultSheet() throws IllegalStateException {
        InputStream is = this.loadCSSfromClasspath(HTML_DEFAULT_SHEET);
        try {
            return this.loadDefaultSheet(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read the default style sheet", e);
        }
    }

    protected BaseDocumentCSSStyleSheet htmlQuirksDefaultSheet() throws IllegalStateException {
        InputStream is = this.loadCSSfromClasspath(HTML_DEFAULT_SHEET_QUIRKS);
        try {
            return this.loadDefaultSheet(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read the default style sheet", e);
        }
    }

    private BaseDocumentCSSStyleSheet loadDefaultSheet(InputStream is) throws IOException {
        BaseDocumentCSSStyleSheet cssSheet;
        InputStreamReader re = null;
        try {
            re = new InputStreamReader(is, "UTF-8");
            InputSource source = new InputSource((Reader)re);
            cssSheet = this.createDocumentStyleSheet((byte)16);
            cssSheet.parseStyleSheet(source, true);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (re != null) {
                try {
                    ((Reader)re).close();
                }
                catch (IOException iOException) {}
            }
        }
        return cssSheet;
    }

    private InputStream loadCSSfromClasspath(final String cssFilename) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                if (BaseCSSStyleSheetFactory.this.classLoader != null) {
                    return BaseCSSStyleSheetFactory.this.classLoader.getResourceAsStream(BaseCSSStyleSheetFactory.resourcePath(BaseCSSStyleSheetFactory.class.getPackage().getName(), cssFilename));
                }
                return this.getClass().getResourceAsStream(cssFilename);
            }
        });
    }

    private static String resourcePath(String clase, String filename) {
        return '/' + clase.replace('.', '/') + '/' + filename;
    }

    @Override
    protected ValueFactory getValueFactory() {
        return new ValueFactory(this.flags);
    }

    @Override
    public void setFactoryFlag(byte flag) {
        if (flag < 3) {
            this.flags = (byte)(this.flags & 0x7C);
            this.flags = (byte)(this.flags | flag);
        } else {
            this.flags = flag = (byte)(flag | this.flags & 3);
        }
    }

    @Override
    public void setLenientSystemValues(boolean lenient) {
        this.lenientSystemValues = lenient;
    }

    @Override
    public PrimitiveValue getSystemDefaultValue(String propertyName) {
        if (this.lenientSystemValues) {
            PrimitiveValue value = null;
            if ("color".equals(propertyName = propertyName.toLowerCase(Locale.ROOT)) || propertyName.endsWith("-color")) {
                value = (PrimitiveValue)new ValueFactory().parseProperty("#000000");
                ((ColorValue)value).setSystemDefault();
            } else if ("font-family".equals(propertyName)) {
                value = (PrimitiveValue)new ValueFactory().parseProperty("serif");
            }
            if (value != null) {
                return new LenientSystemDefaultValue((ExtendedCSSPrimitiveValue)value);
            }
        }
        return SystemDefaultValue.getInstance();
    }

    @Override
    protected Parser createSACParser() throws DOMException {
        Parser parser = SACParserFactory.createSACParser();
        if (parser instanceof Parser2) {
            Parser2 parser2 = (Parser2)parser;
            EnumSet<Parser2.Flag> flags = this.getParserFlags();
            for (Parser2.Flag flag : flags) {
                parser2.setFlag(flag);
            }
        }
        return parser;
    }

    @Override
    protected EnumSet<Parser2.Flag> getParserFlags() {
        return this.parserFlags;
    }

    @Override
    protected boolean hasCompatValueFlags() {
        EnumSet<Parser2.Flag> flags = this.parserFlags;
        return flags.contains((Object)Parser2.Flag.IEVALUES) || flags.contains((Object)Parser2.Flag.IEPRIO) || flags.contains((Object)Parser2.Flag.IEPRIOCHAR);
    }

    @Override
    public StyleDeclarationErrorHandler createInlineStyleErrorHandler(CSSElement owner) {
        return new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public StyleDeclarationErrorHandler createStyleDeclarationErrorHandler(CSSDeclarationRule rule) {
        return new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public SheetErrorHandler createSheetErrorHandler(ExtendedCSSStyleSheet<? extends ExtendedCSSRule> sheet) {
        return new DefaultSheetErrorHandler(sheet);
    }

    @Override
    public MediaQueryList createMediaQueryList(String mediaQueryString, Node owner) {
        if (BaseCSSStyleSheetFactory.isPlainMediaList(mediaQueryString)) {
            return MediaList.createMediaList(mediaQueryString);
        }
        return this.parseMediaQueryList(mediaQueryString, owner);
    }

    @Override
    public MediaQueryList createImmutableMediaQueryList(String media, Node owner) {
        if (media == null) {
            return MediaList.createUnmodifiable();
        }
        if (BaseCSSStyleSheetFactory.isPlainMediaList(media)) {
            return MediaList.createUnmodifiable(media);
        }
        return ((MediaListAccess)((Object)this.parseMediaQueryList(media, owner))).unmodifiable();
    }

    @Override
    @Deprecated
    public MediaQueryList createUnmodifiableMediaQueryList(String media, Node owner) {
        return this.createImmutableMediaQueryList(media, owner);
    }

    MediaQueryList parseMediaQueryList(String mediaQueryString, Node owner) {
        MediaQueryListImpl qlist = new MediaQueryListImpl();
        CSSParser parser = new CSSParser();
        if (this.getParserFlags().contains((Object)Parser2.Flag.IEVALUES)) {
            parser.setFlag(Parser2.Flag.IEVALUES);
        }
        qlist.parse(parser, mediaQueryString, owner);
        return qlist;
    }

    public MediaQueryList createMediaList(SACMediaList media, Node owner) {
        int sz = media.getLength();
        boolean plainMedium = true;
        for (int i = 0; i < sz; ++i) {
            if (MediaList.isPlainMedium(media.item(i))) continue;
            plainMedium = false;
            break;
        }
        if (plainMedium) {
            return MediaList.createMediaList(media);
        }
        CSSParser parser = new CSSParser();
        if (this.getParserFlags().contains((Object)Parser2.Flag.IEVALUES)) {
            parser.setFlag(Parser2.Flag.IEVALUES);
        }
        MediaQueryListImpl qlist = new MediaQueryListImpl();
        for (int i = 0; i < sz; ++i) {
            qlist.parse(parser, media.item(i), owner);
        }
        return qlist;
    }

    static boolean isPlainMediaList(String newMedium) {
        StringTokenizer st = new StringTokenizer(newMedium, ",");
        while (st.hasMoreTokens()) {
            if (MediaList.isPlainMedium(st.nextToken().trim())) continue;
            return false;
        }
        return true;
    }

    @Override
    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    public void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }
}

