/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.MediaList;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public abstract class BaseDocumentCSSStyleSheet
extends BaseCSSStyleSheet
implements DocumentCSSStyleSheet,
Cloneable {
    private String targetMedium = null;

    protected BaseDocumentCSSStyleSheet(String medium, byte origin) {
        super(null, MediaList.createUnmodifiable(medium), null, origin);
        this.targetMedium = "all".equals(medium) ? null : medium;
    }

    @Override
    public void setHref(String href) {
        throw new IllegalStateException("Document sheet's href is parent document href");
    }

    @Override
    public String getHref() {
        return this.getOwnerNode() != null ? this.getOwnerNode().getBaseURI() : null;
    }

    @Override
    public abstract CSSDocument getOwnerNode();

    public abstract void setOwnerDocument(CSSDocument var1);

    protected void copyToTarget(BaseDocumentCSSStyleSheet myCopy) {
        if (myCopy.getTargetMedium() == null) {
            throw new NullPointerException();
        }
        CSSDocument doc = myCopy.getOwnerNode();
        CSSCanvas canvas = doc != null ? doc.getCanvas() : null;
        if (!this.getMedia().matches(myCopy.getTargetMedium(), canvas)) {
            throw new IllegalArgumentException("Incompatible target medium: " + this.targetMedium);
        }
        this.copyFieldsTo(myCopy);
        myCopy.cssRules.ensureCapacity(this.cssRules.getLength());
        for (AbstractCSSRule rule : this.cssRules) {
            short type = rule.getType();
            if (type == 4 && !((MediaRule)rule).getMedia().matches(this.targetMedium, canvas) || type == 3 && !((ImportRule)rule).getMedia().matches(this.targetMedium, canvas)) continue;
            myCopy.cssRules.add(rule.clone(myCopy));
        }
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public abstract ComputedCSSStyle getComputedStyle(CSSElement var1, String var2);

    @Override
    public abstract BaseDocumentCSSStyleSheet clone();

    @Override
    public abstract BaseDocumentCSSStyleSheet clone(String var1);

    protected ComputedCSSStyle computeStyle(ComputedCSSStyle style, SelectorMatcher matcher, String pseudoElt, InlineStyle inlineStyle) {
        AbstractCSSStyleSheet userImportantStyleSheet;
        if (this.getDisabled()) {
            return style;
        }
        matcher.setPseudoElement(pseudoElt);
        CSSElement elt = style.getOwnerNode();
        ErrorHandler errHandler = elt.getOwnerDocument().getErrorHandler();
        errHandler.resetComputedStyleErrors(elt);
        if (elt.hasPresentationalHints()) {
            try {
                elt.exportHintsToStyle(style);
            }
            catch (DOMException e) {
                errHandler.presentationalHintError(elt, e);
            }
        }
        Cascade matchingStyles = new Cascade();
        matchingStyles.cascade(matcher, this.getTargetMedium(), this.cssRules);
        Iterator<StyleRule> styleit = matchingStyles.iterator();
        while (styleit.hasNext()) {
            StyleRule rule = styleit.next();
            style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
        }
        if (inlineStyle != null && !inlineStyle.isEmpty()) {
            style.addStyle(inlineStyle);
        }
        if (elt.hasOverrideStyle(pseudoElt)) {
            style.addStyle((BaseCSSStyleDeclaration)elt.getOverrideStyle(pseudoElt));
        }
        if ((userImportantStyleSheet = this.getStyleSheetFactory().getUserImportantStyleSheet()) != null) {
            Cascade usercascade = new Cascade();
            usercascade.cascade(matcher, this.getTargetMedium(), userImportantStyleSheet.getCssRules());
            styleit = usercascade.iterator();
            while (styleit.hasNext()) {
                StyleRule rule = styleit.next();
                style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
            }
        }
        return style;
    }

    CSSCanvas getCanvas() {
        CSSCanvas canvas = this.getOwnerNode() != null ? this.getOwnerNode().getCanvas() : null;
        return canvas;
    }

    class Cascade {
        private final SortedMap<StyleRule.RuleSpecifity, LinkedList<StyleRule>> matchingStyles = new TreeMap<StyleRule.RuleSpecifity, LinkedList<StyleRule>>(new StyleRule.SpecificityComparator());

        Cascade() {
        }

        void cascade(SelectorMatcher matcher, String targetMedium, CSSRuleArrayList list) {
            for (CSSRule rule : list) {
                short type = rule.getType();
                if (type != 1 && type != 6) {
                    StyleDatabase sdb;
                    if (type == 4) {
                        this.scanMediaRule(matcher, targetMedium, BaseDocumentCSSStyleSheet.this.getCanvas(), (MediaRule)rule);
                        continue;
                    }
                    if (type == 5) {
                        this.processFontFaceRule((FontFaceRule)rule, targetMedium);
                        continue;
                    }
                    if (type != 12) continue;
                    SupportsRule supports = (SupportsRule)rule;
                    DeviceFactory df = BaseDocumentCSSStyleSheet.this.getStyleSheetFactory().getDeviceFactory();
                    if (df == null || (sdb = df.getStyleDatabase(targetMedium)) == null || !supports.supports(sdb)) continue;
                    CSSRuleArrayList rules = supports.getCssRules();
                    this.cascade(matcher, targetMedium, rules);
                    continue;
                }
                StyleRule stylerule = (StyleRule)rule;
                int selIdx = matcher.matches(stylerule.getSelectorList());
                if (selIdx == -1) continue;
                this.add(stylerule.getSpecifity(selIdx));
            }
        }

        private void scanMediaRule(SelectorMatcher matcher, String targetMedium, CSSCanvas canvas, MediaRule mediaRule) {
            MediaQueryList mediaList = mediaRule.getMedia();
            if (targetMedium != null && mediaList.matches(targetMedium, canvas)) {
                CSSRuleList ruleList = mediaRule.getCssRules();
                this.cascade(matcher, targetMedium, (CSSRuleArrayList)ruleList);
            }
        }

        private void processFontFaceRule(FontFaceRule rule, String targetMedium) {
            StyleDatabase sdb;
            DeviceFactory df = BaseDocumentCSSStyleSheet.this.getStyleSheetFactory().getDeviceFactory();
            if (df != null && (sdb = df.getStyleDatabase(targetMedium)) != null) {
                sdb.loadFontFaceRule(rule);
            }
        }

        void add(StyleRule.RuleSpecifity sp) {
            if (this.matchingStyles.containsKey(sp)) {
                ((LinkedList)this.matchingStyles.get(sp)).add(sp.getCSSStyleRule());
            } else {
                LinkedList<StyleRule> matchingRules = new LinkedList<StyleRule>();
                matchingRules.add(sp.getCSSStyleRule());
                this.matchingStyles.put(sp, matchingRules);
            }
        }

        Iterator<StyleRule> iterator() {
            return new RuleIterator();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            Iterator<StyleRule> it = this.iterator();
            while (it.hasNext()) {
                StyleRule rule = it.next();
                buf.append(rule.getOrigin()).append(": ").append(rule.getCssText()).append('\n');
            }
            return buf.toString();
        }

        class RuleIterator
        implements Iterator<StyleRule> {
            private final Iterator<StyleRule.RuleSpecifity> keyit;
            private Iterator<StyleRule> currentList;

            RuleIterator() {
                this.keyit = Cascade.this.matchingStyles.keySet().iterator();
                if (this.keyit.hasNext()) {
                    this.findCurrentList();
                } else {
                    this.currentList = null;
                }
            }

            private void findCurrentList() {
                while (this.currentList == null || !this.currentList.hasNext()) {
                    if (this.keyit.hasNext()) {
                        this.currentList = ((LinkedList)Cascade.this.matchingStyles.get(this.keyit.next())).iterator();
                        continue;
                    }
                    this.currentList = null;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.currentList != null;
            }

            @Override
            public StyleRule next() {
                if (this.currentList != null && this.currentList.hasNext()) {
                    StyleRule thenext = this.currentList.next();
                    this.findCurrentList();
                    return thenext;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

