/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.GridAreaShorthandSetter;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Iterator;
import org.w3c.css.sac.LexicalUnit;

abstract class BaseGridShorthandSetter
extends ShorthandSetter {
    BaseGridShorthandSetter(BaseCSSStyleDeclaration style, String shorthandName) {
        super(style, shorthandName);
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        this.currentValue = shorthandValue;
        this.setPriority(important);
        this.initValueString();
    }

    boolean isNoneDeclaration() {
        return this.currentValue.getLexicalUnitType() == 35 && "none".equalsIgnoreCase(this.currentValue.getStringValue()) && this.currentValue.getNextLexicalUnit() == null;
    }

    boolean isTemplateAreasSyntax() {
        LexicalUnit lu = this.currentValue;
        do {
            if (lu.getLexicalUnitType() != 36) continue;
            return true;
        } while ((lu = lu.getNextLexicalUnit()) != null);
        return false;
    }

    boolean templateSyntax(boolean setTemplateAreas) {
        StyleValue value;
        LexicalUnit fullValue = this.currentValue;
        ValueList gridTemplateRows = ValueList.createWSValueList();
        ValueList gridTemplateAreas = ValueList.createWSValueList();
        ValueList lineNames = null;
        boolean missSlash = !setTemplateAreas;
        int lasttype = -1;
        block5: do {
            short type = this.currentValue.getLexicalUnitType();
            switch (type) {
                case 68: {
                    LexicalUnit nlu;
                    ValueFactory.ListValueItem item;
                    if (lasttype == 36) {
                        gridTemplateRows.add(GridAreaShorthandSetter.createAutoValue());
                    }
                    if ((item = this.valueFactory.parseBracketList(nlu = this.currentValue.getNextLexicalUnit(), this.styleDeclaration, true)) != null) {
                        ValueList newLineNames = item.getCSSValue();
                        if (lineNames == null) {
                            lineNames = newLineNames;
                            gridTemplateRows.add(lineNames);
                        } else {
                            lineNames.addAll(newLineNames);
                        }
                        this.appendValueItemString(newLineNames);
                        this.currentValue = item.getNextLexicalUnit();
                        lasttype = type;
                        break;
                    }
                    this.currentValue = nlu.getNextLexicalUnit();
                    break;
                }
                case 36: {
                    if (lasttype == 36) {
                        gridTemplateRows.add(GridAreaShorthandSetter.createAutoValue());
                    }
                    lineNames = null;
                    value = this.createCSSValue();
                    gridTemplateAreas.add(value);
                    this.appendValueItemString(value);
                    lasttype = type;
                    break;
                }
                case 4: {
                    if (lasttype != -1) {
                        this.currentValue = this.currentValue.getNextLexicalUnit();
                        if (this.currentValue != null) {
                            value = this.valueFactory.createCSSValue(this.currentValue, this.styleDeclaration);
                            value = this.subpropertyValue(value);
                            this.setSubpropertyValue("grid-template-columns", value);
                            this.getValueItemBuffer().append(" /");
                            this.getValueItemBufferMini().append('/');
                            this.appendValueItemString(value);
                            missSlash = false;
                            break block5;
                        }
                        this.syntaxError("Unexpected end of declaration after slash '/' in " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                    } else {
                        this.syntaxError("Slash '/' was the first token in " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                    }
                    return false;
                }
                default: {
                    if (setTemplateAreas && type == 41 && "repeat".equalsIgnoreCase(this.currentValue.getFunctionName())) {
                        this.syntaxError("This syntax does not allow repeat(): " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue));
                        return false;
                    }
                    lineNames = null;
                    value = this.createCSSValue();
                    gridTemplateRows.add(value);
                    this.appendValueItemString(value);
                    lasttype = type;
                }
            }
        } while (this.currentValue != null);
        if (missSlash) {
            String message = "Not a correct rows / columns syntax: " + BaseCSSStyleDeclaration.lexicalUnitToString(fullValue);
            this.syntaxError(message);
            return false;
        }
        if (gridTemplateRows.getLength() != 0) {
            if (!BaseGridShorthandSetter.isAutoOnly(gridTemplateRows)) {
                value = gridTemplateRows.getLength() != 1 ? gridTemplateRows : gridTemplateRows.item(0);
                this.setSubpropertyValue("grid-template-rows", value);
            } else {
                this.setSubpropertyValue("grid-template-rows", gridTemplateRows.item(0));
            }
        } else if (setTemplateAreas) {
            IdentifierValue auto = new IdentifierValue("auto");
            auto.setSubproperty(true);
            this.setSubpropertyValue("grid-template-rows", auto);
        }
        if (gridTemplateAreas.getLength() != 0) {
            value = gridTemplateAreas.getLength() != 1 ? gridTemplateAreas : gridTemplateAreas.item(0);
            this.setSubpropertyValue("grid-template-areas", value);
        }
        return true;
    }

    StyleValue subpropertyValue(StyleValue value) {
        switch (value.getCssValueType()) {
            case 1: {
                ((PrimitiveValue)value).setSubproperty(true);
                break;
            }
            case 2: {
                ((ValueList)value).setSubproperty(true);
                break;
            }
            case 0: {
                value = ((InheritValue)value).asSubproperty();
            }
        }
        return value;
    }

    void syntaxError(String message) {
        BaseCSSDeclarationRule rule = this.styleDeclaration.getParentRule();
        if (rule != null) {
            rule.getStyleDeclarationErrorHandler().shorthandSyntaxError(this.getShorthandName(), message);
        }
    }

    @Override
    protected boolean isDelimiterChar(char c, String cssText) {
        return c == ',' || c == '/' || c == ']' && cssText.charAt(0) == '[';
    }

    static boolean isAutoOnly(ValueList list) {
        Iterator<StyleValue> it = list.iterator();
        while (it.hasNext()) {
            if ("auto".equalsIgnoreCase(it.next().getCssText())) continue;
            return false;
        }
        return true;
    }
}

