/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;

class BorderShorthandSetter
extends ShorthandSetter {
    BorderShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "border");
    }

    @Override
    public boolean assignSubproperties() {
        if (super.assignSubproperties()) {
            this.setDeclarationPropertyToDefault("border-image-source");
            this.setDeclarationPropertyToDefault("border-image-slice");
            this.setDeclarationPropertyToDefault("border-image-width");
            this.setDeclarationPropertyToDefault("border-image-outset");
            this.setDeclarationPropertyToDefault("border-image-repeat");
            this.styleDeclaration.getShorthandSet().remove("border-image");
            return true;
        }
        return false;
    }

    @Override
    protected boolean assignSubproperty(String subproperty) {
        if ("border-width".equals(subproperty)) {
            if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subproperty) || ValueFactory.isSizeSACUnit(this.currentValue)) {
                StyleValue cssValue = this.createCSSValue("border-width", this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.nextCurrentValue();
                return true;
            }
        } else if ("border-style".equals(subproperty)) {
            short utype = this.currentValue.getLexicalUnitType();
            if (35 == utype && this.testIdentifiers(subproperty)) {
                StyleValue cssValue = this.createCSSValue("border-style", this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.nextCurrentValue();
                return true;
            }
        } else if ("border-color".equals(subproperty) && BaseCSSStyleDeclaration.testColor(this.currentValue)) {
            StyleValue cssValue = this.createCSSValue("border-color", this.currentValue);
            this.setSubpropertyValue(subproperty, cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    @Override
    protected void setSubpropertyValue(String subproperty, StyleValue cssValue) {
        String[] subparray = this.getShorthandDatabase().getShorthandSubproperties(subproperty);
        for (int i = 0; i < subparray.length; ++i) {
            if (i != 0) {
                cssValue = cssValue.clone();
            }
            super.setSubpropertyValue(subparray[i], cssValue);
        }
    }
}

