/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.SimpleBoxModel;
import io.sf.carte.doc.style.css.property.NumberValue;

public class BoxModelHelper {
    public static String contractSpaces(String t) {
        int tl = t.length();
        StringBuffer sb = new StringBuffer(tl);
        int ini = 0;
        int fin = 0;
        while ((ini = t.indexOf("  ", fin)) != -1) {
            sb.append(t.substring(fin, ini));
            fin = ini;
            while (++fin < tl && t.charAt(fin) == ' ') {
            }
            --fin;
        }
        sb.append(t.substring(fin));
        return sb.toString();
    }

    public static float computeNodeMinimumWidth(String text, ComputedCSSStyle style, CSSCanvas canvas, short unitType) {
        int k;
        int tlen = text.length();
        int maxsz = 0;
        int j = 0;
        int i = 0;
        while (i < tlen) {
            if (BoxModelHelper.isSeparator(text.charAt(i))) {
                k = canvas.stringWidth(text.substring(j, i), style);
                if (k > maxsz) {
                    maxsz = k;
                }
                j = i;
                ++j;
                while (j < tlen && BoxModelHelper.isSeparator(text.charAt(j))) {
                    ++j;
                }
                i = j;
                continue;
            }
            ++i;
        }
        if (j > 0) {
            k = canvas.stringWidth(text.substring(j, tlen), style);
            if (k > maxsz) {
                maxsz = k;
            }
        } else {
            maxsz = canvas.stringWidth(text, style);
        }
        return NumberValue.floatValueConversion(maxsz, (short)9, unitType);
    }

    public static float computeNodeMinimumWidth(String text, ComputedCSSStyle styledecl, short unitType) {
        float maxsz = BoxModelHelper.computeMinimumCharsWidth(text);
        if (maxsz == 0.0f) {
            return 0.0f;
        }
        if (styledecl.getStyleDatabase() == null) {
            if (unitType < 0) {
                throw new StyleDatabaseRequiredException();
            }
            maxsz *= 0.5f * styledecl.getComputedFontSize();
        } else {
            if (unitType < 0) {
                unitType = styledecl.getStyleDatabase().getNaturalUnit();
            }
            maxsz *= styledecl.getStyleDatabase().getExSizeInPt(styledecl.getUsedFontFamily(), styledecl.getComputedFontSize());
        }
        return NumberValue.floatValueConversion(maxsz, (short)9, unitType);
    }

    public static int computeMinimumCharsWidth(String text) {
        int tlen = text.length();
        int maxsz = 0;
        int j = 0;
        int i = 0;
        while (i < tlen) {
            if (BoxModelHelper.isSeparator(text.charAt(i))) {
                int k = i - j;
                if (k > maxsz) {
                    maxsz = k;
                }
                j = i;
                ++j;
                while (j < tlen && BoxModelHelper.isSeparator(text.charAt(j))) {
                    ++j;
                }
                i = j;
                continue;
            }
            ++i;
        }
        if (j > 0) {
            if (tlen - j > maxsz) {
                maxsz = tlen - j;
            }
        } else {
            maxsz = tlen;
        }
        return maxsz;
    }

    private static boolean isSeparator(char c) {
        return Character.isWhitespace(c);
    }

    public static float computeTextWidth(String text, ComputedCSSStyle styledecl, short unitType) {
        float maxsz = text.length();
        if (maxsz == 0.0f) {
            return 0.0f;
        }
        if (styledecl.getStyleDatabase() == null) {
            if (unitType < 0) {
                throw new StyleDatabaseRequiredException();
            }
            maxsz *= 0.5f * styledecl.getComputedFontSize();
        } else {
            if (unitType < 0) {
                unitType = styledecl.getStyleDatabase().getNaturalUnit();
            }
            maxsz *= styledecl.getStyleDatabase().getExSizeInPt(styledecl.getUsedFontFamily(), styledecl.getComputedFontSize());
        }
        return NumberValue.floatValueConversion(maxsz, (short)9, unitType);
    }

    static void shrinkTo(SimpleBoxModel.MyTableBoxValues box, float[] minrcw, float minwidth, float curwidth, float width) {
        int shrinkableCount = 0;
        for (int i = 0; i < minrcw.length; ++i) {
            if (!(box.colwidth[i] > minrcw[i])) continue;
            ++shrinkableCount;
        }
        if (shrinkableCount == 0) {
            return;
        }
        float delta = curwidth - width;
        float coldelta = delta / (float)shrinkableCount;
        float shrink = 0.0f;
        curwidth = 0.0f;
        for (int i = 0; i < minrcw.length; ++i) {
            float colwidth = box.colwidth[i];
            if (colwidth > minrcw[i]) {
                if ((colwidth -= coldelta) < minrcw[i]) {
                    colwidth = minrcw[i];
                }
                shrink += box.colwidth[i] - colwidth;
                box.colwidth[i] = colwidth;
            }
            curwidth += colwidth;
        }
        if (Math.abs(delta - shrink) > 0.1f) {
            BoxModelHelper.shrinkTo(box, minrcw, minwidth, curwidth, width);
        }
    }
}

