/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.PositionalCondition2;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import io.sf.jclf.text.TokenParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.DOMException;

public abstract class CSSStyleDeclarationRule
extends BaseCSSDeclarationRule {
    private SelectorList selectorList = null;
    private String selectorText = "";

    protected CSSStyleDeclarationRule(AbstractCSSStyleSheet parentSheet, short type, byte origin) {
        super(parentSheet, type, origin);
    }

    CSSStyleDeclarationRule() {
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    void setSelectorText(String selectorText) throws DOMException {
        this.selectorText = selectorText;
    }

    void setSelectorList(SelectorList selectorList) {
        this.selectorList = selectorList;
        this.updateSelectorText();
    }

    void updateSelectorText() {
        int sz = this.selectorList.getLength();
        StringBuilder sb = new StringBuilder(sz * 7 + 5);
        if (sz > 0) {
            this.selectorListText(sb, this.selectorList, false, false);
        }
        this.selectorText = sb.toString();
    }

    SelectorList getSelectorList() {
        return this.selectorList;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.clear();
        this.selectorList = null;
        this.selectorText = "";
        Parser parser = this.createSACParser();
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        PropertyDocumentHandler handler = this.createDocumentHandler();
        handler.setLexicalPropertyListener(this.getLexicalPropertyListener());
        parser.setDocumentHandler((DocumentHandler)handler);
        parser.setErrorHandler((ErrorHandler)handler);
        try {
            parser.parseRule(source);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0) {
            context.startRule(wri);
            wri.write(seltext);
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            this.getStyle().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri);
        }
    }

    @Override
    public String getMinifiedCssText() {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0) {
            return seltext + '{' + this.getStyle().getMinifiedCssText() + '}';
        }
        return "";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = super.hashCode();
        result = 31 * result + (this.selectorList == null ? 0 : this.selectorList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSSStyleDeclarationRule)) {
            return false;
        }
        CSSStyleDeclarationRule other = (CSSStyleDeclarationRule)obj;
        if (!super.equals(other)) {
            return false;
        }
        return !(this.selectorList == null ? other.selectorList != null : !this.selectorList.equals(other.selectorList));
    }

    @Override
    public CSSStyleDeclarationRule clone(AbstractCSSStyleSheet parentSheet) throws IllegalArgumentException {
        CSSStyleDeclarationRule rule;
        Constructor<?> ctor;
        Class[] parameterTypes = new Class[]{AbstractCSSStyleSheet.class, Byte.TYPE};
        try {
            ctor = this.getClass().getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        Object[] initargs = new Object[]{parentSheet, this.getOrigin()};
        try {
            rule = (CSSStyleDeclarationRule)ctor.newInstance(initargs);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        rule.selectorList = this.getSelectorList();
        rule.selectorText = this.getSelectorText();
        if (this.hasErrorsOrWarnings()) {
            rule.setStyleDeclarationErrorHandler(this.getStyleDeclarationErrorHandler());
        }
        return rule;
    }

    protected PropertyDocumentHandler createDocumentHandler() {
        return new RuleDocumentHandler();
    }

    String selectorText(Selector sel, boolean omitUniversal) {
        return this.selectorText(sel, omitUniversal, false);
    }

    private String selectorText(Selector sel, boolean omitUniversal, boolean scoped) {
        switch (sel.getSelectorType()) {
            case 1: {
                return omitUniversal ? "" : "*";
            }
            case 4: {
                ElementSelector esel = (ElementSelector)sel;
                String lname = esel.getLocalName();
                String nsuri = esel.getNamespaceURI();
                if (nsuri != null) {
                    if (nsuri.length() != 0) {
                        String nsprefix = this.getParentStyleSheet().getNamespacePrefix(esel.getNamespaceURI());
                        if (nsprefix.length() != 0) {
                            return nsprefix + "|" + lname;
                        }
                        return lname;
                    }
                    return "|" + lname;
                }
                AbstractCSSStyleSheet psheet = this.getParentStyleSheet();
                if (psheet != null && psheet.hasDefaultNamespace()) {
                    return "*|" + lname;
                }
                return lname != null ? lname : (omitUniversal ? "" : "*");
            }
            case 11: {
                DescendantSelector dsel = (DescendantSelector)sel;
                Selector ancsel = dsel.getAncestorSelector();
                String anctext = !scoped || ancsel.getSelectorType() != 1 ? this.selectorText(ancsel, false, scoped) : "";
                String desctext = this.selectorText((Selector)dsel.getSimpleSelector(), false, scoped);
                StringBuilder buf = new StringBuilder(anctext.length() + desctext.length() + 3);
                buf.append(anctext);
                short stype = dsel.getSimpleSelector().getSelectorType();
                if (stype != 9 && stype != 3) {
                    buf.append(">");
                }
                buf.append(desctext);
                return buf.toString();
            }
            case 0: {
                ConditionalSelector csel = (ConditionalSelector)sel;
                return this.conditionalSelectorText(csel.getCondition(), csel.getSimpleSelector());
            }
            case 10: {
                DescendantSelector dsel = (DescendantSelector)sel;
                String anctext = this.selectorText(dsel.getAncestorSelector(), false, scoped);
                String desctext = this.selectorText((Selector)dsel.getSimpleSelector(), false, scoped);
                StringBuilder buf = new StringBuilder(anctext.length() + desctext.length() + 1);
                buf.append(anctext);
                if (dsel.getSimpleSelector().getSelectorType() != 9) {
                    buf.append(' ');
                }
                buf.append(desctext);
                return buf.toString();
            }
            case 12: {
                SiblingSelector asel = (SiblingSelector)sel;
                return this.selectorText(asel.getSelector(), omitUniversal, scoped) + " + " + this.selectorText((Selector)asel.getSiblingSelector(), false, scoped);
            }
            case 13: {
                SiblingSelector asel = (SiblingSelector)sel;
                return this.selectorText(asel.getSelector(), omitUniversal, scoped) + "~" + this.selectorText((Selector)asel.getSiblingSelector(), false, scoped);
            }
            case 14: {
                DescendantSelector dsel = (DescendantSelector)sel;
                return this.selectorText(dsel.getAncestorSelector(), omitUniversal, scoped) + "||" + this.selectorText((Selector)dsel.getSimpleSelector(), false, scoped);
            }
            case 2: {
                return ":root";
            }
            case 15: {
                return "";
            }
        }
        return null;
    }

    private String conditionalSelectorText(Condition condition, SimpleSelector simpleSelector) {
        switch (condition.getConditionType()) {
            case 9: {
                return this.classText((AttributeCondition)condition, simpleSelector);
            }
            case 5: {
                return "#" + ParseHelper.escape(((AttributeCondition)condition).getValue(), false, false);
            }
            case 4: {
                return this.attributeText((AttributeCondition)condition, simpleSelector);
            }
            case 14: {
                return this.attributeBeginsText((AttributeCondition)condition, simpleSelector);
            }
            case 8: {
                return this.attributeBeginHyphenText((AttributeCondition)condition, simpleSelector);
            }
            case 15: {
                return this.attributeEndsText((AttributeCondition)condition, simpleSelector);
            }
            case 16: {
                return this.attributeSubstringText((AttributeCondition)condition, simpleSelector);
            }
            case 6: {
                return this.langText((LangCondition)condition, simpleSelector);
            }
            case 2: {
                return ":not(" + this.conditionalSelectorText(((NegativeCondition)condition).getCondition(), simpleSelector) + ")";
            }
            case 7: {
                return this.attributeOneOfText((AttributeCondition)condition, simpleSelector);
            }
            case 11: {
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    this.appendSimpleSelector(simpleSelector, buf);
                }
                return buf.append(":only-child").toString();
            }
            case 12: {
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    this.appendSimpleSelector(simpleSelector, buf);
                }
                return buf.append(":only-of-type").toString();
            }
            case 3: {
                StringBuilder buf = new StringBuilder(50);
                if (simpleSelector != null) {
                    this.appendSimpleSelector(simpleSelector, buf);
                }
                PositionalCondition2 pcond = (PositionalCondition2)condition;
                buf.append(':');
                if (pcond.getType()) {
                    this.appendPositionalOfType(pcond, buf);
                } else {
                    this.appendPositional(pcond, buf);
                }
                return buf.toString();
            }
            case 10: {
                return this.pseudoClassText((AttributeCondition)condition, simpleSelector);
            }
            case 18: {
                return this.pseudoElementText((AttributeCondition)condition, simpleSelector);
            }
            case 1: {
                return this.conditionOrDeprecated(simpleSelector, (CombinatorCondition)condition);
            }
            case 0: {
                CombinatorCondition ccond = (CombinatorCondition)condition;
                return this.conditionalSelectorText(ccond.getFirstCondition(), simpleSelector) + this.conditionalSelectorText(ccond.getSecondCondition(), null);
            }
            case 17: {
                return this.selectorArgumentText((ArgumentCondition)condition, simpleSelector);
            }
        }
        return null;
    }

    private void appendSimpleSelector(SimpleSelector simpleSelector, StringBuilder buf) {
        buf.append(this.selectorText((Selector)simpleSelector, true));
    }

    private String classText(AttributeCondition acond, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(16);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append(".").append(ParseHelper.escape(acond.getValue(), false, false));
        return buf.toString();
    }

    private String pseudoClassText(AttributeCondition acond, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(24);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append(':');
        String name = acond.getLocalName();
        String value = acond.getValue();
        if (name == null) {
            buf.append(value);
        } else {
            buf.append(name);
            if (value != null) {
                buf.append('(');
                buf.append(value);
                buf.append(')');
            }
        }
        return buf.toString();
    }

    private String attributeText(AttributeCondition acond, SimpleSelector simpleSelector) {
        String value;
        StringBuilder buf = new StringBuilder(32);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        if ((value = acond.getValue()) != null) {
            buf.append('[').append(acond.getLocalName()).append('=');
            this.quoteAttributeValue(acond.getValue(), buf);
            buf.append(']');
        } else {
            buf.append('[').append(acond.getLocalName()).append(']');
        }
        return buf.toString();
    }

    private String attributeBeginsText(AttributeCondition acond, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append('[').append(acond.getLocalName()).append("^=");
        this.quoteAttributeValue(acond.getValue(), buf);
        buf.append(']');
        return buf.toString();
    }

    private String attributeBeginHyphenText(AttributeCondition acond, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append('[').append(acond.getLocalName()).append("|=");
        this.quoteAttributeValue(acond.getValue(), buf);
        buf.append(']');
        return buf.toString();
    }

    private String attributeEndsText(AttributeCondition acond, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append('[').append(acond.getLocalName()).append("$=");
        this.quoteAttributeValue(acond.getValue(), buf);
        buf.append(']');
        return buf.toString();
    }

    private String attributeSubstringText(AttributeCondition acond, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append('[').append(acond.getLocalName()).append("*=");
        this.quoteAttributeValue(acond.getValue(), buf);
        buf.append(']');
        return buf.toString();
    }

    private String attributeOneOfText(AttributeCondition acond, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(48);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append('[').append(acond.getLocalName()).append("~=");
        this.quoteAttributeValue(acond.getValue(), buf);
        buf.append(']');
        return buf.toString();
    }

    private void quoteAttributeValue(String value, StringBuilder buf) {
        char quote = this.quoteChar(true);
        buf.append(ParseHelper.quote(value, quote));
    }

    private String langText(LangCondition condition, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(32);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append(":lang(");
        String lang = condition.getLang();
        TokenParser parser = new TokenParser(lang, ", ", "\"'");
        String s = parser.next();
        int commaIdx = lang.indexOf(44) + 1;
        buf.append(this.escapeLang(s, lang, commaIdx));
        while (parser.hasNext()) {
            s = parser.next();
            commaIdx = lang.indexOf(44, commaIdx) + 1;
            buf.append(',').append(this.escapeLang(s, lang, commaIdx));
        }
        buf.append(')');
        return buf.toString();
    }

    private String escapeLang(String s, String lang, int commaIdx) {
        boolean noDQ;
        int nextCommaIdx = lang.indexOf(44, commaIdx) + 1;
        int nextDQIdx = lang.indexOf(34, commaIdx);
        int nextSQIdx = lang.indexOf(39, commaIdx);
        boolean bl = noDQ = nextDQIdx == -1 || nextDQIdx > nextCommaIdx;
        if (s.indexOf(32) != -1) {
            char quote = this.quoteChar(noDQ);
            s = ParseHelper.quote(s, quote);
        } else {
            CharSequence escaped = ParseHelper.escapeCssCharsAndFirstChar(s);
            if (escaped != s) {
                boolean noSQ;
                boolean bl2 = noSQ = nextSQIdx == -1 || nextSQIdx > nextCommaIdx;
                if (escaped.length() < s.length() + 2 && noDQ && noSQ) {
                    s = escaped.toString();
                } else {
                    char quote = this.quoteChar(noDQ);
                    s = ParseHelper.quote(s, quote);
                }
            }
        }
        return s;
    }

    private char quoteChar(boolean noDQ) {
        ValueFactory factory;
        AbstractCSSStyleSheet sheet = this.getParentStyleSheet();
        int quote = sheet != null ? ((factory = sheet.getStyleSheetFactory().getValueFactory()).hasFactoryFlag((byte)2) ? 34 : (factory.hasFactoryFlag((byte)1) ? 39 : (noDQ ? 39 : 34))) : (noDQ ? 39 : 34);
        return (char)quote;
    }

    private String pseudoElementText(AttributeCondition acond, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(16);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        return buf.append(':').append(':').append(acond.getLocalName()).toString();
    }

    private String selectorArgumentText(ArgumentCondition condition, SimpleSelector simpleSelector) {
        StringBuilder buf = new StringBuilder(96);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append(':').append(condition.getName()).append("(");
        this.selectorListText(buf, condition.getSelectors(), true, true);
        return buf.append(')').toString();
    }

    private void appendPositional(PositionalCondition2 pcond, StringBuilder buf) {
        int slope = pcond.getFactor();
        int offset = pcond.getOffset();
        SelectorList ofList = pcond.getOfList();
        boolean forwardCondition = pcond.isForwardCondition();
        if (slope == 0) {
            if (offset == 1 && ofList == null && !pcond.hasArgument()) {
                if (forwardCondition) {
                    buf.append("first-child");
                } else {
                    buf.append("last-child");
                }
            } else {
                if (forwardCondition) {
                    buf.append("nth-child(");
                } else {
                    buf.append("nth-last-child(");
                }
                buf.append(offset);
                if (!CSSStyleDeclarationRule.isUniversalSelectorList(ofList)) {
                    buf.append(" of ");
                    this.selectorListText(buf, ofList, true, false);
                }
                buf.append(')');
            }
        } else {
            if (forwardCondition) {
                buf.append("nth-child(");
            } else {
                buf.append("nth-last-child(");
            }
            this.appendAnB(slope, offset, pcond.hasKeyword(), buf);
            if (!CSSStyleDeclarationRule.isUniversalSelectorList(ofList)) {
                buf.append(" of ").append(ofList.toString());
            }
            buf.append(')');
        }
    }

    private void appendPositionalOfType(PositionalCondition2 pcond, StringBuilder buf) {
        int slope = pcond.getFactor();
        int offset = pcond.getOffset();
        SelectorList ofList = pcond.getOfList();
        boolean forwardCondition = pcond.isForwardCondition();
        if (slope == 0) {
            if (offset == 1 && ofList == null && !pcond.hasArgument()) {
                if (forwardCondition) {
                    buf.append("first-of-type");
                } else {
                    buf.append("last-of-type");
                }
            } else {
                if (forwardCondition) {
                    buf.append("nth-of-type(");
                } else {
                    buf.append("nth-last-of-type(");
                }
                buf.append(offset).append(')');
            }
        } else {
            if (forwardCondition) {
                buf.append("nth-of-type(");
            } else {
                buf.append("nth-last-of-type(");
            }
            this.appendAnB(slope, offset, pcond.hasKeyword(), buf);
            buf.append(')');
        }
    }

    private void appendAnB(int slope, int offset, boolean hasKeyword, StringBuilder buf) {
        if (hasKeyword && slope == 2) {
            if (offset == 0) {
                buf.append("even");
            } else {
                buf.append("odd");
            }
            return;
        }
        if (slope == -1) {
            buf.append('-');
        } else if (slope != 1) {
            buf.append(slope);
        }
        buf.append('n');
        if (offset > 0) {
            buf.append('+');
            buf.append(offset);
        } else if (offset != 0) {
            buf.append(offset);
        }
    }

    private void selectorListText(StringBuilder buf, SelectorList selist, boolean omitUniversal, boolean scoped) {
        buf.append(this.selectorText(selist.item(0), omitUniversal, scoped));
        for (int i = 1; i < selist.getLength(); ++i) {
            buf.append(',').append(this.selectorText(selist.item(i), omitUniversal, scoped));
        }
    }

    private static boolean isUniversalSelectorList(SelectorList selist) {
        if (selist == null) {
            return true;
        }
        for (int i = 0; i < selist.getLength(); ++i) {
            if (selist.item(i).getSelectorType() != 1) continue;
            return true;
        }
        return false;
    }

    private String conditionOrDeprecated(SimpleSelector simpleSelector, CombinatorCondition ccond) {
        StringBuilder buf = new StringBuilder(96);
        if (simpleSelector != null) {
            this.appendSimpleSelector(simpleSelector, buf);
        }
        buf.append(":matches(").append(this.conditionalSelectorText(ccond.getFirstCondition(), null)).append(',').append(this.conditionalSelectorText(ccond.getSecondCondition(), null)).append(')');
        return buf.toString();
    }

    class RuleDocumentHandler
    extends BaseCSSDeclarationRule.DeclarationRuleDocumentHandler {
        RuleDocumentHandler() {
            super(CSSStyleDeclarationRule.this);
        }

        @Override
        public void startSelector(SelectorList selectors) throws DOMException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                throw new DOMException(3, "Rule already set, stream contains more than one rule");
            }
            CSSStyleDeclarationRule.this.setSelectorList(selectors);
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            try {
                super.property(name, value, important);
            }
            catch (DOMException e) {
                CSSPropertyValueException ex = new CSSPropertyValueException(e);
                ex.setValueText(value.toString());
                CSSStyleDeclarationRule.this.getStyleDeclarationErrorHandler().wrongValue(name, ex);
            }
        }

        @Override
        public void warning(CSSParseException exception) throws CSSException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                super.warning(exception);
            } else {
                AbstractCSSStyleSheet sheet = CSSStyleDeclarationRule.this.getParentStyleSheet();
                if (sheet != null) {
                    sheet.getErrorHandler().ruleParseWarning(CSSStyleDeclarationRule.this, exception);
                }
            }
        }

        @Override
        public void error(CSSParseException exception) throws CSSException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                super.error(exception);
            } else {
                AbstractCSSStyleSheet sheet = CSSStyleDeclarationRule.this.getParentStyleSheet();
                if (sheet != null) {
                    sheet.getErrorHandler().ruleParseError(CSSStyleDeclarationRule.this, exception);
                }
            }
        }

        @Override
        public void fatalError(CSSParseException exception) throws CSSException {
            if (CSSStyleDeclarationRule.this.selectorList != null) {
                super.fatalError(exception);
            } else {
                AbstractCSSStyleSheet sheet = CSSStyleDeclarationRule.this.getParentStyleSheet();
                if (sheet != null) {
                    sheet.getErrorHandler().ruleParseError(CSSStyleDeclarationRule.this, exception);
                }
            }
        }
    }
}

