/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.agent.Viewport;
import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BoxModelHelper;
import io.sf.carte.doc.style.css.om.PropertyCounterDocumentHandler;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.om.SimpleBoxModel;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.AttrValue;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.CustomPropertyValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.URIValueWrapper;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public abstract class ComputedCSSStyle
extends BaseCSSStyleDeclaration
implements CSSComputedProperties {
    private CSSElement node = null;
    private transient LinkedList<String> customPropertyStack = null;
    private transient LinkedList<String> attrValueStack = null;

    protected ComputedCSSStyle() {
    }

    protected ComputedCSSStyle(ComputedCSSStyle copiedObject) {
        super(copiedObject);
        this.setOwnerNode(copiedObject.getOwnerNode());
    }

    protected void setOwnerNode(CSSElement node) {
        this.node = node;
    }

    @Override
    public CSSElement getOwnerNode() {
        return this.node;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.node != null && this.node.getNodeType() == 1) {
            return this.node.getOwnerDocument().getErrorHandler().getInlineStyleErrorHandler(this.node);
        }
        return null;
    }

    @Override
    String getUnknownPropertyPriority(String propertyName) {
        return this.checkShorthandPriority(propertyName);
    }

    @Override
    public String getPropertyValue(String propertyName) {
        StyleValue value = this.getCSSValue(propertyName = this.getCanonicalPropertyName(propertyName));
        if (value != null) {
            short ptype;
            short type = value.getCssValueType();
            if (type == 1 && ((ptype = ((CSSPrimitiveValue)((Object)value)).getPrimitiveType()) == 19 || ptype == 21)) {
                return ((CSSPrimitiveValue)((Object)value)).getStringValue();
            }
            return value.getCssText();
        }
        if (ShorthandDatabase.getInstance().isShorthand(propertyName)) {
            return this.serializeShorthand(propertyName);
        }
        return "";
    }

    private String serializeShorthand(String propertyName) {
        ShorthandBuilder builder = this.createBuilder(propertyName);
        if (builder != null) {
            String[] longhands;
            for (String longhand : longhands = builder.getLonghandProperties()) {
                builder.addAssignedProperty(longhand, false);
            }
            if ("font".equals(propertyName) || "font-variant".equals(propertyName)) {
                builder.addAssignedProperty("font-variant-caps", false);
                builder.addAssignedProperty("font-variant-ligatures", false);
                builder.addAssignedProperty("font-variant-position", false);
                builder.addAssignedProperty("font-variant-numeric", false);
                builder.addAssignedProperty("font-variant-alternates", false);
                builder.addAssignedProperty("font-variant-east-asian", false);
            }
            StringBuilder buf = new StringBuilder(64);
            builder.appendMinifiedCssText(buf);
            String declaration = buf.toString();
            InputSource source = new InputSource((Reader)new StringReader(declaration));
            CSSParser parser = new CSSParser();
            PropertyCounterDocumentHandler handler = new PropertyCounterDocumentHandler();
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            try {
                parser.parseStyleDeclaration(source);
            }
            catch (IOException | CSSException e) {
                return "";
            }
            if (!handler.hasError() && handler.getPropertyCount() == 1) {
                int len = declaration.length();
                int lenm1 = len - 1;
                int firstc = declaration.indexOf(58);
                if (declaration.charAt(lenm1) == ';') {
                    len = lenm1;
                }
                return declaration.substring(firstc + 1, len);
            }
        }
        return "";
    }

    @Override
    protected void setPropertyCSSValue(String propertyName, StyleValue value, String hrefcontext) {
        if ("background-image".equals(propertyName) || "border-image-source".equals(propertyName)) {
            if (value.getCssValueType() == 2) {
                if (hrefcontext != null) {
                    value = ((ValueList)value).wrap(hrefcontext, this.getOwnerNode().getOwnerDocument().getBaseURI());
                }
            } else if (value.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)value)).getPrimitiveType() == 20 && hrefcontext != null) {
                value = new URIValueWrapper((URIValue)value, hrefcontext, this.getOwnerNode().getOwnerDocument().getBaseURI());
            }
        }
        super.setPropertyCSSValue(propertyName, value, hrefcontext);
    }

    @Override
    public StyleValue getCSSValue(String property) throws StyleDatabaseRequiredException {
        boolean inherited;
        StyleValue value = super.getCSSValue(property);
        PropertyDatabase propertydb = PropertyDatabase.getInstance();
        boolean bl = inherited = propertydb.isInherited(property) || property.startsWith("--");
        if (value != null) {
            if (value.getCssValueType() == 3) {
                return null;
            }
            if (ComputedCSSStyle.isCSSIdentifier(value, "unset")) {
                value = null;
            }
        }
        if ((value = ComputedCSSStyle.inheritValue(this, property, value, inherited)) != null && value.getCssValueType() == 0) {
            value = null;
        }
        value = this.computeValue(property, value, inherited, propertydb);
        return value;
    }

    private static StyleValue inheritValue(ComputedCSSStyle ancStyle, String propertyName, StyleValue value, boolean inherited) {
        while ((value == null ? inherited : value.getCssValueType() == 0) && (ancStyle = ancStyle.getParentComputedStyle()) != null) {
            if (!ancStyle.isPropertySet(propertyName) || (value = ancStyle.getCSSValue(propertyName)) == null || !ComputedCSSStyle.isCSSIdentifier(value, "unset")) continue;
            value = null;
        }
        return value;
    }

    private static boolean isCSSIdentifier(CSSValue value, String ident) {
        CSSPrimitiveValue primi;
        return value.getCssValueType() == 1 && (primi = (CSSPrimitiveValue)value).getPrimitiveType() == 21 && ident.equalsIgnoreCase(primi.getStringValue());
    }

    private StyleValue computeValue(String property, StyleValue value, boolean inherited, PropertyDatabase propertydb) {
        if (value == null || ComputedCSSStyle.isCSSIdentifier(value, "initial")) {
            value = this.defaultPropertyValue(property, propertydb);
        }
        if (value != null) {
            if (value.isSystemDefault() && value instanceof SystemDefaultValue) {
                return value;
            }
            if (property.equals("font-size")) {
                value = this.absoluteFontSizeValue(value, false);
            } else {
                try {
                    value = this.absoluteValue(property, value, false);
                }
                catch (DOMException e) {
                    this.computedStyleError(property, value.getCssText(), null, e);
                    value = null;
                }
                if (value == null) {
                    if (inherited) {
                        ComputedCSSStyle ancStyle = this;
                        do {
                            value = ComputedCSSStyle.inheritValue(ancStyle, property, value, true);
                        } while ((value = ancStyle.computeValue(property, value, inherited, propertydb)) == null && (ancStyle = ancStyle.getParentComputedStyle()) != null);
                    }
                    if (value == null || value.getCssValueType() == 0) {
                        value = this.defaultPropertyValue(property, propertydb);
                    }
                }
                if ("display".equals(property)) {
                    value = this.applyDisplayConstrains(value);
                } else if (property.endsWith("-width")) {
                    value = this.applyBorderWidthConstrains(property, value);
                } else if ("background-repeat".equals(property)) {
                    value = this.computeBackgroundRepeat(value);
                } else if (property.endsWith("color") && value.getCssValueType() == 1) {
                    value = this.colorValue(property, (PrimitiveValue)value);
                }
            }
        }
        return value;
    }

    private StyleValue absoluteValue(String property, StyleValue value, boolean useParentStyle) {
        short type = value.getCssValueType();
        if (type == 2) {
            ValueList list = (ValueList)value;
            int lstlen = list.getLength();
            for (int i = 0; i < lstlen; ++i) {
                list.set(i, this.absoluteValue(property, list.item(i), useParentStyle));
            }
        } else if (type == 1) {
            PrimitiveValue primi = (PrimitiveValue)value;
            value = primi.getPrimitiveType() == 128 ? this.evaluateCustomProperty(property, (CustomPropertyValue)primi, useParentStyle) : this.absolutePrimitiveValue(property, primi, useParentStyle);
        }
        return value;
    }

    PrimitiveValue absolutePrimitiveValue(String propertyName, PrimitiveValue pri, boolean useParentStyle) {
        if (this.isRelativeUnit(pri)) {
            try {
                pri = this.absoluteNumberValue((NumberValue)pri, useParentStyle);
            }
            catch (IllegalStateException | DOMException runtimeException) {}
        } else {
            StyleValue custom;
            short type = pri.getPrimitiveType();
            if (type == 101) {
                pri = pri.clone();
                ExpressionValue exprval = (ExpressionValue)pri;
                MyEvaluator ev = new MyEvaluator(propertyName);
                try {
                    pri = (PrimitiveValue)ev.evaluateExpression(exprval);
                }
                catch (DOMException e) {
                    this.absoluteExpressionValue(propertyName, exprval.getExpression(), useParentStyle);
                }
            } else if (type == 127) {
                FunctionValue function = (FunctionValue)pri;
                function = function.clone();
                MyEvaluator ev = new MyEvaluator(propertyName);
                try {
                    pri = (PrimitiveValue)ev.evaluateFunction(function);
                }
                catch (DOMException e) {
                    LinkedCSSValueList args = function.getArguments();
                    int sz = args.size();
                    for (int i = 0; i < sz; ++i) {
                        args.set(i, this.absoluteValue(propertyName, (StyleValue)args.get(i), useParentStyle));
                    }
                }
            } else if (type == 22) {
                pri = this.computeAttribute(propertyName, (AttrValue)pri, useParentStyle);
            } else if (type == 128 && (custom = this.evaluateCustomProperty(propertyName, (CustomPropertyValue)pri, useParentStyle)).getCssValueType() == 1) {
                pri = (PrimitiveValue)custom;
            }
        }
        return pri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NumberValue absoluteNumberValue(NumberValue value, boolean useParentStyle) {
        short unit = value.getPrimitiveType();
        float fv = value.getFloatValue(unit);
        if (unit == 3) {
            fv = useParentStyle ? (fv *= this.getParentComputedStyle().getComputedFontSize()) : (fv *= this.getComputedFontSize());
        } else if (unit == 4) {
            if (this.getStyleDatabase() != null) {
                fv *= this.getStyleDatabase().getExSizeInPt(this.getUsedFontFamily(), this.getComputedFontSize());
            } else {
                fv = useParentStyle ? (fv *= this.getParentComputedStyle().getComputedFontSize()) : (fv *= this.getComputedFontSize());
                fv *= 0.5f;
            }
        } else if (unit == 31) {
            CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
            fv = root != this.getOwnerNode() ? (fv *= root.getComputedStyle(null).getComputedFontSize()) : (fv *= this.getInitialFontSize());
        } else if (unit == 29) {
            fv = useParentStyle ? (fv *= this.getParentComputedStyle().getComputedLineHeight()) : (fv *= this.getComputedLineHeight());
        } else if (unit == 32) {
            CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
            fv = root != this.getOwnerNode() ? (fv *= root.getComputedStyle(null).getComputedLineHeight()) : (fv *= this.getInitialFontSize());
        } else {
            CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
            if (unit == 26) {
                if (canvas == null) throw new IllegalStateException("cap unit requires canvas");
                fv *= canvas.getCapHeight(this);
            } else if (unit == 27) {
                fv = canvas != null ? (fv *= (float)canvas.stringWidth("0", this)) : (fv *= this.getComputedFontSize() * 0.25f);
            } else if (unit == 28) {
                fv = canvas != null ? (fv *= (float)canvas.stringWidth("\u6c34", this)) : (fv *= this.getComputedFontSize());
            } else if (unit == 39) {
                fv *= this.getInitialContainingBlockWidthPt(canvas, true) * 0.01f;
            } else if (unit == 35) {
                fv *= this.getInitialContainingBlockHeightPt(canvas, true) * 0.01f;
            } else if (unit == 36) {
                String writingMode = this.getCSSValue("writing-mode").getCssText();
                fv = "horizontal-tb".equalsIgnoreCase(writingMode) ? (fv *= this.getInitialContainingBlockWidthPt(canvas, true)) : (fv *= this.getInitialContainingBlockHeightPt(canvas, true));
                fv *= 0.01f;
            } else if (unit == 34) {
                String writingMode = this.getCSSValue("writing-mode").getCssText();
                fv = "horizontal-tb".equalsIgnoreCase(writingMode) ? (fv *= this.getInitialContainingBlockHeightPt(canvas, true)) : (fv *= this.getInitialContainingBlockWidthPt(canvas, true));
                fv *= 0.01f;
            } else if (unit == 38) {
                float size = Math.min(this.getInitialContainingBlockWidthPt(canvas, true), this.getInitialContainingBlockHeightPt(canvas, true));
                fv *= size * 0.01f;
            } else if (unit == 37) {
                float size = Math.max(this.getInitialContainingBlockWidthPt(canvas, true), this.getInitialContainingBlockHeightPt(canvas, true));
                fv *= size * 0.01f;
            } else {
                fv = NumberValue.floatValueConversion(fv, unit, (short)9);
            }
        }
        value = new NumberValue();
        value.setFloatValuePt(fv);
        value.setAbsolutizedUnit();
        return value;
    }

    private float getInitialContainingBlockWidthPt(CSSCanvas canvas, boolean force) throws StyleDatabaseRequiredException {
        String medium;
        Viewport viewport;
        if (canvas != null && (viewport = canvas.getViewport()) != null) {
            float fv = viewport.getViewportWidth();
            return NumberValue.floatValueConversion(fv, this.getStyleDatabase().getNaturalUnit(), (short)9);
        }
        StyleDatabase sdb = this.getStyleDatabase();
        if (sdb != null) {
            float fv = sdb.getDeviceWidth();
            return NumberValue.floatValueConversion(fv, sdb.getNaturalUnit(), (short)9);
        }
        if (force && (medium = this.getOwnerNode().getOwnerDocument().getTargetMedium()) != null) {
            if ("print".equals(medium)) {
                return 595.0f;
            }
            if ("screen".equals(medium)) {
                return 1440.0f;
            }
            if ("handheld".equals(medium)) {
                return 270.0f;
            }
        }
        throw new StyleDatabaseRequiredException("Unit conversion failed.");
    }

    private float getInitialContainingBlockHeightPt(CSSCanvas canvas, boolean force) throws StyleDatabaseRequiredException {
        String medium;
        Viewport viewport;
        if (canvas != null && (viewport = canvas.getViewport()) != null) {
            float fv = viewport.getViewportHeight();
            return NumberValue.floatValueConversion(fv, this.getStyleDatabase().getNaturalUnit(), (short)9);
        }
        StyleDatabase sdb = this.getStyleDatabase();
        if (sdb != null) {
            float fv = sdb.getDeviceHeight();
            return NumberValue.floatValueConversion(fv, sdb.getNaturalUnit(), (short)9);
        }
        if (force && (medium = this.getOwnerNode().getOwnerDocument().getTargetMedium()) != null) {
            if ("print".equals(medium)) {
                return 842.0f;
            }
            if ("screen".equals(medium)) {
                return 810.0f;
            }
            if ("handheld".equals(medium)) {
                return 480.0f;
            }
        }
        throw new StyleDatabaseRequiredException("Unit conversion failed.");
    }

    private void absoluteExpressionValue(String propertyName, CSSExpression expr, boolean useParentStyle) {
        switch (expr.getPartType()) {
            case SUM: 
            case PRODUCT: {
                AlgebraicExpression ae = (AlgebraicExpression)expr;
                int len = ae.getLength();
                for (int i = 0; i < len; ++i) {
                    CSSExpression op = ae.item(i);
                    this.absoluteExpressionValue(propertyName, op, useParentStyle);
                }
                break;
            }
            case OPERAND: {
                CSSOperandExpression operand = (CSSOperandExpression)expr;
                PrimitiveValue primi = (PrimitiveValue)operand.getOperand();
                operand.setOperand(this.absolutePrimitiveValue(propertyName, primi, useParentStyle));
            }
        }
    }

    private PrimitiveValue computeAttribute(String propertyName, AttrValue attr, boolean useParentStyle) throws DOMException {
        StyleValue fallback;
        PrimitiveValue pri;
        StyleValue value;
        String attrname = attr.getAttributeName();
        String attrvalue = this.getOwnerNode().getAttribute(attrname);
        String attrtype = attr.getAttributeType();
        if (attrvalue.length() != 0) {
            if (attrtype == null || "string".equalsIgnoreCase(attrtype)) {
                StringValue value2 = new StringValue(2);
                value2.setStringValue((short)19, attrvalue);
                return value2;
            }
            attrvalue = attrvalue.trim();
            if ("url".equalsIgnoreCase(attrtype)) {
                try {
                    URL url = this.getOwnerNode().getOwnerDocument().getURL(attrvalue);
                    URIValue uri = new URIValue(2);
                    uri.setStringValue((short)20, url.toExternalForm());
                    return uri;
                }
                catch (MalformedURLException url) {}
            } else {
                ValueFactory factory = new ValueFactory();
                try {
                    value = factory.parseProperty(attrvalue);
                }
                catch (DOMException e) {
                    DOMException ex = new DOMException(e.code, "Error parsing attribute '" + attrname + "', value: " + attrvalue);
                    ex.initCause(e);
                    throw ex;
                }
                if (value.getCssValueType() == 1) {
                    this.addAttrNameGuard(attrname);
                    try {
                        pri = this.absolutePrimitiveValue(propertyName, (PrimitiveValue)value, useParentStyle);
                    }
                    catch (Exception e) {
                        this.clearAttrGuardStack();
                        throw e;
                    }
                    this.removeAttrNameGuard(attrname);
                    PrimitiveValue val = this.attrValueOfType(pri, attrtype);
                    if (val != null) {
                        val = this.absolutePrimitiveValue(propertyName, val, useParentStyle);
                        return val;
                    }
                    this.computedStyleWarning(propertyName, attr, "Attribute value does not match type (" + attrtype + ").");
                } else {
                    this.computedStyleWarning(propertyName, attr, "Invalid attribute value");
                }
            }
        }
        if ((fallback = attr.getFallback()) == null) {
            if (this.attrValueStack != null && !this.attrValueStack.isEmpty()) {
                throw new DOMException(15, "No explicit fallback and we are in recursive attr(), forbidden by CSS.");
            }
            PrimitiveValue defval = AttrValue.defaultFallback(attrtype);
            if (defval == null) {
                throw new DOMException(15, "Invalid attribute, no default fallback for type " + attrtype + '.');
            }
            if ("color".equalsIgnoreCase(attrtype)) {
                defval = this.colorValue("", defval);
            }
            return defval;
        }
        this.addAttrNameGuard(attrname);
        try {
            fallback = ComputedCSSStyle.inheritValue(this, propertyName, fallback, false);
            if (fallback != null && fallback.getCssValueType() == 0) {
                throw new DOMException(15, "Invalid fallback.");
            }
            value = this.absoluteValue(propertyName, fallback, useParentStyle);
        }
        catch (Exception e) {
            this.clearAttrGuardStack();
            throw e;
        }
        this.removeAttrNameGuard(attrname);
        if (value.getCssValueType() != 1) {
            throw new DOMException(15, "Invalid fallback.");
        }
        pri = (PrimitiveValue)value;
        if (pri.getPrimitiveType() == 19 && "url".equalsIgnoreCase(attrtype)) {
            try {
                URL url = this.getOwnerNode().getOwnerDocument().getURL(pri.getStringValue());
                URIValue uri = new URIValue(2);
                uri.setStringValue((short)20, url.toExternalForm());
                return uri;
            }
            catch (MalformedURLException malformedURLException) {}
        } else if ("color".equalsIgnoreCase(attrtype)) {
            pri = this.colorValue("", pri);
        }
        return pri;
    }

    private void addAttrNameGuard(String attrname) {
        if (this.attrValueStack == null) {
            this.attrValueStack = new LinkedList();
        } else if (this.attrValueStack.contains(attrname)) {
            this.attrValueStack.clear();
            throw new DOMException(15, "Recursive use of attribute " + attrname + " in computed style.");
        }
        this.attrValueStack.add(attrname);
    }

    private void removeAttrNameGuard(String attrname) {
        this.attrValueStack.remove(attrname);
    }

    private void clearAttrGuardStack() {
        this.attrValueStack.clear();
    }

    private PrimitiveValue attrValueOfType(PrimitiveValue value, String type) throws DOMException {
        if ("color".equalsIgnoreCase(type)) {
            if ((value = this.colorValue("", value)).getPrimitiveType() == 25) {
                return value;
            }
        } else {
            short ptype = value.getPrimitiveType();
            if ("number".equalsIgnoreCase(type)) {
                if (ptype == 1) {
                    return value;
                }
            } else if ("integer".equalsIgnoreCase(type)) {
                float fval;
                float f;
                if (ptype == 1 && (double)Math.abs(f - (float)Math.round(fval = value.getFloatValue(ptype))) < 7.0E-6) {
                    return value;
                }
            } else if ("%".equals(type)) {
                if (ptype == 1) {
                    float fval = value.getFloatValue((short)1);
                    value.setFloatValue((short)2, fval);
                    return value;
                }
                if (ptype == 2) {
                    return value;
                }
            } else if ("length".equalsIgnoreCase(type)) {
                if (NumberValue.isLengthUnitType(ptype)) {
                    return value;
                }
            } else if ("angle".equalsIgnoreCase(type)) {
                if (NumberValue.isAngleUnitType(ptype)) {
                    return value;
                }
            } else if ("time".equalsIgnoreCase(type)) {
                if (ptype == 15 || ptype == 14) {
                    return value;
                }
            } else if ("frequency".equalsIgnoreCase(type)) {
                if (ptype == 16 || ptype == 17) {
                    return value;
                }
            } else {
                if (ptype == 1) {
                    String lctypeval = type.toLowerCase(Locale.ROOT).intern();
                    short sacUnit = ParseHelper.unitFromString(lctypeval);
                    if (sacUnit != 42) {
                        short expectedType = ValueFactory.domPrimitiveType(sacUnit);
                        if (expectedType != 0) {
                            if (NumberValue.isLengthUnitType(expectedType)) {
                                return NumberValue.createCSSNumberValue(expectedType, value.getFloatValue(ptype));
                            }
                            if (NumberValue.isAngleUnitType(expectedType)) {
                                return NumberValue.createCSSNumberValue(expectedType, value.getFloatValue(ptype));
                            }
                            if (expectedType == 15 || expectedType == 14) {
                                return NumberValue.createCSSNumberValue(expectedType, value.getFloatValue(ptype));
                            }
                            if (expectedType == 16 || expectedType == 17) {
                                return NumberValue.createCSSNumberValue(expectedType, value.getFloatValue(ptype));
                            }
                            return null;
                        }
                        return value;
                    }
                    throw new DOMException(15, "Unknown attribute type '" + type + "' found in computed style.");
                }
                throw new DOMException(15, "Invalid attr() value found in computed style.");
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StyleValue evaluateCustomProperty(String property, CustomPropertyValue value, boolean useParentStyle) {
        StyleValue custom;
        String propertyName = this.getCanonicalPropertyName(value.getStringValue());
        if (this.customPropertyStack == null) {
            this.customPropertyStack = new LinkedList();
        } else if (this.customPropertyStack.contains(propertyName)) {
            StyleValue custom2 = value.getFallback();
            if (custom2 != null) {
                return this.absoluteValue(property, custom2, useParentStyle);
            }
            this.customPropertyStack.clear();
            throw new DOMException(15, "Dependency loop in " + propertyName);
        }
        this.customPropertyStack.add(propertyName);
        try {
            custom = this.getCSSValue(propertyName);
            if (custom == null) {
                custom = value.getFallback();
                if (custom == null) throw new DOMException(15, "Unable to evaluate custom property " + propertyName);
                custom = this.absoluteValue(property, custom, useParentStyle);
            } else {
                custom = this.absoluteValue(property, custom, useParentStyle);
            }
        }
        catch (Exception e) {
            this.customPropertyStack.clear();
            throw e;
        }
        this.customPropertyStack.remove(propertyName);
        if (!value.isExpectingInteger() || value.getCssValueType() != 1) return custom;
        ((PrimitiveValue)custom).setExpectInteger();
        return custom;
    }

    private PrimitiveValue getFontSizeValue() {
        StyleValue value = super.getCSSValue("font-size");
        if (value != null && ComputedCSSStyle.isCSSIdentifier(value, "unset")) {
            value = null;
        }
        if ((value = ComputedCSSStyle.inheritValue(this, "font-size", value, true)) != null && value.getCssValueType() == 0) {
            value = null;
        }
        if (value == null || ComputedCSSStyle.isCSSIdentifier(value, "initial")) {
            return new IdentifierValue("medium");
        }
        return this.absoluteFontSizeValue(value, false);
    }

    private PrimitiveValue absoluteFontSizeValue(StyleValue value, boolean force) {
        short type = value.getCssValueType();
        if (type == 1) {
            PrimitiveValue primi = this.absoluteFontSizePrimitive((PrimitiveValue)value, force);
            if (primi == null) {
                StyleValue inheritedValue;
                ComputedCSSStyle ancStyle = this;
                while ((primi = this.absoluteFontSizeValue(inheritedValue = ComputedCSSStyle.inheritValue(ancStyle, "font-size", primi, true), force)) == null && (ancStyle = ancStyle.getParentComputedStyle()) != null) {
                }
                if (primi != null) {
                    return primi;
                }
            } else {
                return primi;
            }
        }
        this.reportFontSizeError(value, "Could not compute font-size from " + value.getCssText());
        if (force) {
            float sz = this.getInitialFontSize();
            return ComputedCSSStyle.asNumericValuePt(sz);
        }
        return new IdentifierValue("medium");
    }

    private PrimitiveValue absoluteFontSizePrimitive(PrimitiveValue cssSize, boolean force) {
        float sz;
        switch (cssSize.getPrimitiveType()) {
            case 3: {
                float factor = cssSize.getFloatValue((short)3);
                return this.getRelativeFontSize(cssSize, factor, force);
            }
            case 4: {
                float factor = cssSize.getFloatValue((short)4);
                ComputedCSSStyle parentStyle = this.getParentComputedStyle();
                if (parentStyle == null) {
                    sz = this.getInitialFontSize() * 0.5f * factor;
                    break;
                }
                if (this.getStyleDatabase() != null) {
                    sz = this.getStyleDatabase().getExSizeInPt(parentStyle.getUsedFontFamily(), parentStyle.getComputedFontSize()) * factor;
                    break;
                }
                if (force) {
                    factor = 0.5f * factor;
                    return this.getRelativeFontSize(cssSize, factor, force);
                }
                return cssSize;
            }
            case 31: {
                float factor = cssSize.getFloatValue((short)31);
                CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (root != this.getOwnerNode()) {
                    sz = root.getComputedStyle(null).getComputedFontSize();
                } else if (force) {
                    sz = this.getInitialFontSize();
                } else {
                    return cssSize;
                }
                sz *= factor;
                break;
            }
            case 29: {
                float factor = cssSize.getFloatValue((short)29);
                ComputedCSSStyle parentStyle = this.getParentComputedStyle();
                if (parentStyle != null) {
                    sz = parentStyle.getComputedLineHeight();
                } else if (force) {
                    sz = this.getInitialFontSize();
                } else {
                    return cssSize;
                }
                sz *= factor;
                break;
            }
            case 32: {
                float factor = cssSize.getFloatValue((short)32);
                CSSElement root = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (root != this.getOwnerNode()) {
                    sz = root.getComputedStyle(null).getComputedLineHeight();
                } else if (force) {
                    sz = this.getInitialFontSize();
                } else {
                    return cssSize;
                }
                sz *= factor;
                break;
            }
            case 26: {
                ComputedCSSStyle parentStyle;
                float factor = cssSize.getFloatValue((short)26);
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                if (canvas != null && (parentStyle = this.getParentComputedStyle()) != null) {
                    sz = canvas.getCapHeight(parentStyle) * factor;
                    break;
                }
                if (force) {
                    sz = this.getInitialFontSize() * factor;
                    break;
                }
                return cssSize;
            }
            case 27: {
                ComputedCSSStyle parentStyle;
                float factor = cssSize.getFloatValue((short)27);
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                if (canvas != null && (parentStyle = this.getParentComputedStyle()) != null) {
                    sz = (float)canvas.stringWidth("0", parentStyle) * factor;
                    break;
                }
                if (force) {
                    sz = this.getParentElementFontSize() * 0.25f * factor;
                    break;
                }
                return cssSize;
            }
            case 28: {
                ComputedCSSStyle parentStyle;
                float factor = cssSize.getFloatValue((short)28);
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                if (canvas != null && (parentStyle = this.getParentComputedStyle()) != null) {
                    sz = (float)canvas.stringWidth("\u6c34", parentStyle) * factor;
                    break;
                }
                if (force) {
                    sz = this.getParentElementFontSize() * factor;
                    break;
                }
                return cssSize;
            }
            case 21: {
                String sizeIdentifier = cssSize.getStringValue();
                String familyName = this.getUsedFontFamily();
                if ("larger".equalsIgnoreCase(sizeIdentifier)) {
                    cssSize = this.getLargerFontSize(familyName);
                } else if ("smaller".equalsIgnoreCase(sizeIdentifier)) {
                    cssSize = this.getSmallerFontSize(familyName);
                }
                return cssSize;
            }
            case 2: {
                float pcnt = cssSize.getFloatValue((short)2);
                return this.getRelativeFontSize(cssSize, pcnt * 0.01f, force);
            }
            case 39: {
                float factor = cssSize.getFloatValue((short)39);
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = this.getInitialContainingBlockWidthPt(canvas, force) * factor * 0.01f;
                    break;
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
            }
            case 35: {
                float factor = cssSize.getFloatValue((short)35);
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = this.getInitialContainingBlockHeightPt(canvas, force) * factor * 0.01f;
                    break;
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
            }
            case 36: {
                float factor = cssSize.getFloatValue((short)36);
                String writingMode = this.getCSSValue("writing-mode").getCssText();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = "horizontal-tb".equalsIgnoreCase(writingMode) ? this.getInitialContainingBlockWidthPt(canvas, force) : this.getInitialContainingBlockHeightPt(canvas, force);
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
                sz *= factor * 0.01f;
                break;
            }
            case 34: {
                float factor = cssSize.getFloatValue((short)34);
                String writingMode = this.getCSSValue("writing-mode").getCssText();
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = "horizontal-tb".equalsIgnoreCase(writingMode) ? this.getInitialContainingBlockHeightPt(canvas, force) : this.getInitialContainingBlockWidthPt(canvas, force);
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
                sz *= factor * 0.01f;
                break;
            }
            case 38: {
                float factor = cssSize.getFloatValue((short)38);
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = Math.min(this.getInitialContainingBlockWidthPt(canvas, force), this.getInitialContainingBlockHeightPt(canvas, force));
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
                sz *= factor * 0.01f;
                break;
            }
            case 37: {
                float factor = cssSize.getFloatValue((short)37);
                CSSCanvas canvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    sz = Math.max(this.getInitialContainingBlockWidthPt(canvas, force), this.getInitialContainingBlockHeightPt(canvas, force));
                }
                catch (StyleDatabaseRequiredException e) {
                    if (force) {
                        throw e;
                    }
                    return cssSize;
                }
                sz *= factor * 0.01f;
                break;
            }
            case 101: {
                cssSize = cssSize.clone();
                ExpressionValue exprval = (ExpressionValue)cssSize;
                this.absoluteExpressionValue("font-size", exprval.getExpression(), true);
                FontEvaluator ev = new FontEvaluator();
                try {
                    cssSize = (PrimitiveValue)ev.evaluateExpression(exprval);
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
                return cssSize;
            }
            case 127: {
                FunctionValue function = (FunctionValue)cssSize;
                function = function.clone();
                LinkedCSSValueList args = function.getArguments();
                int siz = args.size();
                for (int i = 0; i < siz; ++i) {
                    args.set(i, this.absoluteFontSizeValue((StyleValue)args.get(i), true));
                }
                FontEvaluator ev = new FontEvaluator();
                try {
                    cssSize = (PrimitiveValue)ev.evaluateFunction(function);
                }
                catch (DOMException i) {
                    // empty catch block
                }
                return cssSize;
            }
            case 128: {
                StyleValue custom = this.evaluateFontCustomProperty((CustomPropertyValue)cssSize);
                cssSize = custom != null && custom.getCssValueType() == 1 ? (PrimitiveValue)custom : null;
                return cssSize;
            }
            default: {
                try {
                    cssSize.getFloatValue((short)9);
                }
                catch (DOMException e) {
                    String cssText = cssSize.getCssText();
                    this.computedStyleError("font-size", cssText, "Error converting to points.", e);
                    sz = this.getInitialFontSize();
                    break;
                }
                return cssSize;
            }
        }
        sz = (float)Math.round(sz * 100.0f) * 0.01f;
        NumberValue number = new NumberValue();
        number.setFloatValuePt(sz);
        number.setSubproperty(cssSize.isSubproperty());
        return number;
    }

    private StyleValue evaluateFontCustomProperty(CustomPropertyValue cssSize) {
        StyleValue custom;
        String propertyName = this.getCanonicalPropertyName(cssSize.getStringValue());
        if (this.customPropertyStack == null) {
            this.customPropertyStack = new LinkedList();
        } else if (this.customPropertyStack.contains(propertyName)) {
            StyleValue custom2 = cssSize.getFallback();
            if (custom2 != null) {
                return this.absoluteFontSizeValue(custom2, true);
            }
            this.reportFontSizeError(cssSize, "Dependency loop in " + propertyName);
            return null;
        }
        this.customPropertyStack.add(propertyName);
        try {
            custom = this.getCSSValue(propertyName);
            custom = custom == null ? ((custom = cssSize.getFallback()) != null ? this.absoluteFontSizeValue(custom, true) : null) : this.absoluteFontSizeValue(custom, true);
        }
        catch (Exception e) {
            this.customPropertyStack.clear();
            throw e;
        }
        this.customPropertyStack.remove(propertyName);
        return custom;
    }

    private PrimitiveValue getRelativeFontSize(PrimitiveValue cssSize, float factor, boolean force) {
        PrimitiveValue value;
        ComputedCSSStyle parentCss = this.getParentComputedStyle();
        if (parentCss != null) {
            if (force) {
                float sz = parentCss.getComputedFontSize() * factor;
                sz = (float)Math.round(sz * 100.0f) * 0.01f;
                value = ComputedCSSStyle.asNumericValuePt(sz);
            } else {
                value = parentCss.getFontSizeValue();
                if (value.getPrimitiveType() == 21) {
                    value = cssSize;
                } else {
                    try {
                        float sz = value.getFloatValue((short)9) * factor;
                        sz = (float)Math.round(sz * 100.0f) * 0.01f;
                        value = ComputedCSSStyle.asNumericValuePt(sz);
                    }
                    catch (DOMException e) {
                        value = cssSize;
                    }
                }
            }
        } else if (force) {
            float sz = this.getInitialFontSize() * factor;
            value = ComputedCSSStyle.asNumericValuePt(sz);
        } else {
            value = cssSize;
        }
        return value;
    }

    @Override
    public float getComputedFontSize() {
        float sz;
        StyleValue value = super.getCSSValue("font-size");
        if (value != null && ComputedCSSStyle.isCSSIdentifier(value, "unset")) {
            value = null;
        }
        if ((value = ComputedCSSStyle.inheritValue(this, "font-size", value, true)) != null && value.getCssValueType() == 0) {
            value = null;
        }
        if (value == null || ComputedCSSStyle.isCSSIdentifier(value, "initial")) {
            return this.getInitialFontSize();
        }
        PrimitiveValue cssSize = this.absoluteFontSizeValue(value, true);
        switch (cssSize.getPrimitiveType()) {
            case 21: {
                String sizeIdentifier = cssSize.getStringValue().toLowerCase(Locale.ROOT);
                try {
                    String familyName = this.getUsedFontFamily();
                    sz = this.getFontSizeFromIdentifier(familyName, sizeIdentifier);
                }
                catch (DOMException e) {
                    this.computedStyleError("font-size", sizeIdentifier, "Unknown identifier", e);
                    sz = this.getInitialFontSize();
                }
                break;
            }
            default: {
                try {
                    sz = cssSize.getFloatValue((short)9);
                    break;
                }
                catch (DOMException e) {
                    String cssText = cssSize.getCssText();
                    this.computedStyleError("font-size", cssText, null, e);
                    sz = this.getInitialFontSize();
                }
            }
        }
        return sz;
    }

    private float getFontSizeFromIdentifier(String familyName, String sizeIdentifier) {
        if (this.getStyleDatabase() != null) {
            return this.getStyleDatabase().getFontSizeFromIdentifier(familyName, sizeIdentifier);
        }
        float sz = sizeIdentifier.equals("medium") ? 12.0f : (sizeIdentifier.equals("x-small") ? 9.0f : (sizeIdentifier.equals("small") ? 10.0f : (sizeIdentifier.equals("xx-small") ? 8.0f : (sizeIdentifier.equals("large") ? 14.0f : (sizeIdentifier.equals("x-large") ? 18.0f : (sizeIdentifier.equals("xx-large") ? 24.0f : 12.0f))))));
        return sz;
    }

    private PrimitiveValue getLargerFontSize(String familyName) {
        CSSPrimitiveValue csssize;
        ComputedCSSStyle parentCss = this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSPrimitiveValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            String larger;
            switch (csssize.getPrimitiveType()) {
                case 21: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        larger = "x-small";
                        break;
                    }
                    if (baseFontSize.equals("x-small")) {
                        larger = "small";
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        larger = "medium";
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        larger = "large";
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        larger = "x-large";
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        larger = "xx-large";
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        return ComputedCSSStyle.asNumericValuePt(2.0f * this.getFontSizeFromIdentifier(familyName, "xx-large") - this.getFontSizeFromIdentifier(familyName, "x-large"));
                    }
                    this.computedStyleError("font-size", baseFontSize, "Unknown identifier");
                    return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(familyName, "medium") * 1.2f);
                }
                default: {
                    return ComputedCSSStyle.asNumericValuePt(parentCss.getComputedFontSize() * 1.2f);
                }
            }
            return new IdentifierValue(larger);
        }
        return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(familyName, "medium") * 1.2f);
    }

    private PrimitiveValue getSmallerFontSize(String familyName) {
        CSSPrimitiveValue csssize;
        ComputedCSSStyle parentCss = this.getParentComputedStyle();
        if (parentCss != null && (csssize = (CSSPrimitiveValue)((Object)parentCss.getCSSValue("font-size"))) != null) {
            String smaller;
            switch (csssize.getPrimitiveType()) {
                case 21: {
                    String baseFontSize = csssize.getStringValue();
                    if (baseFontSize.equals("xx-small")) {
                        float sz = 2.0f * this.getFontSizeFromIdentifier(familyName, "xx-small") - this.getFontSizeFromIdentifier(familyName, "x-small");
                        if (sz < 7.0f) {
                            sz = this.getFontSizeFromIdentifier(familyName, "xx-small");
                        }
                        return ComputedCSSStyle.asNumericValuePt(sz);
                    }
                    if (baseFontSize.equals("x-small")) {
                        smaller = "xx-small";
                        break;
                    }
                    if (baseFontSize.equals("small")) {
                        smaller = "x-small";
                        break;
                    }
                    if (baseFontSize.equals("medium")) {
                        smaller = "small";
                        break;
                    }
                    if (baseFontSize.equals("large")) {
                        smaller = "medium";
                        break;
                    }
                    if (baseFontSize.equals("x-large")) {
                        smaller = "large";
                        break;
                    }
                    if (baseFontSize.equals("xx-large")) {
                        smaller = "x-large";
                        break;
                    }
                    this.computedStyleError("font-size", baseFontSize, "Unknown identifier");
                    return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(familyName, "medium") * 0.82f);
                }
                default: {
                    return ComputedCSSStyle.asNumericValuePt(parentCss.getComputedFontSize() * 0.82f);
                }
            }
            return new IdentifierValue(smaller);
        }
        return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(familyName, "medium") * 0.82f);
    }

    private void reportFontSizeError(CSSValue cssSize, String message) {
        String cssText = cssSize.getCssText();
        this.computedStyleError("font-size", cssText, message);
    }

    private float getParentElementFontSize() {
        ComputedCSSStyle parentCss = this.getParentComputedStyle();
        float sz = parentCss != null ? parentCss.getComputedFontSize() : this.getInitialFontSize();
        return sz;
    }

    private boolean isRelativeUnit(CSSPrimitiveValue pri) {
        switch (pri.getPrimitiveType()) {
            case 3: 
            case 4: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    private PrimitiveValue colorValue(String propertyName, PrimitiveValue primi) {
        if (primi.getPrimitiveType() == 21) {
            String s = primi.getStringValue().toLowerCase(Locale.ROOT);
            if ("currentcolor".equals(s)) {
                if (!"color".equals(propertyName)) {
                    primi = this.getCSSColor();
                }
            } else {
                String spec = "transparent".equals(s) ? "rgba(0 0 0/0)" : ColorIdentifiers.getInstance().getColor(s);
                if (spec != null) {
                    try {
                        primi = (PrimitiveValue)this.getValueFactory().parseProperty(spec);
                    }
                    catch (DOMException dOMException) {
                        // empty catch block
                    }
                }
            }
        }
        return primi;
    }

    private static NumberValue asNumericValuePt(float f) {
        NumberValue number = new NumberValue();
        number.setFloatValuePt(f);
        return number;
    }

    private float getInitialFontSize() {
        String familyName = this.getUsedFontFamily();
        return this.getFontSizeFromIdentifier(familyName, "medium");
    }

    @Override
    public float getComputedLineHeight() {
        return this.getComputedLineHeight(1.16f);
    }

    public float getComputedLineHeight(float defval) {
        float height;
        CSSPrimitiveValue cssval = (CSSPrimitiveValue)((Object)this.getCSSValue("line-height"));
        if (cssval == null) {
            return defval * this.getComputedFontSize();
        }
        short declType = cssval.getPrimitiveType();
        if (declType == 2) {
            height = this.getComputedFontSize() * cssval.getFloatValue((short)2) / 100.0f;
        } else if (declType == 21) {
            if (!"normal".equalsIgnoreCase(cssval.getStringValue())) {
                this.computedStyleError("line-height", cssval.getStringValue(), "Wrong value: expected 'normal'");
            }
            height = defval * this.getComputedFontSize();
        } else if (cssval instanceof NumberValue) {
            height = cssval.getFloatValue(declType);
            if (declType != 9) {
                height = NumberValue.floatValueConversion(height, declType, (short)9);
            }
        } else {
            this.computedStyleError("line-height", cssval.getStringValue(), "Wrong value: expected number or identifier");
            height = defval * this.getComputedFontSize();
        }
        return height;
    }

    private StyleValue applyDisplayConstrains(StyleValue value) {
        StyleValue computedValue = value;
        if (value.getCssValueType() != 1) {
            return value;
        }
        String strVal = ((CSSPrimitiveValue)((Object)value)).getStringValue();
        if (!"none".equalsIgnoreCase(strVal)) {
            String position = ((CSSPrimitiveValue)((Object)this.getCSSValue("position"))).getStringValue();
            if ("absolute".equalsIgnoreCase(position) || "fixed".equalsIgnoreCase(position)) {
                computedValue = this.computeConstrainedDisplay(value);
            } else {
                CSSElement node;
                String floatProp = ((CSSPrimitiveValue)((Object)this.getCSSValue("float"))).getStringValue();
                if (!"none".equalsIgnoreCase(floatProp) || (node = this.getOwnerNode()).getParentNode() == node.getOwnerDocument()) {
                    computedValue = this.computeConstrainedDisplay(value);
                }
            }
        }
        return computedValue;
    }

    private StyleValue computeConstrainedDisplay(StyleValue value) {
        String display = ((CSSPrimitiveValue)((Object)value)).getStringValue().toLowerCase(Locale.ROOT);
        if ("inline-table".equals(display)) {
            return new IdentifierValue("table");
        }
        if ("inline".equals(display) || "run-in".equals(display) || "table-row-group".equals(display) || "table-column".equals(display) || "table-column-group".equals(display) || "table-header-group".equals(display) || "table-footer-group".equals(display) || "table-row".equals(display) || "table-cell".equals(display) || "table-caption".equals(display) || "inline-block".equals(display)) {
            return new IdentifierValue("block");
        }
        return value;
    }

    private StyleValue applyBorderWidthConstrains(String property, StyleValue value) {
        String style = null;
        if (property.equals("border-top-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-right-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-bottom-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        } else if (property.equals("border-left-width")) {
            style = this.getCSSValue("border-top-style").getCssText();
        }
        if (style != null && (style.equals("none") || style.equals("hidden"))) {
            value = new ValueFactory().parseProperty("0");
        }
        return value;
    }

    private StyleValue computeBackgroundRepeat(StyleValue value) {
        if (value.getCssValueType() == 2) {
            ValueList list = (ValueList)value;
            if (list.isCommaSeparated()) {
                for (int i = 0; i < list.getLength(); ++i) {
                    StyleValue item = list.item(i);
                    if (item.getCssValueType() == 2) continue;
                    list.set(i, this.computeBackgroundRepeatPrimitive(item));
                }
            }
        } else {
            value = this.computeBackgroundRepeatPrimitive(value);
        }
        return value;
    }

    private StyleValue computeBackgroundRepeatPrimitive(StyleValue value) {
        ValueList list = ValueList.createWSValueList();
        String s = value.getCssText();
        if (s.equals("repeat-y")) {
            list.add(new IdentifierValue("no-repeat"));
            list.add(new IdentifierValue("repeat"));
        } else if (s.equals("repeat-x")) {
            list.add(new IdentifierValue("repeat"));
            list.add(new IdentifierValue("no-repeat"));
        } else if (s.equals("repeat")) {
            list.add(new IdentifierValue("repeat"));
            list.add(new IdentifierValue("repeat"));
        } else if (s.equals("no-repeat")) {
            list.add(new IdentifierValue("no-repeat"));
            list.add(new IdentifierValue("no-repeat"));
        } else if (s.equals("space")) {
            list.add(new IdentifierValue("space"));
            list.add(new IdentifierValue("space"));
        } else if (s.equals("round")) {
            list.add(new IdentifierValue("round"));
            list.add(new IdentifierValue("round"));
        } else {
            return value;
        }
        return list;
    }

    @Override
    protected PrimitiveValue getCurrentColor() {
        return this.getCSSColor();
    }

    @Override
    public PrimitiveValue getCSSColor() {
        return (PrimitiveValue)this.getCSSValue("color");
    }

    @Override
    public ExtendedCSSPrimitiveValue getCSSBackgroundColor() {
        return (ExtendedCSSPrimitiveValue)((Object)this.getCSSValue("background-color"));
    }

    @Override
    public String[] getBackgroundImages() {
        BaseCSSDeclarationRule pRule;
        StyleValue cssVal = this.getCSSValue("background-image");
        if (cssVal == null) {
            return null;
        }
        String baseHref = cssVal instanceof WrappedValue ? ((WrappedValue)((Object)cssVal)).getParentSheetHref() : ((pRule = this.getParentRule()) != null ? pRule.getParentStyleSheet().getHref() : null);
        if (cssVal.getCssValueType() == 1) {
            return new String[]{this.getHref((CSSPrimitiveValue)((Object)cssVal), baseHref)};
        }
        CSSValueList list = (CSSValueList)((Object)cssVal);
        int len = list.getLength();
        String[] sa = new String[len];
        for (int i = 0; i < len; ++i) {
            sa[i] = this.getHref((CSSPrimitiveValue)list.item(i), baseHref);
        }
        return sa;
    }

    protected String getHref(CSSPrimitiveValue cssVal, String baseHref) {
        String href = cssVal.getStringValue();
        if (!href.contains("://")) {
            URL baseUrl = null;
            if (baseHref == null) {
                String documentURI = this.getOwnerNode().getBaseURI();
                if (documentURI != null) {
                    try {
                        baseUrl = new URL(documentURI);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else if (!baseHref.contains("://")) {
                try {
                    baseUrl = new URL(new URL(this.getOwnerNode().getBaseURI()), baseHref);
                }
                catch (MalformedURLException e) {
                    this.getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
                }
            } else {
                try {
                    baseUrl = new URL(baseHref);
                }
                catch (MalformedURLException e) {
                    this.getStyleDeclarationErrorHandler().malformedURIValue(baseHref);
                }
            }
            if (baseUrl != null) {
                try {
                    URL url = new URL(baseUrl, href);
                    href = url.toExternalForm();
                }
                catch (MalformedURLException e) {
                    this.getStyleDeclarationErrorHandler().malformedURIValue(href);
                }
            }
        }
        return href;
    }

    @Override
    public String getUsedFontFamily() {
        StyleDatabase sdb = this.getStyleDatabase();
        if (sdb != null) {
            return sdb.getUsedFontFamily(this);
        }
        StyleValue fontFamily = this.getCSSValue("font-family");
        if (fontFamily != null) {
            if (fontFamily.getCssValueType() == 1) {
                CSSPrimitiveValue primi = (CSSPrimitiveValue)((Object)fontFamily);
                try {
                    return primi.getStringValue();
                }
                catch (DOMException dOMException) {
                }
            } else {
                ValueList list = (ValueList)fontFamily;
                if ((fontFamily = list.item(0)).getCssValueType() == 1) {
                    CSSPrimitiveValue primi = (CSSPrimitiveValue)((Object)fontFamily);
                    try {
                        return primi.getStringValue();
                    }
                    catch (DOMException dOMException) {
                        // empty catch block
                    }
                }
            }
        }
        return "Serif";
    }

    private void computedStyleError(String propertyName, String propertyValue, String message) {
        this.computedStyleError(propertyName, propertyValue, message, null);
    }

    private void computedStyleError(String propertyName, String propertyValue, String message, Throwable cause) {
        if (message == null) {
            message = cause.getMessage();
        }
        CSSPropertyValueException ex = new CSSPropertyValueException(message, cause);
        ex.setValueText(propertyValue);
        this.getOwnerNode().getOwnerDocument().getErrorHandler().computedStyleError(this.getOwnerNode(), propertyName, ex);
    }

    private void computedStyleWarning(String propertyName, PrimitiveValue value, String message) {
        CSSPropertyValueException ex = new CSSPropertyValueException(message);
        ex.setValueText(value.getCssText());
        this.getOwnerNode().getOwnerDocument().getErrorHandler().computedStyleWarning(this.getOwnerNode(), propertyName, ex);
    }

    @Override
    public BoxValues getBoxValues(short unitType) throws DOMException, StyleDatabaseRequiredException {
        return new MyDefaultBoxModel().getComputedBox(unitType);
    }

    @Override
    public String getCssText() {
        return this.getPlainCssText();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        this.writeComputedCssText(wri, context);
    }

    @Override
    public String getMinifiedCssText() {
        return this.getOptimizedCssText();
    }

    @Override
    public abstract ComputedCSSStyle getParentComputedStyle();

    public String getText() {
        return BoxModelHelper.contractSpaces(this.getOwnerNode().getTextContent()).trim();
    }

    @Override
    public abstract ComputedCSSStyle clone();

    private class MyEvaluator
    extends Evaluator {
        final String propertyName;

        MyEvaluator(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        protected ExtendedCSSPrimitiveValue absoluteValue(ExtendedCSSPrimitiveValue partialValue) {
            return ComputedCSSStyle.this.absolutePrimitiveValue(this.propertyName, (PrimitiveValue)partialValue, false);
        }
    }

    private class FontEvaluator
    extends MyEvaluator {
        FontEvaluator() {
            super("font-size");
        }

        @Override
        protected ExtendedCSSPrimitiveValue absoluteValue(ExtendedCSSPrimitiveValue partialValue) {
            return ComputedCSSStyle.this.absolutePrimitiveValue(this.propertyName, (PrimitiveValue)partialValue, true);
        }

        @Override
        protected float percentage(ExtendedCSSPrimitiveValue value, short resultType) throws DOMException {
            float pcnt = value.getFloatValue((short)2);
            return ComputedCSSStyle.this.getParentElementFontSize() * pcnt * 0.01f;
        }
    }

    private class MyDefaultBoxModel
    extends SimpleBoxModel {
        MyDefaultBoxModel() {
        }

        @Override
        protected ComputedCSSStyle getComputedStyle() {
            return ComputedCSSStyle.this;
        }
    }
}

