/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSCounterStyleRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class CounterStyleRule
extends BaseCSSDeclarationRule
implements CSSCounterStyleRule {
    private String name = null;

    public CounterStyleRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)11, origin);
    }

    @Override
    public String getName() {
        return ParseHelper.escape(this.name);
    }

    void setName(String name) throws DOMException {
        if ((name = ParseHelper.parseIdent(name)) == null || "none".equalsIgnoreCase(name) || "disc".equalsIgnoreCase(name) || "decimal".equalsIgnoreCase(name) || "inside".equalsIgnoreCase(name) || "outside".equalsIgnoreCase(name) || "inherit".equalsIgnoreCase(name) || "unset".equalsIgnoreCase(name) || "initial".equalsIgnoreCase(name)) {
            throw new DOMException(12, "Bad counter-style name: " + name);
        }
        this.name = name;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.name != null || this.getStyle().getLength() != 0) {
            return "@counter-style " + this.getName() + " {" + this.getStyle().getMinifiedCssText() + '}';
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.name != null || this.getStyle().getLength() != 0) {
            context.startRule(wri);
            wri.write("@counter-style ");
            wri.write(this.getName());
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            this.getStyle().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri);
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        int idx = (cssText = cssText.trim()).indexOf(123);
        if (idx < 16) {
            throw new DOMException(12, "Bad counter-style rule: " + cssText);
        }
        if (!ParseHelper.startsWithIgnoreCase(cssText, "@counter-style") || !Character.isWhitespace(cssText.charAt(14))) {
            throw new DOMException(13, "Not a @counter-style rule: " + cssText);
        }
        super.setCssText(cssText);
        this.setName(cssText.substring(15, idx).trim());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getType();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CounterStyleRule other = (CounterStyleRule)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public CounterStyleRule clone(AbstractCSSStyleSheet parentSheet) {
        CounterStyleRule rule = new CounterStyleRule(parentSheet, this.getOrigin());
        rule.setName(this.getName());
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return rule;
    }
}

