/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DocumentException;
import io.sf.carte.doc.agent.AbstractUserAgent;
import io.sf.carte.doc.agent.AgentUtil;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AnonymousStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CompatInlineStyle;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMComputedStyle;
import io.sf.carte.doc.style.css.om.DOMDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.StylableDocumentWrapper;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumSet;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DOMCSSStyleSheetFactory
extends BaseCSSStyleSheetFactory {
    private DocumentCSSStyleSheet defStyleSheet = null;
    private DocumentCSSStyleSheet defQStyleSheet = null;
    private DocumentCSSStyleSheet uaStyleSheet = null;
    private DocumentCSSStyleSheet uaQStyleSheet = null;
    private EntityResolver resolver = this.createEntityResolver();
    private WrapperUserAgent myUserAgent = null;

    public DOMCSSStyleSheetFactory() {
    }

    public DOMCSSStyleSheetFactory(EnumSet<Parser2.Flag> parserFlags) {
        super(parserFlags);
    }

    @Override
    protected DOMDocumentCSSStyleSheet createDocumentStyleSheet(byte origin) {
        return new MyDOMDocumentCSSStyleSheet(null, origin);
    }

    @Override
    protected DOMCSSStyleSheet createRuleStyleSheet(AbstractCSSRule ownerRule, String title, MediaQueryList mediaList) {
        return new MyDOMCSSStyleSheet(title, null, mediaList, ownerRule, ownerRule.getOrigin());
    }

    @Override
    protected BaseCSSStyleSheet createLinkedStyleSheet(Node ownerNode, String title, MediaQueryList mediaList) {
        Node titleattr;
        NamedNodeMap nnm;
        if (title == null && ownerNode != null && (nnm = ownerNode.getAttributes()) != null && (titleattr = nnm.getNamedItem("title")) != null) {
            title = titleattr.getNodeValue();
        }
        return new MyDOMCSSStyleSheet(title, ownerNode, mediaList, null, 8);
    }

    @Override
    public DocumentCSSStyleSheet getUserAgentStyleSheet(CSSDocument.ComplianceMode mode) {
        if (mode == CSSDocument.ComplianceMode.STRICT) {
            if (this.uaStyleSheet == null) {
                this.uaStyleSheet = this.createDocumentStyleSheet((byte)16);
            }
            return this.uaStyleSheet;
        }
        if (this.uaQStyleSheet == null) {
            this.uaQStyleSheet = this.createDocumentStyleSheet((byte)16);
        }
        return this.uaQStyleSheet;
    }

    @Override
    protected DocumentCSSStyleSheet getDefaultStyleSheet(CSSDocument.ComplianceMode mode) {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        DocumentCSSStyleSheet sheet = mode == CSSDocument.ComplianceMode.STRICT ? this.defStyleSheet : this.defQStyleSheet;
        return sheet;
    }

    @Override
    public void setDefaultHTMLUserAgentSheet() {
        this.uaStyleSheet = this.htmlDefaultSheet();
        this.uaQStyleSheet = this.htmlQuirksDefaultSheet();
        this.defStyleSheet = null;
        this.defQStyleSheet = null;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.STRICT).clone();
        this.defQStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.QUIRKS).clone();
        AbstractCSSStyleSheet usersheet = this.getUserNormalStyleSheet();
        if (usersheet != null) {
            this.defStyleSheet.addStyleSheet(usersheet);
            this.defQStyleSheet.addStyleSheet(usersheet);
        }
    }

    public WrapperUserAgent getUserAgent() {
        if (this.myUserAgent == null) {
            this.myUserAgent = new WrapperUserAgent();
        }
        return this.myUserAgent;
    }

    public StylableDocumentWrapper createCSSDocument(Document document) {
        return new MyStylableDocumentWrapper(document);
    }

    @Override
    public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node) {
        MyAnonStyleDeclaration style = new MyAnonStyleDeclaration(node);
        return style;
    }

    @Override
    protected InlineStyle createInlineStyle(Node owner) {
        InlineStyle style = !this.hasCompatValueFlags() ? new MyInlineStyle() : new MyCompatInlineStyle();
        style.setOwnerNode(owner);
        return style;
    }

    protected EntityResolver createEntityResolver() {
        return new DefaultEntityResolver();
    }

    public class WrapperUserAgent
    extends AbstractUserAgent {
        DocumentBuilder docbuilder;

        WrapperUserAgent() {
            super(DOMCSSStyleSheetFactory.this.getParserFlags());
            this.docbuilder = null;
        }

        public void setDocumentBuilder(DocumentBuilder docbuilder) {
            this.docbuilder = docbuilder;
            docbuilder.setEntityResolver(DOMCSSStyleSheetFactory.this.resolver);
        }

        @Override
        public CSSDocument readURL(URL url) throws IOException, DocumentException {
            String referrerPolicy;
            if (this.docbuilder == null) {
                throw new IllegalStateException("Must set a DocumentBuilder first");
            }
            if (this.getOriginPolicy() == null) {
                throw new IllegalStateException("Must set an origin policy first");
            }
            long time = System.currentTimeMillis();
            URLConnection con = this.openConnection(url, time);
            con.connect();
            String conType = con.getContentType();
            String contentEncoding = con.getContentEncoding();
            Document xdoc = null;
            try (InputStream is = null;){
                is = con.getInputStream();
                InputSource source = new InputSource(AgentUtil.inputStreamToReader(is, conType, contentEncoding, "utf-8"));
                xdoc = this.docbuilder.parse(source);
            }
            xdoc.getDocumentElement().normalize();
            xdoc.setDocumentURI(url.toExternalForm());
            StylableDocumentWrapper wrapper = DOMCSSStyleSheetFactory.this.createCSSDocument(xdoc);
            wrapper.setLoadingTime(time);
            String defStyle = con.getHeaderField("Default-Style");
            NodeList list = xdoc.getElementsByTagName("meta");
            int listL = list.getLength();
            for (int i = listL - 1; i >= 0; --i) {
                String metaDefStyle;
                if (!"Default-Style".equalsIgnoreCase(((Element)list.item(i)).getAttribute("http-equiv")) || (metaDefStyle = ((Element)list.item(i)).getAttribute("content")).length() != 0) continue;
                defStyle = metaDefStyle;
            }
            if (defStyle != null) {
                wrapper.setSelectedStyleSheetSet(defStyle);
            }
            if ((referrerPolicy = con.getHeaderField("Referrer-Policy")) != null) {
                wrapper.setReferrerPolicyHeader(referrerPolicy);
            }
            if (con instanceof HttpURLConnection) {
                HttpURLConnection hcon = (HttpURLConnection)con;
                this.readCookies(hcon, time);
                hcon.disconnect();
            }
            return wrapper;
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            DOMCSSStyleSheetFactory.this.resolver = resolver;
            if (this.docbuilder != null) {
                this.docbuilder.setEntityResolver(resolver);
            }
        }

        @Override
        public URLConnection openConnection(URL url, long creationDate) throws IOException {
            return super.openConnection(url, creationDate);
        }
    }

    private class MyDOMDocumentCSSStyleSheet
    extends DOMDocumentCSSStyleSheet {
        MyDOMDocumentCSSStyleSheet(String medium, byte origin) {
            super(medium, origin);
        }

        @Override
        protected DOMDocumentCSSStyleSheet createDocumentStyleSheet(String medium, byte origin) {
            return new MyDOMDocumentCSSStyleSheet(medium, origin);
        }

        @Override
        protected DOMComputedStyle createComputedCSSStyle(BaseDocumentCSSStyleSheet parentSheet) {
            return new MyDOMComputedStyle(parentSheet);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }
    }

    class MyDOMCSSStyleSheet
    extends DOMCSSStyleSheet {
        MyDOMCSSStyleSheet(String title, Node ownerNode, MediaQueryList media, AbstractCSSRule ownerRule, byte origin) {
            super(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        protected DOMCSSStyleSheet createCSSStyleSheet(String title, Node ownerNode, MediaQueryList media, AbstractCSSRule ownerRule, byte origin) {
            return new MyDOMCSSStyleSheet(title, ownerNode, media, ownerRule, origin);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }
    }

    private class MyStylableDocumentWrapper
    extends StylableDocumentWrapper {
        private long loadingTime;

        MyStylableDocumentWrapper(Document document) {
            super(document);
        }

        @Override
        protected DOMCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public URLConnection openConnection(URL url) throws IOException {
            return DOMCSSStyleSheetFactory.this.getUserAgent().openConnection(url, this.loadingTime);
        }

        @Override
        public void setLoadingTime(long time) {
            this.loadingTime = time;
        }

        @Override
        protected void setReferrerPolicyHeader(String policy) {
            super.setReferrerPolicyHeader(policy);
        }
    }

    class MyAnonStyleDeclaration
    extends AnonymousStyleDeclaration {
        MyAnonStyleDeclaration(Node ownerNode) {
            super(ownerNode);
        }

        private MyAnonStyleDeclaration(AnonymousStyleDeclaration copiedObject) {
            super(copiedObject);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public AnonymousStyleDeclaration clone() {
            MyAnonStyleDeclaration styleClone = new MyAnonStyleDeclaration(this);
            return styleClone;
        }
    }

    class MyInlineStyle
    extends InlineStyle {
        MyInlineStyle() {
        }

        MyInlineStyle(InlineStyle copiedObject) {
            super(copiedObject);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public InlineStyle clone() {
            return new MyInlineStyle(this);
        }
    }

    class MyCompatInlineStyle
    extends CompatInlineStyle {
        MyCompatInlineStyle() {
        }

        MyCompatInlineStyle(CompatInlineStyle copiedObject) {
            super(copiedObject);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public InlineStyle clone() {
            return new MyCompatInlineStyle(this);
        }
    }

    class MyDOMComputedStyle
    extends DOMComputedStyle {
        MyDOMComputedStyle(BaseDocumentCSSStyleSheet parentSheet) {
            super(parentSheet);
        }

        private MyDOMComputedStyle(ComputedCSSStyle copiedObject) {
            super(copiedObject);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public ComputedCSSStyle clone() {
            MyDOMComputedStyle styleClone = new MyDOMComputedStyle(this);
            return styleClone;
        }
    }
}

