/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.jclf.text.TokenParser;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

public class DOMUtil {
    public static void parsePseudoAttributes(String data, LinkedHashMap<String, String> pseudoAttrs) throws DOMException {
        pseudoAttrs.clear();
        LinkedList<String> tokenlist = new LinkedList<String>();
        TokenParser tp = new TokenParser(data, " ", "\"'");
        while (tp.hasNext()) {
            tokenlist.add(tp.next());
        }
        String token = null;
        String name = null;
        int stage = 0;
        int sz = tokenlist.size();
        for (int i = 0; i < sz; ++i) {
            String value;
            int idx;
            token = (String)tokenlist.get(i);
            if (stage == 0) {
                idx = token.indexOf(61);
                if (idx == -1) {
                    if (DOMUtil.invalidPseudoAttrName(token)) {
                        pseudoAttrs.clear();
                        DOMUtil.parseError("Invalid pseudo-attribute name in PI: " + token);
                        return;
                    }
                    name = token;
                    stage = 1;
                    continue;
                }
                name = token.substring(0, idx);
                if (DOMUtil.invalidPseudoAttrName(name)) {
                    pseudoAttrs.clear();
                    DOMUtil.parseError("Invalid pseudo-attribute name in PI: " + name);
                    return;
                }
                if (++idx != token.length()) {
                    value = token.substring(idx);
                    pseudoAttrs.put(name, value);
                    name = null;
                    stage = 0;
                    continue;
                }
                stage = 2;
                continue;
            }
            if (stage == 1) {
                idx = token.indexOf(61);
                if (idx == -1) {
                    pseudoAttrs.put(name, null);
                    if (DOMUtil.invalidPseudoAttrName(token)) {
                        pseudoAttrs.clear();
                        DOMUtil.parseError("Invalid pseudo-attribute name in PI: " + token);
                        return;
                    }
                    name = token;
                    continue;
                }
                if (idx == 0) {
                    if (++idx != token.length()) {
                        value = token.substring(idx);
                        pseudoAttrs.put(name, value);
                        name = null;
                        stage = 0;
                        continue;
                    }
                    stage = 2;
                    continue;
                }
                pseudoAttrs.put(name, null);
                name = token.substring(0, idx);
                if (DOMUtil.invalidPseudoAttrName(name)) {
                    pseudoAttrs.clear();
                    DOMUtil.parseError("Invalid pseudo-attribute name in PI: " + name);
                    return;
                }
                if (++idx != token.length()) {
                    value = token.substring(idx);
                    pseudoAttrs.put(name, value);
                    name = null;
                    stage = 0;
                    continue;
                }
                stage = 2;
                continue;
            }
            if (stage != 2) continue;
            pseudoAttrs.put(name, token);
            stage = 0;
        }
    }

    private static void parseError(String message) throws DOMException {
        throw new DOMException(5, message);
    }

    private static boolean invalidPseudoAttrName(String name) {
        if (name.length() != 0) {
            char[] na = name.toCharArray();
            for (int i = 0; i < na.length; ++i) {
                if (Character.isLetterOrDigit(na[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

