/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.om.AbstractErrorHandler;
import java.util.LinkedHashMap;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleSheet;

public abstract class DefaultErrorHandler
extends AbstractErrorHandler {
    private LinkedHashMap<Node, String> linkedStyleErrors = null;
    private LinkedHashMap<Exception, String> inlineStyleErrors = null;
    private LinkedHashMap<Exception, CSSStyleSheet> linkedSheetErrors = null;

    @Override
    public boolean hasErrors() {
        return this.linkedStyleErrors != null || this.inlineStyleErrors != null || this.linkedSheetErrors != null || super.hasErrors();
    }

    @Override
    public void linkedStyleError(Node node, String message) {
        if (this.linkedStyleErrors == null) {
            this.linkedStyleErrors = new LinkedHashMap();
        }
        this.linkedStyleErrors.put(node, message);
    }

    @Override
    public void linkedSheetError(Exception e, CSSStyleSheet sheet) {
        if (this.linkedSheetErrors == null) {
            this.linkedSheetErrors = new LinkedHashMap();
        }
        this.linkedSheetErrors.put(e, sheet);
    }

    @Override
    public void inlineStyleError(CSSElement owner, Exception e, String style) {
        if (this.inlineStyleErrors == null) {
            this.inlineStyleErrors = new LinkedHashMap();
        }
        this.inlineStyleErrors.put(e, style);
    }

    @Override
    public void reset() {
        this.linkedStyleErrors = null;
        this.inlineStyleErrors = null;
        this.linkedSheetErrors = null;
        super.reset();
    }

    public LinkedHashMap<Node, String> getLinkedStyleErrors() {
        return this.linkedStyleErrors;
    }

    public LinkedHashMap<Exception, String> getInlineStyleErrors() {
        return this.inlineStyleErrors;
    }

    public LinkedHashMap<Exception, CSSStyleSheet> getLinkedSheetErrors() {
        return this.linkedSheetErrors;
    }
}

