/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSFontFaceRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class FontFaceRule
extends BaseCSSDeclarationRule
implements ExtendedCSSFontFaceRule {
    public FontFaceRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)5, origin);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.getStyle().getLength() != 0) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("@font-face{").append(((AbstractCSSStyleDeclaration)this.getStyle()).getMinifiedCssText()).append('}');
            return buf.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.getStyle().getLength() != 0) {
            context.startRule(wri);
            wri.write("@font-face");
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            ((AbstractCSSStyleDeclaration)this.getStyle()).writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri);
        }
    }

    @Override
    PropertyDocumentHandler createPropertyDocumentHandler() {
        return new FFDeclarationRuleDocumentHandler();
    }

    class FFDeclarationRuleDocumentHandler
    extends BaseCSSDeclarationRule.DeclarationRuleDocumentHandler {
        FFDeclarationRuleDocumentHandler() {
            super(FontFaceRule.this);
        }

        @Override
        public void startAtRule(String name, String pseudoSelector) {
            if (!"font-face".equalsIgnoreCase(name)) {
                throw new DOMException(13, "Cannot set rule of type: " + name);
            }
        }
    }
}

