/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSFontFeatureValuesMap;
import io.sf.carte.doc.style.css.CSSFontFeatureValuesRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.EmptyDocumentHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.FontFeatureValuesHandler;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class FontFeatureValuesRule
extends BaseCSSRule
implements CSSFontFeatureValuesRule {
    private String[] fontFamily = null;
    private CSSFontFeatureValuesMapImpl annotation = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl ornaments = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl stylistic = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl swash = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl characterVariant = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl styleset = new CSSFontFeatureValuesMapImpl();
    private HashMap<String, CSSFontFeatureValuesMapImpl> mapmap = null;

    protected FontFeatureValuesRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)14, origin);
    }

    @Override
    public String[] getFontFamily() {
        return this.fontFamily;
    }

    void setFontFamily(String[] fontFamily) {
        this.fontFamily = fontFamily;
    }

    @Override
    public CSSFontFeatureValuesMap getAnnotation() {
        return this.annotation;
    }

    @Override
    public CSSFontFeatureValuesMap getOrnaments() {
        return this.ornaments;
    }

    @Override
    public CSSFontFeatureValuesMap getStylistic() {
        return this.stylistic;
    }

    @Override
    public CSSFontFeatureValuesMap getSwash() {
        return this.swash;
    }

    @Override
    public CSSFontFeatureValuesMap getCharacterVariant() {
        return this.characterVariant;
    }

    @Override
    public CSSFontFeatureValuesMap getStyleset() {
        return this.styleset;
    }

    @Override
    public void enableMap(String featureValueName) {
        featureValueName = featureValueName.toLowerCase(Locale.ROOT);
        FontFeatureValuesRule.enableMap(featureValueName, this.mapmap);
    }

    private static void enableMap(String featureValueName, HashMap<String, CSSFontFeatureValuesMapImpl> mapmap) {
        if (!(featureValueName.equals("annotation") || featureValueName.equals("ornaments") || featureValueName.equals("stylistic") || featureValueName.equals("swash") || featureValueName.equals("character-variant") || featureValueName.equals("styleset"))) {
            if (mapmap == null) {
                mapmap = new HashMap();
            }
            mapmap.put(featureValueName, new CSSFontFeatureValuesMapImpl());
        }
    }

    @Override
    public CSSFontFeatureValuesMap getFeatureValuesMap(String featureValueName) {
        Object map = (featureValueName = featureValueName.toLowerCase(Locale.ROOT)).equals("annotation") ? this.annotation : (featureValueName.equals("ornaments") ? this.ornaments : (featureValueName.equals("stylistic") ? this.stylistic : (featureValueName.equals("swash") ? this.swash : (featureValueName.equals("character-variant") ? this.characterVariant : (featureValueName.equals("styleset") ? this.styleset : (this.mapmap == null ? null : (CSSFontFeatureValuesMap)this.mapmap.get(featureValueName)))))));
        return map;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(256);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.fontFamily == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append("@font-feature-values ");
        buf.append(this.fontFamily[0]);
        for (int i = 1; i < this.fontFamily.length; ++i) {
            buf.append(',').append(this.fontFamily[i]);
        }
        buf.append('{');
        if (!this.swash.isEmpty()) {
            buf.append("@swash{");
            this.appendMinifiedFeatureString(buf, this.swash);
            buf.append('}');
        }
        if (!this.annotation.isEmpty()) {
            buf.append("@annotation{");
            this.appendMinifiedFeatureString(buf, this.annotation);
            buf.append('}');
        }
        if (!this.ornaments.isEmpty()) {
            buf.append("@ornaments{");
            this.appendMinifiedFeatureString(buf, this.ornaments);
            buf.append('}');
        }
        if (!this.stylistic.isEmpty()) {
            buf.append("@stylistic{");
            this.appendMinifiedFeatureString(buf, this.stylistic);
            buf.append('}');
        }
        if (!this.styleset.isEmpty()) {
            buf.append("@styleset{");
            this.appendMinifiedFeatureString(buf, this.styleset);
            buf.append('}');
        }
        if (!this.characterVariant.isEmpty()) {
            buf.append("@character-variant{");
            this.appendMinifiedFeatureString(buf, this.characterVariant);
            buf.append('}');
        }
        if (this.mapmap != null) {
            for (Map.Entry<String, CSSFontFeatureValuesMapImpl> me : this.mapmap.entrySet()) {
                buf.append('@').append(me.getKey()).append('{');
                this.appendMinifiedFeatureString(buf, me.getValue());
                buf.append('}');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    private void appendMinifiedFeatureString(StringBuilder buf, CSSFontFeatureValuesMapImpl featureMap) {
        int szm1 = featureMap.featureMap.size() - 1;
        String[] names = featureMap.featureMap.keySet().toArray(new String[0]);
        for (int i = 0; i <= szm1; ++i) {
            String name = names[i];
            buf.append(name).append(':');
            PrimitiveValue[] values = (PrimitiveValue[])featureMap.featureMap.get(name);
            buf.append(values[0].getMinifiedCssText(name));
            for (int j = 1; j < values.length; ++j) {
                buf.append(' ').append(values[j].getMinifiedCssText(name));
            }
            if (i == szm1) continue;
            buf.append(';');
        }
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.fontFamily == null) {
            return;
        }
        context.startRule(wri);
        wri.write("@font-feature-values ");
        FontFeatureValuesRule.writeFontFamily(wri, this.fontFamily[0]);
        for (int i = 1; i < this.fontFamily.length; ++i) {
            context.writeComma(wri);
            FontFeatureValuesRule.writeFontFamily(wri, this.fontFamily[i]);
        }
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        this.writeFeatureBlock(wri, context, "@swash", this.swash);
        this.writeFeatureBlock(wri, context, "@annotation", this.annotation);
        this.writeFeatureBlock(wri, context, "@ornaments", this.ornaments);
        this.writeFeatureBlock(wri, context, "@stylistic", this.stylistic);
        this.writeFeatureBlock(wri, context, "@styleset", this.styleset);
        this.writeFeatureBlock(wri, context, "@character-variant", this.characterVariant);
        if (this.mapmap != null) {
            Iterator<Map.Entry<String, CSSFontFeatureValuesMapImpl>> it = this.mapmap.entrySet().iterator();
            while (it.hasNext()) {
                context.startRule(wri);
                Map.Entry<String, CSSFontFeatureValuesMapImpl> me = it.next();
                wri.write('@');
                wri.write(me.getKey());
                context.writeLeftCurlyBracket(wri);
                this.appendFeatureString(wri, context, me.getValue());
                context.writeRightCurlyBracket(wri);
                context.endRule(wri);
            }
        }
        context.endCurrentContext(this);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri);
    }

    private static void writeFontFamily(SimpleWriter wri, String ff) throws IOException {
        if (ff.indexOf(32) == -1) {
            wri.write(ff);
        } else {
            wri.write('\'');
            wri.write(ff);
            wri.write('\'');
        }
    }

    private void writeFeatureBlock(SimpleWriter wri, StyleFormattingContext context, String atFeatureType, CSSFontFeatureValuesMapImpl featureMap) throws IOException {
        if (!featureMap.isEmpty()) {
            context.startRule(wri);
            wri.write(atFeatureType);
            context.writeLeftCurlyBracket(wri);
            this.appendFeatureString(wri, context, featureMap);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri);
        }
    }

    private void appendFeatureString(SimpleWriter wri, StyleFormattingContext context, CSSFontFeatureValuesMapImpl featureMap) throws IOException {
        context.deepenCurrentContext();
        context.startStyleDeclaration(wri);
        Iterator it = featureMap.featureMap.entrySet().iterator();
        while (it.hasNext()) {
            context.startPropertyDeclaration(wri);
            Map.Entry me = it.next();
            wri.write((CharSequence)me.getKey());
            context.writeColon(wri);
            PrimitiveValue[] values = (PrimitiveValue[])me.getValue();
            values[0].writeCssText(wri);
            for (int i = 1; i < values.length; ++i) {
                wri.write(' ');
                values[i].writeCssText(wri);
            }
            context.writeSemiColon(wri);
            context.endPropertyDeclaration(wri);
        }
        context.updateContext(this);
        context.endStyleDeclaration(wri);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        CSSParser parser;
        int len = (cssText = cssText.trim()).length();
        if (len < 24) {
            throw new DOMException(12, "Invalid @font-feature-values rule: " + cssText);
        }
        CharSequence atkeyword = cssText.subSequence(0, 21);
        if (!ParseHelper.startsWithIgnoreCase(atkeyword, "@font-feature-values") || !Character.isWhitespace(cssText.charAt(20))) {
            throw new DOMException(13, "Not a @font-feature-values rule: " + cssText);
        }
        String body = cssText.substring(21, len);
        MyFontFeatureValuesHandler handler = new MyFontFeatureValuesHandler();
        try {
            parser = (CSSParser)this.createSACParser();
        }
        catch (ClassCastException e) {
            parser = new CSSParser();
        }
        parser.setDocumentHandler(handler);
        try {
            parser.parseFontFeatureValuesBody(body);
        }
        catch (CSSParseException e) {
            throw new DOMException(5, e.getMessage());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = this.annotation == null ? 0 : this.annotation.hashCode();
        result = 31 * result + (this.characterVariant == null ? 0 : this.characterVariant.hashCode());
        result = 31 * result + Arrays.hashCode(this.fontFamily);
        result = 31 * result + (this.mapmap == null ? 0 : this.mapmap.hashCode());
        result = 31 * result + (this.ornaments == null ? 0 : this.ornaments.hashCode());
        result = 31 * result + (this.styleset == null ? 0 : this.styleset.hashCode());
        result = 31 * result + (this.stylistic == null ? 0 : this.stylistic.hashCode());
        result = 31 * result + (this.swash == null ? 0 : this.swash.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontFeatureValuesRule other = (FontFeatureValuesRule)obj;
        if (this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation)) {
            return false;
        }
        if (this.characterVariant == null ? other.characterVariant != null : !this.characterVariant.equals(other.characterVariant)) {
            return false;
        }
        if (!Arrays.equals(this.fontFamily, other.fontFamily)) {
            return false;
        }
        if (this.mapmap == null ? other.mapmap != null : !this.mapmap.equals(other.mapmap)) {
            return false;
        }
        if (this.ornaments == null ? other.ornaments != null : !this.ornaments.equals(other.ornaments)) {
            return false;
        }
        if (this.styleset == null ? other.styleset != null : !this.styleset.equals(other.styleset)) {
            return false;
        }
        if (this.stylistic == null ? other.stylistic != null : !this.stylistic.equals(other.stylistic)) {
            return false;
        }
        return !(this.swash == null ? other.swash != null : !this.swash.equals(other.swash));
    }

    @Override
    public FontFeatureValuesRule clone(AbstractCSSStyleSheet parentSheet) {
        FontFeatureValuesRule rule = new FontFeatureValuesRule(parentSheet, this.getOrigin());
        rule.fontFamily = this.fontFamily;
        rule.annotation = this.annotation;
        rule.ornaments = this.ornaments;
        rule.stylistic = this.stylistic;
        rule.swash = this.swash;
        rule.styleset = this.styleset;
        rule.characterVariant = this.characterVariant;
        return rule;
    }

    static /* synthetic */ String[] access$102(FontFeatureValuesRule x0, String[] x1) {
        x0.fontFamily = x1;
        return x1;
    }

    static class CSSFontFeatureValuesMapImpl
    implements CSSFontFeatureValuesMap {
        private final LinkedHashMap<String, PrimitiveValue[]> featureMap = new LinkedHashMap();
        private List<String> precedingComments = null;

        CSSFontFeatureValuesMapImpl() {
        }

        void addAll(CSSFontFeatureValuesMapImpl othermap) {
            this.featureMap.putAll(othermap.featureMap);
        }

        void clear() {
            this.featureMap.clear();
        }

        @Override
        public PrimitiveValue[] get(String featureValueName) {
            return this.featureMap.get(featureValueName);
        }

        @Override
        public void set(String featureValueName, PrimitiveValue ... values) {
            if (values == null) {
                throw new DOMException(12, "Must provide at least one value");
            }
            for (PrimitiveValue pri : values) {
                if (pri == null) {
                    throw new DOMException(12, "Null value supplied.");
                }
                pri.setExpectInteger();
            }
            this.featureMap.put(featureValueName, values);
        }

        public boolean isEmpty() {
            return this.featureMap.isEmpty();
        }

        void setPrecedingComments(List<String> ruleComments) {
            this.precedingComments = ruleComments;
        }

        @Override
        public List<String> getPrecedingComments() {
            return this.precedingComments;
        }

        public int hashCode() {
            int prime = 31;
            if (this.featureMap == null) {
                return 0;
            }
            int result = 1;
            TreeSet<String> set = new TreeSet<String>();
            set.addAll(this.featureMap.keySet());
            for (String ffname : set) {
                result = 31 * result + ffname.hashCode();
                result = 31 * result + Arrays.hashCode(this.featureMap.get(ffname));
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CSSFontFeatureValuesMapImpl other = (CSSFontFeatureValuesMapImpl)obj;
            if (this.featureMap == null) {
                if (other.featureMap != null) {
                    return false;
                }
            } else {
                if (other.featureMap == null || this.featureMap.size() != other.featureMap.size()) {
                    return false;
                }
                for (Map.Entry<String, PrimitiveValue[]> entry : this.featureMap.entrySet()) {
                    String ffname = entry.getKey();
                    Object[] values = entry.getValue();
                    Object[] ovalues = other.featureMap.get(ffname);
                    if (ovalues != null && Arrays.equals(values, ovalues)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private class MyFontFeatureValuesHandler
    extends EmptyDocumentHandler
    implements FontFeatureValuesHandler {
        private String[] fontFamily = null;
        private final CSSFontFeatureValuesMapImpl annotation = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl ornaments = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl stylistic = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl swash = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl characterVariant = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl styleset = new CSSFontFeatureValuesMapImpl();
        private final HashMap<String, CSSFontFeatureValuesMapImpl> mapmap = null;
        private CSSFontFeatureValuesMap currentMap = null;
        private LinkedList<String> comments = null;

        MyFontFeatureValuesHandler() {
        }

        @Override
        public void startFontFeatures(String[] fontFamily) {
            this.fontFamily = fontFamily;
        }

        @Override
        public void endFontFeatures() {
            FontFeatureValuesRule.access$102(FontFeatureValuesRule.this, this.fontFamily);
            FontFeatureValuesRule.this.annotation.clear();
            FontFeatureValuesRule.this.ornaments.clear();
            FontFeatureValuesRule.this.stylistic.clear();
            FontFeatureValuesRule.this.swash.clear();
            FontFeatureValuesRule.this.characterVariant.clear();
            FontFeatureValuesRule.this.styleset.clear();
            FontFeatureValuesRule.this.annotation.addAll(this.annotation);
            FontFeatureValuesRule.this.ornaments.addAll(this.ornaments);
            FontFeatureValuesRule.this.stylistic.addAll(this.stylistic);
            FontFeatureValuesRule.this.swash.addAll(this.swash);
            FontFeatureValuesRule.this.characterVariant.addAll(this.characterVariant);
            FontFeatureValuesRule.this.styleset.addAll(this.styleset);
            FontFeatureValuesRule.this.mapmap = this.mapmap;
            FontFeatureValuesRule.this.annotation.setPrecedingComments(this.annotation.getPrecedingComments());
            FontFeatureValuesRule.this.ornaments.setPrecedingComments(this.ornaments.getPrecedingComments());
            FontFeatureValuesRule.this.stylistic.setPrecedingComments(this.stylistic.getPrecedingComments());
            FontFeatureValuesRule.this.swash.setPrecedingComments(this.swash.getPrecedingComments());
            FontFeatureValuesRule.this.characterVariant.setPrecedingComments(this.characterVariant.getPrecedingComments());
            FontFeatureValuesRule.this.styleset.setPrecedingComments(this.styleset.getPrecedingComments());
        }

        @Override
        public void startFeatureMap(String mapname) {
            mapname = mapname.toLowerCase(Locale.ROOT);
            this.enableMap(mapname);
            this.currentMap = this.getFeatureValuesMap(mapname);
        }

        private void enableMap(String featureValueName) {
            FontFeatureValuesRule.enableMap(featureValueName, this.mapmap);
        }

        private CSSFontFeatureValuesMap getFeatureValuesMap(String featureValueName) {
            CSSFontFeatureValuesMapImpl map;
            if (featureValueName.equals("annotation")) {
                map = this.annotation;
            } else if (featureValueName.equals("ornaments")) {
                map = this.ornaments;
            } else if (featureValueName.equals("stylistic")) {
                map = this.stylistic;
            } else if (featureValueName.equals("swash")) {
                map = this.swash;
            } else if (featureValueName.equals("character-variant")) {
                map = this.characterVariant;
            } else if (featureValueName.equals("styleset")) {
                map = this.styleset;
            } else if (this.mapmap == null) {
                map = null;
            } else {
                map = this.mapmap.get(featureValueName);
                map.precedingComments = null;
            }
            return map;
        }

        @Override
        public void endFeatureMap() {
            this.setCommentsToCurrentMap();
            this.currentMap = null;
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            LinkedList<PrimitiveValue> values = new LinkedList<PrimitiveValue>();
            while (value != null) {
                String funcname;
                short lutype = value.getLexicalUnitType();
                if (lutype == 13) {
                    NumberValue number = new NumberValue();
                    int ival = value.getIntegerValue();
                    number.setIntegerValue(ival);
                    values.add(number);
                } else if (lutype == 41 && ("calc".equalsIgnoreCase(funcname = value.getFunctionName()) || "var".equalsIgnoreCase(funcname))) {
                    ValueFactory valueFactory = new ValueFactory();
                    StyleValue cssval = valueFactory.createCSSValue(value);
                    PrimitiveValue pri = (PrimitiveValue)cssval;
                    pri.setExpectInteger();
                    values.add(pri);
                } else {
                    throw new CSSException("Found non-integer value: " + value.toString());
                }
                value = value.getNextLexicalUnit();
            }
            PrimitiveValue[] intvals = new PrimitiveValue[values.size()];
            for (int i = 0; i < intvals.length; ++i) {
                intvals[i] = (PrimitiveValue)values.get(i);
            }
            this.currentMap.set(name, intvals);
        }

        @Override
        public void comment(String text) throws CSSException {
            if (this.currentMap == null) {
                if (this.comments == null) {
                    this.comments = new LinkedList();
                }
                this.comments.add(text);
            }
        }

        private void setCommentsToCurrentMap() {
            if (this.comments != null && !this.comments.isEmpty()) {
                ArrayList<String> ruleComments = new ArrayList<String>(this.comments.size());
                ruleComments.addAll(this.comments);
                ((CSSFontFeatureValuesMapImpl)this.currentMap).setPrecedingComments(ruleComments);
            }
            this.resetCommentStack();
        }

        private void resetCommentStack() {
            if (this.comments != null) {
                this.comments.clear();
            }
        }
    }
}

