/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.List;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

class FontShorthandSetter
extends ShorthandSetter {
    private boolean lineHeightSet = false;

    FontShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "font");
    }

    @Override
    protected List<String> subpropertyList() {
        List<String> subp = super.subpropertyList();
        subp.remove("line-height");
        subp.remove("font-kerning");
        subp.remove("font-size-adjust");
        subp.add(0, "font-variant-css21");
        return subp;
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        shorthandValue = this.filterNormalIdentifier(shorthandValue);
        super.init(shorthandValue, important);
    }

    @Override
    protected void nextCurrentValue() {
        if (this.currentValue != null) {
            this.currentValue = this.filterNormalIdentifier(this.currentValue.getNextLexicalUnit());
            this.appendValueItemString();
        }
    }

    private LexicalUnit filterNormalIdentifier(LexicalUnit lu) {
        while (lu != null && lu.getLexicalUnitType() == 35 && "normal".equalsIgnoreCase(lu.getStringValue())) {
            lu = lu.getNextLexicalUnit();
        }
        return lu;
    }

    @Override
    protected boolean assignSubproperty(String subproperty) {
        if (subproperty.equals("font-size") && this.assignFontSize()) {
            if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 4) {
                this.nextCurrentValue();
                StyleValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                this.setProperty("line-height", cssValue, this.getPriority());
                this.nextCurrentValue();
                this.lineHeightSet = true;
            }
            return true;
        }
        switch (this.currentValue.getLexicalUnitType()) {
            case 35: {
                if (subproperty.equals("font-variant-css21")) {
                    if (!"small-caps".equalsIgnoreCase(this.currentValue.getStringValue())) break;
                    this.setSubpropertyValue("font-variant-caps", this.createCSSValue("font-variant-caps", this.currentValue));
                    this.nextCurrentValue();
                    return true;
                }
                if (super.assignSubproperty(subproperty)) {
                    return true;
                }
                if (!subproperty.equals("font-family")) break;
                this.consumeFontFamilyIdent();
                while (this.currentValue != null) {
                    short type = this.currentValue.getLexicalUnitType();
                    if (type == 0) {
                        this.nextCurrentValue();
                        if (this.currentValue == null) {
                            throw new DOMException(12, "Unexpected comma at the end of font-family list");
                        }
                        type = this.currentValue.getLexicalUnitType();
                    }
                    if (type == 35) {
                        this.consumeFontFamilyIdent();
                        continue;
                    }
                    if (type != 36) break;
                    this.consumeFontFamilyString();
                }
                return true;
            }
            case 36: {
                if (!subproperty.equals("font-family")) break;
                this.consumeFontFamilyString();
                while (this.currentValue != null) {
                    short type = this.currentValue.getLexicalUnitType();
                    if (type == 0) {
                        this.nextCurrentValue();
                        if (this.currentValue == null) {
                            throw new DOMException(12, "Unexpected comma at the end of font-family list");
                        }
                        type = this.currentValue.getLexicalUnitType();
                    }
                    if (type == 35) {
                        this.consumeFontFamilyIdent();
                        continue;
                    }
                    if (type != 36) break;
                    this.consumeFontFamilyString();
                }
                return true;
            }
            case 13: {
                if (!subproperty.equals("font-weight")) break;
                this.setSubpropertyValue("font-weight", this.createCSSValue("font-size", this.currentValue));
                this.nextCurrentValue();
                return true;
            }
        }
        return false;
    }

    private void consumeFontFamilyIdent() {
        int stringType = 21;
        String str = this.currentValue.getStringValue();
        super.nextCurrentValue();
        while (this.currentValue != null && this.currentValue.getLexicalUnitType() == 35) {
            String s = this.currentValue.getStringValue();
            str = str + " " + s;
            stringType = 19;
            super.nextCurrentValue();
        }
        AbstractTextValue value = stringType == 19 ? new StringValue() : new IdentifierValue();
        value.setStringValue((short)stringType, str);
        value.setSubproperty(true);
        this.addSubpropertyValue("font-family", value, true);
    }

    private void consumeFontFamilyString() {
        StyleValue value = this.createCSSValue("font-family", this.currentValue);
        this.addSubpropertyValue("font-family", value, true);
        super.nextCurrentValue();
    }

    private boolean assignFontSize() {
        if (this.currentValue.getLexicalUnitType() == 35) {
            return super.assignSubproperty("font-size");
        }
        if (ValueFactory.isPositiveSizeSACUnit(this.currentValue)) {
            StyleValue cssValue = this.createCSSValue("font-size", this.currentValue);
            this.setSubpropertyValue("font-size", cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    @Override
    protected void resetSubproperties() {
        this.getUnassignedProperties().remove("font-variant-css21");
        super.resetSubproperties();
        if (!this.lineHeightSet) {
            this.setPropertyToDefault("line-height");
        }
        if (!this.isPropertySet("font-variant-caps")) {
            this.setPropertyToDefault("font-variant-caps");
        }
        this.setPropertyToDefault("font-size-adjust");
        this.setPropertyToDefault("font-kerning");
        this.setPropertyToDefault("font-variant-ligatures");
        this.setPropertyToDefault("font-variant-position");
        this.setPropertyToDefault("font-variant-numeric");
        this.setPropertyToDefault("font-variant-alternates");
        this.setPropertyToDefault("font-variant-east-asian");
    }

    @Override
    protected void setSubpropertiesInherit(InheritValue inherit) {
        super.setSubpropertiesInherit(inherit);
        this.lineHeightSet = true;
        this.resetSubproperties();
        this.flush();
    }

    @Override
    protected void setSubpropertiesToKeyword(StyleValue keyword) {
        super.setSubpropertiesToKeyword(keyword);
        this.lineHeightSet = true;
        this.resetSubproperties();
        this.flush();
    }
}

