/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.StyleValue;

class FontVariantShorthandSetter
extends ShorthandSetter {
    FontVariantShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "font-variant");
    }

    @Override
    public boolean assignSubproperties() {
        if (this.currentValue.getLexicalUnitType() == 35) {
            String text = this.currentValue.getStringValue();
            boolean isNone = false;
            if (text.equalsIgnoreCase("normal") || (isNone = text.equalsIgnoreCase("none"))) {
                if (this.currentValue.getNextLexicalUnit() == null) {
                    String[] sh;
                    IdentifierValue normal = new IdentifierValue("normal");
                    normal.setSubproperty(true);
                    for (String s : sh = this.getShorthandSubproperties()) {
                        this.styleDeclaration.setProperty(s, normal, this.getPriority());
                    }
                    if (isNone) {
                        IdentifierValue none = new IdentifierValue("none");
                        none.setSubproperty(true);
                        this.styleDeclaration.setProperty("font-variant-ligatures", none, this.getPriority());
                    }
                    this.initValueString();
                    this.appendValueItemString(text);
                    return true;
                }
                StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    errHandler.shorthandError(this.getShorthandName(), "Found '" + text + "' keyword mixed with other values");
                }
                return false;
            }
        }
        return super.assignSubproperties();
    }

    @Override
    protected boolean assignSubproperty(String subproperty) {
        switch (this.currentValue.getLexicalUnitType()) {
            case 35: {
                if (subproperty.equals("font-variant-alternates") && this.testFontVariantAlternates()) {
                    return true;
                }
                boolean is_set = false;
                while (this.currentValue != null) {
                    if (this.testIdentifiers(subproperty)) {
                        StyleValue cssValue = this.createCSSValue(subproperty, this.currentValue);
                        this.addSubpropertyValue(subproperty, cssValue, false);
                        is_set = true;
                        this.nextCurrentValue();
                        if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 35) continue;
                        break;
                    }
                    return is_set;
                }
                return is_set;
            }
            case 41: {
                if (!subproperty.equals("font-variant-alternates") || !this.testFontVariantAlternates()) break;
                return true;
            }
        }
        return false;
    }

    private boolean testFontVariantAlternates() {
        boolean is_set = false;
        while (this.currentValue != null) {
            switch (this.currentValue.getLexicalUnitType()) {
                case 35: {
                    StyleValue cssValue;
                    if (this.testIdentifiers("font-variant-alternates")) {
                        cssValue = this.createCSSValue("font-variant-alternates", this.currentValue);
                        this.addSubpropertyValue("font-variant-alternates", cssValue, false);
                        this.nextCurrentValue();
                        is_set = true;
                        break;
                    }
                    return is_set;
                }
                case 41: {
                    StyleValue cssValue = this.createCSSValue("font-variant-alternates", this.currentValue);
                    this.addSubpropertyValue("font-variant-alternates", cssValue, false);
                    this.nextCurrentValue();
                    is_set = true;
                }
            }
        }
        return is_set;
    }
}

