/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Locale;
import java.util.Set;

class GenericShorthandBuilder
extends ShorthandBuilder {
    final String initialvalue;

    GenericShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue) {
        super(shorthandName, parentStyle);
        this.initialvalue = initialvalue;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        if (this.hasPropertiesToExclude(declaredSet)) {
            return false;
        }
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkValuesForKeyword("unset", declaredSet);
        if (check == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        boolean appended = false;
        String[] subp = this.getLonghandProperties();
        for (int i = 0; i < subp.length; ++i) {
            String property = subp[i];
            if (!declaredSet.contains(property)) continue;
            StyleValue cssVal = this.getCSSValue(property);
            if (cssVal.getCssValueType() == 2 && ((ValueList)cssVal).isCommaSeparated() || this.invalidValueClash(declaredSet, property, cssVal)) {
                return false;
            }
            appended = this.appendValueText(buf, property, appended);
        }
        if (!appended) {
            buf.append(this.initialvalue);
        }
        this.appendPriority(buf, important);
        return true;
    }

    boolean invalidValueClash(Set<String> declaredSet, String property, StyleValue cssVal) {
        if (cssVal.getCssValueType() == 2) {
            ValueList list = (ValueList)cssVal;
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                if (!this.invalidValueClash(declaredSet, property, list.item(i))) continue;
                return true;
            }
        } else {
            if (cssVal.getCssValueType() == 1) {
                return this.invalidPrimitiveValueClash(declaredSet, property, (PrimitiveValue)cssVal);
            }
            return true;
        }
        return false;
    }

    boolean invalidPrimitiveValueClash(Set<String> declaredSet, String propertyName, PrimitiveValue primi) {
        if (primi.getPrimitiveType() == 21) {
            return this.invalidIdentValueClash(declaredSet, propertyName, primi);
        }
        return false;
    }

    boolean invalidIdentValueClash(Set<String> declaredSet, String propertyName, PrimitiveValue primi) {
        String ident = primi.getStringValue().toLowerCase(Locale.ROOT);
        if (!(GenericShorthandBuilder.getShorthandDatabase().isIdentifierValue(propertyName, ident) || ident.equals(this.initialvalue) || ident.equals("initial"))) {
            if (this.identifierValuesAreKnown(propertyName) || this.containsControl(ident)) {
                return true;
            }
            for (String property : declaredSet) {
                if (!GenericShorthandBuilder.getShorthandDatabase().hasKnownIdentifierValues(property) || !GenericShorthandBuilder.getShorthandDatabase().isIdentifierValue(property, ident)) continue;
                return true;
            }
        }
        return false;
    }

    boolean identifierValuesAreKnown(String propertyName) {
        return GenericShorthandBuilder.getShorthandDatabase().hasKnownIdentifierValues(propertyName);
    }

    boolean appendValueText(StringBuilder buf, String property, boolean appended) {
        return this.appendValueIfNotInitial(buf, property, appended);
    }
}

