/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class GridPlacementShorthandBuilder
extends ShorthandBuilder {
    GridPlacementShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle) {
        super(shorthandName, parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 2;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        if (this.hasPropertiesToExclude(declaredSet)) {
            return false;
        }
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkValuesForKeyword("unset", declaredSet);
        if (check == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        String[] subp = this.getSubproperties();
        StyleValue cssVal0 = this.getCSSValue(subp[0]);
        if (cssVal0.getCssValueType() == 2 && ((ValueList)cssVal0).isCommaSeparated()) {
            return false;
        }
        this.appendValueText(buf, cssVal0);
        if (subp.length == 2) {
            StyleValue cssVal = this.getCSSValue(subp[1]);
            if (this.isPrintValue(subp[1], cssVal, cssVal0)) {
                buf.append('/');
                this.appendValueText(buf, cssVal);
            }
        } else {
            boolean p2;
            StyleValue cssVal3 = this.getCSSValue(subp[3]);
            StyleValue cssVal2 = this.getCSSValue(subp[2]);
            StyleValue cssVal1 = this.getCSSValue(subp[1]);
            boolean p3 = this.isPrintValue(subp[3], cssVal3, cssVal1);
            boolean bl = p2 = this.isPrintValue(subp[2], cssVal2, cssVal0) || p3;
            if (this.isPrintValue(subp[1], cssVal1, cssVal0) || p2) {
                buf.append('/');
                this.appendValueText(buf, cssVal1);
                if (p2) {
                    buf.append('/');
                    this.appendValueText(buf, cssVal2);
                    if (p3) {
                        buf.append('/');
                        this.appendValueText(buf, cssVal3);
                    }
                }
            }
        }
        this.appendPriority(buf, important);
        return true;
    }

    private boolean isPrintValue(String propertyName, StyleValue cssValue, StyleValue cssVal0) {
        if (!this.isIdentifier(cssValue)) {
            return true;
        }
        if (this.isIdentifier(cssVal0)) {
            return !this.valueEquals(cssVal0, cssValue);
        }
        return this.isNotInitialValue(cssValue, propertyName);
    }

    @Override
    protected boolean isNotInitialValue(StyleValue cssVal, String propertyName) {
        return cssVal != null && !GridPlacementShorthandBuilder.isInitialIdentifier(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(StringBuilder buf, StyleValue cssVal) {
        buf.append(cssVal.getMinifiedCssText(this.getShorthandName()));
    }

    private boolean isIdentifier(StyleValue cssVal) {
        return cssVal.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)cssVal)).getPrimitiveType() == 21;
    }
}

