/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSGroupingRule;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSStyleDeclarationRule;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.doc.style.css.om.StyleRule;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;

public abstract class GroupingRule
extends BaseCSSRule
implements CSSGroupingRule {
    CSSRuleArrayList cssRules;

    protected GroupingRule(AbstractCSSStyleSheet parentSheet, short type, byte origin) {
        super(parentSheet, type, origin);
        this.cssRules = new CSSRuleArrayList();
    }

    protected GroupingRule(AbstractCSSStyleSheet parentSheet, GroupingRule copyfrom) {
        super(parentSheet, copyfrom.getType(), copyfrom.getOrigin());
        if (copyfrom.precedingComments != null) {
            this.precedingComments = new ArrayList(copyfrom.precedingComments.size());
            this.precedingComments.addAll(copyfrom.precedingComments);
        }
        this.cssRules = new CSSRuleArrayList(copyfrom.getCssRules().getLength());
        Iterator it = copyfrom.getCssRules().iterator();
        while (it.hasNext()) {
            AbstractCSSRule cloned = ((AbstractCSSRule)it.next()).clone(parentSheet);
            cloned.setParentRule(this);
            this.cssRules.add(cloned);
        }
    }

    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index < 0 || index > this.cssRules.size()) {
            throw new DOMException(1, "Index out of bounds in rule list");
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(rule);
        source.setCharacterStream((Reader)re);
        RuleDocumentHandler handler = new RuleDocumentHandler();
        handler.setCurrentInsertionIndex(index);
        RuleErrorHandler errorHandler = new RuleErrorHandler();
        Parser parser = this.createSACParser();
        parser.setDocumentHandler((DocumentHandler)handler);
        parser.setErrorHandler((ErrorHandler)errorHandler);
        try {
            parser.parseRule(source);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (index < 0 || index >= this.cssRules.size()) {
            throw new DOMException(1, "Could not delete rule in rule list: index out of bounds.");
        }
        this.cssRules.remove(index);
    }

    int insertRule(AbstractCSSRule cssrule, int index) {
        cssrule.setParentRule(this);
        return this.cssRules.insertRule(cssrule, index);
    }

    int addRule(AbstractCSSRule cssrule) {
        int len = this.cssRules.getLength();
        this.cssRules.add(cssrule);
        cssrule.setParentRule(this);
        return len;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
        if (parentSS == null) {
            throw new DOMException(11, "This rule must be added to a sheet first");
        }
        AbstractCSSStyleSheet css = parentSS.getStyleSheetFactory().createRuleStyleSheet(this, null, null);
        StringReader re = new StringReader(cssText);
        InputSource source = new InputSource((Reader)re);
        try {
            css.parseStyleSheet(source);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        CSSRuleArrayList parsedRules = css.getCssRules();
        int len = parsedRules.getLength();
        if (len > 1) {
            throw new DOMException(13, "Attempted to parse more than one rule inside this one");
        }
        if (len == 1) {
            AbstractCSSRule firstRule = (AbstractCSSRule)parsedRules.item(0);
            if (firstRule.getType() != this.getType()) {
                throw new DOMException(13, "Attempted to parse a rule of type " + firstRule.getType());
            }
            GroupingRule groupingRule = (GroupingRule)firstRule;
            this.setGroupingRule(groupingRule);
            this.precedingComments = groupingRule.precedingComments;
            this.cssRules.clear();
            this.cssRules.addAll(groupingRule.getCssRules());
            for (AbstractCSSRule rule : this.cssRules) {
                rule.setParentRule(this);
            }
            if (css.hasRuleErrorsOrWarnings()) {
                parentSS.getErrorHandler().mergeState(css.getErrorHandler());
            }
        } else {
            this.cssRules.clear();
        }
    }

    protected void setGroupingRule(GroupingRule rule) throws DOMException {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cssRules == null ? 0 : this.cssRules.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingRule)) {
            return false;
        }
        GroupingRule other = (GroupingRule)obj;
        return !(this.cssRules == null ? other.cssRules != null : !this.cssRules.equals(other.cssRules));
    }

    class RuleDocumentHandler
    implements DocumentHandler {
        private AbstractCSSRule currentRule = null;
        private int currentInsertionIndex = 0;
        private boolean active = true;

        public void setCurrentInsertionIndex(int index) {
            this.currentInsertionIndex = index;
        }

        public void startDocument(InputSource source) throws CSSException {
            this.currentRule = null;
            this.active = true;
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.active = false;
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.active = true;
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            if (this.active) {
                this.currentRule = new PageRule(GroupingRule.this.getParentStyleSheet(), GroupingRule.this.getOrigin());
                if (name != null) {
                    ((PageRule)this.currentRule).setSelectorText(name);
                }
                if (pseudo_page != null) {
                    Parser parser = GroupingRule.this.createSACParser();
                    InputSource source = new InputSource((Reader)new StringReader(pseudo_page));
                    try {
                        ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(parser.parseSelectors(source));
                    }
                    catch (IOException iOException) {}
                } else {
                    ((CSSStyleDeclarationRule)this.currentRule).setSelectorText("");
                }
            }
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            if (this.active) {
                this.currentInsertionIndex = GroupingRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void startFontFace() throws CSSException {
            if (this.active) {
                this.currentRule = new FontFaceRule(GroupingRule.this.getParentStyleSheet(), GroupingRule.this.getOrigin());
            }
        }

        public void endFontFace() throws CSSException {
            if (this.active) {
                this.currentInsertionIndex = GroupingRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            if (this.active) {
                if (this.currentRule == null) {
                    this.currentRule = GroupingRule.this.getParentStyleSheet().createStyleRule();
                }
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
            }
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            if (this.active && this.currentRule instanceof StyleRule) {
                GroupingRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (this.active) {
                String importantString = null;
                if (important) {
                    importantString = "important";
                }
                ((BaseCSSStyleDeclaration)((CSSStyleDeclarationRule)this.currentRule).getStyle()).setProperty(name, value, importantString);
            }
        }
    }

    class RuleErrorHandler
    implements ErrorHandler {
        RuleErrorHandler() {
        }

        public void warning(CSSParseException exception) throws CSSException {
            AbstractCSSStyleSheet sheet = GroupingRule.this.getParentStyleSheet();
            if (sheet != null) {
                sheet.getErrorHandler().ruleParseWarning(GroupingRule.this, exception);
            }
        }

        public void error(CSSParseException exception) throws CSSException {
            AbstractCSSStyleSheet sheet = GroupingRule.this.getParentStyleSheet();
            if (sheet != null) {
                sheet.getErrorHandler().ruleParseError(GroupingRule.this, exception);
            }
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            AbstractCSSStyleSheet sheet = GroupingRule.this.getParentStyleSheet();
            if (sheet != null) {
                sheet.getErrorHandler().ruleParseError(GroupingRule.this, exception);
            }
        }
    }
}

