/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;

public class ImportRule
extends BaseCSSRule
implements CSSImportRule,
ExtendedCSSRule {
    private AbstractCSSStyleSheet importedSheet = null;
    private String styleSheetURI;
    private MediaQueryList mediaList;

    protected ImportRule(AbstractCSSStyleSheet parentSheet, MediaQueryList mediaList, String href, byte origin) {
        super(parentSheet, (short)3, origin);
        this.mediaList = mediaList;
        this.styleSheetURI = href;
    }

    @Override
    public String getHref() {
        return this.styleSheetURI;
    }

    @Override
    public MediaQueryList getMedia() {
        return this.mediaList;
    }

    @Override
    public AbstractCSSStyleSheet getStyleSheet() {
        if (this.importedSheet == null) {
            AbstractCSSStyleSheet parent = this.getParentStyleSheet();
            this.importedSheet = parent.getStyleSheetFactory().createRuleStyleSheet(this, parent.getTitle(), this.mediaList);
            this.importedSheet.setParentStyleSheet(parent);
            try {
                this.loadStyleSheet();
            }
            catch (DOMException e) {
                parent.getErrorHandler().badAtRule(e, this.getCssText());
            }
            catch (IOException e) {
                parent.getDocumentErrorHandler().ruleIOError(this.styleSheetURI, e);
            }
        }
        return this.importedSheet;
    }

    private boolean loadStyleSheet() throws IOException, DOMException {
        URL styleSheetURL = this.getURL(this.getHref());
        return this.importedSheet.loadStyleSheet(styleSheetURL, "");
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
        if (parentSS == null) {
            throw new DOMException(11, "This rule must be added to a sheet first");
        }
        AbstractCSSStyleSheet css = parentSS.getStyleSheetFactory().createRuleStyleSheet(this, null, null);
        StringReader re = new StringReader(cssText);
        InputSource source = new InputSource((Reader)re);
        try {
            css.parseStyleSheet(source);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        CSSRuleArrayList parsedRules = css.getCssRules();
        int len = parsedRules.getLength();
        if (len != 1) {
            throw new DOMException(13, "Exactly one rule must be parsed into this one, not " + len + '.');
        }
        AbstractCSSRule firstRule = (AbstractCSSRule)parsedRules.item(0);
        if (firstRule.getType() != this.getType()) {
            throw new DOMException(13, "Attempted to parse a rule of type " + firstRule.getType());
        }
        ImportRule imp = (ImportRule)firstRule;
        this.styleSheetURI = imp.getHref();
        this.mediaList = imp.getMedia();
        this.precedingComments = imp.precedingComments;
        this.importedSheet = null;
        if (css.hasRuleErrorsOrWarnings()) {
            parentSS.getErrorHandler().mergeState(css.getErrorHandler());
        }
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(230);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        wri.write("@import ");
        context.writeURL(wri, this.getHref());
        if (!this.mediaList.isAllMedia()) {
            wri.write(' ');
            wri.write(this.mediaList.getMediaText());
        }
        context.writeSemiColon(wri);
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder(80);
        buf.append("@import ");
        buf.append(ParseHelper.quote(this.styleSheetURI, '\''));
        if (!this.mediaList.isAllMedia()) {
            buf.append(' ');
            buf.append(this.mediaList.getMinifiedMedia());
        }
        buf.append(';');
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaList == null ? 0 : this.mediaList.hashCode());
        result = 31 * result + (this.styleSheetURI == null ? 0 : this.styleSheetURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportRule other = (ImportRule)obj;
        if (this.mediaList == null ? other.mediaList != null : !this.mediaList.equals(other.mediaList)) {
            return false;
        }
        return !(this.styleSheetURI == null ? other.styleSheetURI != null : !this.styleSheetURI.equals(other.styleSheetURI));
    }

    @Override
    public ImportRule clone(AbstractCSSStyleSheet parentSheet) {
        ImportRule rule = new ImportRule(parentSheet, ((MediaListAccess)((Object)this.getMedia())).unmodifiable(), this.getHref(), this.getOrigin());
        return rule;
    }
}

