/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSKeyframeRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.KeyframesRule;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class KeyframeRule
extends BaseCSSDeclarationRule
implements CSSKeyframeRule {
    private final KeyframesRule parentRule;
    private String keyText;

    public KeyframeRule(KeyframesRule parentRule) {
        super(parentRule.getParentStyleSheet(), (short)8, parentRule.getOrigin());
        this.parentRule = parentRule;
    }

    @Override
    public String getKeyText() {
        return this.keyText;
    }

    void setKeyText(String keyText) {
        this.keyText = keyText;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return this.getKeyText() + '{' + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri);
        wri.write(this.getKeyText());
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        context.startStyleDeclaration(wri);
        this.getStyle().writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endStyleDeclaration(wri);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int lenm1 = cssText.length() - 1;
        int endIdx = cssText.lastIndexOf(125);
        int idx = cssText.indexOf(123);
        if (idx < 2 || endIdx != lenm1 || idx == endIdx) {
            throw new DOMException(12, "Bad keyframe rule: " + cssText);
        }
        String selector = cssText.substring(0, idx).trim();
        selector = this.getParentRule().keyframeSelector(selector);
        super.setCssText(cssText);
        this.keyText = selector;
    }

    @Override
    PropertyDocumentHandler createPropertyDocumentHandler() {
        return new MyPropertyDocumentHandler();
    }

    @Override
    public KeyframesRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parentRule.getParentStyleSheet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.keyText == null ? 0 : this.keyText.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyframeRule other = (KeyframeRule)obj;
        return !(this.keyText == null ? other.keyText != null : !this.keyText.equals(other.keyText));
    }

    @Override
    public KeyframeRule clone(AbstractCSSStyleSheet parentSheet) {
        KeyframeRule rule = new KeyframeRule(this.getParentRule());
        rule.setKeyText(this.getKeyText());
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return rule;
    }

    private class MyPropertyDocumentHandler
    extends BaseCSSDeclarationRule.DeclarationRuleDocumentHandler {
        public MyPropertyDocumentHandler() {
            super(KeyframeRule.this);
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            if (important) {
                CSSPropertyValueException ex = new CSSPropertyValueException("Important declarations in a keyframe rule are not valid");
                ex.setValueText(value.toString() + " !important");
                KeyframeRule.this.getStyleDeclarationErrorHandler().wrongValue(name, ex);
            } else {
                super.property(name, value, important);
            }
        }
    }
}

