/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSKeyframeRule;
import io.sf.carte.doc.style.css.CSSKeyframesRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.KeyframeRule;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.KeyframesHandler;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class KeyframesRule
extends BaseCSSRule
implements CSSKeyframesRule {
    private String name = null;
    private final CSSRuleArrayList cssRules;

    protected KeyframesRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)7, origin);
        this.cssRules = new CSSRuleArrayList();
    }

    KeyframesRule(AbstractCSSStyleSheet parentSheet, KeyframesRule copyfrom) {
        super(parentSheet, (short)7, copyfrom.getOrigin());
        this.name = copyfrom.name;
        this.cssRules = copyfrom.cssRules;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String keyframesName) {
        this.name = keyframesName;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public void appendRule(String rule) throws DOMException {
        KeyframeRule krule = new KeyframeRule(this);
        krule.setCssText(rule);
        this.cssRules.add(krule);
    }

    @Override
    public void deleteRule(String select) {
        try {
            select = this.keyframeSelector(select);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        for (int i = this.cssRules.getLength() - 1; i >= 0; --i) {
            CSSKeyframeRule rule = (CSSKeyframeRule)this.cssRules.get(i);
            if (!rule.getKeyText().equals(select)) continue;
            this.cssRules.remove(i);
            break;
        }
    }

    @Override
    public CSSKeyframeRule findRule(String select) throws DOMException {
        try {
            select = this.keyframeSelector(select);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        for (int i = this.cssRules.getLength() - 1; i >= 0; --i) {
            CSSKeyframeRule rule = (CSSKeyframeRule)this.cssRules.get(i);
            if (!rule.getKeyText().equals(select)) continue;
            return rule;
        }
        return null;
    }

    String keyframeSelector(String rawselector) {
        LexicalUnit selunit;
        StringReader re = new StringReader(rawselector);
        InputSource source = new InputSource((Reader)re);
        Parser parser = this.createSACParser();
        try {
            selunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return KeyframesRule.keyframeSelector(selunit);
    }

    private static String keyframeSelector(LexicalUnit selunit) {
        StringBuilder buffer = new StringBuilder();
        KeyframesRule.appendSelector(buffer, selunit);
        LexicalUnit lu = selunit.getNextLexicalUnit();
        while (lu != null) {
            LexicalUnit nextlu = lu.getNextLexicalUnit();
            if (lu.getLexicalUnitType() != 0 || nextlu == null) {
                throw new DOMException(12, "Wrong keyframe selector syntax: " + selunit.toString());
            }
            buffer.append(',');
            KeyframesRule.appendSelector(buffer, nextlu);
            lu = nextlu.getNextLexicalUnit();
        }
        return buffer.toString();
    }

    private static void appendSelector(StringBuilder buffer, LexicalUnit selunit) {
        short type = selunit.getLexicalUnitType();
        if (type == 35 || type == 36) {
            buffer.append(selunit.getStringValue());
        } else if (type == 23) {
            float floatValue = selunit.getFloatValue();
            if (floatValue % 1.0f != 0.0f) {
                buffer.append(String.format(Locale.ROOT, "%s", Float.valueOf(floatValue)));
            } else {
                buffer.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(floatValue)));
            }
            buffer.append('%');
        } else if (type == 13 && selunit.getIntegerValue() == 0) {
            buffer.append('0');
        } else {
            throw new DOMException(12, "Wrong keyframe selector: " + selunit.toString());
        }
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(30 + this.getCssRules().getLength() * 24);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.name != null || !this.getCssRules().isEmpty()) {
            StringBuilder sb = new StringBuilder(30 + this.getCssRules().getLength() * 20);
            sb.append("@keyframes");
            if (this.name != null) {
                String sname = this.getName();
                if (sname.indexOf(32) == -1) {
                    sb.append(' ').append(sname);
                } else {
                    sb.append(' ').append('\'').append(sname).append('\'');
                }
            }
            sb.append('{');
            Iterator it = this.getCssRules().iterator();
            while (it.hasNext()) {
                sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
            }
            sb.append('}');
            return sb.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.name != null || !this.getCssRules().isEmpty()) {
            context.startRule(wri);
            wri.write("@keyframes ");
            if (this.name != null) {
                String sname = this.getName();
                if (sname.indexOf(32) == -1) {
                    wri.write(sname);
                } else {
                    wri.write('\'');
                    wri.write(sname);
                    wri.write('\'');
                }
            }
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            this.getCssRules().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endRuleList(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri);
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        CSSParser parser;
        int len = (cssText = cssText.trim()).length();
        if (len < 14) {
            throw new DOMException(12, "Invalid @keyframes rule: " + cssText);
        }
        CharSequence atkeyword = cssText.subSequence(0, 11);
        if (!ParseHelper.startsWithIgnoreCase(atkeyword, "@keyframes") || !Character.isWhitespace(cssText.charAt(10))) {
            throw new DOMException(13, "Not a @keyframes rule: " + cssText);
        }
        String body = cssText.substring(11, len);
        MyKeyframesHandler handler = new MyKeyframesHandler();
        try {
            parser = (CSSParser)this.createSACParser();
        }
        catch (ClassCastException e) {
            parser = new CSSParser();
        }
        parser.setDocumentHandler(handler);
        try {
            parser.parseKeyFramesBody(body);
        }
        catch (CSSParseException e) {
            throw new DOMException(5, e.getMessage());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cssRules == null ? 0 : this.cssRules.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyframesRule other = (KeyframesRule)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.cssRules == null ? other.cssRules != null : !this.cssRules.equals(other.cssRules));
    }

    @Override
    public KeyframesRule clone(AbstractCSSStyleSheet parentSheet) {
        return new KeyframesRule(parentSheet, this);
    }

    private class MyKeyframesHandler
    extends PropertyDocumentHandler
    implements KeyframesHandler {
        private String name = null;
        private final CSSRuleArrayList cssRules = new CSSRuleArrayList();
        private KeyframeRule currentRule = null;
        private LinkedList<String> comments = null;

        MyKeyframesHandler() {
        }

        @Override
        public void startKeyframes(String name) {
            this.name = name;
        }

        @Override
        public void endKeyframes() {
            KeyframesRule.this.name = this.name;
            KeyframesRule.this.cssRules.clear();
            KeyframesRule.this.cssRules.addAll(this.cssRules);
        }

        @Override
        public void startKeyframe(LexicalUnit keyframeSelector) {
            this.currentRule = new KeyframeRule(KeyframesRule.this);
            this.currentRule.setKeyText(KeyframesRule.keyframeSelector(keyframeSelector));
            this.setLexicalPropertyListener(this.currentRule.getLexicalPropertyListener());
            this.cssRules.add(this.currentRule);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (this.currentRule == null) throw new CSSException("Declaration outside of keyframe rule");
            if (important) {
                CSSPropertyValueException ex = new CSSPropertyValueException("Important declarations in a keyframe rule are not valid");
                ex.setValueText(value.toString() + " !important");
                this.currentRule.getStyleDeclarationErrorHandler().wrongValue(name, ex);
                return;
            } else {
                try {
                    super.property(name, value, important);
                    return;
                }
                catch (DOMException e) {
                    if (this.currentRule.getStyleDeclarationErrorHandler() == null) return;
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    this.currentRule.getStyleDeclarationErrorHandler().wrongValue(name, ex);
                }
            }
        }

        @Override
        public void endKeyframe() {
            this.setCommentsToRule(this.currentRule);
            this.currentRule = null;
            this.setLexicalPropertyListener(null);
        }

        @Override
        public void comment(String text) throws CSSException {
            if (this.currentRule == null) {
                if (this.comments == null) {
                    this.comments = new LinkedList();
                }
                this.comments.add(text);
            }
        }

        private void setCommentsToRule(AbstractCSSRule rule) {
            if (this.comments != null && !this.comments.isEmpty()) {
                ArrayList<String> ruleComments = new ArrayList<String>(this.comments.size());
                ruleComments.addAll(this.comments);
                rule.setPrecedingComments(ruleComments);
            }
            this.resetCommentStack();
        }

        private void resetCommentStack() {
            if (this.comments != null) {
                this.comments.clear();
            }
        }
    }
}

