/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.OrderedShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

abstract class ListOrderedShorthandBuilder
extends OrderedShorthandBuilder {
    ListOrderedShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue, String freeProperty) {
        super(shorthandName, parentStyle, initialvalue, freeProperty);
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        ValueList masterList;
        if (this.hasPropertiesToExclude(declaredSet)) {
            return false;
        }
        StyleValue masterValue = this.getCSSValue(this.freeProperty);
        if (masterValue.getCssValueType() != 2 || !(masterList = (ValueList)masterValue).isCommaSeparated()) {
            return super.appendShorthandSet(buf, declaredSet, important);
        }
        int listLen = masterList.getLength();
        if (this.checkDeclaredValueListForInherit(declaredSet, listLen)) {
            return false;
        }
        if (this.checkDeclaredValueListForKeyword("unset", declaredSet, listLen)) {
            return false;
        }
        for (String property : declaredSet) {
            StyleValue value = this.getCSSValue(property);
            short type = value.getCssValueType();
            if (!(type == 2 ? this.invalidListValueClash(declaredSet, property, (ValueList)value) : this.invalidValueClash(declaredSet, property, value))) continue;
            return false;
        }
        buf.append(this.getShorthandName()).append(':');
        for (int index = 0; index < listLen; ++index) {
            if (index != 0) {
                buf.append(',');
            }
            boolean appended = false;
            String[] subp = this.getSubproperties();
            for (int i = 0; i < subp.length; ++i) {
                String property = subp[i];
                if (!declaredSet.contains(property)) continue;
                appended = this.appendValueText(index, buf, property, appended);
            }
            if (appended) continue;
            buf.append(this.initialvalue);
        }
        this.appendPriority(buf, important);
        return true;
    }

    private boolean checkDeclaredValueListForInherit(Set<String> declaredSet, int listLen) {
        for (String propertyName : declaredSet) {
            ValueList list = this.computeCSSItemList(propertyName, listLen - 1);
            for (int i = 0; i < listLen; ++i) {
                if (!this.isInherit(list.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkDeclaredValueListForKeyword(String keyword, Set<String> declaredSet, int listLen) {
        for (String propertyName : declaredSet) {
            ValueList list = this.computeCSSItemList(propertyName, listLen - 1);
            for (int i = 0; i < listLen; ++i) {
                if (!ListOrderedShorthandBuilder.isCssKeywordValue(keyword, list.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean invalidListValueClash(Set<String> declaredSet, String property, ValueList list) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            if (!this.invalidValueClash(declaredSet, property, list.item(i))) continue;
            return true;
        }
        return false;
    }

    private boolean appendValueText(int index, StringBuilder buf, String property, boolean appended) {
        StyleValue cssVal = this.getCSSListItemValue(property, index);
        if (this.isNotInitialValue(cssVal, property) || !this.freeProperty.equals(property) && this.valueClash(index, property)) {
            if (appended) {
                buf.append(' ');
            }
            buf.append(cssVal.getMinifiedCssText(property));
            return true;
        }
        return appended;
    }

    StyleValue getCSSListItemValue(String propertyName, int index) {
        return this.computeCSSItemList(propertyName, index).item(index);
    }

    private ValueList computeCSSItemList(String propertyName, int lastIdx) {
        int items;
        ValueList list;
        StyleValue value = this.getCSSValue(propertyName);
        if (value.getCssValueType() == 2 && ((ValueList)value).isCommaSeparated()) {
            list = (ValueList)value.clone();
            items = list.getLength();
        } else {
            list = ValueList.createCSValueList();
            list.add(value);
            value = list;
            items = 1;
        }
        if (lastIdx >= items) {
            int j = 0;
            while (items++ <= lastIdx) {
                list.add(list.item(j++));
            }
        }
        return list;
    }

    boolean isConflictingIdentifier(String property, CSSPrimitiveValue freePrimi) {
        return freePrimi.getPrimitiveType() == 21 && ListOrderedShorthandBuilder.getShorthandDatabase().isIdentifierValue(property, freePrimi.getStringValue());
    }

    boolean listHasConflictingIdentifiers(String property, CSSValueList list) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            CSSValue item = list.item(i);
            short type = item.getCssValueType();
            if (type == 1) {
                if (!this.isConflictingIdentifier(property, (CSSPrimitiveValue)item)) continue;
                return true;
            }
            if (type != 2) continue;
            return this.listHasConflictingIdentifiers(property, (CSSValueList)item);
        }
        return false;
    }

    abstract boolean valueClash(int var1, String var2);
}

