/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.om.MediaPredicate;
import io.sf.carte.doc.style.css.om.MediaQuery;
import io.sf.carte.doc.style.css.parser.MediaFeaturePredicate;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RatioValue;
import java.util.Objects;
import org.w3c.dom.DOMException;

class MediaFeaturePredicateImpl
extends MediaPredicate
implements MediaFeaturePredicate {
    private ExtendedCSSPrimitiveValue value1;
    private ExtendedCSSPrimitiveValue value2;
    private byte rangeType;

    MediaFeaturePredicateImpl(String featureName) {
        super(featureName);
    }

    @Override
    public void setRangeType(byte rangeType) {
        this.rangeType = rangeType;
    }

    @Override
    public byte getRangeType() {
        return this.rangeType;
    }

    @Override
    public ExtendedCSSPrimitiveValue getValue() {
        return this.value1;
    }

    @Override
    public void setValue(ExtendedCSSPrimitiveValue value) {
        this.value1 = value;
    }

    @Override
    public ExtendedCSSPrimitiveValue getRangeSecondValue() {
        return this.value2;
    }

    @Override
    public void setRangeSecondValue(ExtendedCSSPrimitiveValue value) {
        this.value2 = value;
    }

    @Override
    public boolean matches(MediaPredicate otherPredicate, byte negatedQuery) {
        float ofval1;
        float fval1;
        if (this.getPredicateType() != otherPredicate.getPredicateType()) {
            return false;
        }
        MediaFeaturePredicateImpl other = (MediaFeaturePredicateImpl)otherPredicate;
        String feature = this.getName();
        String oFeature = other.getName();
        byte type = this.getRangeType();
        byte oType = other.getRangeType();
        if (type == 0) {
            if (feature.startsWith("min-")) {
                if ((feature = feature.substring(4)).startsWith("device-")) {
                    feature = feature.substring(7);
                }
                type = 5;
            } else if (feature.startsWith("max-")) {
                if ((feature = feature.substring(4)).startsWith("device-")) {
                    feature = feature.substring(7);
                }
                type = 3;
            } else {
                if (feature.startsWith("device-")) {
                    feature = feature.substring(7);
                }
                type = this.value1 != null ? (byte)1 : 4;
            }
        }
        if (oType == 0) {
            if (oFeature.startsWith("min-")) {
                if ((oFeature = oFeature.substring(4)).startsWith("device-")) {
                    oFeature = oFeature.substring(7);
                }
                oType = 5;
            } else if (oFeature.startsWith("max-")) {
                if ((oFeature = oFeature.substring(4)).startsWith("device-")) {
                    oFeature = oFeature.substring(7);
                }
                oType = 3;
            } else {
                if (oFeature.startsWith("device-")) {
                    oFeature = oFeature.substring(7);
                }
                oType = other.value1 != null ? (byte)1 : 4;
            }
        }
        if (!feature.equals(oFeature)) {
            return false;
        }
        if (negatedQuery == 2) {
            oType = MediaFeaturePredicateImpl.negateType(oType);
        } else if (negatedQuery == 1) {
            type = MediaFeaturePredicateImpl.negateType(type);
        }
        ExtendedCSSPrimitiveValue otherVal1 = other.value1;
        ExtendedCSSPrimitiveValue otherVal2 = other.value2;
        boolean noeq1 = false;
        boolean noeq2 = false;
        switch (type) {
            case 1: {
                if (this.value1.getPrimitiveType() != 21) break;
                if (otherVal1 != null && otherVal1.getPrimitiveType() == 21 && this.value1.getStringValue().equalsIgnoreCase(otherVal1.getStringValue())) {
                    return negatedQuery == 0 || negatedQuery == 3;
                }
                return negatedQuery == 1;
            }
            case 2: {
                if (oType == 3) {
                    oType = 2;
                    noeq1 = true;
                    break;
                }
                if (oType == 1) {
                    oType = 2;
                    noeq1 = true;
                    break;
                }
                if (oType == 36 || oType == 44) {
                    oType = 2;
                    break;
                }
                if (oType == 37 || oType == 45) {
                    oType = 2;
                    noeq1 = true;
                    break;
                }
                if (oType == 19 || oType == 18) {
                    oType = 2;
                    otherVal1 = otherVal2;
                    break;
                }
                if (oType != 27 && oType != 26) break;
                oType = 2;
                noeq1 = true;
                otherVal1 = otherVal2;
                break;
            }
            case 3: {
                if (oType == 2) {
                    type = 2;
                    break;
                }
                if (oType == 1) {
                    oType = 3;
                    break;
                }
                if (oType == 36 || oType == 44) {
                    type = 2;
                    oType = 2;
                    break;
                }
                if (oType == 37 || oType == 45) {
                    oType = 3;
                    break;
                }
                if (oType == 19 || oType == 18) {
                    type = 2;
                    oType = 2;
                    otherVal1 = otherVal2;
                    break;
                }
                if (oType != 27 && oType != 26) break;
                oType = 3;
                otherVal1 = otherVal2;
                break;
            }
            case 4: {
                if (oType == 5) {
                    oType = 4;
                    noeq1 = true;
                    break;
                }
                if (oType == 1) {
                    oType = 4;
                    noeq1 = true;
                    break;
                }
                if (oType == 18 || oType == 26) {
                    oType = 4;
                    break;
                }
                if (oType == 19 || oType == 27) {
                    oType = 4;
                    noeq1 = true;
                    break;
                }
                if (oType == 37 || oType == 36) {
                    oType = 4;
                    otherVal1 = otherVal2;
                    break;
                }
                if (oType != 45 && oType != 44) break;
                oType = 4;
                noeq1 = true;
                otherVal1 = otherVal2;
                break;
            }
            case 5: {
                if (oType == 4) {
                    type = 4;
                    break;
                }
                if (oType == 1) {
                    oType = 5;
                    break;
                }
                if (oType == 18 || oType == 26) {
                    type = 4;
                    oType = 4;
                    break;
                }
                if (oType == 19 || oType == 27) {
                    type = 4;
                    oType = 4;
                    break;
                }
                if (oType == 37 || oType == 36) {
                    type = 4;
                    oType = 4;
                    otherVal1 = otherVal2;
                    break;
                }
                if (oType != 44 && oType != 45) break;
                oType = 5;
                otherVal1 = otherVal2;
                break;
            }
            case 18: {
                if (oType == 19) {
                    oType = 18;
                    noeq1 = true;
                    break;
                }
                if (oType == 26) {
                    oType = 18;
                    noeq2 = true;
                    break;
                }
                if (oType == 27) {
                    oType = 18;
                    noeq1 = true;
                    noeq2 = true;
                    break;
                }
                if (oType != 1) break;
                oType = 18;
                noeq1 = true;
                noeq2 = true;
                otherVal2 = otherVal1;
                break;
            }
            case 19: {
                if (oType == 18) {
                    type = 18;
                    break;
                }
                if (oType == 27) {
                    oType = 19;
                    noeq2 = true;
                    break;
                }
                if (oType == 26) {
                    type = 18;
                    oType = 18;
                    noeq2 = true;
                    break;
                }
                if (oType != 1) break;
                oType = 19;
                noeq2 = true;
                otherVal2 = otherVal1;
                break;
            }
            case 26: {
                if (oType == 18) {
                    type = 18;
                    break;
                }
                if (oType == 27) {
                    oType = 26;
                    noeq1 = true;
                    break;
                }
                if (oType == 19) {
                    type = 18;
                    oType = 18;
                    noeq1 = true;
                    break;
                }
                if (oType != 1) break;
                oType = 26;
                noeq1 = true;
                otherVal2 = otherVal1;
                break;
            }
            case 27: {
                if (oType == 18) {
                    type = 18;
                    break;
                }
                if (oType == 26) {
                    type = 26;
                    break;
                }
                if (oType == 19) {
                    type = 19;
                    break;
                }
                if (oType != 1) break;
                oType = 27;
                otherVal2 = otherVal1;
                break;
            }
            case 36: {
                if (oType == 37) {
                    oType = 36;
                    noeq1 = true;
                    break;
                }
                if (oType == 44) {
                    oType = 36;
                    noeq2 = true;
                    break;
                }
                if (oType == 45) {
                    oType = 36;
                    noeq1 = true;
                    noeq2 = true;
                    break;
                }
                if (oType != 1) break;
                oType = 36;
                noeq1 = true;
                noeq2 = true;
                otherVal2 = otherVal1;
                break;
            }
            case 37: {
                if (oType == 36) {
                    type = 36;
                    break;
                }
                if (oType == 45) {
                    oType = 37;
                    noeq2 = true;
                    break;
                }
                if (oType == 44) {
                    type = 36;
                    oType = 36;
                    noeq2 = true;
                    break;
                }
                if (oType != 1) break;
                oType = 37;
                noeq2 = true;
                otherVal2 = otherVal1;
                break;
            }
            case 44: {
                if (oType == 36) {
                    type = 36;
                    break;
                }
                if (oType == 45) {
                    oType = 44;
                    noeq1 = true;
                    break;
                }
                if (oType == 37) {
                    type = 36;
                    oType = 36;
                    noeq1 = true;
                    break;
                }
                if (oType != 1) break;
                oType = 44;
                noeq1 = true;
                otherVal2 = otherVal1;
                break;
            }
            case 45: {
                if (oType == 36) {
                    type = 36;
                    break;
                }
                if (oType == 44) {
                    type = 44;
                    break;
                }
                if (oType == 37) {
                    type = 37;
                    break;
                }
                if (oType != 1) break;
                oType = 45;
                otherVal2 = otherVal1;
            }
        }
        if (type != oType) {
            return false;
        }
        float denom = 1.0f;
        boolean isRatio = false;
        short pType = 1;
        if (this.value1 == null) {
            if (otherVal1 == null) {
                boolean negated = negatedQuery == 1 || negatedQuery == 2;
                return !negated;
            }
            fval1 = 0.0f;
        } else {
            pType = this.value1.getPrimitiveType();
            if (pType != 135) {
                fval1 = this.value1.getFloatValue(pType);
            } else {
                RatioValue ratio = (RatioValue)this.value1;
                PrimitiveValue ante = ratio.getAntecedentValue();
                pType = ante.getPrimitiveType();
                try {
                    fval1 = ante.getFloatValue(pType);
                    denom = ratio.getConsequentValue().getFloatValue(pType);
                }
                catch (DOMException e) {
                    return false;
                }
                isRatio = true;
            }
        }
        if (otherVal1 == null) {
            ofval1 = 0.0f;
        } else {
            if (otherVal1.getPrimitiveType() == 135) {
                float odenom;
                RatioValue ratio = (RatioValue)otherVal1;
                PrimitiveValue ante = ratio.getAntecedentValue();
                try {
                    ofval1 = ante.getFloatValue(pType);
                    odenom = ratio.getConsequentValue().getFloatValue(pType);
                }
                catch (DOMException e) {
                    return false;
                }
                fval1 *= odenom;
            } else {
                try {
                    ofval1 = otherVal1.getFloatValue(pType);
                }
                catch (DOMException e) {
                    return false;
                }
            }
            if (isRatio) {
                ofval1 *= denom;
            }
        }
        float fval2 = Float.NaN;
        float ofval2 = Float.NaN;
        if (this.value2 != null) {
            if (otherVal2 == null) {
                return false;
            }
            boolean isRatio2 = false;
            pType = this.value2.getPrimitiveType();
            if (pType != 135) {
                try {
                    fval2 = this.value2.getFloatValue(pType);
                }
                catch (DOMException e) {
                    return false;
                }
            }
            RatioValue ratio = (RatioValue)this.value2;
            PrimitiveValue ante = ratio.getAntecedentValue();
            pType = ante.getPrimitiveType();
            try {
                fval2 = ante.getFloatValue(pType);
                denom = ratio.getConsequentValue().getFloatValue(pType);
            }
            catch (DOMException e) {
                return false;
            }
            isRatio2 = true;
            if (otherVal2.getPrimitiveType() == 135) {
                float odenom;
                ratio = (RatioValue)otherVal2;
                ante = ratio.getAntecedentValue();
                try {
                    ofval2 = ante.getFloatValue(pType);
                    odenom = ratio.getConsequentValue().getFloatValue(pType);
                }
                catch (DOMException e) {
                    return false;
                }
                fval2 *= odenom;
            } else {
                try {
                    ofval2 = otherVal2.getFloatValue(pType);
                }
                catch (DOMException e) {
                    return false;
                }
            }
            if (isRatio2) {
                ofval2 *= denom;
            }
        }
        switch (type) {
            case 1: {
                boolean negated;
                boolean bl = negated = negatedQuery == 1 || negatedQuery == 2;
                if (MediaQuery.floatEquals(fval1, ofval1)) {
                    return !negated;
                }
                return negated;
            }
            case 2: 
            case 3: {
                return noeq1 ? fval1 > ofval1 : fval1 >= ofval1;
            }
            case 4: 
            case 5: {
                return noeq1 ? fval1 < ofval1 : fval1 <= ofval1;
            }
            case 18: 
            case 19: 
            case 26: 
            case 27: {
                boolean first;
                boolean bl = noeq1 ? fval1 < ofval1 : (first = fval1 <= ofval1);
                boolean second = noeq2 ? ofval2 < fval2 : ofval2 <= fval2;
                return first && second;
            }
            case 36: 
            case 37: 
            case 44: 
            case 45: {
                boolean first;
                boolean bl = noeq1 ? fval1 > ofval1 : (first = fval1 >= ofval1);
                boolean second = noeq2 ? ofval2 > fval2 : ofval2 >= fval2;
                return first && second;
            }
        }
        return false;
    }

    private static byte negateType(byte type) {
        switch (type) {
            case 2: {
                type = (byte)5;
                break;
            }
            case 3: {
                type = (byte)4;
                break;
            }
            case 4: {
                type = (byte)3;
                break;
            }
            case 5: {
                type = (byte)2;
                break;
            }
            case 27: {
                type = (byte)36;
                break;
            }
            case 19: {
                type = (byte)44;
                break;
            }
            case 26: {
                type = (byte)37;
                break;
            }
            case 18: {
                type = (byte)45;
                break;
            }
            case 45: {
                type = (byte)18;
                break;
            }
            case 37: {
                type = (byte)26;
                break;
            }
            case 44: {
                type = (byte)19;
                break;
            }
            case 36: {
                type = (byte)27;
            }
        }
        return type;
    }

    @Override
    public void appendText(StringBuilder buf) {
        buf.append('(');
        switch (this.rangeType) {
            case 0: 
            case 1: {
                this.appendFeatureName(buf);
                if (this.value1 == null) break;
                buf.append(": ");
                buf.append(this.value1.getCssText());
                break;
            }
            case 2: {
                this.appendFeatureName(buf);
                buf.append(" < ");
                buf.append(this.value1.getCssText());
                break;
            }
            case 3: {
                this.appendFeatureName(buf);
                buf.append(" <= ");
                buf.append(this.value1.getCssText());
                break;
            }
            case 4: {
                this.appendFeatureName(buf);
                buf.append(" > ");
                buf.append(this.value1.getCssText());
                break;
            }
            case 5: {
                this.appendFeatureName(buf);
                buf.append(" >= ");
                buf.append(this.value1.getCssText());
                break;
            }
            case 26: {
                buf.append(this.value1.getCssText());
                buf.append(" < ");
                this.appendFeatureName(buf);
                buf.append(" <= ");
                buf.append(this.value2.getCssText());
                break;
            }
            case 18: {
                buf.append(this.value1.getCssText());
                buf.append(" < ");
                this.appendFeatureName(buf);
                buf.append(" < ");
                buf.append(this.value2.getCssText());
                break;
            }
            case 19: {
                buf.append(this.value1.getCssText());
                buf.append(" <= ");
                this.appendFeatureName(buf);
                buf.append(" < ");
                buf.append(this.value2.getCssText());
                break;
            }
            case 27: {
                buf.append(this.value1.getCssText());
                buf.append(" <= ");
                this.appendFeatureName(buf);
                buf.append(" <= ");
                buf.append(this.value2.getCssText());
                break;
            }
            case 36: {
                buf.append(this.value1.getCssText());
                buf.append(" > ");
                this.appendFeatureName(buf);
                buf.append(" > ");
                buf.append(this.value2.getCssText());
                break;
            }
            case 37: {
                buf.append(this.value1.getCssText());
                buf.append(" >= ");
                this.appendFeatureName(buf);
                buf.append(" > ");
                buf.append(this.value2.getCssText());
                break;
            }
            case 44: {
                buf.append(this.value1.getCssText());
                buf.append(" > ");
                this.appendFeatureName(buf);
                buf.append(" >= ");
                buf.append(this.value2.getCssText());
                break;
            }
            case 45: {
                buf.append(this.value1.getCssText());
                buf.append(" >= ");
                this.appendFeatureName(buf);
                buf.append(" >= ");
                buf.append(this.value2.getCssText());
            }
        }
        buf.append(')');
    }

    @Override
    public void appendMinifiedText(StringBuilder buf) {
        buf.append('(');
        switch (this.rangeType) {
            case 0: 
            case 1: {
                this.appendFeatureName(buf);
                if (this.value1 == null) break;
                buf.append(':');
                buf.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 2: {
                this.appendFeatureName(buf);
                buf.append('<');
                buf.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 3: {
                this.appendFeatureName(buf);
                buf.append("<=");
                buf.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 4: {
                this.appendFeatureName(buf);
                buf.append('>');
                buf.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 5: {
                this.appendFeatureName(buf);
                buf.append(">=");
                buf.append(this.value1.getMinifiedCssText(""));
                break;
            }
            case 26: {
                buf.append(this.value1.getMinifiedCssText(""));
                buf.append('<');
                this.appendFeatureName(buf);
                buf.append("<=");
                buf.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 18: {
                buf.append(this.value1.getMinifiedCssText(""));
                buf.append('<');
                this.appendFeatureName(buf);
                buf.append('<');
                buf.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 19: {
                buf.append(this.value1.getMinifiedCssText(""));
                buf.append("<=");
                this.appendFeatureName(buf);
                buf.append('<');
                buf.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 27: {
                buf.append(this.value1.getMinifiedCssText(""));
                buf.append("<=");
                this.appendFeatureName(buf);
                buf.append("<=");
                buf.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 36: {
                buf.append(this.value1.getMinifiedCssText(""));
                buf.append('>');
                this.appendFeatureName(buf);
                buf.append('>');
                buf.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 37: {
                buf.append(this.value1.getMinifiedCssText(""));
                buf.append(">=");
                this.appendFeatureName(buf);
                buf.append('>');
                buf.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 44: {
                buf.append(this.value1.getMinifiedCssText(""));
                buf.append('>');
                this.appendFeatureName(buf);
                buf.append(">=");
                buf.append(this.value2.getMinifiedCssText(""));
                break;
            }
            case 45: {
                buf.append(this.value1.getMinifiedCssText(""));
                buf.append(">=");
                this.appendFeatureName(buf);
                buf.append(">=");
                buf.append(this.value2.getMinifiedCssText(""));
            }
        }
        buf.append(')');
    }

    private void appendFeatureName(StringBuilder buf) {
        buf.append(ParseHelper.escape(this.getName()));
    }

    @Override
    public int hashCode() {
        byte efftype = this.rangeType == 0 ? (byte)1 : this.rangeType;
        return 17 + 31 * Objects.hash(this.getName(), efftype, this.value1, this.value2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaFeaturePredicateImpl other = (MediaFeaturePredicateImpl)obj;
        byte efftype = this.rangeType == 0 ? (byte)1 : this.rangeType;
        byte otherefftype = other.rangeType == 0 ? (byte)1 : other.rangeType;
        return Objects.equals(this.getName(), other.getName()) && efftype == otherefftype && Objects.equals(this.value1, other.value1) && Objects.equals(this.value2, other.value2);
    }
}

