/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.om.BooleanConditionImpl;
import io.sf.carte.doc.style.css.om.MediaPredicate;
import io.sf.carte.doc.style.css.parser.BooleanCondition;
import io.sf.carte.doc.style.css.parser.MediaFeaturePredicate;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CalcValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RatioValue;
import java.util.Collections;
import java.util.HashSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

class MediaQuery {
    public static final byte FEATURE_PLAIN = 0;
    public static final byte FEATURE_EQ = 1;
    public static final byte FEATURE_LT = 2;
    public static final byte FEATURE_LE = 3;
    public static final byte FEATURE_GT = 4;
    public static final byte FEATURE_GE = 5;
    public static final byte FEATURE_LT_AND_LT = 18;
    public static final byte FEATURE_LT_AND_LE = 26;
    public static final byte FEATURE_LE_AND_LE = 27;
    public static final byte FEATURE_LE_AND_LT = 19;
    public static final byte FEATURE_GT_AND_GT = 36;
    public static final byte FEATURE_GE_AND_GT = 37;
    public static final byte FEATURE_GT_AND_GE = 44;
    public static final byte FEATURE_GE_AND_GE = 45;
    private static final HashSet<String> rangeFeatureSet;
    private String mediaType = null;
    private boolean negativeQuery = false;
    private boolean onlyPrefix = false;
    private BooleanCondition predicate = null;

    void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public BooleanCondition getCondition() {
        return this.predicate;
    }

    void setFeaturePredicate(BooleanCondition predicate) {
        this.predicate = predicate;
    }

    public boolean isNegative() {
        return this.negativeQuery;
    }

    void setNegative(boolean negative) {
        this.negativeQuery = negative;
    }

    void setOnlyPrefix(boolean only) {
        this.onlyPrefix = only;
    }

    public boolean matches(String medium, CSSCanvas canvas) {
        if (this.mediaType != null && (this.mediaType.equals(medium) ? this.negativeQuery : !this.negativeQuery)) {
            return false;
        }
        if (this.predicate != null) {
            if (canvas == null) {
                return false;
            }
            return MediaQuery.matchesCondition(this.predicate, canvas);
        }
        return true;
    }

    private static boolean matchesCondition(BooleanCondition condition, CSSCanvas canvas) {
        switch (condition.getType()) {
            case AND: {
                for (BooleanCondition subcond : condition.getSubConditions()) {
                    if (MediaQuery.matchesCondition(subcond, canvas)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                return !MediaQuery.matchesCondition(condition.getNestedCondition(), canvas);
            }
            case OR: {
                for (BooleanCondition subcond : condition.getSubConditions()) {
                    if (!MediaQuery.matchesCondition(subcond, canvas)) continue;
                    return true;
                }
                break;
            }
            default: {
                if (((BooleanConditionImpl.Predicate)condition).getPredicateType() == 0) {
                    return MediaQuery.matchesPredicate((MediaFeaturePredicate)condition, canvas);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean matchesPredicate(MediaFeaturePredicate predicate, CSSCanvas canvas) {
        String feature = predicate.getName();
        ExtendedCSSPrimitiveValue value = predicate.getValue();
        predicate.getRangeSecondValue();
        byte type = predicate.getRangeType();
        if (type == 0 && value == null) {
            return MediaQuery.featureBooleanMatch(feature, canvas);
        }
        if (type == 0) {
            if (feature.startsWith("min-")) {
                if ((feature = feature.substring(4)).startsWith("device-")) {
                    feature = feature.substring(7);
                }
                if (MediaQuery.featureRangeMatch(feature, (byte)5, value, null, canvas)) {
                    return true;
                }
            } else if (feature.startsWith("max-")) {
                if ((feature = feature.substring(4)).startsWith("device-")) {
                    feature = feature.substring(7);
                }
                if (MediaQuery.featureRangeMatch(feature, (byte)3, value, null, canvas)) {
                    return true;
                }
            } else {
                if (feature.startsWith("device-")) {
                    feature = feature.substring(7);
                }
                if (!MediaQuery.isRangeFeature(feature) ? canvas.matchesFeature(feature, value) : MediaQuery.featureRangeMatch(feature, (byte)1, value, null, canvas)) {
                    return true;
                }
            }
        } else if (MediaQuery.featureRangeMatch(feature, type, value, predicate.getRangeSecondValue(), canvas)) {
            return true;
        }
        return false;
    }

    private static boolean featureBooleanMatch(String feature, CSSCanvas canvas) {
        if (MediaQuery.isRangeFeature(feature)) {
            ExtendedCSSPrimitiveValue featured = canvas.getFeatureValue(feature);
            return !featured.isNumberZero();
        }
        return canvas.matchesFeature(feature, null);
    }

    private static boolean featureRangeMatch(String feature, byte type, CSSPrimitiveValue value, CSSPrimitiveValue value2, CSSCanvas canvas) {
        float fval1;
        ExtendedCSSPrimitiveValue featured = canvas.getFeatureValue(feature);
        if (featured == null) {
            return false;
        }
        short primitype = featured.getPrimitiveType();
        float featureValue = featured.getFloatValue(primitype);
        float fval2 = 0.0f;
        try {
            fval1 = MediaQuery.valueInUnit(value, canvas, primitype);
        }
        catch (DOMException e) {
            return false;
        }
        if (type >= 6) {
            if (value2 == null) {
                return false;
            }
            try {
                fval2 = MediaQuery.valueInUnit(value2, canvas, primitype);
            }
            catch (DOMException e) {
                return false;
            }
        }
        switch (type) {
            case 1: {
                return MediaQuery.floatEquals(fval1, featureValue);
            }
            case 2: {
                return fval1 > featureValue;
            }
            case 3: {
                return fval1 >= featureValue;
            }
            case 4: {
                return fval1 < featureValue;
            }
            case 5: {
                return fval1 <= featureValue;
            }
            case 18: {
                return fval1 < featureValue && featureValue < fval2;
            }
            case 19: {
                return fval1 <= featureValue && featureValue < fval2;
            }
            case 26: {
                return fval1 < featureValue && featureValue <= fval2;
            }
            case 27: {
                return fval1 <= featureValue && featureValue <= fval2;
            }
            case 36: {
                return fval1 > featureValue && featureValue > fval2;
            }
            case 37: {
                return fval1 >= featureValue && featureValue > fval2;
            }
            case 44: {
                return fval1 > featureValue && featureValue >= fval2;
            }
            case 45: {
                return fval1 >= featureValue && featureValue >= fval2;
            }
        }
        return false;
    }

    private static float valueInUnit(CSSPrimitiveValue value, CSSCanvas canvas, short primitype) throws DOMException {
        float fval;
        switch (value.getPrimitiveType()) {
            case 3: {
                fval = value.getFloatValue((short)3);
                StyleDatabase sdb = canvas.getStyleDatabase();
                float fontSize = sdb.getFontSizeFromIdentifier(null, "medium");
                fontSize = NumberValue.floatValueConversion(fontSize, sdb.getNaturalUnit(), primitype);
                fval *= fontSize;
                break;
            }
            case 4: {
                fval = value.getFloatValue((short)4);
                StyleDatabase sdb = canvas.getStyleDatabase();
                float fontSize = sdb.getFontSizeFromIdentifier(null, "medium");
                float exSize = sdb.getExSizeInPt(null, fontSize);
                exSize = NumberValue.floatValueConversion(exSize, (short)9, primitype);
                fval *= exSize;
                break;
            }
            case 101: {
                ExpressionValue evalue = (ExpressionValue)value;
                MQEvaluator ev = new MQEvaluator(canvas);
                fval = ev.evaluateExpression(evalue).getFloatValue(primitype);
                break;
            }
            case 135: {
                float fsecond;
                MQEvaluator ev;
                float ffirst;
                RatioValue ratio = (RatioValue)value;
                PrimitiveValue first = ratio.getAntecedentValue();
                PrimitiveValue second = ratio.getConsequentValue();
                if (first.getPrimitiveType() == 1) {
                    ffirst = first.getFloatValue((short)1);
                } else {
                    ev = new MQEvaluator(canvas);
                    ffirst = ev.evaluateExpression((CalcValue)first).getFloatValue((short)1);
                }
                if (second.getPrimitiveType() == 1) {
                    fsecond = second.getFloatValue((short)1);
                } else {
                    ev = new MQEvaluator(canvas);
                    fsecond = ev.evaluateExpression((CalcValue)second).getFloatValue((short)1);
                }
                fval = ffirst / fsecond;
                break;
            }
            default: {
                fval = value.getFloatValue(primitype);
            }
        }
        return fval;
    }

    static boolean floatEquals(float value1, float value2) {
        return (double)Math.abs(value2 - value1) < 7.0E-6;
    }

    private static boolean isRangeFeature(String string) {
        return rangeFeatureSet.contains(string);
    }

    boolean matches(MediaQuery other) {
        boolean isAllMedium;
        if (other.isNotAllMedia()) {
            return false;
        }
        boolean bl = isAllMedium = this.mediaType == null || "all".equals(this.mediaType);
        if (this.negativeQuery ? (isAllMedium ? this.predicate == null : (this.mediaType.equals(other.mediaType) ? !other.negativeQuery : other.negativeQuery)) : !isAllMedium && (other.negativeQuery || !this.mediaType.equals(other.mediaType))) {
            return false;
        }
        if (this.predicate == null) {
            return true;
        }
        if (other.predicate == null) {
            return false;
        }
        byte negatedQuery = this.negativeQuery ? (!other.negativeQuery ? (byte)1 : 0) : (other.negativeQuery ? (byte)2 : 0);
        return MediaQuery.matches(this.predicate, other.predicate, negatedQuery) != 0;
    }

    private static byte matches(BooleanCondition condition, BooleanCondition otherCondition, byte negatedQuery) {
        switch (condition.getType()) {
            case AND: {
                for (BooleanCondition subcond : condition.getSubConditions()) {
                    if (MediaQuery.matches(subcond, otherCondition, negatedQuery) != 0) continue;
                    return 0;
                }
                return 1;
            }
            case OR: {
                for (BooleanCondition subcond : condition.getSubConditions()) {
                    if (MediaQuery.matches(subcond, otherCondition, negatedQuery) != 1) continue;
                    return 1;
                }
                break;
            }
            case PREDICATE: {
                MediaPredicate predicate = (MediaPredicate)condition;
                if (predicate.getPredicateType() == 1) {
                    return 2;
                }
                switch (otherCondition.getType()) {
                    case PREDICATE: {
                        MediaPredicate otherPredicate = (MediaPredicate)otherCondition;
                        if (otherPredicate.getPredicateType() == 1) {
                            return 2;
                        }
                        if (predicate.matches(otherPredicate, negatedQuery)) {
                            return 1;
                        }
                        return 0;
                    }
                    case AND: {
                        for (BooleanCondition subcond : otherCondition.getSubConditions()) {
                            if (MediaQuery.matches(condition, subcond, negatedQuery) != 1) continue;
                            return 1;
                        }
                        break;
                    }
                    case OR: {
                        for (BooleanCondition subcond : otherCondition.getSubConditions()) {
                            if (MediaQuery.matches(condition, subcond, negatedQuery) != 0) continue;
                            return 0;
                        }
                        return 1;
                    }
                    case NOT: {
                        negatedQuery = negatedQuery == 0 ? (byte)2 : (negatedQuery == 1 ? (byte)3 : (negatedQuery == 2 ? (byte)0 : 1));
                        return MediaQuery.matches(condition, otherCondition.getNestedCondition(), negatedQuery);
                    }
                }
                break;
            }
            case NOT: {
                negatedQuery = negatedQuery == 0 ? (byte)1 : (negatedQuery == 1 ? (byte)0 : (negatedQuery == 2 ? (byte)3 : (byte)2));
                return MediaQuery.matches(condition.getNestedCondition(), otherCondition, negatedQuery);
            }
        }
        return 0;
    }

    boolean isAllMedia() {
        return (this.mediaType == null || "all".equalsIgnoreCase(this.mediaType)) && !this.negativeQuery && this.predicate == null;
    }

    boolean isNotAllMedia() {
        return this.mediaType != null && "all".equalsIgnoreCase(this.mediaType) && this.negativeQuery && this.predicate == null;
    }

    public String getMedia() {
        StringBuilder buf = new StringBuilder(32);
        if (this.negativeQuery) {
            buf.append("not ");
        } else if (this.onlyPrefix) {
            buf.append("only ");
        }
        if (this.predicate != null) {
            this.predicate.appendText(buf);
        } else if (this.mediaType != null) {
            buf.append(MediaQuery.escapeIdentifier(this.mediaType));
        }
        return buf.toString();
    }

    public String getMinifiedMedia() {
        StringBuilder buf = new StringBuilder(32);
        if (this.negativeQuery) {
            buf.append("not ");
        } else if (this.onlyPrefix) {
            buf.append("only ");
        }
        if (this.predicate != null) {
            this.predicate.appendMinifiedText(buf);
        } else if (this.mediaType != null) {
            buf.append(MediaQuery.escapeIdentifier(this.mediaType));
        }
        return buf.toString();
    }

    static String escapeIdentifier(String medium) {
        return ParseHelper.escape(medium);
    }

    public String toString() {
        return this.getMedia();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = 31 * result + (this.negativeQuery ? 1231 : 1237);
        result = 31 * result + (this.onlyPrefix ? 1231 : 1237);
        if (this.predicate != null) {
            result = 31 * result + this.predicate.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaQuery other = (MediaQuery)obj;
        if (this.mediaType == null ? other.mediaType != null : !this.mediaType.equals(other.mediaType)) {
            return false;
        }
        if (this.negativeQuery != other.negativeQuery) {
            return false;
        }
        if (this.onlyPrefix != other.onlyPrefix) {
            return false;
        }
        if (this.predicate == null) {
            if (other.predicate != null) {
                return false;
            }
        } else {
            if (other.predicate == null) {
                return false;
            }
            if (!this.predicate.equals(other.predicate)) {
                return false;
            }
        }
        return true;
    }

    static {
        String[] rangeFeatures = new String[]{"aspect-ratio", "color", "color-index", "height", "monochrome", "resolution", "width"};
        rangeFeatureSet = new HashSet(rangeFeatures.length);
        Collections.addAll(rangeFeatureSet, rangeFeatures);
    }

    private static class MQEvaluator
    extends Evaluator {
        private final CSSCanvas canvas;
        private final short expectedUnit;

        private MQEvaluator(CSSCanvas canvas) {
            this.canvas = canvas;
            this.expectedUnit = canvas.getStyleDatabase().getNaturalUnit();
        }

        @Override
        protected ExtendedCSSPrimitiveValue absoluteValue(ExtendedCSSPrimitiveValue partialValue) {
            if (partialValue.getPrimitiveType() != 1) {
                float fval = MediaQuery.valueInUnit(partialValue, this.canvas, this.expectedUnit);
                NumberValue number = new NumberValue();
                number.setFloatValue(this.expectedUnit, fval);
                return number;
            }
            return partialValue;
        }
    }
}

