/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.MediaQueryListListener;
import io.sf.carte.doc.style.css.om.MediaConditionFactoryImpl;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaQuery;
import io.sf.carte.doc.style.css.parser.BooleanCondition;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.MediaQueryHandler;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.css.sac.CSSParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class MediaQueryListImpl
implements MediaQueryList,
MediaListAccess {
    private final LinkedList<MediaQuery> queryList = new LinkedList();
    private LinkedList<CSSParseException> queryErrorList = null;
    boolean invalidQueryList = false;

    MediaQueryListImpl() {
    }

    @Override
    public String getMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder buf = new StringBuilder();
        Iterator it = this.queryList.iterator();
        buf.append(((MediaQuery)it.next()).getMedia());
        while (it.hasNext()) {
            buf.append(',').append(((MediaQuery)it.next()).getMedia());
        }
        return buf.toString();
    }

    @Override
    public String getMinifiedMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder buf = new StringBuilder();
        Iterator it = this.queryList.iterator();
        buf.append(((MediaQuery)it.next()).getMinifiedMedia());
        while (it.hasNext()) {
            buf.append(',').append(((MediaQuery)it.next()).getMinifiedMedia());
        }
        return buf.toString();
    }

    @Override
    public String getMediaText() {
        return this.getMedia();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        this.queryList.clear();
        if (!this.parse(mediaText, null)) {
            throw new DOMException(12, "Bad media query: " + mediaText);
        }
    }

    @Override
    public int getLength() {
        int sz = this.queryList.size();
        if (sz == 0 && this.invalidQueryList) {
            return 1;
        }
        return sz;
    }

    @Override
    public String item(int index) {
        int sz = this.queryList.size();
        if (sz == 0 && this.invalidQueryList && index == 0) {
            return "not all";
        }
        if (index < 0 || index >= sz) {
            return null;
        }
        return this.queryList.get(index).getMedia();
    }

    public MediaQuery getMediaQuery(int index) {
        int sz = this.queryList.size();
        if (index < 0 || index >= sz || this.invalidQueryList) {
            return null;
        }
        return this.queryList.get(index);
    }

    @Override
    public MediaQueryList unmodifiable() {
        return new UnmodifiableMediaQueryList();
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        if (!this.parse(newMedium, null)) {
            throw new DOMException(12, "Bad media query: " + newMedium);
        }
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        throw new DOMException(9, "Delete operation not supported");
    }

    @Override
    public boolean matches(String medium, CSSCanvas canvas) {
        Iterator it = this.queryList.iterator();
        while (it.hasNext()) {
            if (!((MediaQuery)it.next()).matches(medium, canvas)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(MediaQueryList otherMedia) {
        MediaQueryListImpl otherqlist;
        if (otherMedia == null) {
            return !this.isNotAllMedia();
        }
        if (otherMedia.isNotAllMedia()) {
            return false;
        }
        if (this.isAllMedia()) {
            return true;
        }
        if (otherMedia.isAllMedia()) {
            return false;
        }
        if (otherMedia.getClass() == MediaQueryListImpl.class) {
            otherqlist = (MediaQueryListImpl)otherMedia;
        } else if (otherMedia.getClass() == UnmodifiableMediaQueryList.class) {
            otherqlist = ((UnmodifiableMediaQueryList)otherMedia).getEnclosingInstance();
        } else {
            return this.oldMatch(otherMedia);
        }
        HashSet<MediaQuery> otherList = new HashSet<MediaQuery>(otherqlist.queryList.size());
        otherList.addAll(otherqlist.queryList);
        for (MediaQuery query : this.queryList) {
            Iterator otherIt = otherList.iterator();
            while (otherIt.hasNext()) {
                MediaQuery othermq = (MediaQuery)otherIt.next();
                if (!query.matches(othermq)) continue;
                otherIt.remove();
            }
            if (!otherList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean oldMatch(MediaQueryList otherMedia) {
        int sz = this.getLength();
        HashSet<String> mediastringList = new HashSet<String>(sz);
        for (int i = 0; i < sz; ++i) {
            String item = this.item(i).toLowerCase(Locale.ROOT);
            mediastringList.add(item);
        }
        int osz = otherMedia.getLength();
        for (int i = 0; i < osz; ++i) {
            String item = otherMedia.item(i).toLowerCase(Locale.ROOT);
            if (!mediastringList.contains(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(MediaQueryListListener listener) throws DOMException {
        throw new DOMException(9, "You should use CSSCanvas for this");
    }

    @Override
    public void removeListener(MediaQueryListListener listener) throws DOMException {
        throw new DOMException(9, "You should use CSSCanvas for this");
    }

    @Override
    public boolean isAllMedia() {
        return this.queryList.isEmpty() && !this.invalidQueryList;
    }

    @Override
    public boolean isNotAllMedia() {
        return this.invalidQueryList || this.queryList.size() == 1 && this.queryList.get(0).isNotAllMedia();
    }

    @Override
    public boolean hasErrors() {
        return this.invalidQueryList || this.queryErrorList != null;
    }

    public LinkedList<CSSParseException> getExceptions() {
        return this.queryErrorList;
    }

    public int hashCode() {
        int result = 1;
        if (this.queryList != null) {
            for (MediaQuery mq : this.queryList) {
                result += mq.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        MediaQueryListImpl other;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == UnmodifiableMediaQueryList.class) {
            other = ((UnmodifiableMediaQueryList)obj).getEnclosingInstance();
        } else if (obj instanceof MediaQueryListImpl) {
            other = (MediaQueryListImpl)obj;
        } else {
            return false;
        }
        return !(this.queryList == null ? other.queryList != null : this.queryList.size() != other.queryList.size() || !this.queryList.containsAll(other.queryList));
    }

    public String toString() {
        return this.getMedia();
    }

    boolean parse(String mediaQueryString, Node owner) {
        CSSParser parser = new CSSParser();
        return this.parse(parser, mediaQueryString, owner);
    }

    boolean parse(CSSParser parser, String mediaQueryString, Node owner) {
        this.invalidQueryList = false;
        MyMediaQueryHandler qhandler = new MyMediaQueryHandler(owner);
        parser.parseMediaQuery(mediaQueryString, new MediaConditionFactoryImpl(), qhandler);
        if (qhandler.allMedia) {
            this.queryList.clear();
        }
        return !this.invalidQueryList;
    }

    private class UnmodifiableMediaQueryList
    implements MediaQueryList,
    MediaListAccess {
        UnmodifiableMediaQueryList() {
        }

        @Override
        public String getMedia() {
            return MediaQueryListImpl.this.getMedia();
        }

        @Override
        public String getMinifiedMedia() {
            return MediaQueryListImpl.this.getMinifiedMedia();
        }

        @Override
        public String getMediaText() {
            return this.getMedia();
        }

        @Override
        public int getLength() {
            return MediaQueryListImpl.this.getLength();
        }

        @Override
        public String item(int index) {
            return MediaQueryListImpl.this.item(index);
        }

        @Override
        public boolean isAllMedia() {
            return MediaQueryListImpl.this.isAllMedia();
        }

        @Override
        public boolean isNotAllMedia() {
            return MediaQueryListImpl.this.isNotAllMedia();
        }

        @Override
        public boolean matches(MediaQueryList otherMedia) {
            return MediaQueryListImpl.this.matches(otherMedia);
        }

        @Override
        public boolean matches(String medium, CSSCanvas canvas) {
            return MediaQueryListImpl.this.matches(medium, canvas);
        }

        @Override
        public MediaQueryList unmodifiable() {
            return this;
        }

        @Override
        public boolean hasErrors() {
            return MediaQueryListImpl.this.hasErrors();
        }

        public LinkedList<CSSParseException> getExceptions() {
            return MediaQueryListImpl.this.getExceptions();
        }

        @Override
        public void addListener(MediaQueryListListener listener) {
            MediaQueryListImpl.this.addListener(listener);
        }

        @Override
        public void removeListener(MediaQueryListListener listener) {
            MediaQueryListImpl.this.removeListener(listener);
        }

        public int hashCode() {
            return MediaQueryListImpl.this.hashCode();
        }

        public boolean equals(Object obj) {
            return MediaQueryListImpl.this.equals(obj);
        }

        public String toString() {
            return this.getMedia();
        }

        @Override
        public void setMediaText(String mediaText) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        @Override
        public void appendMedium(String newMedium) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        @Override
        public void deleteMedium(String oldMedium) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        private MediaQueryListImpl getEnclosingInstance() {
            return MediaQueryListImpl.this;
        }
    }

    class MyMediaQueryHandler
    implements MediaQueryHandler {
        private MediaQuery currentQuery;
        private boolean invalidQuery = false;
        private boolean compatQuery = false;
        private boolean allMedia = false;
        private final Node ownerNode;

        MyMediaQueryHandler(Node ownerNode) {
            this.ownerNode = ownerNode;
        }

        @Override
        public void startQuery() {
            this.currentQuery = new MediaQuery();
        }

        @Override
        public void mediaType(String mediaType) {
            String unescaped;
            try {
                unescaped = ParseHelper.unescapeStringValue(mediaType, false, false);
            }
            catch (DOMNullCharacterException e) {
                unescaped = mediaType;
            }
            this.currentQuery.setMediaType(unescaped);
        }

        @Override
        public void negativeQuery() {
            this.currentQuery.setNegative(true);
        }

        @Override
        public void onlyPrefix() {
            this.currentQuery.setOnlyPrefix(true);
        }

        @Override
        public void condition(BooleanCondition condition) {
            this.currentQuery.setFeaturePredicate(condition);
        }

        @Override
        public void endQuery() {
            if (!this.invalidQuery) {
                if (!this.currentQuery.isNotAllMedia() || !this.containsNotAll()) {
                    MediaQueryListImpl.this.queryList.add(this.currentQuery);
                }
                if (MediaQueryListImpl.this.invalidQueryList && !this.compatQuery) {
                    MediaQueryListImpl.this.invalidQueryList = false;
                }
                if (this.currentQuery.isAllMedia()) {
                    this.allMedia = true;
                }
            }
            this.currentQuery = null;
            this.invalidQuery = false;
            this.compatQuery = false;
        }

        private boolean containsNotAll() {
            Iterator it = MediaQueryListImpl.this.queryList.iterator();
            while (it.hasNext()) {
                if (!((MediaQuery)it.next()).isNotAllMedia()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void invalidQuery(CSSParseException queryError) {
            this.invalidQuery = true;
            MediaQueryListImpl.this.invalidQueryList = true;
            if (MediaQueryListImpl.this.queryErrorList == null) {
                MediaQueryListImpl.this.queryErrorList = new LinkedList();
            }
            MediaQueryListImpl.this.queryErrorList.add(queryError);
            if (this.ownerNode != null) {
                CSSMediaException e = new CSSMediaException(queryError);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryError(this.ownerNode, e);
            }
        }

        @Override
        public void compatQuery(CSSParseException exception) {
            MediaQueryListImpl.this.invalidQueryList = true;
            this.compatQuery = true;
            if (MediaQueryListImpl.this.queryErrorList == null) {
                MediaQueryListImpl.this.queryErrorList = new LinkedList();
            }
            MediaQueryListImpl.this.queryErrorList.add(exception);
            if (this.ownerNode != null) {
                CSSMediaException e = new CSSMediaException(exception);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryWarning(this.ownerNode, e);
            }
        }
    }
}

