/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSMediaRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.DOMException;

public class MediaRule
extends GroupingRule
implements ExtendedCSSMediaRule {
    private MediaQueryList mediaList = null;

    protected MediaRule(AbstractCSSStyleSheet parentSheet, MediaQueryList mediaList, byte origin) {
        super(parentSheet, (short)4, origin);
        this.mediaList = mediaList;
    }

    MediaRule(AbstractCSSStyleSheet parentSheet, MediaRule copyfrom) {
        super(parentSheet, copyfrom);
        this.mediaList = ((MediaListAccess)((Object)copyfrom.getMedia())).unmodifiable();
    }

    @Override
    public MediaQueryList getMedia() {
        return this.mediaList;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(64 + ((CSSRuleArrayList)this.getCssRules()).getLength() * 36);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder sb = new StringBuilder(30 + ((CSSRuleArrayList)this.getCssRules()).getLength() * 20);
        sb.append("@media");
        if (!this.mediaList.isAllMedia()) {
            sb.append(' ').append(this.mediaList.getMinifiedMedia());
        }
        sb.append("{");
        Iterator it = ((ArrayList)((Object)this.getCssRules())).iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri);
        wri.write("@media");
        if (!this.mediaList.isAllMedia()) {
            wri.write(' ');
            wri.write(this.mediaList.getMediaText());
        }
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        ((CSSRuleArrayList)this.getCssRules()).writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endRuleList(wri);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri);
    }

    @Override
    protected void setGroupingRule(GroupingRule rule) throws DOMException {
        MediaRule mediaRule = (MediaRule)rule;
        this.mediaList = mediaRule.mediaList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mediaList == null ? 0 : this.mediaList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaRule other = (MediaRule)obj;
        return !(this.mediaList == null ? other.mediaList != null : !this.mediaList.equals(other.mediaList));
    }

    @Override
    public MediaRule clone(AbstractCSSStyleSheet parentSheet) {
        return new MediaRule(parentSheet, this);
    }
}

