/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.GenericShorthandBuilder;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.css.CSSPrimitiveValue;

class OrderedShorthandBuilder
extends GenericShorthandBuilder {
    final String freeProperty;
    private final String freePropertyStringValue;

    OrderedShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue, String freeProperty) {
        super(shorthandName, parentStyle, initialvalue);
        this.freeProperty = freeProperty.toLowerCase(Locale.ROOT);
        StyleValue freePropertyValue = this.getCSSValue(freeProperty);
        this.freePropertyStringValue = freePropertyValue != null && freePropertyValue.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)freePropertyValue)).getPrimitiveType() == 21 ? ((CSSPrimitiveValue)((Object)freePropertyValue)).getStringValue() : null;
    }

    @Override
    boolean invalidPrimitiveValueClash(Set<String> declaredSet, String propertyName, PrimitiveValue primi) {
        return !this.freeProperty.equals(propertyName) && super.invalidPrimitiveValueClash(declaredSet, propertyName, primi);
    }

    @Override
    boolean identifierValuesAreKnown(String propertyName) {
        return !this.freeProperty.equals(propertyName) && super.identifierValuesAreKnown(propertyName);
    }

    @Override
    boolean appendValueText(StringBuilder buf, String property, boolean appended) {
        StyleValue cssVal = this.getCSSValue(property);
        if (this.isNotInitialValue(cssVal, property) || !this.freeProperty.equals(property) && this.validValueClash(property)) {
            if (appended) {
                buf.append(' ');
            }
            buf.append(cssVal.getMinifiedCssText(property));
            return true;
        }
        return appended;
    }

    boolean validValueClash(String property) {
        return this.freePropertyStringValue != null && OrderedShorthandBuilder.getShorthandDatabase().isIdentifierValue(property, this.freePropertyStringValue);
    }
}

