/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Set;

class OrderedTwoValueShorthandBuilder
extends ShorthandBuilder {
    private final String initialvalue;

    OrderedTwoValueShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue) {
        super(shorthandName, parentStyle);
        this.initialvalue = initialvalue;
    }

    @Override
    boolean appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        StyleValue cssVal2;
        if (this.hasPropertiesToExclude(declaredSet)) {
            return false;
        }
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkValuesForKeyword("unset", declaredSet);
        if (check == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return true;
        }
        if (check == 2) {
            return false;
        }
        String[] subp = this.getSubproperties();
        if (subp.length != 2) {
            throw new IllegalStateException("This class is only for two subproperties");
        }
        String property = subp[0];
        StyleValue cssVal = this.getCSSValue(property);
        if (cssVal.getCssValueType() == 2 && ((ValueList)cssVal).isCommaSeparated()) {
            return false;
        }
        boolean appended = false;
        if (this.isNotInitialValue(cssVal, property)) {
            this.appendValueText(buf, cssVal, false);
            appended = true;
        }
        if (!this.valueEquals(cssVal, cssVal2 = this.getCSSValue(subp[1]))) {
            this.appendValueText(buf, cssVal2, appended);
            appended = true;
        }
        if (!appended) {
            buf.append(this.initialvalue);
        }
        this.appendPriority(buf, important);
        return true;
    }

    @Override
    protected boolean isNotInitialValue(StyleValue cssVal, String propertyName) {
        return cssVal != null && !OrderedTwoValueShorthandBuilder.isInitialIdentifier(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(StringBuilder buf, StyleValue cssVal, boolean prepend) {
        if (prepend) {
            buf.append(' ');
        }
        buf.append(cssVal.getMinifiedCssText(this.getShorthandName()));
    }
}

