/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.ExtendedCSSValueList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;

abstract class ShorthandBuilder {
    private static final ShorthandDatabase shorthandDb = ShorthandDatabase.getInstance();
    private final String shorthandName;
    private final BaseCSSStyleDeclaration parentStyle;
    private final String[] subp;
    private final Set<String> impPtySet = new TreeSet<String>();
    private final Set<String> ptySet = new TreeSet<String>();

    ShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle) {
        this.shorthandName = shorthandName;
        this.parentStyle = parentStyle;
        this.subp = ShorthandBuilder.getShorthandDatabase().getShorthandSubproperties(shorthandName);
    }

    BaseCSSStyleDeclaration getParentStyle() {
        return this.parentStyle;
    }

    String getShorthandName() {
        return this.shorthandName;
    }

    static ShorthandDatabase getShorthandDatabase() {
        return shorthandDb;
    }

    String[] getLonghandProperties() {
        return this.getLonghandProperties(this.getShorthandName());
    }

    String[] getLonghandProperties(String shorthandName) {
        return ShorthandBuilder.getShorthandDatabase().getLonghandProperties(shorthandName);
    }

    String[] getSubproperties() {
        return this.subp;
    }

    StyleValue getCSSValue(String propertyName) {
        return this.parentStyle.getCSSValue(propertyName);
    }

    StyleValue getInitialPropertyValue(String propertyName) {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (this.parentStyle instanceof ComputedCSSStyle) {
            return this.parentStyle.defaultPropertyValue(propertyName, pdb);
        }
        StyleValue defval = pdb.getInitialValue(propertyName);
        if (defval == null) {
            if (propertyName.equals("color")) {
                defval = SystemDefaultValue.getInstance();
            } else if (propertyName.equals("font-family")) {
                defval = SystemDefaultValue.getInstance();
            } else if (propertyName.equals("text-align")) {
                String directionValue = this.parentStyle.getPropertyValue("direction");
                defval = directionValue.equals("rtl") ? new IdentifierValue("right") : new IdentifierValue("left");
            } else if (propertyName.equals("background-color")) {
                defval = new IdentifierValue("transparent");
            } else if (propertyName.endsWith("-color")) {
                defval = new IdentifierValue("currentcolor");
            } else if (propertyName.equals("quotes")) {
                defval = this.parentStyle.getValueFactory().parseProperty("\" \"");
            }
        }
        return defval;
    }

    boolean isPropertyAssigned(String propertyName, boolean important) {
        return this.parentStyle.isPropertySet(propertyName, important);
    }

    boolean isPropertyAssigned(String property) {
        return this.ptySet.contains(property) || this.impPtySet.contains(property);
    }

    boolean isPropertyImportant(String property) {
        return this.impPtySet.contains(property);
    }

    void addAssignedProperty(String propertyName, boolean important) {
        if (important) {
            this.impPtySet.add(propertyName);
        } else {
            this.ptySet.add(propertyName);
        }
    }

    public void appendMinifiedCssText(StringBuilder buf) {
        int len = buf.length();
        if (!this.appendShorthandText(buf)) {
            buf.setLength(len);
            this.appendMinifiedIndividualProperties(buf);
        }
    }

    protected void appendMinifiedIndividualProperties(StringBuilder buf) {
        this.appendImportantProperties(buf);
        this.appendNonImportantProperties(buf);
    }

    private void appendImportantProperties(StringBuilder buf) {
        for (String property : this.impPtySet) {
            buf.append(property).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(buf, this.getCSSValue(property), property);
            buf.append("!important;");
        }
    }

    private void appendNonImportantProperties(StringBuilder buf) {
        for (String property : this.ptySet) {
            buf.append(property).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(buf, this.getCSSValue(property), property);
            buf.append(';');
        }
    }

    boolean appendShorthandText(StringBuilder buf) {
        this.preprocessSet();
        int sz = this.getMinimumSetSize();
        if (this.getTotalSetSize() < sz) {
            return false;
        }
        return this.processPriorities(buf);
    }

    protected void preprocessSet() {
    }

    protected int getTotalSetSize() {
        return this.impPtySet.size() + this.ptySet.size();
    }

    boolean hasPropertiesToExclude(Set<String> declaredSet) {
        for (String property : declaredSet) {
            if (!this.isPropertyToExclude(property)) continue;
            return true;
        }
        return false;
    }

    boolean isPropertyToExclude(String property) {
        return this.isExcludedValue(this.getCSSValue(property));
    }

    boolean isExcludedValue(StyleValue cssValue) {
        short type = cssValue.getCssValueType();
        if (type == 1) {
            return this.isExcludedType(((CSSPrimitiveValue)((Object)cssValue)).getPrimitiveType());
        }
        if (type == 2) {
            ExtendedCSSValueList list = (ExtendedCSSValueList)((Object)cssValue);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (!this.isExcludedValue((StyleValue)it.next())) continue;
                return true;
            }
        }
        return false;
    }

    boolean isExcludedType(short primitiveType) {
        return primitiveType == 128;
    }

    boolean processPriorities(StringBuilder buf) {
        int sz = this.getMinimumSetSize();
        int impsz = this.impPtySet.size();
        if (impsz < sz) {
            if (!this.appendShorthandSet(buf, this.ptySet, false)) {
                return false;
            }
            if (impsz != 0) {
                this.appendImportantProperties(buf);
            }
        } else {
            if (this.ptySet.size() != 0) {
                int len = buf.length();
                if (!this.appendShorthandSet(buf, this.ptySet, false)) {
                    buf.setLength(len);
                    this.appendNonImportantProperties(buf);
                }
            }
            if (!this.appendShorthandSet(buf, this.impPtySet, true)) {
                return false;
            }
        }
        return true;
    }

    byte checkValuesForInherit(Set<String> declaredSet) {
        return this.checkValuesForInherit(this.getShorthandName(), declaredSet);
    }

    byte checkValuesForInherit(String shorthand, Set<String> declaredSet) {
        String[] properties;
        int count = 0;
        int expect = 0;
        for (String propertyName : properties = this.getLonghandProperties(shorthand)) {
            if (!declaredSet.contains(propertyName)) continue;
            expect = (byte)(expect + 1);
            if (!this.isInherit(this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == expect) {
            return 1;
        }
        return 2;
    }

    byte checkDeclaredValuesForInherit(Set<String> declaredSet) {
        byte count = 0;
        for (String propertyName : declaredSet) {
            if (!this.isInherit(this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == (byte)declaredSet.size()) {
            return 1;
        }
        return 2;
    }

    boolean isInherit(StyleValue value) {
        return value != null && value.getCssValueType() == 0;
    }

    byte checkDeclaredValuesForKeyword(String keyword, Set<String> declaredSet) {
        byte count = 0;
        for (String propertyName : declaredSet) {
            if (!ShorthandBuilder.isCssKeywordValue(keyword, this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == (byte)declaredSet.size()) {
            return 1;
        }
        return 2;
    }

    byte checkValuesForKeyword(String keyword, Set<String> declaredSet) {
        return this.checkValuesForKeyword(keyword, this.getShorthandName(), declaredSet);
    }

    byte checkValuesForKeyword(String keyword, String shorthand, Set<String> declaredSet) {
        String[] properties;
        int count = 0;
        int expect = 0;
        for (String propertyName : properties = this.getLonghandProperties(shorthand)) {
            if (!declaredSet.contains(propertyName)) continue;
            expect = (byte)(expect + 1);
            if (!ShorthandBuilder.isCssKeywordValue(keyword, this.getCSSValue(propertyName))) continue;
            count = (byte)(count + 1);
        }
        if (count == 0) {
            return 0;
        }
        if (count == expect) {
            return 1;
        }
        return 2;
    }

    static boolean isCssKeywordValue(String keyword, StyleValue cssValue) {
        return cssValue != null && cssValue.getCssValueType() == 1 && ShorthandBuilder.isCSSIdentifier((CSSPrimitiveValue)((Object)cssValue), keyword);
    }

    static boolean isCSSIdentifier(CSSPrimitiveValue value, String ident) {
        return value.getPrimitiveType() == 21 && ident.equalsIgnoreCase(value.getStringValue());
    }

    String getValueTextIfNotInitial(String propertyName, StyleValue cssVal) {
        if (!(cssVal == null || cssVal.isSystemDefault() || ShorthandBuilder.isInitialIdentifier(cssVal) || this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal))) {
            return cssVal.getMinifiedCssText(propertyName);
        }
        return null;
    }

    static boolean isInitialIdentifier(StyleValue cssVal) {
        return cssVal.getCssValueType() == 1 && ((CSSPrimitiveValue)((Object)cssVal)).getPrimitiveType() == 21 && ((CSSPrimitiveValue)((Object)cssVal)).getStringValue().toLowerCase(Locale.ROOT).equals("initial");
    }

    boolean isInitialValue(String propertyName) {
        StyleValue cssVal = this.getCSSValue(propertyName);
        return cssVal.isSystemDefault() || ShorthandBuilder.isInitialIdentifier(cssVal) || this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    protected boolean isNotInitialValue(StyleValue cssVal, String propertyName) {
        return cssVal != null && !cssVal.isSystemDefault() && !ShorthandBuilder.isInitialIdentifier(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    boolean containsControl(String ident) {
        int len = ident.length();
        for (int i = 0; i < len; ++i) {
            char c = ident.charAt(i);
            if (!Character.isISOControl(c)) continue;
            return true;
        }
        return false;
    }

    boolean isUnknownIdentifier(String propertyName, StyleValue value) {
        if (value.getCssValueType() == 1) {
            String s;
            CSSPrimitiveValue primi = (CSSPrimitiveValue)((Object)value);
            if (primi.getPrimitiveType() == 21 && !"none".equalsIgnoreCase(s = primi.getStringValue())) {
                return !ShorthandBuilder.getShorthandDatabase().isIdentifierValue(propertyName, s);
            }
        } else if (value.getCssValueType() == 2) {
            ValueList list = (ValueList)value;
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                if (!this.isUnknownIdentifier(propertyName, list.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    boolean isImagePrimitiveValue(PrimitiveValue primi) {
        short type = primi.getPrimitiveType();
        return type == 20 || type == 126 || type == 127 && this.isImageFunction(primi) || type == 133 || type == 128;
    }

    private boolean isImageFunction(PrimitiveValue primi) {
        String name = primi.getStringValue();
        return "image".equalsIgnoreCase(name) || "image-set".equalsIgnoreCase(name) || "cross-fade".equalsIgnoreCase(name);
    }

    boolean valueEquals(StyleValue value1, StyleValue value2) {
        if (value2 == null) {
            return value1 == null;
        }
        if (value1 == null) {
            return false;
        }
        if (value2.isSystemDefault() != value1.isSystemDefault()) {
            return false;
        }
        if (value1.getCssValueType() == 1 && value2.getCssValueType() == 1) {
            PrimitiveValue pvalue1 = (PrimitiveValue)value1;
            short type1 = pvalue1.getPrimitiveType();
            PrimitiveValue pvalue2 = (PrimitiveValue)value2;
            short type2 = pvalue2.getPrimitiveType();
            if (type1 == 21) {
                if (type2 == 25) {
                    return this.testColorIdentifier(pvalue2, pvalue1.getStringValue().toLowerCase(Locale.ROOT));
                }
                if (type2 == 21) {
                    return pvalue1.getStringValue().equalsIgnoreCase(pvalue2.getStringValue());
                }
            } else if (type1 == 25 && type2 == 21) {
                return this.testColorIdentifier(pvalue1, pvalue2.getStringValue());
            }
        }
        return value1.equals(value2);
    }

    private boolean testColorIdentifier(PrimitiveValue color, String ident) {
        String spec = "transparent".equals(ident) ? "rgba(0,0,0,0)" : ColorIdentifiers.getInstance().getColor(ident);
        if (spec != null) {
            ValueFactory factory = new ValueFactory();
            try {
                CSSPrimitiveValue val = (CSSPrimitiveValue)((Object)factory.parseProperty(spec));
                return val.getRGBColorValue().equals(color.getRGBColorValue());
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean appendValueIfNotInitial(StringBuilder buf, String propertyName, boolean prepend) {
        StyleValue cssVal = this.getCSSValue(propertyName);
        if (this.isNotInitialValue(cssVal, propertyName)) {
            if (prepend) {
                buf.append(' ');
            }
            buf.append(cssVal.getMinifiedCssText(propertyName));
            return true;
        }
        return prepend;
    }

    void appendPriority(StringBuilder buf, boolean important) {
        if (important) {
            buf.append("!important;");
        } else {
            buf.append(';');
        }
    }

    boolean appendRelativeURI(StringBuilder buf, boolean prepend, StyleValue value) {
        String text;
        if (value.getCssValueType() == 1) {
            CSSPrimitiveValue pvalue = (CSSPrimitiveValue)((Object)value);
            short type = pvalue.getPrimitiveType();
            if (type == 20) {
                URL url = ((URIValue)pvalue).getURLValue();
                if (url != null) {
                    String baseuri = this.getBaseURI();
                    text = baseuri != null ? ShorthandBuilder.relativeURI(baseuri, url) : url.toExternalForm();
                    text = "url('" + text + "')";
                } else {
                    text = pvalue.getCssText();
                }
            } else if (type == 21) {
                text = pvalue.getStringValue();
                if ("none".equalsIgnoreCase(text) || "initial".equalsIgnoreCase(text)) {
                    return false;
                }
            } else {
                text = value.getMinifiedCssText("background-image");
            }
        } else {
            text = value.getMinifiedCssText("background-image");
        }
        if (prepend) {
            buf.append(' ');
        }
        buf.append(text);
        return true;
    }

    String getBaseURI() {
        Document document;
        AbstractCSSStyleSheet psheet;
        BaseCSSDeclarationRule prule = this.getParentStyle().getParentRule();
        if (prule != null && (psheet = prule.getParentStyleSheet()) != null) {
            return psheet.getHref();
        }
        Node node = this.getParentStyle().getOwnerNode();
        String baseuri = null;
        if (node != null && (document = node.getOwnerDocument()) != null) {
            baseuri = document.getBaseURI();
        }
        return baseuri;
    }

    static String relativeURI(String baseuri, URL url) {
        try {
            URL base = new URL(baseuri);
            if (ShorthandBuilder.sameTree(base, url)) {
                try {
                    return base.toURI().relativize(url.toURI()).toString();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String uri = url.toExternalForm();
        return uri;
    }

    static boolean sameTree(URL base, URL url) {
        if (base.getProtocol().equals(url.getProtocol())) {
            String bhost = base.getHost();
            String uhost = url.getHost();
            if (bhost != null) {
                if (bhost.equals(uhost)) {
                    int bport = base.getPort();
                    int uport = url.getPort();
                    if (bport == -1) {
                        bport = base.getDefaultPort();
                    }
                    if (uport == -1) {
                        uport = url.getDefaultPort();
                    }
                    return bport == uport;
                }
            } else {
                return uhost == null;
            }
        }
        return false;
    }

    protected int getMinimumSetSize() {
        return this.getLonghandProperties().length;
    }

    abstract boolean appendShorthandSet(StringBuilder var1, Set<String> var2, boolean var3);
}

