/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

class ShorthandSetter
implements BaseCSSStyleDeclaration.SubpropertySetter {
    BaseCSSStyleDeclaration styleDeclaration;
    private final String shorthandName;
    private boolean priorityImportant = false;
    private final PropertyDatabase pdb = PropertyDatabase.getInstance();
    private final ShorthandDatabase shorthandDb = ShorthandDatabase.getInstance();
    final ValueFactory valueFactory;
    private final HashMap<String, StyleValue> mypropValue = new HashMap();
    private final LinkedList<String> mypropertyList = new LinkedList();
    private final LinkedList<String> mypriorities = new LinkedList();
    protected LexicalUnit currentValue = null;
    private final StringBuilder valueBuffer = new StringBuilder(40);
    private final StringBuilder miniValueBuffer = new StringBuilder(40);
    private final ArrayList<String> unassignedProperties = new ArrayList(6);

    ShorthandSetter(BaseCSSStyleDeclaration style, String shorthandName) {
        this.styleDeclaration = style;
        this.shorthandName = shorthandName;
        this.valueFactory = style.getValueFactory();
    }

    public String getShorthandName() {
        return this.shorthandName;
    }

    public boolean isPriorityImportant() {
        return this.priorityImportant;
    }

    String getPriority() {
        return this.priorityImportant ? "important" : null;
    }

    void setPriority(boolean important) {
        this.priorityImportant = important;
    }

    public final PropertyDatabase getPropertyDatabase() {
        return this.pdb;
    }

    public final ShorthandDatabase getShorthandDatabase() {
        return this.shorthandDb;
    }

    boolean hasCompatValue() {
        for (LexicalUnit lu = this.currentValue; lu != null; lu = lu.getNextLexicalUnit()) {
            short type = lu.getLexicalUnitType();
            if (type != 71 && type != 72) continue;
            return true;
        }
        return false;
    }

    void addUnassignedProperty(String propertyName) {
        this.unassignedProperties.add(propertyName);
    }

    List<String> getUnassignedProperties() {
        return this.unassignedProperties;
    }

    boolean scanUnassigned(List<LexicalUnit> unassignedValues) {
        block0: for (LexicalUnit lu : unassignedValues) {
            StyleDeclarationErrorHandler errHandler;
            if (lu.getLexicalUnitType() == 35) {
                if (!this.isNotValidIdentifier(lu)) continue;
                String sv = lu.getStringValue();
                Iterator<String> it = this.getUnassignedProperties().iterator();
                while (it.hasNext()) {
                    String property = it.next();
                    if (!property.endsWith("-color") || !sv.endsWith("-color")) continue;
                    this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                    it.remove();
                    continue block0;
                }
            } else if (lu.getLexicalUnitType() == 41) {
                String funcname = lu.getFunctionName();
                List<String> unass = this.getUnassignedProperties();
                Iterator<String> it = unass.iterator();
                while (it.hasNext()) {
                    String property = it.next();
                    if (property.endsWith("-color")) {
                        if (!"var".equalsIgnoreCase(funcname)) {
                            for (LexicalUnit param = lu.getParameters(); param != null; param = param.getNextLexicalUnit()) {
                                if (!BaseCSSStyleDeclaration.testColor(param)) continue;
                                this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                                it.remove();
                                continue block0;
                            }
                            continue;
                        }
                        if (unass.size() != 1) continue;
                        this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                        it.remove();
                        break block0;
                    }
                    if (!property.endsWith("-image") || unass.size() != 1 || !"var".equalsIgnoreCase(funcname)) continue;
                    this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                    it.remove();
                    break block0;
                }
            }
            if ((errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
                errHandler.unassignedShorthandValue(this.getShorthandName(), lu.toString());
            }
            return false;
        }
        return true;
    }

    byte scanForCssWideKeywords(LexicalUnit lunit) {
        String keyword;
        if (lunit.getLexicalUnitType() == 12) {
            if (lunit.getNextLexicalUnit() != null) {
                this.reportMixedKeywords("inherit");
                return 2;
            }
            InheritValue inherit = InheritValue.getValue().asSubproperty();
            this.setSubpropertiesInherit(inherit);
            this.initValueString();
            this.appendValueItemString(inherit);
            return 1;
        }
        if (lunit.getLexicalUnitType() == 35 && ((keyword = lunit.getStringValue()).equalsIgnoreCase("initial") || keyword.equalsIgnoreCase("unset"))) {
            if (lunit.getNextLexicalUnit() != null) {
                this.reportMixedKeywords(keyword);
                return 2;
            }
            StyleValue cssval = this.valueFactory.createCSSValueItem(lunit, true).getCSSValue();
            this.setSubpropertiesToKeyword(cssval);
            this.initValueString();
            this.appendValueItemString(cssval);
            return 1;
        }
        return 0;
    }

    private void reportMixedKeywords(String keyword) {
        StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
        if (errHandler != null) {
            errHandler.shorthandError(this.getShorthandName(), "Found '" + keyword + "' keyword mixed with other values");
        }
    }

    protected void setSubpropertiesInherit(InheritValue inherit) {
        String[] subparray;
        for (String subp : subparray = this.getShorthandSubproperties()) {
            String[] sh;
            if (!this.getShorthandDatabase().isShorthand(subp)) {
                this.styleDeclaration.setProperty(subp, inherit, this.getPriority());
                continue;
            }
            for (String s : sh = this.getShorthandDatabase().getShorthandSubproperties(subp)) {
                this.styleDeclaration.setProperty(s, inherit, this.getPriority());
            }
        }
    }

    protected void setSubpropertiesToKeyword(StyleValue keyword) {
        String[] subparray;
        for (String subp : subparray = this.getShorthandSubproperties()) {
            String[] sh;
            if (!this.getShorthandDatabase().isShorthand(subp)) {
                this.styleDeclaration.setProperty(subp, keyword, this.getPriority());
                continue;
            }
            for (String s : sh = this.getShorthandDatabase().getShorthandSubproperties(subp)) {
                this.styleDeclaration.setProperty(s, keyword, this.getPriority());
            }
        }
    }

    protected String[] getShorthandSubproperties() {
        return this.getShorthandDatabase().getShorthandSubproperties(this.getShorthandName());
    }

    protected void nextCurrentValue() {
        if (this.currentValue != null) {
            this.currentValue = this.currentValue.getNextLexicalUnit();
            this.appendValueItemString();
        }
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        this.currentValue = shorthandValue;
        this.setPriority(important);
        this.unassignedProperties.clear();
        this.initValueString();
        this.appendValueItemString();
    }

    protected void resetSubproperties() {
        List<String> props = this.getUnassignedProperties();
        for (String pname : props) {
            if (!this.getShorthandDatabase().isShorthand(pname)) {
                this.setPropertyToDefault(pname);
                continue;
            }
            String[] sh = this.getShorthandDatabase().getShorthandSubproperties(pname);
            for (int i = 0; i < sh.length; ++i) {
                this.setPropertyToDefault(sh[i]);
            }
        }
    }

    protected void setSubpropertiesToDefault() {
        String[] subp;
        for (String pname : subp = this.getShorthandSubproperties()) {
            if (!this.getShorthandDatabase().isShorthand(pname)) {
                this.setPropertyToDefault(pname);
                continue;
            }
            String[] sh = this.getShorthandDatabase().getShorthandSubproperties(pname);
            for (int i = 0; i < sh.length; ++i) {
                this.setPropertyToDefault(sh[i]);
            }
        }
    }

    StyleValue defaultPropertyValue(String propertyName) {
        StyleValue cssVal = this.styleDeclaration.defaultPropertyValue(propertyName, this.getPropertyDatabase());
        if (cssVal != null) {
            short type = cssVal.getCssValueType();
            if (type == 1) {
                ((PrimitiveValue)cssVal).setSubproperty(true);
            } else if (type == 2) {
                ((ValueList)cssVal).setSubproperty(true);
            }
        } else {
            IdentifierValue ident = new IdentifierValue("initial");
            ident.setSubproperty(true);
            cssVal = ident;
        }
        return cssVal;
    }

    void setPropertyToDefault(String pname) {
        StyleValue cssVal = this.defaultPropertyValue(pname);
        this.setProperty(pname, cssVal, this.getPriority());
    }

    void setDeclarationPropertyToDefault(String propertyName) {
        StyleValue cssVal = this.defaultPropertyValue(propertyName);
        this.styleDeclaration.setProperty(propertyName, cssVal, this.getPriority());
    }

    protected List<String> subpropertyList() {
        String[] subparray = this.getShorthandSubproperties();
        ArrayList<String> subp = new ArrayList<String>(subparray.length);
        subp.addAll(Arrays.asList((Object[])subparray.clone()));
        return subp;
    }

    @Override
    public boolean assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        LinkedList<LexicalUnit> unassignedValues = new LinkedList<LexicalUnit>();
        List<String> subp = this.subpropertyList();
        while (this.currentValue != null) {
            boolean assigned = false;
            for (int i = 0; i < subp.size(); ++i) {
                String pname = subp.get(i);
                if (!this.assignSubproperty(pname)) continue;
                subp.remove(i);
                assigned = true;
                break;
            }
            if (assigned) continue;
            unassignedValues.add(this.currentValue);
            this.nextCurrentValue();
        }
        if (!subp.isEmpty()) {
            Iterator<String> it = subp.iterator();
            while (it.hasNext()) {
                this.addUnassignedProperty(it.next());
            }
        }
        if (!unassignedValues.isEmpty() && !this.scanUnassigned(unassignedValues)) {
            return false;
        }
        this.resetSubproperties();
        this.flush();
        return true;
    }

    boolean isNotValidIdentifier(LexicalUnit lu) {
        return !lu.getStringValue().equalsIgnoreCase("none");
    }

    protected boolean assignSubproperty(String subproperty) {
        short lutype = this.currentValue.getLexicalUnitType();
        if (lutype == 35 && this.assignIdentifiers(subproperty)) {
            return true;
        }
        return subproperty.endsWith("-color") ? BaseCSSStyleDeclaration.testColor(this.currentValue) && this.setCurrentValue(subproperty) : (subproperty.endsWith("-width") ? ValueFactory.isSizeSACUnit(this.currentValue) && this.setCurrentValue(subproperty) : subproperty.endsWith("-image") && this.isImage() && this.setCurrentValue(subproperty));
    }

    boolean isImage() {
        short type = this.currentValue.getLexicalUnitType();
        return type == 24 || type == 41 && this.isImageFunctionOrGradientName() || type == 73;
    }

    private boolean isImageFunctionOrGradientName() {
        String lcfn = this.currentValue.getFunctionName().toLowerCase(Locale.ROOT);
        return lcfn.endsWith("-gradient") || lcfn.equals("image") || lcfn.equals("image-set") || lcfn.equals("cross-fade");
    }

    boolean setCurrentValue(String subproperty) {
        StyleValue cssValue = this.createCSSValue(subproperty, this.currentValue);
        if (cssValue != null) {
            this.setSubpropertyValue(subproperty, cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    boolean assignIdentifiers(String subproperty) {
        if (this.testIdentifiers(subproperty)) {
            StyleValue cssValue = this.createCSSValue(subproperty, this.currentValue);
            this.setSubpropertyValue(subproperty, cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    boolean testIdentifiers(String subproperty) {
        return this.getShorthandDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
    }

    protected void setSubpropertyValue(String subproperty, StyleValue cssValue) {
        this.setProperty(subproperty, cssValue, this.getPriority());
    }

    void setSubpropertyValueWListCheck(String property, StyleValue value) {
        ValueList list;
        if (value.getCssValueType() == 2 && (list = (ValueList)value).getLength() == 1) {
            value = list.item(0);
        }
        this.setSubpropertyValue(property, value);
    }

    void addSubpropertyValue(String subproperty, StyleValue cssValue, boolean commaList) {
        StyleValue cssval = this.getDeclaredCSSValue(subproperty);
        if (cssval == null) {
            this.setSubpropertyValue(subproperty, cssValue);
        } else {
            switch (cssval.getCssValueType()) {
                case 2: {
                    ((ValueList)cssval).add(cssValue);
                    cssValue = cssval;
                    break;
                }
                default: {
                    ValueList list = commaList ? ValueList.createCSValueList() : ValueList.createWSValueList();
                    list.add(cssval);
                    list.add(cssValue);
                    cssValue = list;
                }
            }
            this.setProperty(subproperty, cssValue, this.getPriority());
        }
    }

    void setProperty(String subpropertyName, StyleValue cssValue, String priority) {
        this.mypropertyList.add(subpropertyName);
        this.mypriorities.add(priority);
        this.mypropValue.put(subpropertyName, cssValue);
    }

    boolean isPropertySet(String subpropertyName) {
        return this.mypropertyList.contains(subpropertyName);
    }

    StyleValue getDeclaredCSSValue(String propertyName) {
        return this.mypropValue.get(propertyName);
    }

    void flush() {
        int i = 0;
        for (String myproperty : this.mypropertyList) {
            this.styleDeclaration.setProperty(myproperty, this.mypropValue.get(myproperty), this.mypriorities.get(i));
            ++i;
        }
        this.mypropertyList.clear();
        this.mypriorities.clear();
        this.mypropValue.clear();
    }

    StyleValue createCSSValue() throws DOMException {
        StyleDeclarationErrorHandler errHandler;
        ValueItem item = this.valueFactory.createCSSValueItem(this.currentValue, true);
        if (item.hasWarnings() && (errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
            item.handleSyntaxWarnings(errHandler);
        }
        this.currentValue = item.getNextLexicalUnit();
        return item.getCSSValue();
    }

    protected StyleValue createCSSValue(String propertyName, LexicalUnit lunit) throws DOMException {
        return this.createCSSValue(propertyName, lunit, true);
    }

    StyleValue createCSSValue(String propertyName, LexicalUnit lunit, boolean subproperty) throws DOMException {
        StyleDeclarationErrorHandler errHandler;
        ValueItem item = this.valueFactory.createCSSValueItem(lunit, subproperty);
        StyleValue cssVal = item.getCSSValue();
        if (item.hasWarnings() && (errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
            item.handleSyntaxWarnings(errHandler);
        }
        return cssVal;
    }

    void initValueString() {
        this.valueBuffer.setLength(0);
        this.miniValueBuffer.setLength(0);
    }

    void appendValueItemString(StyleValue cssValue) {
        if (cssValue != null) {
            String cssText = cssValue.getCssText();
            String miniCssText = cssValue.getMinifiedCssText(this.getShorthandName());
            StringBuilder buf = this.getValueItemBuffer();
            StringBuilder minibuf = this.getValueItemBufferMini();
            int len = buf.length();
            if (len != 0) {
                char c = buf.charAt(len - 1);
                if (!this.isDelimiterChar(c, miniCssText)) {
                    minibuf.append(' ');
                }
                buf.append(' ');
            }
            buf.append(cssText);
            minibuf.append(miniCssText);
        }
    }

    protected boolean isDelimiterChar(char c, String cssText) {
        return c == ',' || c == '/';
    }

    void appendValueItemString(String text) {
        this.getValueItemBuffer().append(text);
        this.getValueItemBufferMini().append(text);
    }

    protected void appendValueItemString() {
        if (this.currentValue != null) {
            this.valueFactory.appendValueString(this.getValueItemBuffer(), this.currentValue);
            this.valueFactory.appendMinifiedValueString(this.getValueItemBufferMini(), this.currentValue);
        }
    }

    StringBuilder getValueItemBuffer() {
        return this.valueBuffer;
    }

    StringBuilder getValueItemBufferMini() {
        return this.miniValueBuffer;
    }

    void appendToValueBuffer(StringBuilder buf, StringBuilder minibuf) {
        this.valueBuffer.append((CharSequence)buf);
        this.miniValueBuffer.append((CharSequence)minibuf);
    }

    @Override
    public String getCssText() {
        return this.valueBuffer.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return this.miniValueBuffer.toString();
    }

    void reportDeclarationError(String propertyName, String message) {
        BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
        if (prule != null) {
            prule.getStyleDeclarationErrorHandler().shorthandError(propertyName, message);
        }
    }
}

