/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSShorthandValue;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

class ShorthandValue
extends StyleValue
implements CSSShorthandValue {
    private String cssText = null;
    private final LexicalUnit lexicalUnit;
    private final boolean important;
    private final boolean priorityCompat;
    private final HashSet<String> longhands;
    private String miniCssText = "";

    ShorthandValue(LexicalUnit lexicalUnit, boolean important) {
        this(lexicalUnit, important, new String[0]);
    }

    private ShorthandValue(LexicalUnit lexicalUnit, boolean important, String[] longhands) {
        super((short)3);
        this.lexicalUnit = lexicalUnit;
        this.important = important;
        this.priorityCompat = lexicalUnit.getLexicalUnitType() == 72;
        this.longhands = new HashSet<String>(Arrays.asList(longhands));
    }

    private ShorthandValue(ShorthandValue copied) {
        super(copied);
        this.lexicalUnit = copied.lexicalUnit;
        this.important = copied.important;
        this.priorityCompat = copied.priorityCompat;
        this.cssText = copied.cssText;
        this.miniCssText = copied.miniCssText;
        this.longhands = new HashSet(copied.longhands.size());
        this.longhands.addAll(copied.longhands);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "This property can only be changed from CSSStyleDeclaration.setCssText()");
    }

    public void setShorthandText(String cssText, String miniCssText) throws DOMException {
        this.cssText = cssText;
        this.miniCssText = miniCssText;
    }

    public LexicalUnit getLexicalUnit() {
        return this.lexicalUnit;
    }

    public HashSet<String> getLonghands() {
        return this.longhands;
    }

    @Override
    public boolean isImportant() {
        return this.important && !this.priorityCompat;
    }

    public boolean isPriorityCompat() {
        return this.priorityCompat;
    }

    @Override
    public String getCssText() {
        return this.cssText;
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write(this.getCssText());
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return this.miniCssText;
    }

    boolean isSetSubproperty(String ptyname) {
        return this.longhands.contains(ptyname);
    }

    boolean overrideBy(ShorthandValue shorthand) {
        this.longhands.removeAll(shorthand.longhands);
        return this.longhands.isEmpty();
    }

    boolean overrideByLonghand(String longhandName) {
        this.longhands.remove(longhandName);
        return this.longhands.isEmpty();
    }

    @Override
    public ShorthandValue clone() {
        return new ShorthandValue(this);
    }

    static ShorthandValue createCSSShorthandValue(ShorthandDatabase sdb, String shorthandName, LexicalUnit value, boolean important) {
        ShorthandValue shval = new ShorthandValue(value, important, sdb.getLonghandProperties(shorthandName));
        if ("border".equals(shorthandName)) {
            shval.longhands.add("border-image-source");
            shval.longhands.add("border-image-slice");
            shval.longhands.add("border-image-width");
            shval.longhands.add("border-image-outset");
            shval.longhands.add("border-image-repeat");
        } else if ("font".equals(shorthandName)) {
            shval.longhands.add("font-variant-caps");
            shval.longhands.add("font-variant-ligatures");
            shval.longhands.add("font-variant-position");
            shval.longhands.add("font-variant-numeric");
            shval.longhands.add("font-variant-alternates");
            shval.longhands.add("font-variant-east-asian");
        }
        return shval;
    }
}

