/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.agent.Viewport;
import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue2;
import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.om.BoxModelHelper;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

abstract class SimpleBoxModel {
    SimpleBoxModel() {
    }

    protected abstract ComputedCSSStyle getComputedStyle();

    private StyleDatabase getStyleDatabase() {
        return this.getComputedStyle().getStyleDatabase();
    }

    private void computeSharedBoxValues(MyBoxValues box, short unitType) {
        CSSPropertyValueException e;
        CSSPrimitiveValue2 primi;
        ComputedCSSStyle styledecl = this.getComputedStyle();
        StyleValue cssval = styledecl.getCSSValue("margin-top");
        while (cssval.getCssValueType() == 0 && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-top");
        }
        if (styledecl == null) {
            box.marginTop = 0.0f;
        } else if (cssval.getCssValueType() == 1) {
            primi = (CSSPrimitiveValue2)((Object)cssval);
            box.marginTop = SimpleBoxModel.isPrimitiveAutoLength(primi) ? 0.0f : this.computeMarginNumberValue(styledecl, "margin-top", primi, unitType);
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-top, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-top", e);
            box.marginTop = 0.0f;
        }
        cssval = styledecl.getCSSValue("margin-bottom");
        while (cssval.getCssValueType() == 0 && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-bottom");
        }
        if (styledecl == null) {
            box.marginBottom = 0.0f;
        } else if (cssval.getCssValueType() == 1) {
            primi = (CSSPrimitiveValue2)((Object)cssval);
            box.marginBottom = SimpleBoxModel.isPrimitiveAutoLength(primi) ? 0.0f : this.computeMarginNumberValue(styledecl, "margin-bottom", primi, unitType);
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-bottom, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-bottom", e);
            box.marginBottom = 0.0f;
        }
        box.paddingTop = this.computePaddingSubproperty(styledecl, "padding-top", unitType);
        box.paddingRight = this.computePaddingSubproperty(styledecl, "padding-right", unitType);
        box.paddingBottom = this.computePaddingSubproperty(styledecl, "padding-bottom", unitType);
        box.paddingLeft = this.computePaddingSubproperty(styledecl, "padding-left", unitType);
        box.borderTopWidth = this.findBorderWidthProperty(styledecl, "border-top-width", styledecl.getCSSValue("border-top-width"), unitType);
        box.borderBottomWidth = this.findBorderWidthProperty(styledecl, "border-bottom-width", styledecl.getCSSValue("border-bottom-width"), unitType);
        box.borderLeftWidth = this.findBorderWidthProperty(styledecl, "border-left-width", styledecl.getCSSValue("border-left-width"), unitType);
        box.borderRightWidth = this.findBorderWidthProperty(styledecl, "border-right-width", styledecl.getCSSValue("border-right-width"), unitType);
    }

    private static boolean isPrimitiveAutoLength(CSSPrimitiveValue2 value) {
        return value.getPrimitiveType() == 21 && "auto".equalsIgnoreCase(value.getStringValue()) || value.isNegativeNumber() && !value.isCalculatedNumber();
    }

    void computeInlineBox(MyBoxValues box, short unitType) throws StyleDatabaseRequiredException {
        CSSElement elm;
        CSSPropertyValueException e;
        CSSPrimitiveValue2 primi;
        ComputedCSSStyle styledecl = this.getComputedStyle();
        StyleValue cssval = styledecl.getCSSValue("margin-right");
        while (cssval.getCssValueType() == 0 && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-right");
        }
        if (styledecl == null) {
            box.marginRight = 0.0f;
        } else if (cssval.getCssValueType() == 1) {
            primi = (CSSPrimitiveValue2)((Object)cssval);
            if (!SimpleBoxModel.isPrimitiveAutoLength(primi)) {
                box.marginRight = this.computeMarginNumberValue(styledecl, "margin-right", primi, unitType);
            }
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-right, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-right", e);
            box.marginRight = 0.0f;
        }
        styledecl = this.getComputedStyle();
        cssval = styledecl.getCSSValue("margin-left");
        while (cssval.getCssValueType() == 0 && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-left");
        }
        if (styledecl == null) {
            box.marginLeft = 0.0f;
        } else if (cssval.getCssValueType() == 1) {
            primi = (CSSPrimitiveValue2)((Object)cssval);
            if (!SimpleBoxModel.isPrimitiveAutoLength(primi)) {
                box.marginLeft = this.computeMarginNumberValue(styledecl, "margin-left", primi, unitType);
            }
        } else {
            e = new CSSPropertyValueException("Expected primitive value for margin-left, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-left", e);
            box.marginLeft = 0.0f;
        }
        CSSElement node = styledecl.getOwnerNode();
        if (node != null && node.getNodeType() == 1 && "img".equals((elm = node).getTagName()) && elm.hasAttribute("width")) {
            String strWidth = elm.getAttribute("width");
            try {
                box.width = Float.parseFloat(strWidth);
            }
            catch (NumberFormatException e2) {
                String message = "Could not parse value of 'width' attribute for img element";
                CSSPropertyValueException ex = new CSSPropertyValueException(message, e2);
                ex.setValueText(strWidth);
                elm.getOwnerDocument().getErrorHandler().computedStyleError(elm, "width", ex);
            }
            if (unitType != 5) {
                box.width = NumberValue.floatValueConversion(box.width, (short)5, unitType);
            }
        }
    }

    public BoxValues getComputedBox(short unitType) throws DOMException, StyleDatabaseRequiredException {
        String display = this.getComputedStyle().getDisplay();
        if ("block".equalsIgnoreCase(display) || "list-item".equalsIgnoreCase(display)) {
            MyBoxValues box = new MyBoxValues();
            this.computeSharedBoxValues(box, unitType);
            this.computeBlockBox(box, unitType);
            return box;
        }
        if ("table".equalsIgnoreCase(display)) {
            MyTableBoxValues box = new MyTableBoxValues();
            this.computeSharedBoxValues(box, unitType);
            String tableLayout = this.getComputedStyle().getPropertyValue("table-layout");
            if ("auto".equalsIgnoreCase(tableLayout)) {
                this.computeTableBox(box, unitType);
                return box;
            }
            this.computeBlockBox(box, unitType);
            return box;
        }
        if ("table-cell".equalsIgnoreCase(display) || "table-row".equalsIgnoreCase(display)) {
            MyTableItemBoxValues box = new MyTableItemBoxValues();
            this.computeTableCellBox(box, unitType);
            return box;
        }
        MyBoxValues box = new MyBoxValues();
        this.computeSharedBoxValues(box, unitType);
        this.computeInlineBox(box, unitType);
        return box;
    }

    void computeBlockBox(MyBoxValues box, short unitType) throws StyleDatabaseRequiredException {
        CSSPrimitiveValue2 primi;
        boolean margin_right_auto = false;
        ComputedCSSStyle styledecl = this.getComputedStyle();
        StyleValue cssval = styledecl.getCSSValue("margin-right");
        while (cssval.getCssValueType() == 0 && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-right");
        }
        if (cssval.getCssValueType() == 1) {
            CSSPrimitiveValue2 primi2 = (CSSPrimitiveValue2)((Object)cssval);
            margin_right_auto = SimpleBoxModel.isPrimitiveAutoLength(primi2);
            if (!margin_right_auto) {
                box.marginRight = this.computeMarginNumberValue(styledecl, "margin-right", primi2, unitType);
            }
        } else {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected primitive value for margin-right, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-right", e);
            box.marginRight = 0.0f;
        }
        styledecl = this.getComputedStyle();
        boolean margin_left_auto = false;
        cssval = styledecl.getCSSValue("margin-left");
        while (cssval.getCssValueType() == 0 && (styledecl = styledecl.getParentComputedStyle()) != null) {
            cssval = styledecl.getCSSValue("margin-left");
        }
        if (cssval.getCssValueType() == 1) {
            primi = (CSSPrimitiveValue2)((Object)cssval);
            margin_left_auto = SimpleBoxModel.isPrimitiveAutoLength(primi);
            if (!margin_left_auto) {
                box.marginLeft = this.computeMarginNumberValue(styledecl, "margin-left", primi, unitType);
            }
        } else {
            CSSPropertyValueException e = new CSSPropertyValueException("Expected primitive value for margin-left, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("margin-left", e);
            box.marginLeft = 0.0f;
        }
        styledecl = this.getComputedStyle();
        cssval = styledecl.getCSSValue("width");
        if (cssval == null || cssval.getCssValueType() != 1 || SimpleBoxModel.isPrimitiveAutoLength(primi = (CSSPrimitiveValue2)((Object)cssval))) {
            ComputedCSSStyle contblockStyledecl;
            if (margin_right_auto) {
                box.marginRight = 0.0f;
            }
            if (margin_left_auto) {
                box.marginLeft = 0.0f;
            }
            float contBlockWidth = (contblockStyledecl = SimpleBoxModel.findContainingBlockStyle(styledecl)) == null ? this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto") : this.computeWidth(contblockStyledecl, unitType);
            box.width = contBlockWidth - (box.marginLeft + box.marginRight + box.borderLeftWidth + box.borderRightWidth + box.paddingLeft + box.paddingRight);
        } else {
            box.width = this.computeNonAutoWidth(styledecl, primi, unitType);
            ComputedCSSStyle contblockStyledecl = SimpleBoxModel.findContainingBlockStyle(styledecl);
            float contBlockWidth = contblockStyledecl == null ? this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto") : this.computeWidth(styledecl, unitType);
            float remMargin = contBlockWidth - box.width;
            remMargin -= box.borderLeftWidth + box.borderRightWidth + box.paddingLeft + box.paddingRight;
            if (margin_right_auto) {
                if (remMargin < 0.0f) {
                    box.marginRight = 0.0f;
                    box.marginLeft = 0.0f;
                } else if (margin_left_auto) {
                    box.marginLeft = box.marginRight = remMargin / 2.0f;
                } else if (remMargin < box.marginLeft) {
                    box.marginLeft = remMargin;
                    box.marginRight = 0.0f;
                } else {
                    box.marginRight = remMargin - box.marginLeft;
                }
            } else if (margin_left_auto) {
                if (remMargin < 0.0f) {
                    box.marginRight = 0.0f;
                    box.marginLeft = 0.0f;
                } else if (remMargin < box.marginRight) {
                    box.marginRight = remMargin;
                    box.marginLeft = 0.0f;
                } else {
                    box.marginLeft = remMargin;
                }
            } else if ((remMargin -= box.marginLeft + box.marginRight) < 0.0f) {
                if ("ltr".equalsIgnoreCase(styledecl.getPropertyValue("direction"))) {
                    box.marginRight = (remMargin += box.marginRight) > 0.0f ? remMargin : 0.0f;
                } else {
                    box.marginLeft = (remMargin += box.marginLeft) > 0.0f ? remMargin : 0.0f;
                }
            }
        }
    }

    private void computeTableBox(MyTableBoxValues box, short unitType) {
        block25: {
            float mincw;
            float[] minrcw;
            int ncol;
            float capmin;
            block23: {
                boolean unset;
                float maxcw;
                float[] maxrcw;
                block26: {
                    block24: {
                        this.computeBlockBox(box, unitType);
                        capmin = this.computeCapmin(unitType);
                        ComputedCSSStyle style = this.getComputedStyle();
                        CSSElement tbl = style.getOwnerNode();
                        NodeList nlist = tbl.getElementsByTagName("tbody");
                        nlist = nlist.getLength() > 0 ? nlist.item(0).getChildNodes() : tbl.getChildNodes();
                        ncol = 0;
                        int nrows = nlist.getLength();
                        for (int i = 0; i < nrows; ++i) {
                            int rowcols;
                            CSSElement elm;
                            Node node = nlist.item(i);
                            if (node.getNodeType() != 1 || !"tr".equalsIgnoreCase((elm = (CSSElement)node).getTagName()) || (rowcols = elm.getChildNodes().getLength()) <= ncol) continue;
                            ncol = rowcols;
                        }
                        minrcw = new float[ncol];
                        maxrcw = new float[ncol];
                        float maxRowSpacing = 0.0f;
                        for (int i = 0; i < nrows; ++i) {
                            CSSElement elm;
                            Node node = nlist.item(i);
                            if (node.getNodeType() != 1 || !"tr".equalsIgnoreCase((elm = (CSSElement)node).getTagName())) continue;
                            style = (ComputedCSSStyle)elm.getOwnerDocument().getStyleSheet().getComputedStyle(elm, null);
                            BoxValues colbox = style.getBoxValues(unitType);
                            float rowSpacing = colbox.getBorderLeftWidth() + colbox.getBorderRightWidth() + colbox.getMarginLeft() + colbox.getMarginRight() + colbox.getPaddingLeft() + colbox.getPaddingRight();
                            if (maxRowSpacing < rowSpacing) {
                                maxRowSpacing = rowSpacing;
                            }
                            NodeList columns = elm.getChildNodes();
                            int nrowcols = columns.getLength();
                            int k = 0;
                            for (int j = 0; j < nrowcols; ++j) {
                                float[] contw;
                                Node colnode = columns.item(j);
                                if (colnode.getNodeType() != 1) continue;
                                CSSElement col = (CSSElement)colnode;
                                style = (ComputedCSSStyle)elm.getOwnerDocument().getStyleSheet().getComputedStyle(col, null);
                                if (!"table-cell".equalsIgnoreCase(style.getPropertyValue("display"))) continue;
                                int colspan = 1;
                                String colspanStr = col.getAttribute("colspan");
                                if (colspanStr.length() != 0) {
                                    colspan = Integer.parseInt(colspanStr);
                                }
                                if ((contw = this.computeChildContentWidth(col, colspan, style, unitType))[0] > maxrcw[k]) {
                                    maxrcw[k] = contw[0];
                                }
                                if (contw[1] > minrcw[k]) {
                                    minrcw[k] = contw[1];
                                }
                                k += colspan;
                            }
                        }
                        mincw = maxRowSpacing += box.getBorderLeftWidth() + box.getBorderRightWidth() + box.getMarginLeft() + box.getMarginRight() + box.getPaddingLeft() + box.getPaddingRight();
                        maxcw = maxRowSpacing;
                        for (int i = 0; i < ncol; ++i) {
                            mincw += minrcw[i];
                            maxcw += maxrcw[i];
                        }
                        box.colwidth = new float[ncol];
                        StyleValue cssval = style.getCSSValue("width");
                        if (cssval != null && cssval.getCssValueType() == 1 && !SimpleBoxModel.isPrimitiveAutoLength((CSSPrimitiveValue2)((Object)cssval))) break block23;
                        if (!(capmin < box.getWidth()) || !(maxcw < box.getWidth())) break block24;
                        if (maxcw > capmin) {
                            box.width = maxcw;
                            for (int i = 0; i < ncol; ++i) {
                                box.colwidth[i] = maxrcw[i];
                            }
                        } else {
                            box.width = capmin;
                            float factor = capmin / maxcw;
                            for (int i = 0; i < ncol; ++i) {
                                box.colwidth[i] = maxrcw[i] * factor;
                            }
                        }
                        break block25;
                    }
                    unset = true;
                    if (mincw > box.width) {
                        box.width = mincw;
                        for (int i = 0; i < ncol; ++i) {
                            box.colwidth[i] = minrcw[i];
                        }
                        unset = false;
                    }
                    if (!(capmin > box.width)) break block26;
                    float factor = capmin / box.width;
                    box.width = capmin;
                    int i = 0;
                    while (i < ncol) {
                        int n = i++;
                        box.colwidth[n] = box.colwidth[n] * factor;
                    }
                    break block25;
                }
                if (!unset) break block25;
                for (int i = 0; i < ncol; ++i) {
                    box.colwidth[i] = maxrcw[i];
                }
                BoxModelHelper.shrinkTo(box, minrcw, mincw, maxcw, box.width);
                float width = 0.0f;
                for (int i = 0; i < ncol; ++i) {
                    width += box.colwidth[i];
                }
                box.width = width;
                break block25;
            }
            if (mincw > box.width) {
                box.width = mincw;
                for (int i = 0; i < ncol; ++i) {
                    box.colwidth[i] = minrcw[i];
                }
            } else {
                float factor = box.width / mincw;
                for (int i = 0; i < ncol; ++i) {
                    box.colwidth[i] = minrcw[i] * factor;
                }
            }
            if (capmin > box.width) {
                float factor = capmin / box.width;
                box.width = capmin;
                int i = 0;
                while (i < ncol) {
                    int n = i++;
                    box.colwidth[n] = box.colwidth[n] * factor;
                }
            }
        }
    }

    private float computeCapmin(short unitType) {
        CSSCanvas canvas = this.getComputedStyle().getOwnerNode().getOwnerDocument().getCanvas();
        ComputedCSSStyle style = this.getComputedStyle();
        CSSElement tbl = style.getOwnerNode();
        NodeList nlist = tbl.getElementsByTagName("caption");
        float capmin = 0.0f;
        for (int i = 0; i < nlist.getLength(); ++i) {
            CSSElement elm = (CSSElement)nlist.item(i);
            NodeList chldlist = elm.getChildNodes();
            for (int j = 0; j < chldlist.getLength(); ++j) {
                String text;
                Node chldnode = chldlist.item(j);
                if (chldnode.getNodeType() == 1) {
                    CSSElement col = (CSSElement)chldnode;
                    style = (ComputedCSSStyle)col.getOwnerDocument().getStyleSheet().getComputedStyle(col, null);
                    if (!"inline".equalsIgnoreCase(style.getDisplay())) {
                        throw new DOMException(9, "Only inline elements are supported in caption");
                    }
                    text = chldnode.getTextContent();
                } else {
                    text = chldnode.getNodeType() == 3 || chldnode.getNodeType() == 4 ? chldnode.getTextContent() : null;
                }
                float minw = 0.0f;
                if (text != null) {
                    text = BoxModelHelper.contractSpaces(text.trim());
                    minw = canvas != null ? NumberValue.floatValueConversion(canvas.stringWidth(text, style), (short)9, unitType) : BoxModelHelper.computeNodeMinimumWidth(text, style, unitType);
                }
                if (!(minw > capmin)) continue;
                capmin = minw;
            }
        }
        return capmin;
    }

    private float[] computeChildContentWidth(CSSElement col, int colspan, ComputedCSSStyle style, short unitType) {
        float[] contw = new float[]{0.0f, 0.0f};
        NodeList nlist = col.getChildNodes();
        int sz = nlist.getLength();
        for (int i = 0; i < sz; ++i) {
            Node node = nlist.item(i);
            if (node.getNodeType() == 3) {
                float[] nodew = this.computeTextWidth(node.getTextContent(), colspan, style, unitType);
                contw[0] = contw[0] + nodew[0];
                contw[1] = contw[1] + nodew[1];
                continue;
            }
            if (node.getNodeType() != 1) continue;
            CSSElement elm = (CSSElement)node;
            style = (ComputedCSSStyle)elm.getOwnerDocument().getStyleSheet().getComputedStyle(elm, null);
            float width = this.computeWidth(style, unitType);
            contw[0] = contw[0] + width;
            contw[1] = contw[1] + width;
        }
        return contw;
    }

    private float[] computeTextWidth(String text, int colspan, ComputedCSSStyle style, short unitType) {
        float[] contw = new float[]{0.0f, 0.0f};
        text = BoxModelHelper.contractSpaces(text.trim());
        CSSCanvas canvas = this.getComputedStyle().getOwnerNode().getOwnerDocument().getCanvas();
        contw[0] = canvas != null ? NumberValue.floatValueConversion(canvas.stringWidth(text, style), (short)9, unitType) : BoxModelHelper.computeTextWidth(text, style, unitType);
        BoxValues colbox = style.getBoxValues(unitType);
        float spacing = colbox.getBorderLeftWidth() + colbox.getBorderRightWidth() + colbox.getMarginLeft() + colbox.getMarginRight() + colbox.getPaddingLeft() + colbox.getPaddingRight();
        contw[0] = contw[0] + spacing;
        contw[1] = canvas != null ? BoxModelHelper.computeNodeMinimumWidth(text, style, canvas, unitType) / (float)colspan + spacing : BoxModelHelper.computeNodeMinimumWidth(text, style, unitType) / (float)colspan + spacing;
        return contw;
    }

    private void computeTableCellBox(MyBoxValues colbox, short unitType) {
        this.computeSharedBoxValues(colbox, unitType);
        this.computeInlineBox(colbox, unitType);
    }

    private float deviceDocumentWidth(String failureReason, String value) throws StyleDatabaseRequiredException {
        Viewport viewport;
        CSSCanvas canvas;
        StyleDatabase sdb = this.getStyleDatabase();
        Document doc = this.getComputedStyle().getOwnerNode().getOwnerDocument();
        if (doc != null && (canvas = doc.getCanvas()) != null && (viewport = canvas.getViewport()) != null) {
            float fv = viewport.getViewportWidth();
            return NumberValue.floatValueConversion(fv, sdb.getNaturalUnit(), (short)9);
        }
        if (sdb == null) {
            StyleDatabaseRequiredException pve = new StyleDatabaseRequiredException("No style database, " + failureReason);
            pve.setValueText(value);
            throw pve;
        }
        return NumberValue.floatValueConversion(sdb.getDeviceWidth(), sdb.getNaturalUnit(), (short)9);
    }

    private float computeMarginNumberValue(ComputedCSSStyle styledecl, String propertyName, CSSPrimitiveValue cssval, short unitType) throws StyleDatabaseRequiredException {
        float fv;
        try {
            fv = this.floatValue(styledecl, propertyName, cssval, unitType, true);
            if (fv < 0.0f) {
                fv = 0.0f;
            }
        }
        catch (DOMException e) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Expected number, found " + cssval.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue(propertyName, ex);
            fv = 0.0f;
        }
        return fv;
    }

    private float floatValue(ComputedCSSStyle styledecl, String propertyName, CSSPrimitiveValue cssval, short unitType, boolean useDeviceDocumentWidth) throws DOMException {
        short declType;
        if (unitType < 0) {
            if (this.getStyleDatabase() == null) {
                StyleDatabaseRequiredException sdex = new StyleDatabaseRequiredException("Requested natural unit, but no style database was set.");
                sdex.setValueText(cssval.getCssText());
                throw sdex;
            }
            unitType = this.getStyleDatabase().getNaturalUnit();
        }
        float fv = (declType = cssval.getPrimitiveType()) == 2 ? this.percentageValue(styledecl, cssval, unitType, useDeviceDocumentWidth) : (declType == 101 ? this.calcValue(styledecl, propertyName, (ExpressionValue)cssval, unitType, useDeviceDocumentWidth) : (declType == 127 ? this.functionValue(styledecl, propertyName, (CSSFunctionValue)cssval, unitType, useDeviceDocumentWidth) : cssval.getFloatValue(unitType)));
        return fv;
    }

    private float percentageValue(ComputedCSSStyle styledecl, CSSPrimitiveValue cssval, short unitType, boolean useDeviceDocumentWidth) {
        if ((styledecl = SimpleBoxModel.findContainingBlockStyle(styledecl)) == null) {
            if (useDeviceDocumentWidth) {
                return this.deviceDocumentWidth("no enclosing block, and value is percentage.", cssval.getCssText()) * cssval.getFloatValue((short)2) / 100.0f;
            }
            this.getComputedStyle().getStyleDeclarationErrorHandler().noContainingBlock(this.getComputedStyle().getDisplay(), this.getComputedStyle().getOwnerNode());
            return 0.0f;
        }
        return this.computeWidth(styledecl, unitType) * cssval.getFloatValue((short)2) / 100.0f;
    }

    private static ComputedCSSStyle findContainingBlockStyle(ComputedCSSStyle styledecl) {
        String position = styledecl.getPropertyValue("position");
        if ("fixed".equalsIgnoreCase(position)) {
            return null;
        }
        if ("absolute".equalsIgnoreCase(position)) {
            throw new DOMException(9, "position: absolute is not supported");
        }
        String display = styledecl.getPropertyValue("display");
        if ("table-cell".equalsIgnoreCase(display)) {
            while ((styledecl = styledecl.getParentComputedStyle()) != null && !"table".equalsIgnoreCase(display = styledecl.getPropertyValue("display"))) {
            }
        } else {
            while ((styledecl = styledecl.getParentComputedStyle()) != null) {
                display = styledecl.getPropertyValue("display");
                if (!"block".equals(display = display.toLowerCase(Locale.ROOT)) && !"list-item".equals(display) && !"table".equals(display) && !display.startsWith("table-")) continue;
            }
        }
        return styledecl;
    }

    private float calcValue(ComputedCSSStyle styledecl, String propertyName, ExpressionValue cssCalc, short unitType, boolean useDeviceDocumentWidth) {
        BoxEvaluator ev = new BoxEvaluator(styledecl, propertyName, useDeviceDocumentWidth);
        ExtendedCSSPrimitiveValue result = ev.evaluateExpression(cssCalc);
        if (result.isNegativeNumber()) {
            return 0.0f;
        }
        return result.getFloatValue(unitType);
    }

    private float functionValue(ComputedCSSStyle styledecl, String propertyName, CSSFunctionValue function, short unitType, boolean useDeviceDocumentWidth) {
        BoxEvaluator ev = new BoxEvaluator(styledecl, propertyName, useDeviceDocumentWidth);
        return ev.evaluateFunction(function).getFloatValue(unitType);
    }

    private float computeWidth(ComputedCSSStyle styledecl, short unitType) throws StyleDatabaseRequiredException {
        CSSPrimitiveValue2 primi;
        StyleValue cssval = styledecl.getCSSValue("width");
        if (cssval == null || cssval.getCssValueType() != 1 || SimpleBoxModel.isPrimitiveAutoLength(primi = (CSSPrimitiveValue2)((Object)cssval))) {
            float contBlockWidth;
            StyleValue cssMarginLeft = styledecl.getCSSValue("margin-left");
            StyleValue cssBorderLeftWidth = styledecl.getCSSValue("border-left-width");
            StyleValue cssMarginRight = styledecl.getCSSValue("margin-right");
            StyleValue cssBorderRightWidth = styledecl.getCSSValue("border-right-width");
            float marginLeft = this.findWidthautoBoxProperty(styledecl, "margin-left", cssMarginLeft, unitType);
            float borderLeftWidth = this.findBorderWidthProperty(styledecl, "border-left-width", cssBorderLeftWidth, unitType);
            float paddingLeft = this.computePaddingSubproperty(styledecl, "padding-left", unitType);
            float paddingRight = this.computePaddingSubproperty(styledecl, "padding-right", unitType);
            float borderRightWidth = this.findBorderWidthProperty(styledecl, "border-right-width", cssBorderRightWidth, unitType);
            float marginRight = this.findWidthautoBoxProperty(styledecl, "margin-right", cssMarginRight, unitType);
            ComputedCSSStyle contblockStyledecl = SimpleBoxModel.findContainingBlockStyle(styledecl);
            if (contblockStyledecl == null) {
                contBlockWidth = this.deviceDocumentWidth("width is auto, and cannot find top block width.", "auto");
            } else {
                String display = contblockStyledecl.getPropertyValue("display").toLowerCase(Locale.ROOT);
                if ("table".equals(display) || display.startsWith("table-")) {
                    cssval = contblockStyledecl.getCSSValue("width");
                    if (cssval == null || cssval.getCssValueType() != 1 || SimpleBoxModel.isPrimitiveAutoLength(primi = (CSSPrimitiveValue2)((Object)cssval)) || primi.getPrimitiveType() == 2) {
                        throw new DOMException(9, "Automatic tables not supported by this box model");
                    }
                    contBlockWidth = this.computeNonAutoWidth(contblockStyledecl, primi, unitType);
                } else {
                    contBlockWidth = this.computeWidth(contblockStyledecl, unitType);
                }
            }
            return contBlockWidth - (marginLeft + marginRight + borderLeftWidth + borderRightWidth + paddingLeft + paddingRight);
        }
        return this.computeNonAutoWidth(styledecl, primi, unitType);
    }

    private float computeNonAutoWidth(ComputedCSSStyle styledecl, CSSPrimitiveValue cssWidth, short unitType) throws DOMException, StyleDatabaseRequiredException {
        float fv;
        try {
            fv = this.floatValue(styledecl, "width", cssWidth, unitType, true);
        }
        catch (DOMException e) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Expected number, found " + cssWidth.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue("width", ex);
            fv = 0.0f;
        }
        return fv;
    }

    private float findWidthautoBoxProperty(ComputedCSSStyle styledecl, String propertyName, CSSValue cssval, short unitType) throws StyleDatabaseRequiredException, DOMException {
        if (cssval != null && !SimpleBoxModel.isAutoLength(cssval)) {
            while (cssval.getCssValueType() == 0) {
                if ((styledecl = SimpleBoxModel.findContainingBlockStyle(styledecl)) != null) {
                    cssval = styledecl.getCSSValue(propertyName);
                    continue;
                }
                cssval = null;
                break;
            }
            if (cssval != null) {
                if (cssval.getCssValueType() != 1) {
                    throw new DOMException(12, "Unexpected width value: " + cssval.getCssText());
                }
                CSSPrimitiveValue cssprim = (CSSPrimitiveValue)cssval;
                return this.findNumericBoxProperty(styledecl, propertyName, cssprim, unitType);
            }
        }
        return 0.0f;
    }

    private static boolean isAutoLength(CSSValue cssval) {
        return cssval.getCssValueType() == 1 && SimpleBoxModel.isPrimitiveAutoLength((CSSPrimitiveValue2)cssval);
    }

    private float findBorderWidthProperty(ComputedCSSStyle styledecl, String propertyName, CSSValue cssval, short unitType) throws StyleDatabaseRequiredException, DOMException {
        if (cssval != null) {
            while (cssval.getCssValueType() == 0) {
                if ((styledecl = SimpleBoxModel.findContainingBlockStyle(styledecl)) != null) {
                    cssval = styledecl.getCSSValue(propertyName);
                    continue;
                }
                cssval = null;
                break;
            }
            if (cssval != null) {
                float fval;
                if (cssval.getCssValueType() != 1) {
                    throw new DOMException(12, "Unexpected border-width value: " + cssval.getCssText());
                }
                CSSPrimitiveValue cssprim = (CSSPrimitiveValue)cssval;
                if (cssprim.getPrimitiveType() == 21) {
                    short declType;
                    if (this.getStyleDatabase() == null) {
                        if (this.getComplianceMode() != CSSDocument.ComplianceMode.QUIRKS) {
                            StyleDatabaseRequiredException pve = new StyleDatabaseRequiredException("No style database, and " + propertyName + " value is an identifier.");
                            pve.setValueText(cssval.getCssText());
                            throw pve;
                        }
                        float sz = this.getComputedStyle().getComputedFontSize();
                        String sv = cssprim.getStringValue();
                        fval = sv.equalsIgnoreCase("thin") ? (float)Math.floor(1.0 + (double)sz * 0.05) : (sv.equalsIgnoreCase("thick") ? (float)Math.floor(4.0 + (double)sz * 0.15) : (float)Math.floor(2.0 + (double)sz * 0.1));
                        declType = 9;
                    } else {
                        declType = this.getStyleDatabase().getNaturalUnit();
                        fval = this.getStyleDatabase().getWidthSize(cssprim.getStringValue(), styledecl.getComputedFontSize());
                    }
                    if (unitType != declType) {
                        fval = NumberValue.floatValueConversion(fval, declType, unitType);
                    }
                } else {
                    fval = this.findNumericBoxProperty(styledecl, propertyName, cssprim, unitType);
                }
                return fval;
            }
        }
        return 0.0f;
    }

    private CSSDocument.ComplianceMode getComplianceMode() {
        CSSDocument document;
        CSSElement node = this.getComputedStyle().getOwnerNode();
        if (node != null && (document = (CSSDocument)node.getOwnerDocument()) != null) {
            return document.getComplianceMode();
        }
        return CSSDocument.ComplianceMode.STRICT;
    }

    private float findNumericBoxProperty(ComputedCSSStyle styledecl, String propertyName, CSSPrimitiveValue cssprim, short unitType) throws StyleDatabaseRequiredException {
        float fv;
        try {
            fv = this.floatValue(styledecl, propertyName, cssprim, unitType, true);
        }
        catch (DOMException e) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Expected number, found " + cssprim.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue(propertyName, ex);
            fv = 0.0f;
        }
        return fv;
    }

    private float computePaddingSubproperty(ComputedCSSStyle styledecl, String propertyName, short unitType) throws StyleDatabaseRequiredException {
        float fv;
        StyleValue cssval = styledecl.getCSSValue(propertyName);
        while (cssval != null && cssval.getCssValueType() == 0) {
            if ((styledecl = styledecl.getParentComputedStyle()) != null) {
                cssval = styledecl.getCSSValue(propertyName);
                continue;
            }
            this.getComputedStyle().getStyleDeclarationErrorHandler().noContainingBlock(this.getComputedStyle().getDisplay(), this.getComputedStyle().getOwnerNode());
            return 0.0f;
        }
        if (cssval == null) {
            return 0.0f;
        }
        if (cssval.getCssValueType() != 1) {
            throw new DOMException(12, "Unexpected padding value: " + cssval.getCssText());
        }
        CSSPrimitiveValue csspri = (CSSPrimitiveValue)((Object)cssval);
        try {
            fv = this.floatValue(styledecl, propertyName, csspri, unitType, false);
            if (fv < 0.0f) {
                fv = 0.0f;
            }
        }
        catch (DOMException e) {
            CSSPropertyValueException ex = new CSSPropertyValueException("Expected number, found " + csspri.getCssText());
            styledecl.getStyleDeclarationErrorHandler().wrongValue(propertyName, ex);
            fv = 0.0f;
        }
        return fv;
    }

    static class MyBoxValues
    implements BoxValues {
        float marginTop = 0.0f;
        float marginRight = 0.0f;
        float marginBottom = 0.0f;
        float marginLeft = 0.0f;
        float paddingTop = 0.0f;
        float paddingRight = 0.0f;
        float paddingBottom = 0.0f;
        float paddingLeft = 0.0f;
        float borderTopWidth = 0.0f;
        float borderBottomWidth = 0.0f;
        float borderRightWidth = 0.0f;
        float borderLeftWidth = 0.0f;
        float width = Float.MIN_VALUE;

        MyBoxValues() {
        }

        @Override
        public float getMarginTop() {
            return this.marginTop;
        }

        @Override
        public float getMarginRight() {
            return this.marginRight;
        }

        @Override
        public float getMarginBottom() {
            return this.marginBottom;
        }

        @Override
        public float getMarginLeft() {
            return this.marginLeft;
        }

        @Override
        public float getPaddingTop() {
            return this.paddingTop;
        }

        @Override
        public float getPaddingRight() {
            return this.paddingRight;
        }

        @Override
        public float getPaddingBottom() {
            return this.paddingBottom;
        }

        @Override
        public float getPaddingLeft() {
            return this.paddingLeft;
        }

        @Override
        public float getBorderTopWidth() {
            return this.borderTopWidth;
        }

        @Override
        public float getBorderRightWidth() {
            return this.borderRightWidth;
        }

        @Override
        public float getBorderBottomWidth() {
            return this.borderBottomWidth;
        }

        @Override
        public float getBorderLeftWidth() {
            return this.borderLeftWidth;
        }

        @Override
        public float getWidth() {
            return this.width;
        }
    }

    static class MyTableBoxValues
    extends MyBoxValues
    implements BoxValues.TableBoxValues {
        float[] colwidth;

        MyTableBoxValues() {
        }

        @Override
        public float[] getColumnsContentWidth() {
            return this.colwidth;
        }
    }

    static class MyTableItemBoxValues
    extends MyBoxValues {
        MyTableItemBoxValues() {
        }

        @Override
        public float getWidth() {
            throw new DOMException(9, "Operation not supported by this box model. Please compute box for table and cast to TableBoxValues.");
        }
    }

    private class BoxEvaluator
    extends Evaluator {
        private final ComputedCSSStyle styledecl;
        private final String propertyName;
        private final boolean useDeviceDocumentWidth;

        private BoxEvaluator(ComputedCSSStyle styledecl, String propertyName, boolean useDeviceDocumentWidth) {
            this.styledecl = styledecl;
            this.propertyName = propertyName;
            this.useDeviceDocumentWidth = useDeviceDocumentWidth;
        }

        @Override
        protected ExtendedCSSPrimitiveValue absoluteValue(ExtendedCSSPrimitiveValue partialValue) {
            return this.styledecl.absolutePrimitiveValue(this.propertyName, (PrimitiveValue)partialValue, false);
        }

        @Override
        protected float percentage(ExtendedCSSPrimitiveValue value, short unitType) throws DOMException {
            return SimpleBoxModel.this.percentageValue(this.styledecl, value, unitType, this.useDeviceDocumentWidth);
        }
    }
}

