/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSSupportsRule;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.parser.BooleanCondition;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.DeclarationCondition;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;

public class SupportsRule
extends GroupingRule
implements CSSSupportsRule {
    private BooleanCondition condition = null;

    protected SupportsRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)12, origin);
    }

    SupportsRule(AbstractCSSStyleSheet parentSheet, SupportsRule copyfrom) {
        super(parentSheet, copyfrom);
        this.condition = copyfrom.getCondition();
    }

    @Override
    public String getConditionText() {
        return this.condition != null ? this.condition.toString() : "";
    }

    @Override
    public void setConditionText(String conditionText) throws DOMException {
        this.parseConditionText(conditionText);
    }

    private void parseConditionText(String conditionText) throws DOMException {
        CSSParser parser;
        try {
            parser = (CSSParser)this.createSACParser();
        }
        catch (ClassCastException e) {
            parser = new CSSParser();
        }
        try {
            this.condition = parser.parseSupportsCondition(conditionText, null);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public BooleanCondition getCondition() {
        return this.condition;
    }

    @Override
    public boolean supports(StyleDatabase styleDatabase) {
        return this.supports(this.condition, styleDatabase);
    }

    private boolean supports(BooleanCondition condition, StyleDatabase styleDatabase) {
        switch (condition.getType()) {
            case PREDICATE: {
                DeclarationCondition declCond = (DeclarationCondition)((Object)condition);
                return declCond.isParsable() && styleDatabase.supports(declCond.getName(), declCond.getValue());
            }
            case AND: {
                Iterator<BooleanCondition> it = condition.getSubConditions().iterator();
                while (it.hasNext()) {
                    if (this.supports(it.next(), styleDatabase)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                return this.supports(condition.getNestedCondition(), styleDatabase);
            }
            case OR: {
                Iterator<BooleanCondition> it = condition.getSubConditions().iterator();
                while (it.hasNext()) {
                    if (!this.supports(it.next(), styleDatabase)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getCssRules().getLength() * 32);
        try {
            this.writeCssText(sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.condition != null || !this.getCssRules().isEmpty()) {
            StringBuilder sb = new StringBuilder(30 + this.getCssRules().getLength() * 20);
            sb.append("@supports");
            if (this.condition != null) {
                this.condition.appendMinifiedText(sb);
            }
            sb.append('{');
            Iterator it = this.getCssRules().iterator();
            while (it.hasNext()) {
                sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
            }
            sb.append('}');
            return sb.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.condition != null || !this.getCssRules().isEmpty()) {
            context.startRule(wri);
            wri.write("@supports ");
            wri.write(this.getConditionText());
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            this.getCssRules().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endRuleList(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri);
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int lm1 = cssText.length() - 1;
        int idx = cssText.indexOf(123);
        if (idx == -1 || lm1 < 16 || cssText.charAt(lm1) != '}') {
            throw new DOMException(12, "Invalid @supports rule: " + cssText);
        }
        CharSequence atkeyword = cssText.subSequence(0, 9);
        if (!ParseHelper.startsWithIgnoreCase(atkeyword, "@supports")) {
            throw new DOMException(13, "Not a @supports rule: " + cssText);
        }
        AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
        if (parentSS == null) {
            throw new DOMException(11, "This rule must be added to a sheet first");
        }
        AbstractCSSStyleSheet css = parentSS.getStyleSheetFactory().createRuleStyleSheet(this, null, null);
        StringReader re = new StringReader(cssText.substring(idx + 1, lm1));
        InputSource source = new InputSource((Reader)re);
        try {
            css.parseStyleSheet(source);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        this.parseConditionText(cssText.substring(9, idx).trim());
        this.cssRules.clear();
        this.cssRules.addAll(css.getCssRules());
        for (AbstractCSSRule rule : this.cssRules) {
            rule.setParentRule(this);
        }
        if (css.hasRuleErrorsOrWarnings()) {
            parentSS.getErrorHandler().mergeState(css.getErrorHandler());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportsRule other = (SupportsRule)obj;
        return !(this.condition == null ? other.condition != null : !this.condition.equals(other.condition));
    }

    @Override
    public SupportsRule clone(AbstractCSSStyleSheet parentSheet) {
        return new SupportsRule(parentSheet, this);
    }
}

