/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import java.util.Locale;
import org.w3c.css.sac.SelectorList;

public abstract class AnBExpression {
    private SelectorList selectorList = null;
    private int offset = 0;
    private int step = 0;
    private boolean haskeyword = false;

    protected AnBExpression() {
    }

    public int getStep() {
        return this.step;
    }

    public int getOffset() {
        return this.offset;
    }

    public SelectorList getSelectorList() {
        return this.selectorList;
    }

    public boolean isKeyword() {
        return this.haskeyword;
    }

    public void parse(String expression) {
        String s = expression;
        int selIdx = s.indexOf(" of ");
        if (selIdx != -1) {
            this.selectorList = this.parseSelector(s.substring(selIdx + 4).trim());
            s = s.substring(0, selIdx);
        }
        s = s.trim().toLowerCase(Locale.ROOT);
        this.offset = 0;
        if (s.equals("even")) {
            this.step = 2;
            this.haskeyword = true;
            return;
        }
        if (s.equals("odd")) {
            this.step = 2;
            this.offset = 1;
            this.haskeyword = true;
            return;
        }
        int nidx = s.indexOf(110);
        int lm1 = s.length() - 1;
        if (lm1 == -1) {
            this.reportError(expression);
        }
        if (nidx != -1) {
            if (lm1 == nidx + 1) {
                this.reportError(expression);
            } else {
                if (lm1 != nidx) {
                    String offstr = s.substring(nidx + 1);
                    if ((offstr = AnBExpression.removeSpacesBeforeFirstDigit(offstr)) == null) {
                        this.reportError(expression);
                    }
                    try {
                        this.offset = Integer.parseInt(offstr);
                    }
                    catch (NumberFormatException e) {
                        this.reportError(expression);
                    }
                }
                if (nidx == 0) {
                    this.step = 1;
                } else if (nidx == 1) {
                    char c = s.charAt(0);
                    if (c == '+') {
                        this.step = 1;
                    } else if (c == '-') {
                        this.step = -1;
                    } else if (Character.isDigit(c)) {
                        this.step = Integer.parseInt(s.substring(0, nidx));
                    } else {
                        this.reportError(expression);
                    }
                } else {
                    try {
                        this.step = Integer.parseInt(s.substring(0, nidx));
                    }
                    catch (NumberFormatException e) {
                        this.reportError(expression);
                    }
                }
            }
        } else {
            this.step = 0;
            try {
                this.offset = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.reportError(expression);
            }
        }
    }

    private static String removeSpacesBeforeFirstDigit(String numstr) {
        boolean negative = false;
        boolean foundSpace = false;
        boolean foundSign = false;
        int len = numstr.length();
        for (int i = 0; i < len; ++i) {
            char c = numstr.charAt(i);
            if (c == '-') {
                if (foundSign) break;
                foundSign = true;
                negative = true;
                continue;
            }
            if (c == ' ') {
                foundSpace = true;
                continue;
            }
            if (Character.isDigit(c)) {
                if (!foundSpace) {
                    return numstr;
                }
                if (negative) {
                    return "-" + numstr.subSequence(i, len);
                }
                if (!foundSign) continue;
                return numstr.substring(i, len);
            }
            if (c != '+' || foundSign) break;
            foundSign = true;
        }
        return null;
    }

    void reportError(String expression) {
        throw new IllegalArgumentException("Wrong expression " + expression);
    }

    protected abstract SelectorList parseSelector(String var1);
}

