/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.agent.AgentUtil;
import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.ExtendedCSSRule;
import io.sf.carte.doc.style.css.nsac.AttributeCondition2;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit2;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.om.SupportsConditionFactory;
import io.sf.carte.doc.style.css.parser.AnBExpression;
import io.sf.carte.doc.style.css.parser.BooleanCondition;
import io.sf.carte.doc.style.css.parser.BooleanConditionFactory;
import io.sf.carte.doc.style.css.parser.DeclarationCondition;
import io.sf.carte.doc.style.css.parser.FontFeatureValuesHandler;
import io.sf.carte.doc.style.css.parser.KeyframesHandler;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MediaConditionFactory;
import io.sf.carte.doc.style.css.parser.MediaFeaturePredicate;
import io.sf.carte.doc.style.css.parser.MediaQueryDatabase;
import io.sf.carte.doc.style.css.parser.MediaQueryHandler;
import io.sf.carte.doc.style.css.parser.NSACSelectorFactory;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SelectorListImpl;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler;
import io.sf.carte.uparser.TokenProducer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.DOMException;

public class CSSParser
implements Parser2 {
    private DocumentHandler handler = null;
    private ErrorHandler errorHandler = null;
    private final EnumSet<Parser2.Flag> parserFlags = EnumSet.noneOf(Parser2.Flag.class);

    public void setLocale(Locale locale) throws CSSException {
        if (!Locale.ROOT.equals(locale)) {
            throw new CSSException("Locale not supported");
        }
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.handler = handler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        throw new IllegalArgumentException();
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        throw new IllegalArgumentException();
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void setFlag(Parser2.Flag flag) {
        this.parserFlags.add(flag);
    }

    @Override
    public void unsetFlag(Parser2.Flag flag) {
        this.parserFlags.remove((Object)flag);
    }

    public void parseStyleSheet(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        String[] opening = new String[]{"/*", "<!--"};
        String[] closing = new String[]{"*/", "-->"};
        Reader re = source.getCharacterStream();
        if (re == null) {
            InputStream is = source.getByteStream();
            if (is == null) {
                String uri = source.getURI();
                if (uri == null) {
                    throw new IllegalArgumentException("Null character stream");
                }
                this.parseStyleSheet(uri);
                return;
            }
            String charset = source.getEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            re = new InputStreamReader(is, charset);
        }
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        SheetTokenHandler handler = new SheetTokenHandler(source, null);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.setAcceptEofEndingQuoted(true);
        this.handler.startDocument(source);
        tp.parseMultiComment(re, opening, closing);
    }

    public void parseStyleSheet(String uri) throws CSSException, IOException {
        URL url = new URL(uri);
        URLConnection ucon = url.openConnection();
        ucon.connect();
        InputStream is = ucon.getInputStream();
        is = new BufferedInputStream(is);
        String contentEncoding = ucon.getContentEncoding();
        String conType = ucon.getContentType();
        Reader re = AgentUtil.inputStreamToReader(is, conType, contentEncoding, "utf-8");
        InputSource source = new InputSource(re);
        source.setURI(uri);
        SheetTokenHandler handler = new SheetTokenHandler(source, null);
        int[] allowInWords = new int[]{45, 95};
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.setAcceptEofEndingQuoted(true);
        this.handler.startDocument(source);
        try {
            tp.parse(re, "/*", "*/");
        }
        catch (IOException e) {
            try {
                re.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        re.close();
    }

    public void parseStyleDeclaration(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationTokenHandler handler = new DeclarationTokenHandler(source, ShorthandDatabase.getInstance());
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.parse(this.getReaderFromSource(source), "/*", "*/");
    }

    private Reader getReaderFromSource(InputSource source) throws IOException {
        Reader re = source.getCharacterStream();
        if (re == null) {
            InputStream is = source.getByteStream();
            if (is != null) {
                String charset = source.getEncoding();
                if (charset == null) {
                    charset = "utf-8";
                }
                re = new InputStreamReader(is, charset);
            } else {
                String uri = source.getURI();
                if (uri != null) {
                    URL url = new URL(uri);
                    URLConnection con = url.openConnection();
                    con.connect();
                    is = con.getInputStream();
                    is = new BufferedInputStream(is);
                    String contentEncoding = con.getContentEncoding();
                    String conType = con.getContentType();
                    String charset = source.getEncoding();
                    if (charset == null) {
                        charset = "utf-8";
                    }
                    re = AgentUtil.inputStreamToReader(is, conType, contentEncoding, charset);
                }
            }
        }
        return re;
    }

    public void parseDeclarationRule(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationRuleTokenHandler handler = new DeclarationRuleTokenHandler(source, ShorthandDatabase.getInstance());
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        Reader re = this.getReaderFromSource(source);
        tp.parse(re, "/*", "*/");
    }

    public void parseRule(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler handler = new RuleTokenHandler(source, null);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        Reader re = this.getReaderFromSource(source);
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        tp.parse(re, "/*", "*/");
    }

    @Override
    public void parseRule(InputSource source, Parser2.NamespaceMap nsmap) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleTokenHandler handler = new RuleTokenHandler(source, nsmap);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        Reader re = this.getReaderFromSource(source);
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        tp.parse(re, "/*", "*/");
    }

    public void parseKeyFramesBody(String blockList) throws CSSParseException {
        int[] allowInWords = new int[]{45, 95};
        KeyFrameBlockListTH handler = new KeyFrameBlockListTH(0, blockList.length());
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.parse(blockList, "/*", "*/");
    }

    public void parseFontFeatureValuesBody(String blockList) {
        int[] allowInWords = new int[]{45, 95};
        FontFeatureValuesTH handler = new FontFeatureValuesTH(0, blockList.length());
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.parse(blockList, "/*", "*/");
    }

    public BooleanCondition parseSupportsCondition(String conditionText, ExtendedCSSRule rule) throws CSSException {
        int[] allowInWords = new int[]{45, 46};
        SupportsTokenHandler handler = new SupportsTokenHandler(rule);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        try {
            tp.parse(conditionText, "/*", "*/");
        }
        catch (IndexOutOfBoundsException e) {
            throw new CSSException(1, "Nested conditions exceed limit", (Exception)e);
        }
        if (handler.errorCode == 0) {
            return handler.getCondition();
        }
        return null;
    }

    public void parseMediaQuery(String media, MediaConditionFactory condFactory, MediaQueryHandler mqhandler) throws CSSException {
        int[] allowInWords = new int[]{45, 46};
        MediaQueryTokenHandler handler = new MediaQueryTokenHandler(condFactory, mqhandler);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        mqhandler.startQuery();
        try {
            tp.parse(media, "/*", "*/");
        }
        catch (IndexOutOfBoundsException e) {
            throw new CSSException(1, "Nested queries exceed limit", (Exception)e);
        }
    }

    private ExtendedCSSPrimitiveValue parseMediaFeature(String stringValue) {
        PrimitiveValue value;
        try {
            value = new ValueFactory().parseMediaFeature(stringValue, this);
        }
        catch (RuntimeException e) {
            value = null;
        }
        return value;
    }

    private static boolean isKnownFeature(String string) {
        return string.startsWith("min-") || string.startsWith("max-") || MediaQueryDatabase.isMediaFeature(string) || string.startsWith("device-");
    }

    private static boolean isValidFeatureSyntax(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    public SelectorList parseSelectors(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        Reader re = this.getReaderFromSource(source);
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        SelectorTokenHandler handler = new SelectorTokenHandler(source, null);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.parse(re, "/*", "*/");
        return handler.getSelectorList();
    }

    public SelectorList parseSelectors(String seltext) throws CSSException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler();
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.parse(seltext, "/*", "*/");
        return handler.getSelectorList();
    }

    private SelectorList parseSelectors(String seltext, NSACSelectorFactory factory) throws CSSException {
        int[] allowInWords = new int[]{45, 95};
        SelectorTokenHandler handler = new SelectorTokenHandler(factory);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.parse(seltext);
        return handler.getSelectorList();
    }

    private SelectorList parseSelectorArgument(String seltext, NSACSelectorFactory factory) throws CSSException {
        int[] allowInWords = new int[]{45, 95};
        SelectorArgumentTokenHandler handler = new SelectorArgumentTokenHandler(factory);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.parse(seltext);
        return handler.getSelectorList();
    }

    public LexicalUnit2 parsePropertyValue(InputSource source) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        Reader re = this.getReaderFromSource(source);
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        PropertyTokenHandler handler = new PropertyTokenHandler(source);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.parse(re, "/*", "*/");
        return handler.getLexicalUnit();
    }

    public LexicalUnit2 parsePropertyValue(String propertyName, Reader reader) throws CSSException, IOException {
        int[] allowInWords = new int[]{45, 95};
        PropertyTokenHandler handler = new PropertyTokenHandler(propertyName);
        TokenProducer tp = new TokenProducer((TokenHandler)handler, allowInWords);
        tp.parse(reader, "/*", "*/");
        return handler.getLexicalUnit();
    }

    public boolean parsePriority(InputSource source) throws CSSException, IOException {
        Reader re = this.getReaderFromSource(source);
        if (re == null) {
            throw new IllegalArgumentException("Null character stream");
        }
        int cp = re.read();
        if (cp != -1) {
            int count = 0;
            StringBuilder buf = new StringBuilder(9);
            int parsingWord = 0;
            if (CSSParser.isNotSeparator(cp)) {
                buf.append(Character.toChars(cp));
                parsingWord = 1;
                count = 1;
            }
            while ((cp = re.read()) != -1 && parsingWord != 2) {
                if (CSSParser.isNotSeparator(cp)) {
                    buf.append(Character.toChars(cp));
                    count = (short)(count + 1);
                    if (count == 10) {
                        return false;
                    }
                    parsingWord = 1;
                    continue;
                }
                if (parsingWord != 1) continue;
                parsingWord = 2;
            }
            if ("important".equals(buf.toString().toLowerCase(Locale.ROOT))) {
                return true;
            }
        }
        return false;
    }

    static boolean bufferEndsWithEscapedCharOrWS(StringBuilder buffer) {
        int bufCp;
        int len = buffer.length();
        if (len != 0 && (ParseHelper.isHexCodePoint(bufCp = buffer.codePointAt(len - 1)) || bufCp == 32)) {
            for (int i = 2; i <= 6; ++i) {
                bufCp = buffer.codePointAt(len - i);
                if (ParseHelper.isHexCodePoint(bufCp)) continue;
                if (bufCp != 92) break;
                return true;
            }
        }
        return false;
    }

    private static boolean isNotSeparator(int cp) {
        return cp != 32 && cp != 9 && cp != 10 && cp != 12 && cp != 13;
    }

    static SACMediaList parseMediaList(String media) {
        return new MySACMediaList(media.split(","));
    }

    private static boolean bufferEndsWithEscapedChar(StringBuilder buffer) {
        int bufCp;
        int len = buffer.length();
        if (len != 0 && ParseHelper.isHexCodePoint(bufCp = buffer.codePointAt(len - 1))) {
            for (int i = 2; i <= 6; ++i) {
                bufCp = buffer.codePointAt(len - i);
                if (ParseHelper.isHexCodePoint(bufCp)) continue;
                if (bufCp != 92) break;
                return true;
            }
        }
        return false;
    }

    class SheetTokenHandler
    extends CSSTokenHandler {
        CSSTokenHandler contextHandler;
        private final DeclarationTokenHandler declarationHandler;
        private final SelectorTokenHandler selectorHandler;
        private String ruleFirstPart;
        private String ruleSecondPart;
        private String marginRule;
        private int curlyBracketDepth;
        private byte ruleType;
        private final byte MEDIA_RULE = 4;
        private final byte FONT_FACE_RULE = 5;
        private final byte PAGE_RULE = 6;
        private final byte MARGIN_RULE = 9;
        private byte stage;
        private boolean rulesFound;
        private SACMediaListWrapper medialist;

        SheetTokenHandler(InputSource source, Parser2.NamespaceMap nsMap) {
            super(source);
            this.ruleFirstPart = null;
            this.ruleSecondPart = null;
            this.marginRule = null;
            this.curlyBracketDepth = 0;
            this.ruleType = 0;
            this.MEDIA_RULE = (byte)4;
            this.FONT_FACE_RULE = (byte)5;
            this.PAGE_RULE = (byte)6;
            this.MARGIN_RULE = (byte)9;
            this.stage = 0;
            this.rulesFound = false;
            this.medialist = null;
            this.buffer = new StringBuilder(512);
            this.declarationHandler = new MyDeclarationTokenHandler(source);
            this.selectorHandler = new MySelectorTokenHandler(source, nsMap);
            this.contextHandler = this.selectorHandler;
        }

        int getCurlyBracketDepth() {
            return this.curlyBracketDepth;
        }

        @Override
        public void word(int index, CharSequence word) {
            if (this.contextHandler != null) {
                this.contextHandler.word(index, word);
            } else {
                if (this.prevcp == 64) {
                    if (this.stage == 0) {
                        if (ParseHelper.equalsIgnoreCase(word, "charset")) {
                            if (!this.rulesFound) {
                                this.stage = (byte)32;
                                this.buffer.setLength(0);
                            } else {
                                this.handleError(index - 1, (byte)33, "@charset must be the first rule");
                            }
                        } else if (ParseHelper.equalsIgnoreCase(word, "import")) {
                            this.stage = (byte)38;
                            this.buffer.setLength(0);
                        } else if (ParseHelper.equalsIgnoreCase(word, "namespace")) {
                            this.stage = (byte)34;
                            this.buffer.setLength(0);
                        } else if (ParseHelper.equalsIgnoreCase(word, "media")) {
                            this.ruleType = (byte)4;
                            this.stage = (byte)2;
                            this.buffer.setLength(0);
                        } else if (ParseHelper.equalsIgnoreCase(word, "font-face")) {
                            this.ruleType = (byte)5;
                            this.stage = (byte)2;
                            this.buffer.setLength(0);
                        } else if (ParseHelper.equalsIgnoreCase(word, "page")) {
                            this.ruleType = (byte)6;
                            this.stage = (byte)2;
                            this.buffer.setLength(0);
                        } else {
                            this.buffer.append(word);
                            this.stage = (byte)5;
                        }
                    } else if (this.stage == 2) {
                        String ruleName = word.toString().toLowerCase(Locale.ROOT);
                        if (this.ruleType == 6) {
                            if (this.isMarginRuleName(ruleName)) {
                                this.ruleType = (byte)9;
                                this.marginRule = ruleName;
                                CSSParser.this.handler.startPage(ruleName, null);
                                this.buffer.setLength(0);
                            } else {
                                this.handleError(index, (byte)9, "Expected margin rule, got " + word);
                            }
                        } else if (this.ruleType == 4 && "page".equals(ruleName)) {
                            this.ruleType = (byte)6;
                            this.stage = (byte)8;
                            this.buffer.setLength(0);
                        } else if (this.ruleType == 4 && "font-face".equals(ruleName)) {
                            this.ruleType = (byte)5;
                            this.stage = (byte)10;
                            this.buffer.setLength(0);
                        } else if (this.ruleType == 4 && "media".equals(ruleName)) {
                            this.buffer.setLength(0);
                        } else {
                            this.stage = (byte)7;
                            this.buffer.append(word);
                        }
                    } else {
                        this.buffer.append(word);
                    }
                } else if (this.ruleType == 6 && this.buffer.length() != 1 && this.ruleFirstPart != null) {
                    this.handleError(index, (byte)9, "Expecting pseudo-page, got " + word);
                } else {
                    this.buffer.append(word);
                }
                this.prevcp = 65;
            }
        }

        private boolean isMarginRuleName(String ruleName) {
            StringTokenizer st = new StringTokenizer(ruleName, "-");
            while (st.hasMoreElements()) {
                String s = st.nextToken();
                if ("top".equals(s) || "left".equals(s) || "center".equals(s) || "right".equals(s) || "corner".equals(s) || "bottom".equals(s) || "middle".equals(s)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void separator(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.separator(index, codepoint);
            } else {
                if (this.stage == 34) {
                    if (this.ruleFirstPart == null) {
                        if (this.buffer.length() != 0) {
                            this.ruleFirstPart = this.buffer.toString();
                            this.buffer.setLength(0);
                            this.stage = (byte)35;
                        }
                    } else {
                        this.stage = (byte)35;
                    }
                } else {
                    if (this.stage == 2 && this.ruleType == 6 || this.stage == 8) {
                        this.processBufferPageRule(index);
                        if (this.prevcp != 44) {
                            this.prevcp = 32;
                        }
                        return;
                    }
                    if (this.buffer.length() != 0 && (this.prevcp != 32 || this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(this.buffer))) {
                        this.buffer.append(' ');
                    }
                }
                this.prevcp = 32;
            }
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quoteCp) {
            if (this.contextHandler != null) {
                this.contextHandler.quoted(index, quoted, quoteCp);
            } else if (this.stage == 5 || this.stage == 7) {
                char c = (char)quoteCp;
                this.buffer.append(c).append(quoted).append(c);
            } else {
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = quoted.toString();
                    if (this.stage == 38) {
                        this.stage = (byte)40;
                    }
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = quoted.toString();
                } else {
                    this.buffer.append(quoted);
                }
                this.prevcp = 65;
            }
        }

        @Override
        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            this.quoted(index, quoted, quoteCp);
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.openGroup(index, codepoint);
            } else {
                if (codepoint == 123) {
                    ++this.curlyBracketDepth;
                    if (this.stage == 2) {
                        if (this.ruleType == 4) {
                            if (this.parendepth == 0) {
                                if (this.buffer.length() != 0) {
                                    this.medialist = this.newMediaList(this.buffer.toString());
                                    this.buffer.setLength(0);
                                } else {
                                    this.medialist = this.newMediaListAll();
                                }
                                CSSParser.this.handler.startMedia(this.medialist.getMediaList());
                                this.contextHandler = this.selectorHandler;
                                this.selectorHandler.prevcp = 32;
                            } else {
                                this.handleError(index - this.buffer.length(), (byte)9, "Bad media query at @media rule: <" + this.buffer.toString() + ">");
                                if (this.medialist != null) {
                                    this.medialist = this.medialist.getParent();
                                }
                                if (this.medialist == null) {
                                    this.ruleType = 0;
                                    this.stage = 0;
                                }
                                --this.curlyBracketDepth;
                                this.parendepth = 0;
                                this.contextHandler = new IgnoredDeclarationTokenHandler();
                            }
                        } else if (this.curlyBracketDepth == 1) {
                            if (this.ruleType == 5) {
                                this.startFontFaceRule(index);
                            } else if (this.ruleType == 6) {
                                this.startPageRule(index);
                            } else if (this.ruleType == 9) {
                                if (this.buffer.length() != 0) {
                                    this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token in margin rule: " + this.buffer.toString());
                                } else {
                                    this.declarationHandler.curlyBracketDepth = 1;
                                    this.contextHandler = this.declarationHandler;
                                }
                                --this.curlyBracketDepth;
                            }
                            this.buffer.setLength(0);
                        }
                    } else if (this.stage == 8 && this.curlyBracketDepth >= 2) {
                        this.startPageRule(index);
                    } else if (this.stage == 10 && this.curlyBracketDepth >= 2) {
                        this.startFontFaceRule(index);
                    } else {
                        this.buffer.append('{');
                    }
                } else if (codepoint == 40) {
                    this.parendepth = (short)(this.parendepth + 1);
                    if (this.stage == 35) {
                        if (this.bufferEquals("url")) {
                            this.stage = (byte)36;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer.toString());
                        }
                    } else if (this.stage == 38) {
                        if (this.bufferEquals("url")) {
                            this.stage = (byte)39;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer.toString());
                        }
                    } else if (this.stage == 34) {
                        if (this.bufferEquals("url")) {
                            this.ruleFirstPart = "";
                            this.stage = (byte)36;
                        } else {
                            this.handleError(index, (byte)4, "Unexpected '(' after " + this.buffer.toString());
                        }
                    } else {
                        this.buffer.append('(');
                    }
                } else {
                    this.bufferAppend(codepoint);
                }
                this.prevcp = codepoint;
            }
        }

        private void startPageRule(int index) {
            this.processBufferPageRule(index);
            CSSParser.this.handler.startPage(this.ruleFirstPart, this.ruleSecondPart);
            this.declarationHandler.curlyBracketDepth = 1;
            this.contextHandler = this.declarationHandler;
            --this.curlyBracketDepth;
        }

        private void startFontFaceRule(int index) {
            if (this.buffer.length() != 0) {
                this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token in @font-face rule: " + this.buffer.toString());
            } else {
                CSSParser.this.handler.startFontFace();
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
                --this.curlyBracketDepth;
            }
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.closeGroup(index, codepoint);
            } else {
                if (codepoint == 125) {
                    --this.curlyBracketDepth;
                    this.buffer.append('}');
                    if (this.curlyBracketDepth == 0) {
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.buffer.setLength(0);
                        this.stage = 0;
                        this.endRuleBody();
                    } else if (this.curlyBracketDepth == 1 && this.stage == 7) {
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.buffer.setLength(0);
                        this.stage = (byte)2;
                        this.switchContextToStage2();
                    }
                } else if (codepoint == 41) {
                    this.parendepth = (short)(this.parendepth - 1);
                    if (this.stage == 36) {
                        this.processBuffer(index);
                        if (this.ruleSecondPart != null) {
                            this.stage = (byte)37;
                        } else {
                            this.handleError(index, (byte)33, "Empty URI in namespace rule");
                        }
                    } else if (this.stage == 39) {
                        this.processBuffer(index);
                        this.stage = (byte)40;
                    } else {
                        this.buffer.append(')');
                    }
                } else {
                    this.bufferAppend(codepoint);
                }
                this.prevcp = codepoint;
            }
        }

        protected void endRuleBody() {
            this.contextHandler = this.selectorHandler;
            this.selectorHandler.prevcp = 32;
            this.rulesFound = true;
        }

        private void switchContextToStage2() {
            if (this.ruleType == 4) {
                this.contextHandler = this.selectorHandler;
                this.selectorHandler.prevcp = 32;
            } else if (this.ruleType == 5) {
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
            } else if (this.ruleType == 6) {
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
            } else if (this.ruleType == 9) {
                this.declarationHandler.curlyBracketDepth = 1;
                this.contextHandler = this.declarationHandler;
            }
        }

        @Override
        public void character(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.character(index, codepoint);
            } else {
                if (codepoint == 59) {
                    if (this.curlyBracketDepth == 0) {
                        if (this.parendepth == 0) {
                            if (this.stage != 0) {
                                this.endOfAtRule(index);
                            } else {
                                this.handleError(index, (byte)33, "Empty @-rule.");
                                this.resetRuleState();
                            }
                        } else {
                            this.handleError(index, (byte)6, "Unmatched parentheses in rule.");
                            this.resetRuleState();
                        }
                        this.contextHandler = this.selectorHandler;
                    } else {
                        this.buffer.append(';');
                    }
                } else if (this.ruleType == 6) {
                    if (codepoint == 44) {
                        this.processBufferPageRule(index);
                    } else {
                        if (codepoint == 58 && (this.prevcp == 44 || this.prevcp == 32 || this.prevcp == 13)) {
                            this.buffer.append(':');
                            return;
                        }
                        this.handleError(index, (byte)4, "Unexpected char " + new String(Character.toChars(codepoint)));
                    }
                } else {
                    this.bufferAppend(codepoint);
                }
                this.prevcp = codepoint;
            }
        }

        private void endOfAtRule(int index) {
            this.processBuffer(index);
            if (this.buffer.length() != 0) {
                this.handleError(index, (byte)9, "Malformed @-rule, unexpected <" + this.buffer.toString() + ">");
            }
            if (this.stage == 40 || this.stage == 38) {
                this.medialist = this.ruleSecondPart != null ? this.newMediaList(this.ruleSecondPart) : null;
                if (this.ruleFirstPart != null) {
                    if (this.medialist == null) {
                        this.medialist = this.newMediaListAll();
                    }
                    CSSParser.this.handler.importStyle(this.ruleFirstPart, this.medialist.getMediaList(), null);
                } else if (!this.parseError) {
                    this.handleError(index, (byte)33, "Malformed @-rule");
                }
            } else if (this.stage == 35 || this.stage == 37) {
                if (this.ruleSecondPart != null) {
                    this.namespaceDeclaration(this.ruleFirstPart, this.ruleSecondPart);
                } else {
                    this.handleError(index, (byte)33, "No URI in namespace rule");
                }
            } else if (this.stage == 34) {
                this.namespaceDeclaration("", this.ruleFirstPart);
            } else if (this.stage == 36) {
                this.handleError(index, (byte)33, "Bad URI in namespace rule");
            }
            this.resetRuleState();
            this.rulesFound = true;
        }

        private SACMediaListWrapper newMediaListAll() {
            return new SACMediaListWrapper(new MySACAllMediaList(), this.medialist);
        }

        private SACMediaListWrapper newMediaList(String media) {
            return new SACMediaListWrapper(CSSParser.parseMediaList(media), this.medialist);
        }

        void namespaceDeclaration(String prefix, String uri) {
            CSSParser.this.handler.namespaceDeclaration(prefix, uri);
            this.selectorHandler.factory.registerNamespacePrefix(prefix, uri);
        }

        void resetRuleState() {
            this.parseError = false;
            if (this.medialist != null) {
                this.medialist = this.medialist.getParent();
                if (this.medialist == null) {
                    this.stage = 0;
                }
            } else {
                this.stage = 0;
            }
            this.ruleFirstPart = null;
            this.ruleSecondPart = null;
            this.prevcp = 32;
            this.buffer.setLength(0);
        }

        private void processBufferPageRule(int index) {
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (this.buffer.charAt(0) == ':') {
                    if (buflen == 1) {
                        this.handleError(index - buflen, (byte)4, "Character ':' must always precede an identifier in page rule preludes");
                    } else {
                        this.ruleSecondPart = this.ruleSecondPart == null ? this.buffer.toString() : new StringBuilder(this.ruleSecondPart.length() + buflen).append(this.ruleSecondPart).append(',').append((CharSequence)this.buffer).toString();
                    }
                } else if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                } else {
                    this.handleError(index - buflen, (byte)9, "Unexpected identifier at page rule: " + this.buffer.toString());
                }
                this.buffer.setLength(0);
            }
        }

        private void processBuffer(int index) {
            if (this.buffer.length() != 0) {
                this.trimBufferTail();
                if (this.ruleFirstPart == null) {
                    this.ruleFirstPart = this.buffer.toString();
                    this.buffer.setLength(0);
                } else if (this.ruleSecondPart == null) {
                    this.ruleSecondPart = this.buffer.toString();
                    this.buffer.setLength(0);
                }
            }
        }

        private void trimBufferTail() {
            if (this.buffer.charAt(this.buffer.length() - 1) == ' ') {
                this.buffer.setLength(this.buffer.length() - 1);
            }
        }

        private boolean bufferEquals(String lcWord) {
            if (ParseHelper.equalsIgnoreCase(this.buffer, lcWord)) {
                this.buffer.setLength(0);
                return true;
            }
            return false;
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (this.contextHandler != null) {
                this.contextHandler.escaped(index, codepoint);
            } else if (!this.parseError) {
                if (ParseHelper.isHexCodePoint(codepoint)) {
                    this.setEscapedTokenStart(index);
                    this.buffer.append('\\');
                }
                this.bufferAppend(codepoint);
            }
            this.prevcp = 65;
        }

        @Override
        public void endOfStream(int len) {
            if (this.contextHandler != null) {
                this.contextHandler.endOfStream(len);
            } else {
                if (this.ruleType == 9) {
                    CSSParser.this.handler.endPage(this.marginRule, null);
                    this.ruleType = (byte)6;
                }
                if (this.ruleType == 6) {
                    this.processBufferPageRule(len);
                    CSSParser.this.handler.endPage(this.ruleFirstPart, this.ruleSecondPart);
                    if (this.stage == 8) {
                        CSSParser.this.handler.endMedia(this.medialist.getMediaList());
                    }
                } else if (this.ruleType == 5) {
                    CSSParser.this.handler.endFontFace();
                    if (this.stage == 10) {
                        CSSParser.this.handler.endMedia(this.medialist.getMediaList());
                    }
                } else if (this.ruleType == 4) {
                    while (this.medialist != null) {
                        CSSParser.this.handler.endMedia(this.medialist.getMediaList());
                        this.medialist = this.medialist.getParent();
                    }
                } else if (this.stage != 0 && !this.parseError) {
                    if (this.curlyBracketDepth == 0) {
                        this.endOfAtRule(len);
                    } else if (this.buffer.length() != 0) {
                        do {
                            --this.curlyBracketDepth;
                            this.buffer.append('}');
                        } while (this.curlyBracketDepth > 0);
                        CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                        this.handleError(len, (byte)10, "Unexpected end of stream");
                    }
                }
            }
            this.endDocument();
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (this.stage == 5 || this.stage == 7) {
                if (commentType == 0) {
                    this.buffer.append("/*").append(comment).append("*/");
                }
            } else if (this.contextHandler != null) {
                this.contextHandler.commented(index, commentType, comment);
            } else {
                super.commented(index, commentType, comment);
            }
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (this.contextHandler != null) {
                this.contextHandler.handleError(index, errCode, message);
            } else {
                super.handleError(index, errCode, message);
                this.buffer.setLength(0);
                this.stage = (byte)127;
            }
        }

        private class MyDeclarationTokenHandler
        extends DeclarationTokenHandler {
            MyDeclarationTokenHandler(InputSource source) {
                super(source, ShorthandDatabase.getInstance());
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.parseError = false;
                ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.prevcp = 32;
                ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.stage = 0;
                SheetTokenHandler.this.prevcp = 125;
                if (SheetTokenHandler.this.ruleType == 5) {
                    CSSParser.this.handler.endFontFace();
                    if (SheetTokenHandler.this.stage == 10) {
                        SheetTokenHandler.this.ruleType = (byte)4;
                        this.buffer.setLength(0);
                        SheetTokenHandler.this.stage = (byte)2;
                        SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                        ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.prevcp = 32;
                    } else {
                        SheetTokenHandler.this.ruleType = (byte)0;
                        SheetTokenHandler.this.stage = (byte)0;
                    }
                } else if (SheetTokenHandler.this.ruleType == 6) {
                    CSSParser.this.handler.endPage(SheetTokenHandler.this.ruleFirstPart, SheetTokenHandler.this.ruleSecondPart);
                    SheetTokenHandler.this.ruleFirstPart = null;
                    SheetTokenHandler.this.ruleSecondPart = null;
                    if (SheetTokenHandler.this.stage == 8) {
                        SheetTokenHandler.this.ruleType = (byte)4;
                        this.buffer.setLength(0);
                        SheetTokenHandler.this.stage = (byte)2;
                        SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                        ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.prevcp = 32;
                    } else {
                        SheetTokenHandler.this.ruleType = (byte)0;
                        SheetTokenHandler.this.stage = (byte)0;
                    }
                } else if (SheetTokenHandler.this.ruleType == 9) {
                    CSSParser.this.handler.endPage(SheetTokenHandler.this.marginRule, null);
                    SheetTokenHandler.this.ruleType = (byte)6;
                    SheetTokenHandler.this.marginRule = null;
                    SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.declarationHandler;
                    SheetTokenHandler.this.declarationHandler.curlyBracketDepth = 2;
                } else {
                    CSSParser.this.handler.endSelector((SelectorList)((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.selist);
                    ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.selist = new CSSTokenHandler.MySelectorListImpl();
                }
                SheetTokenHandler.this.rulesFound = true;
                this.resetHandler();
            }

            @Override
            protected void handleAtKeyword(int index) {
                if (this.propertyName == null && this.buffer.length() == 0 && this.getCurlyBracketDepth() == 1 && SheetTokenHandler.this.selectorHandler.getSelectorList().getLength() == 0) {
                    SheetTokenHandler.this.contextHandler = null;
                    SheetTokenHandler.this.buffer.append('@');
                    SheetTokenHandler.this.prevcp = 64;
                } else {
                    this.unexpectedCharError(index, 64);
                }
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class MySelectorTokenHandler
        extends SelectorTokenHandler {
            MySelectorTokenHandler(InputSource source, Parser2.NamespaceMap nsMap) {
                super(source, nsMap);
            }

            @Override
            protected void handleLeftCurlyBracket(int index) {
                SheetTokenHandler.this.declarationHandler.curlyBracketDepth = 1;
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.declarationHandler;
                if (!this.parseError) {
                    SheetTokenHandler.this.selectorHandler.processBuffer(index, 123, true);
                    if (!this.parseError) {
                        if (this.addCurrentSelector(index)) {
                            CSSParser.this.handler.startSelector((SelectorList)this.selist);
                        } else {
                            this.unexpectedCharError(index, 123);
                        }
                    }
                }
                this.stage = 0;
                if (this.parseError) {
                    this.buffer.setLength(0);
                    this.ignoreRule();
                }
            }

            private void ignoreRule() {
                this.selist.clear();
                this.currentsel = null;
                SheetTokenHandler.this.contextHandler = new IgnoredDeclarationTokenHandler();
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                if (SheetTokenHandler.this.stage == 2) {
                    byte ruleType = SheetTokenHandler.this.ruleType;
                    if (ruleType == 4) {
                        CSSParser.this.handler.endMedia(SheetTokenHandler.this.medialist.getMediaList());
                        SheetTokenHandler.this.medialist = SheetTokenHandler.this.medialist.getParent();
                        if (SheetTokenHandler.this.medialist == null) {
                            this.resetSelectorHandler(true);
                        } else {
                            this.resetSelectorHandler(false);
                        }
                        return;
                    }
                    if (SheetTokenHandler.this.curlyBracketDepth == 1) {
                        this.resetSelectorHandler(true);
                        return;
                    }
                }
                this.handleError(index, (byte)4, "Unexpected '}'");
                this.resetSelectorHandler(true);
                if (SheetTokenHandler.this.curlyBracketDepth < 0) {
                    SheetTokenHandler.this.curlyBracketDepth = 0;
                }
            }

            private void resetSelectorHandler(boolean resetSheetStage) {
                this.resetHandler();
                SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                SheetTokenHandler.this.curlyBracketDepth--;
                if (resetSheetStage) {
                    SheetTokenHandler.this.ruleType = (byte)0;
                    SheetTokenHandler.this.stage = (byte)0;
                }
            }

            @Override
            boolean skipCharacterHandling() {
                return this.parseError && (this.prevcp != 59 || SheetTokenHandler.this.curlyBracketDepth != 0);
            }

            @Override
            protected void handleAtKeyword(int index) {
                if (this.prevcp == 59) {
                    this.parseError = false;
                    this.stage = 0;
                } else if (this.stage > 0) {
                    int len = this.buffer.length();
                    if (len != 0) {
                        int cp = this.buffer.codePointAt(0);
                        String message = Character.isAlphabetic(cp) ? "Unknown token: " + this.buffer.toString() : "Unknown token starting with code point U+" + Integer.toHexString(cp);
                        this.handleError(index - len, (byte)9, message);
                    } else {
                        this.unexpectedCharError(index, 64);
                    }
                    return;
                }
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.prevcp = 64;
                SheetTokenHandler.this.buffer.append('@');
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void endOfStream(int len) {
                if (this.buffer.length() != 0) {
                    this.handleError(len, (byte)10, "Unexpected end of stream");
                }
                this.endDocument();
            }

            @Override
            protected void handleError(int index, byte errCode, String message) {
                this.stage = (byte)127;
                if (!this.parseError) {
                    if (CSSParser.this.errorHandler != null) {
                        if (this.prevcp == this.endcp) {
                            CSSParser.this.errorHandler.error(this.createException(index, errCode, "Expected end of file"));
                        } else {
                            CSSParser.this.errorHandler.error(this.createException(index, errCode, message));
                        }
                    }
                    this.parseError = true;
                }
                this.selist.clear();
                this.buffer.setLength(0);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return SheetTokenHandler.this.createException(index, errCode, message);
            }
        }

        private class IgnoredDeclarationTokenHandler
        extends CSSTokenHandler {
            private int curlyBracketDepth;

            IgnoredDeclarationTokenHandler() {
                super(null);
                this.curlyBracketDepth = 1;
            }

            @Override
            public void word(int index, CharSequence word) {
            }

            @Override
            public void separator(int index, int codePoint) {
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quoteCp) {
            }

            @Override
            public void quotedWithControl(int index, CharSequence quoted, int quote) {
            }

            @Override
            public void openGroup(int index, int codePoint) {
                if (codePoint == 123) {
                    ++this.curlyBracketDepth;
                }
            }

            @Override
            public void closeGroup(int index, int codePoint) {
                if (codePoint == 125) {
                    --this.curlyBracketDepth;
                    if (this.curlyBracketDepth == 0) {
                        SheetTokenHandler.this.contextHandler = SheetTokenHandler.this.selectorHandler;
                        ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.prevcp = 32;
                        ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.parseError = false;
                        ((SheetTokenHandler)SheetTokenHandler.this).selectorHandler.stage = 0;
                        SheetTokenHandler.this.prevcp = 125;
                    }
                }
            }

            @Override
            public void character(int index, int codePoint) {
            }

            @Override
            public void escaped(int index, int codePoint) {
            }

            @Override
            public void control(int index, int codepoint) {
                SheetTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void endOfStream(int len) {
                SheetTokenHandler.this.contextHandler = null;
                SheetTokenHandler.this.endOfStream(len);
            }
        }
    }

    class DeclarationTokenHandler
    extends CSSTokenHandler {
        private LexicalUnitImpl lunit;
        private LexicalUnitImpl currentlu;
        String propertyName;
        private final ShorthandDatabase propertyDatabase;
        private boolean hexColor;
        private boolean unicodeRange;
        private boolean readPriority;
        private boolean priorityImportant;
        private int curlyBracketDepth;
        private int squareBracketDepth;
        private boolean functionToken;
        private final boolean flagIEValues;

        DeclarationTokenHandler(InputSource source, ShorthandDatabase propertyDatabase) {
            this(source, propertyDatabase, 1);
        }

        DeclarationTokenHandler(InputSource source, ShorthandDatabase propertyDatabase, int initialCurlyBracketDepth) {
            super(source);
            this.lunit = null;
            this.currentlu = null;
            this.propertyName = null;
            this.hexColor = false;
            this.unicodeRange = false;
            this.readPriority = false;
            this.priorityImportant = false;
            this.functionToken = false;
            this.curlyBracketDepth = initialCurlyBracketDepth;
            this.flagIEValues = CSSParser.this.parserFlags.contains((Object)Parser2.Flag.IEVALUES);
            this.buffer = new StringBuilder(128);
            this.propertyDatabase = propertyDatabase;
        }

        LexicalUnit2 getLexicalUnit() {
            return this.parseError ? null : this.lunit;
        }

        int getCurlyBracketDepth() {
            return this.curlyBracketDepth;
        }

        @Override
        public void word(int index, CharSequence word) {
            if (!this.parseError) {
                if (this.readPriority) {
                    if (ParseHelper.equalsIgnoreCase(word, "important")) {
                        this.priorityImportant = true;
                    } else {
                        this.checkIEPrioHack(index, word.toString());
                    }
                } else {
                    this.addWord(index, word);
                }
            }
            this.prevcp = 65;
        }

        void addWord(int index, CharSequence word) {
            if (this.prevcp == 92) {
                this.buffer.append('\\');
            }
            this.buffer.append(word);
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (this.hexColor || this.unicodeRange) {
                this.unexpectedCharError(index, codepoint);
            }
            if (codepoint == 40) {
                this.parendepth = (short)(this.parendepth + 1);
                if (!this.parseError) {
                    if (this.prevcp != 65) {
                        if (!this.functionToken) {
                            this.unexpectedCharError(index, codepoint);
                            this.prevcp = codepoint;
                        } else if (this.buffer.length() == 0) {
                            this.newLexicalUnit((short)40);
                        } else {
                            this.handleError(index, (byte)9, "Unexpected token: " + this.buffer.toString());
                            this.buffer.setLength(0);
                        }
                    } else {
                        this.newFunction(index);
                    }
                }
            } else if (codepoint == 123) {
                ++this.curlyBracketDepth;
                this.handleLeftCurlyBracket(index);
            } else if (codepoint == 91) {
                ++this.squareBracketDepth;
                if (!this.parseError) {
                    if (this.propertyName != null) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)68);
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                }
            }
            this.prevcp = codepoint;
        }

        private void newFunction(int index) {
            LexicalUnitImpl lu;
            String name = this.unescapeBuffer(index);
            if ("url".equalsIgnoreCase(name)) {
                lu = this.newLexicalUnit((short)24);
            } else if ("rgb".equalsIgnoreCase(name) || "rgba".equalsIgnoreCase(name)) {
                lu = this.newLexicalUnit((short)27);
            } else if ("attr".equalsIgnoreCase(name)) {
                lu = this.newLexicalUnit((short)37);
            } else {
                if ("element".equalsIgnoreCase(name)) {
                    LexicalUnitImpl lu2 = this.newLexicalUnit((short)73);
                    this.functionToken = true;
                    return;
                }
                lu = "rect".equalsIgnoreCase(name) ? this.newLexicalUnit((short)38) : ("counter".equalsIgnoreCase(name) ? this.newLexicalUnit((short)25) : ("counters".equalsIgnoreCase(name) ? this.newLexicalUnit((short)26) : this.newLexicalUnit((short)41)));
            }
            lu.value = name;
            this.functionToken = true;
        }

        protected void handleLeftCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '{'");
        }

        private LexicalUnitImpl newLexicalUnit(short unitType) {
            LexicalUnitImpl lu;
            if (this.functionToken) {
                if (this.currentlu.getLexicalUnitType() == 24) {
                    lu = this.currentlu;
                } else {
                    lu = new LexicalUnitImpl(unitType);
                    this.currentlu.addFunctionParameter(lu);
                    if (ParseHelper.isFunctionUnitType(unitType) || unitType == 40) {
                        this.currentlu = lu;
                    }
                }
            } else {
                lu = new LexicalUnitImpl(unitType);
                if (this.currentlu != null) {
                    this.currentlu.nextLexicalUnit = lu;
                    lu.previousLexicalUnit = this.currentlu;
                }
                this.currentlu = lu;
                if (this.lunit == null) {
                    this.lunit = lu;
                }
            }
            return lu;
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (codepoint == 41) {
                this.processBuffer(index);
                this.parendepth = (short)(this.parendepth - 1);
                if (this.functionToken) {
                    this.checkFunction(index);
                    if (this.currentlu.ownerLexicalUnit != null) {
                        this.currentlu = this.currentlu.ownerLexicalUnit;
                    } else {
                        this.functionToken = false;
                    }
                }
            } else if (codepoint == 125) {
                if (this.parendepth == 0 && this.squareBracketDepth == 0) {
                    if (this.curlyBracketDepth == 1) {
                        this.endOfPropertyDeclaration(index);
                        this.handleRightCurlyBracket(index);
                    } else if (this.curlyBracketDepth == 2) {
                        this.buffer.setLength(0);
                    } else {
                        this.parseError = true;
                    }
                }
                --this.curlyBracketDepth;
            } else if (codepoint == 93) {
                --this.squareBracketDepth;
                if (!this.parseError) {
                    if (this.propertyName != null) {
                        this.processBuffer(index);
                        this.newLexicalUnit((short)69);
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                }
            }
            this.prevcp = codepoint;
        }

        private void checkFunction(int index) {
            String name;
            short type = this.currentlu.getLexicalUnitType();
            if (this.currentlu.parameters == null) {
                if (type != 41 && type != 24 && type != 73) {
                    this.unexpectedCharError(index, 41);
                }
                return;
            }
            if (!this.lastParamIsOperand()) {
                this.unexpectedCharError(index, 41);
                return;
            }
            if (type == 27 && !this.isValidRGBColor() || type == 41 && ("hsl".equalsIgnoreCase(name = this.currentlu.getFunctionName()) || "hsla".equalsIgnoreCase(name)) && !this.isValidHSLColor()) {
                String s;
                try {
                    s = "Wrong color: " + this.currentlu.toString();
                }
                catch (Exception e) {
                    s = "Wrong color.";
                }
                this.handleError(index, (byte)5, s);
            }
        }

        private boolean lastParamIsOperand() {
            short type = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
            return type != 0 && !this.typeIsAlgebraicOperator(type);
        }

        private boolean lastParamIsAlgebraicOperator() {
            short type = this.findLastValue(this.currentlu.parameters).getLexicalUnitType();
            return this.typeIsAlgebraicOperator(type);
        }

        private boolean typeIsAlgebraicOperator(short type) {
            return type == 1 || type == 2 || type == 3 || type == 4;
        }

        private boolean isValidRGBColor() {
            LexicalUnitImpl lu = this.currentlu.parameters;
            int valCount = 0;
            short lastType = -1;
            boolean hasCommas = false;
            boolean hasNoCommas = false;
            do {
                short type;
                if ((type = lu.getLexicalUnitType()) == 0) {
                    if (lastType == 0 || lastType == -1 || hasNoCommas) {
                        return false;
                    }
                    hasCommas = true;
                } else if (type == 13 || type == 23) {
                    if (hasCommas) {
                        int value;
                        if (lastType != 0) {
                            return false;
                        }
                        if (valCount == 3 && ((value = lu.getIntegerValue()) < 0 || value > 1)) {
                            return false;
                        }
                    } else if (lastType != type) {
                        if (lastType != -1) {
                            if (valCount == 3) {
                                int value;
                                if (lastType != 4) {
                                    return false;
                                }
                                if (type == 13 ? (value = lu.getIntegerValue()) < 0 || value > 1 : (value = lu.getFloatValue()) < 0.0f || value > 100.0f) {
                                    return false;
                                }
                            } else if (lastType == 23 ? lu.getIntegerValue() != 0 : lastType == 13 && lu.getPreviousLexicalUnit().getIntegerValue() != 0) {
                                return false;
                            }
                        }
                    } else {
                        hasNoCommas = true;
                    }
                    valCount = (short)(valCount + 1);
                } else if (type == 4) {
                    if (valCount != 3 || lastType != 13 && lastType != 23 || hasCommas) {
                        return false;
                    }
                } else if (type == 14) {
                    if (lastType != 4 && lastType != 0 || valCount != 3) {
                        return false;
                    }
                    valCount = 4;
                } else {
                    return false;
                }
                lastType = type;
            } while ((lu = lu.nextLexicalUnit) != null);
            return valCount == 3 || valCount == 4;
        }

        private boolean isValidHSLColor() {
            LexicalUnitImpl lu = this.currentlu.parameters;
            int pcntCount = 0;
            short lastType = -1;
            boolean hasCommas = false;
            boolean hasNoCommas = false;
            do {
                short type;
                if ((type = lu.getLexicalUnitType()) == 23) {
                    if (lastType == -1) {
                        return false;
                    }
                    if (hasCommas) {
                        if (lastType != 0) {
                            return false;
                        }
                    } else if (lastType == 13 || this.isAngleType(lastType)) {
                        hasNoCommas = true;
                    }
                    pcntCount = (short)(pcntCount + 1);
                } else if (type == 0) {
                    if (lastType == 0 || lastType == -1 || hasNoCommas) {
                        return false;
                    }
                    hasCommas = true;
                } else if (type == 13) {
                    int value;
                    if (lastType != -1 && (lastType != 4 && lastType != 0 || pcntCount < 2 || (value = lu.getIntegerValue()) < 0 || value > 1)) {
                        return false;
                    }
                } else if (this.isAngleType(type)) {
                    if (lastType != -1) {
                        return false;
                    }
                } else if (type == 4) {
                    if (pcntCount != 2 || lastType != 23 || hasCommas) {
                        return false;
                    }
                } else if (type == 14) {
                    if (lastType != 4 && lastType != 0 || pcntCount != 2) {
                        return false;
                    }
                    pcntCount = 3;
                } else {
                    return false;
                }
                lastType = type;
            } while ((lu = lu.nextLexicalUnit) != null);
            return pcntCount >= 2;
        }

        private boolean isAngleType(short type) {
            return type == 28 || type == 30 || type == 29 || type == 63;
        }

        protected void handleRightCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '}'");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void character(int index, int codepoint) {
            block37: {
                block45: {
                    block47: {
                        block57: {
                            block56: {
                                block54: {
                                    block55: {
                                        char c;
                                        block53: {
                                            block51: {
                                                block52: {
                                                    block50: {
                                                        block49: {
                                                            block48: {
                                                                block46: {
                                                                    block44: {
                                                                        block43: {
                                                                            block42: {
                                                                                String compatText;
                                                                                block40: {
                                                                                    block41: {
                                                                                        block39: {
                                                                                            block38: {
                                                                                                if (!this.functionToken || this.currentlu.getLexicalUnitType() != 24) break block38;
                                                                                                this.bufferAppend(codepoint);
                                                                                                break block37;
                                                                                            }
                                                                                            if (codepoint != 59) break block39;
                                                                                            this.handleSemicolon(index);
                                                                                            break block37;
                                                                                        }
                                                                                        if (this.parseError) break block37;
                                                                                        if (this.propertyName != null) break block40;
                                                                                        if (codepoint != 45) break block41;
                                                                                        this.buffer.append('-');
                                                                                        codepoint = 65;
                                                                                        break block37;
                                                                                    }
                                                                                    if (codepoint == 95) {
                                                                                        this.buffer.append('_');
                                                                                        codepoint = 65;
                                                                                        break block37;
                                                                                    } else if (codepoint == 58) {
                                                                                        this.setPropertyName(index);
                                                                                        break block37;
                                                                                    } else {
                                                                                        if (codepoint != 64) {
                                                                                            this.badPropertyName(index, codepoint);
                                                                                            return;
                                                                                        }
                                                                                        this.handleAtKeyword(index);
                                                                                    }
                                                                                    break block37;
                                                                                }
                                                                                if (!this.readPriority) break block42;
                                                                                if (codepoint == 33 && this.priorityImportant && CSSParser.this.parserFlags.contains((Object)Parser2.Flag.IEPRIOCHAR) && (compatText = this.setFullIdentCompat()) != null) {
                                                                                    this.warnIdentCompat(index, compatText);
                                                                                    this.lunit.setUnitType((short)72);
                                                                                    break block37;
                                                                                } else {
                                                                                    this.unexpectedCharError(index, codepoint);
                                                                                }
                                                                                break block37;
                                                                            }
                                                                            if (codepoint != 44) break block43;
                                                                            if (!this.functionToken || this.currentlu.parameters == null || !this.addToIdentCompat()) {
                                                                                this.processBuffer(index);
                                                                            }
                                                                            this.newLexicalUnit((short)0);
                                                                            break block37;
                                                                        }
                                                                        if (codepoint != 33) break block44;
                                                                        if (!this.functionToken) {
                                                                            this.processBuffer(index);
                                                                            this.readPriority = true;
                                                                            break block37;
                                                                        } else {
                                                                            this.unexpectedCharError(index, codepoint);
                                                                        }
                                                                        break block37;
                                                                    }
                                                                    if (this.hexColor) break block45;
                                                                    if (codepoint != 45) break block46;
                                                                    if (this.functionToken && !this.unicodeRange) {
                                                                        this.processBuffer(index);
                                                                        if (this.currentlu.parameters == null || !this.lastParamIsAlgebraicOperator()) {
                                                                            this.newLexicalUnit((short)2);
                                                                            break block37;
                                                                        } else {
                                                                            this.unexpectedCharError(index, codepoint);
                                                                        }
                                                                        break block37;
                                                                    } else {
                                                                        this.buffer.append('-');
                                                                        codepoint = 65;
                                                                    }
                                                                    break block37;
                                                                }
                                                                if (this.unicodeRange) break block47;
                                                                if (codepoint != 95) break block48;
                                                                this.buffer.append('_');
                                                                codepoint = 65;
                                                                break block37;
                                                            }
                                                            if (codepoint != 46) break block49;
                                                            this.handleFullStop(index);
                                                            break block37;
                                                        }
                                                        if (codepoint != 37) break block50;
                                                        if (this.prevcp == 65 && Character.isDigit(this.buffer.charAt(this.buffer.length() - 1))) {
                                                            this.buffer.append('%');
                                                            break block37;
                                                        } else {
                                                            this.processBuffer(index);
                                                            this.newLexicalUnit((short)5);
                                                        }
                                                        break block37;
                                                    }
                                                    if (codepoint != 35) break block51;
                                                    if (this.buffer.length() == 0) break block52;
                                                    if (this.functionToken && this.currentlu.getLexicalUnitType() != 73) {
                                                        this.buffer.append('#');
                                                        break block37;
                                                    } else {
                                                        this.unexpectedCharError(index, codepoint);
                                                    }
                                                    break block37;
                                                }
                                                if (this.currentlu == null || this.currentlu.getLexicalUnitType() != 73) {
                                                    this.hexColor = true;
                                                    break block37;
                                                } else if (this.currentlu.value == null) {
                                                    this.buffer.append('#');
                                                    break block37;
                                                } else {
                                                    this.unexpectedCharError(index, codepoint);
                                                }
                                                break block37;
                                            }
                                            if (codepoint != 58) break block53;
                                            this.handleColon(index);
                                            break block37;
                                        }
                                        if (codepoint != 43) break block54;
                                        if (this.buffer.length() != 1 || (c = this.buffer.charAt(0)) != 'U' && c != 'u') break block55;
                                        this.buffer.setLength(0);
                                        this.unicodeRange = true;
                                        break block37;
                                    }
                                    if (this.functionToken) {
                                        this.processBuffer(index);
                                        if (this.currentlu.parameters == null || !this.lastParamIsAlgebraicOperator()) {
                                            this.newLexicalUnit((short)1);
                                            break block37;
                                        } else {
                                            this.unexpectedCharError(index, codepoint);
                                        }
                                        break block37;
                                    } else {
                                        this.unexpectedCharError(index, codepoint);
                                    }
                                    break block37;
                                }
                                if (codepoint != 47) break block56;
                                this.processBuffer(index);
                                if (!this.functionToken || this.currentlu.parameters != null && this.lastParamIsOperand()) {
                                    this.newLexicalUnit((short)4);
                                    break block37;
                                } else {
                                    this.unexpectedCharError(index, codepoint);
                                }
                                break block37;
                            }
                            if (!this.functionToken) break block57;
                            if (codepoint == 42) {
                                this.processBuffer(index);
                                if (this.currentlu.parameters != null && this.lastParamIsOperand()) {
                                    this.newLexicalUnit((short)3);
                                    break block37;
                                } else {
                                    this.unexpectedCharError(index, codepoint);
                                }
                                break block37;
                            } else {
                                if (codepoint == 61 && this.handleEqualsSignInsideFunction(index)) {
                                    this.prevcp = 65;
                                    return;
                                }
                                this.unexpectedCharError(index, codepoint);
                            }
                            break block37;
                        }
                        if (codepoint != 64 && codepoint != 63) {
                            this.bufferAppend(codepoint);
                            break block37;
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                        break block37;
                    }
                    if (codepoint == 63 && this.buffer.length() < 6) {
                        this.bufferAppend(codepoint);
                        break block37;
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                    break block37;
                }
                this.unexpectedCharError(index, codepoint);
            }
            this.prevcp = codepoint;
        }

        private void setPropertyName(int index) {
            if (this.buffer.length() != 0) {
                String s = this.buffer.toString();
                if (this.escapedTokenIndex == -1) {
                    this.propertyName = s;
                    this.buffer.setLength(0);
                } else {
                    this.propertyName = this.unescapeBuffer(index);
                    if (!this.parseError && !this.isValidIdentifier(this.propertyName)) {
                        this.handleWarning(index, (byte)-4, "Suspicious property name: " + s);
                    }
                }
            } else {
                this.handleError(index, (byte)4, "Unexpected ':'");
            }
        }

        private boolean handleEqualsSignInsideFunction(int index) {
            if (this.flagIEValues && (this.propertyName.length() == 0 || this.propertyName.endsWith("filter") || "expression".equalsIgnoreCase(this.currentlu.getFunctionName())) && (this.prevcp == 65 || this.prevcp == 32 || this.prevcp == 13 || this.prevcp == 93)) {
                int buflen = this.buffer.length();
                if (buflen != 0) {
                    if (this.escapedTokenIndex == -1) {
                        String s;
                        this.buffer.append('=');
                        this.newLexicalUnit((short)71).value = s = this.buffer.toString();
                        this.buffer.setLength(0);
                        this.hexColor = false;
                        this.warnIdentCompat(index - buflen, s);
                        return true;
                    }
                } else {
                    LexicalUnitImpl lu = this.currentlu.parameters;
                    if (lu != null) {
                        short lutype = (lu = this.findLastValue(lu)).getLexicalUnitType();
                        if (lutype == 35) {
                            lu.setUnitType((short)71);
                            String s = lu.getStringValue();
                            lu.value = lu.value + '=';
                            this.warnIdentCompat(index - s.length(), s);
                            return true;
                        }
                        if (lutype == 71) {
                            lu.value = lu.value + '=';
                            return true;
                        }
                        if (lutype == 69) {
                            this.newLexicalUnit((short)71).value = "=";
                            this.warnIdentCompat(index, "=");
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private LexicalUnitImpl findLastValue(LexicalUnitImpl lu) {
            LexicalUnitImpl nextlu;
            while ((nextlu = lu.nextLexicalUnit) != null) {
                lu = nextlu;
            }
            return lu;
        }

        private boolean addToIdentCompat() {
            LexicalUnitImpl lu;
            short lutype;
            if (this.escapedTokenIndex == -1 && (lutype = (lu = this.findLastValue(this.currentlu.parameters)).getLexicalUnitType()) == 71) {
                if (this.hexColor) {
                    lu.value = lu.value + '#';
                    this.hexColor = false;
                }
                if (this.buffer.length() != 0) {
                    lu.value = lu.value + this.buffer;
                    this.buffer.setLength(0);
                }
                this.prevcp = 65;
                return true;
            }
            return false;
        }

        private boolean checkLastIdentCompat() {
            LexicalUnitImpl lu = this.currentlu.parameters;
            if (lu != null && (lu = this.findLastValue(lu)).getLexicalUnitType() == 71) {
                if (this.hexColor) {
                    lu.value = lu.value + '#';
                    this.hexColor = false;
                }
                lu.value = lu.value + this.buffer;
                this.buffer.setLength(0);
                return true;
            }
            return false;
        }

        private void handleFullStop(int index) {
            if (this.prevcp == 65) {
                this.buffer.append('.');
            } else if (this.buffer.length() == 0) {
                LexicalUnitImpl lastValue;
                if (this.prevcp == 45 && this.functionToken && this.escapedTokenIndex == -1 && this.currentlu.parameters != null && (lastValue = this.findLastValue(this.currentlu.parameters)).getLexicalUnitType() == 2) {
                    LexicalUnitImpl prev = lastValue.previousLexicalUnit;
                    if (prev != null) {
                        prev.nextLexicalUnit = null;
                    } else {
                        this.currentlu.parameters = null;
                    }
                    this.buffer.append('-');
                }
                this.buffer.append('0').append('.');
            } else {
                this.handleError(index, (byte)4, "Unexpected '.'");
            }
        }

        private void handleColon(int index) {
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (buflen != 6 || !this.flagIEValues || !ParseHelper.equalsIgnoreCase(this.buffer, "progid")) {
                    this.handleError(index, (byte)4, "Unexpected ':'");
                } else {
                    this.buffer.append(':');
                    this.handleWarning(index, (byte)-3, "Progid hack applied");
                }
            }
        }

        protected void handleAtKeyword(int index) {
            this.unexpectedCharError(index, 64);
        }

        protected void handleSemicolon(int index) {
            if (this.curlyBracketDepth == 1 && this.parendepth == 0 && this.squareBracketDepth == 0) {
                this.endOfPropertyDeclaration(index);
            } else {
                this.handleError(index, (byte)4, "Unexpected ';'");
            }
        }

        protected void badPropertyName(int index, int codepoint) {
            if (this.buffer.length() == 0 && codepoint == 42 && CSSParser.this.parserFlags.contains((Object)Parser2.Flag.STARHACK)) {
                if (CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.warning(this.createException(index, (byte)4, "Unexpected character: * (IE hack)"));
                }
                this.buffer.append('*');
            } else {
                this.unexpectedCharError(index, codepoint);
            }
        }

        protected void endOfPropertyDeclaration(int index) {
            if (this.propertyName != null) {
                this.processBuffer(index);
                if (!this.parseError) {
                    if (this.lunit != null) {
                        CSSParser.this.handler.property(this.propertyName, (LexicalUnit)this.lunit, this.priorityImportant);
                    } else {
                        this.handleError(index, (byte)32, "Found property name (" + this.propertyName + ") but no value");
                    }
                }
                this.propertyName = null;
            } else if (this.buffer.length() != 0) {
                this.unexpectedTokenError(index, this.buffer);
            }
            this.resetHandler();
        }

        @Override
        void resetHandler() {
            super.resetHandler();
            this.lunit = null;
            this.currentlu = null;
            this.priorityImportant = false;
            this.readPriority = false;
            this.functionToken = false;
            this.hexColor = false;
            this.unicodeRange = false;
            this.buffer.setLength(0);
        }

        protected void processBuffer(int index) {
            if (this.parseError) {
                this.buffer.setLength(0);
                return;
            }
            int buflen = this.buffer.length();
            if (buflen != 0) {
                if (this.propertyName == null) {
                    String raw = this.buffer.toString();
                    String s = this.unescapeBuffer(index);
                    if (this.isValidIdentifier(raw)) {
                        this.propertyName = s;
                    } else {
                        this.handleError(index - buflen, (byte)7, "Invalid identifier: " + raw);
                    }
                } else if (this.readPriority) {
                    String prio = this.rawBuffer();
                    if ("important".equalsIgnoreCase(prio)) {
                        this.priorityImportant = true;
                    } else {
                        this.checkIEPrioHack(index - buflen, prio);
                    }
                } else if (this.unicodeRange) {
                    this.parseUnicodeRange(index, buflen);
                } else if (this.functionToken) {
                    if (this.currentlu.getLexicalUnitType() == 24) {
                        this.currentlu.value = this.rawBuffer();
                    } else if (this.currentlu.getLexicalUnitType() == 73) {
                        String s = this.unescapeStringValue(index);
                        if (s.length() > 1 && s.charAt(0) == '#') {
                            this.currentlu.value = s.substring(1);
                        } else {
                            this.handleError(index - buflen, (byte)5, "Wrong element reference: " + s);
                            this.functionToken = false;
                        }
                        this.buffer.setLength(0);
                    } else if (this.escapedTokenIndex != -1 || !this.checkLastIdentCompat()) {
                        if (!this.hexColor) {
                            this.parseNonHexcolorValue(index);
                        } else {
                            if (!this.parseHexColor(buflen)) {
                                this.handleError(index - buflen, (byte)5, "Wrong color value #" + this.buffer);
                            }
                            this.buffer.setLength(0);
                            this.hexColor = false;
                        }
                    }
                } else if (this.hexColor) {
                    if (!this.parseHexColor(buflen)) {
                        this.handleError(index - buflen, (byte)5, "Wrong color value #" + this.buffer);
                    }
                    this.buffer.setLength(0);
                    this.hexColor = false;
                } else {
                    this.parseNonHexcolorValue(index);
                }
            } else if (this.hexColor) {
                this.handleError(index, (byte)5, "Empty hex color value");
            } else if (this.unicodeRange) {
                this.handleError(index, (byte)9, "Bad unicode range");
            }
        }

        private void parseNonHexcolorValue(int index) {
            String cssText;
            String str;
            String raw = this.buffer.toString();
            int buflen = raw.length();
            if (this.escapedTokenIndex != -1) {
                int escsz = index - this.escapedTokenIndex;
                int nonescLen = buflen - escsz;
                if (nonescLen <= 0) {
                    try {
                        str = this.unescapeIdentifier(index, raw);
                    }
                    catch (DOMNullCharacterException e) {
                        if (this.flagIEValues) {
                            this.setIdentCompat(index - buflen, raw);
                            this.escapedTokenIndex = -1;
                            this.buffer.setLength(0);
                            return;
                        }
                        str = this.safeUnescapeIdentifier(index, raw);
                    }
                    cssText = ParseHelper.escapeCssChars(ParseHelper.escapeBackslash(raw)).toString();
                } else {
                    CharSequence rawPart = this.buffer.subSequence(0, nonescLen);
                    cssText = this.buffer.substring(nonescLen);
                    try {
                        str = this.unescapeIdentifier(index, cssText);
                        str = rawPart + str;
                    }
                    catch (DOMNullCharacterException e) {
                        if (this.flagIEValues) {
                            this.setIdentCompat(index - buflen, raw);
                            this.escapedTokenIndex = -1;
                            this.buffer.setLength(0);
                            return;
                        }
                        str = this.safeUnescapeIdentifier(index, cssText);
                        str = rawPart + str;
                    }
                    rawPart = ParseHelper.escapeAllBackslash(rawPart);
                    cssText = ParseHelper.escapeCssCharsAndFirstChar(rawPart) + cssText;
                }
                this.escapedTokenIndex = -1;
            } else {
                str = this.buffer.toString();
                cssText = ParseHelper.escapeCssCharsAndFirstChar(raw).toString();
            }
            this.createIdentifierOrKeyword(index, raw, str, cssText);
        }

        private void createIdentifierOrKeyword(int index, String raw, String ident, String cssText) {
            int i;
            this.buffer.setLength(0);
            int len = ident.length();
            for (i = len - 1; i >= 0; --i) {
                int cp = ident.codePointAt(i);
                if (Character.isLetter(cp) || cp == 37) continue;
                if (cp >= 48 && cp <= 57 && this.parseNumber(index, ident, i + 1) || this.newIdentifier(raw, ident, cssText)) break;
                this.checkForIEValue(index, raw);
                break;
            }
            if (i == -1) {
                if (ident.equalsIgnoreCase("inherit")) {
                    this.newLexicalUnit((short)12);
                } else if (ident.equalsIgnoreCase("initial")) {
                    this.newLexicalUnit((short)35).value = "initial";
                } else if (ident.equalsIgnoreCase("unset")) {
                    this.newLexicalUnit((short)35).value = "unset";
                } else if (!this.newIdentifier(raw, ident, cssText)) {
                    this.handleError(index - raw.length(), (byte)7, "Invalid identifier: " + raw);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseUnicodeRange(int index, int buflen) {
            LexicalUnitImpl lu1;
            LexicalUnitImpl lu2 = null;
            String s = this.rawBuffer();
            int idx = s.indexOf(45);
            if (idx == -1) {
                byte check = this.rangeLengthCheck(s);
                if (check == 1) {
                    lu1 = new LexicalUnitImpl(13);
                    lu1.intValue = Integer.parseInt(s, 16);
                } else {
                    if (check != 2) {
                        this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                        return;
                    }
                    lu1 = new LexicalUnitImpl(70);
                    lu1.value = s;
                }
            } else if (idx > 0 && idx < s.length() - 1) {
                String range1 = s.substring(0, idx);
                String range2 = s.substring(idx + 1);
                byte check = this.rangeLengthCheck(range1);
                if (check != 1) {
                    this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                    return;
                }
                lu1 = new LexicalUnitImpl(13);
                lu1.intValue = Integer.parseInt(range1, 16);
                check = this.rangeLengthCheck(range2);
                if (check != 1) {
                    this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                    return;
                }
                lu2 = new LexicalUnitImpl(13);
                lu2.intValue = Integer.parseInt(range2, 16);
            } else {
                this.handleError(index - buflen, (byte)9, "Invalid unicode range: " + s);
                return;
            }
            LexicalUnitImpl range = this.newLexicalUnit((short)39);
            range.addFunctionParameter(lu1);
            if (lu2 != null) {
                range.addFunctionParameter(lu2);
            }
            this.unicodeRange = false;
        }

        private byte rangeLengthCheck(String range) {
            int wildcardCount = 0;
            int len = range.length();
            if (len < 7) {
                for (int i = 0; i < len; ++i) {
                    if (range.charAt(i) == '?') {
                        wildcardCount = (byte)(wildcardCount + 1);
                        continue;
                    }
                    if (wildcardCount == 0) continue;
                    return 0;
                }
                if (wildcardCount == 0) {
                    return 1;
                }
                if (wildcardCount != 6) {
                    return 2;
                }
            }
            return 0;
        }

        private boolean parseNumber(int index, String s, int i) {
            String strnum;
            short unitType;
            String unit = null;
            if (i != s.length()) {
                unit = s.substring(i);
                unit = unit.trim().toLowerCase(Locale.ROOT).intern();
                unitType = ParseHelper.unitFromString(unit);
                strnum = s.substring(0, i);
            } else {
                unitType = s.lastIndexOf(46, i) == -1 ? (short)13 : 14;
                strnum = s;
            }
            if (unitType == 13) {
                try {
                    int intval = Integer.parseInt(strnum);
                    LexicalUnitImpl lu = this.newLexicalUnit(unitType);
                    lu.intValue = intval;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            try {
                float flval = Float.parseFloat(strnum);
                if (unitType == 14 && flval == 0.0f) {
                    LexicalUnitImpl lu = this.newLexicalUnit((short)13);
                    lu.intValue = (int)flval;
                } else {
                    LexicalUnitImpl lu = this.newLexicalUnit(unitType);
                    lu.floatValue = flval;
                    if (unit != null) {
                        lu.dimensionUnitText = unit;
                    }
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        private boolean parseHexColor(int buflen) {
            block6: {
                try {
                    if (buflen == 3) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.parseHexComponent(1, 2, true);
                        this.parseHexComponent(2, 3, true);
                        this.recoverOwnerUnit();
                        this.functionToken = prevft;
                        break block6;
                    }
                    if (buflen == 6) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.parseHexComponent(2, 4, false);
                        this.parseHexComponent(4, 6, false);
                        this.recoverOwnerUnit();
                        this.functionToken = prevft;
                        break block6;
                    }
                    if (buflen == 8) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 2, false);
                        this.parseHexComponent(2, 4, false);
                        this.parseHexComponent(4, 6, false);
                        int comp = this.hexComponent(6, 8, false);
                        this.newLexicalUnit((short)4);
                        this.newLexicalUnit((short)14).floatValue = (float)comp / 255.0f;
                        this.recoverOwnerUnit();
                        this.functionToken = prevft;
                        break block6;
                    }
                    if (buflen == 4) {
                        this.newLexicalUnit((short)27);
                        this.currentlu.value = "rgb";
                        boolean prevft = this.functionToken;
                        this.functionToken = true;
                        this.parseHexComponent(0, 1, true);
                        this.parseHexComponent(1, 2, true);
                        this.parseHexComponent(2, 3, true);
                        int comp = this.hexComponent(3, 4, true);
                        this.newLexicalUnit((short)4);
                        this.newLexicalUnit((short)14).floatValue = (float)comp / 255.0f;
                        this.recoverOwnerUnit();
                        this.functionToken = prevft;
                        break block6;
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }

        private void parseHexComponent(int start, int end, boolean doubleDigit) {
            int comp;
            this.newLexicalUnit((short)13).intValue = comp = this.hexComponent(start, end, doubleDigit);
        }

        private int hexComponent(int start, int end, boolean doubleDigit) {
            String s;
            if (doubleDigit) {
                CharSequence seq = this.buffer.subSequence(start, end);
                s = new StringBuilder(2).append(seq).append(seq).toString();
            } else {
                s = this.buffer.substring(start, end);
            }
            return Integer.parseInt(s, 16);
        }

        private void recoverOwnerUnit() {
            this.currentlu.identCssText = "#" + this.buffer;
            if (this.currentlu.ownerLexicalUnit != null) {
                this.currentlu = this.currentlu.ownerLexicalUnit;
            }
        }

        private boolean newIdentifier(String raw, String ident, String cssText) {
            if (this.isValidIdentifier(raw)) {
                String lcident;
                if (this.propertyDatabase != null && (lcident = ident.toLowerCase(Locale.ROOT)) != ident) {
                    if (this.propertyDatabase.isShorthand(this.propertyName)) {
                        if (!this.isPreviousValueCustomIdent()) {
                            String[] longhands = this.propertyDatabase.getLonghandProperties(this.propertyName);
                            for (int i = 0; i < longhands.length; ++i) {
                                if (!this.isIdentifierValueOf(longhands[i], lcident)) continue;
                                ident = lcident;
                            }
                        }
                    } else if (this.isIdentifierValueOf(this.propertyName, lcident)) {
                        ident = lcident;
                    }
                }
                LexicalUnitImpl lu = this.newLexicalUnit((short)35);
                lu.value = ident;
                lu.identCssText = cssText;
                return true;
            }
            return false;
        }

        private boolean isIdentifierValueOf(String propertyName, String lcident) {
            return this.propertyDatabase.isIdentifierValue(propertyName, lcident) || "none".equals(lcident);
        }

        private boolean isPreviousValueCustomIdent() {
            String s;
            return this.currentlu != null && this.currentlu.getLexicalUnitType() == 35 && (s = this.currentlu.getStringValue()) != s.toLowerCase(Locale.ROOT);
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quoteChar) {
            if (!(this.hexColor || this.unicodeRange || this.readPriority || this.propertyName == null)) {
                this.processBuffer(index);
                if (!this.parseError) {
                    String s = quoted.toString();
                    LexicalUnitImpl lu = this.newLexicalUnit((short)36);
                    lu.value = this.safeUnescapeIdentifier(index, s);
                    char c = (char)quoteChar;
                    StringBuilder buf = new StringBuilder(s.length() + 2);
                    buf.append(c).append(s).append(c);
                    lu.identCssText = buf.toString();
                    this.prevcp = 65;
                }
            } else {
                char c = (char)quoteChar;
                StringBuilder buf = new StringBuilder(quoted.length() + 2);
                buf.append(c).append(quoted).append(c);
                this.unexpectedTokenError(index, buf.toString());
            }
        }

        @Override
        public void quotedWithControl(int index, CharSequence quoted, int quoteChar) {
            if (!(this.hexColor || this.unicodeRange || this.readPriority || this.propertyName == null)) {
                this.processBuffer(index);
                if (!this.parseError) {
                    String s = quoted.toString();
                    LexicalUnitImpl lu = this.newLexicalUnit((short)36);
                    lu.value = this.safeUnescapeIdentifier(index, s);
                    char c = (char)quoteChar;
                    lu.identCssText = c + ParseHelper.escapeControl(s) + c;
                    this.prevcp = 65;
                }
            } else {
                char c = (char)quoteChar;
                StringBuilder buf = new StringBuilder(quoted.length() + 2);
                buf.append(c).append(quoted).append(c);
                this.unexpectedTokenError(index, buf.toString());
            }
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (!this.parseError && (this.unicodeRange || this.isEscapedContentError(index, codepoint))) {
                this.unexpectedCharError(index, codepoint);
            }
        }

        private boolean isEscapedContext(int prevcp) {
            return prevcp == 65 || prevcp == 32 || prevcp == 13 || prevcp == 58 || prevcp == 44 || prevcp == 59 || prevcp == 123;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isEscapedContentError(int index, int codepoint) {
            if (this.isEscapedContext(this.prevcp) && !this.hexColor) {
                if (ParseHelper.isHexCodePoint(codepoint)) {
                    this.setEscapedTokenStart(index);
                    this.buffer.append('\\');
                }
                this.prevcp = 65;
                this.bufferAppend(codepoint);
                return false;
            } else {
                if (!this.flagIEValues || !this.isIEHackSuffix(codepoint) || this.lunit == null && this.buffer.length() == 0) return true;
                this.buffer.append('\\');
                this.bufferAppend(codepoint);
                String compatText = this.setFullIdentCompat();
                this.escapedTokenIndex = -1;
                if (compatText == null) return true;
                this.warnIdentCompat(index, compatText);
                this.prevcp = codepoint;
            }
            return false;
        }

        @Override
        public void separator(int index, int codepoint) {
            if (!this.parseError) {
                if (this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(this.buffer)) {
                    this.buffer.append(' ');
                    return;
                }
                this.processBuffer(index);
            }
            this.prevcp = 32;
        }

        @Override
        protected void highControl(int index, int codepoint) {
            if (!this.parseError) {
                if (!(this.hexColor || this.unicodeRange || this.readPriority || this.propertyName == null)) {
                    this.bufferAppend(codepoint);
                } else {
                    this.handleError(index, (byte)4, "Unexpected control: " + codepoint);
                }
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (!this.parseError && this.buffer.length() == 0 && this.propertyName == null && this.curlyBracketDepth == 1 && this.parendepth == 0 && this.squareBracketDepth == 0) {
                super.commented(index, commentType, comment);
            }
        }

        @Override
        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handleError(len, (byte)6, "Unmatched parenthesis");
            } else if (this.propertyName != null) {
                this.processBuffer(len);
                this.endOfPropertyDeclaration(len);
            } else if (this.buffer.length() != 0) {
                this.handleError(len, (byte)9, "Unexpected token: " + this.buffer);
            }
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            super.error(index, errCode, context);
            this.lunit = null;
        }

        private void checkIEPrioHack(int index, String prio) {
            String compatText;
            this.buffer.append('!').append(prio);
            if (CSSParser.this.parserFlags.contains((Object)Parser2.Flag.IEPRIO) && "ie".equals(prio) && (compatText = this.setFullIdentCompat()) != null) {
                this.warnIdentCompat(index, compatText);
            } else {
                this.handleError(index, (byte)9, "Invalid priority: " + prio);
            }
        }

        private void checkForIEValue(int index, String raw) {
            int rawlen = raw.length();
            if (!(this.flagIEValues && rawlen > 2 && raw.charAt(rawlen - 2) == '\\' && this.isIEHackSuffix(raw.codePointAt(rawlen - 1)) && this.setIdentCompat(index - rawlen, raw))) {
                this.handleError(index - rawlen, (byte)7, "Invalid identifier: " + raw);
            }
        }

        private boolean isIEHackSuffix(int codepoint) {
            return codepoint == 57 || codepoint == 48;
        }

        private boolean setIdentCompat(int index, String lastvalue) {
            if (this.currentlu != null) {
                String prev;
                try {
                    prev = this.currentlu.toString();
                }
                catch (RuntimeException e) {
                    this.lunit.reset();
                    return false;
                }
                this.currentlu.reset();
                this.currentlu.value = prev + ' ' + lastvalue;
                this.currentlu.setUnitType((short)71);
            } else {
                this.newLexicalUnit((short)71).value = lastvalue;
            }
            this.warnIdentCompat(index, lastvalue);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String setFullIdentCompat() {
            String newval;
            if (!this.hexColor) {
                newval = this.rawBuffer();
            } else {
                this.hexColor = false;
                newval = '#' + this.rawBuffer();
            }
            if (this.lunit != null) {
                try {
                    newval = this.lunit.toString() + newval;
                }
                catch (RuntimeException e) {
                    String string = null;
                    return string;
                }
                finally {
                    this.lunit.reset();
                }
                this.lunit.value = newval;
                this.lunit.setUnitType((short)71);
            } else {
                this.newLexicalUnit((short)71).value = newval;
            }
            return newval;
        }

        private void warnIdentCompat(int index, String ident) {
            this.handleWarning(index, (byte)-2, "Found compat ident: " + ident);
        }
    }

    class DeclarationRuleTokenHandler
    extends DeclarationTokenHandler {
        private String ruleFirstPart;

        DeclarationRuleTokenHandler(InputSource source, ShorthandDatabase propertyDatabase) {
            super(source, propertyDatabase, 0);
            this.ruleFirstPart = null;
        }

        @Override
        void addWord(int index, CharSequence word) {
            if (this.prevcp == 64) {
                this.ruleFirstPart = word.toString().toLowerCase(Locale.ROOT);
                this.buffer.setLength(0);
            } else {
                super.addWord(index, word);
            }
        }

        @Override
        protected void handleAtKeyword(int index) {
            if (this.propertyName != null || this.buffer.length() != 0) {
                this.unexpectedCharError(index, 64);
            } else {
                this.buffer.append('@');
            }
        }

        @Override
        protected void handleLeftCurlyBracket(int index) {
            if (!this.parseError) {
                String ruleSecondPart = null;
                if (this.buffer.length() != 0) {
                    ruleSecondPart = this.unescapeBuffer(index);
                }
                this.prevcp = 32;
                ((DeclarationRuleHandler)CSSParser.this.handler).startAtRule(this.ruleFirstPart, ruleSecondPart);
            }
        }

        @Override
        protected void handleRightCurlyBracket(int index) {
            if (!this.parseError) {
                ((DeclarationRuleHandler)CSSParser.this.handler).endAtRule();
                this.resetHandler();
                this.ruleFirstPart = null;
            }
        }

        @Override
        public void character(int index, int codepoint) {
            if (this.getCurlyBracketDepth() != 0) {
                super.character(index, codepoint);
            } else {
                this.bufferAppend(codepoint);
                this.prevcp = codepoint;
            }
        }

        @Override
        protected void processBuffer(int index) {
            if (this.getCurlyBracketDepth() != 0) {
                super.processBuffer(index);
            }
        }
    }

    private class RuleTokenHandler
    extends SheetTokenHandler {
        RuleTokenHandler(InputSource source, Parser2.NamespaceMap nsMap) {
            super(source, nsMap);
        }

        @Override
        protected void endRuleBody() {
            if (this.getCurlyBracketDepth() == 0) {
                this.contextHandler = new RuleEndContentHandler();
            } else {
                super.endRuleBody();
            }
        }

        @Override
        protected void resetRuleState() {
            super.resetRuleState();
            this.contextHandler = new RuleEndContentHandler();
        }

        @Override
        void endDocument() {
        }

        private class RuleEndContentHandler
        extends CSSTokenHandler {
            RuleEndContentHandler() {
                super(null);
            }

            @Override
            public void word(int index, CharSequence word) {
                this.reportError(index);
            }

            @Override
            public void separator(int index, int codePoint) {
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quoteCp) {
                this.reportError(index);
            }

            @Override
            public void quotedWithControl(int index, CharSequence quoted, int quote) {
                this.reportError(index);
            }

            @Override
            public void openGroup(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void closeGroup(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void character(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void escaped(int index, int codePoint) {
                this.reportError(index);
            }

            @Override
            public void control(int index, int codepoint) {
                RuleTokenHandler.this.control(index, codepoint);
            }

            @Override
            public void commented(int index, int commentType, String comment) {
            }

            @Override
            public void endOfStream(int len) {
            }

            @Override
            public void error(int index, byte errCode, CharSequence context) {
                this.handleError(index, (byte)9, "Found tokens after rule");
            }

            private void reportError(int index) {
                this.handleError(index, (byte)9, "Found tokens after rule");
            }

            @Override
            protected void handleError(int index, byte errCode, String message) {
                if (!this.parseError && CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.fatalError(this.createException(index, errCode, message));
                }
                this.parseError = true;
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return RuleTokenHandler.this.createException(index, errCode, message);
            }
        }
    }

    private class KeyFrameBlockListTH
    extends NestedRuleTH {
        KeyFrameBlockListTH(int offset, int bufSize) {
            super(offset, bufSize, "@keyframes", true);
        }

        @Override
        void processSelector(int index) {
            String selector = this.rawBuffer();
            InputSource source = new InputSource((Reader)new StringReader(selector));
            try {
                LexicalUnit2 kfsel = CSSParser.this.parsePropertyValue(source);
                ((KeyframesHandler)CSSParser.this.handler).startKeyframe(kfsel);
            }
            catch (CSSException e) {
                this.handleError(index, (byte)5, e.getMessage());
                this.setStage((byte)9);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        void processName(int index, String name) {
            super.processName(index, name);
            if (!this.parseError) {
                ((KeyframesHandler)CSSParser.this.handler).startKeyframes(name);
            }
        }

        @Override
        void endBlock() {
            ((KeyframesHandler)CSSParser.this.handler).endKeyframe();
        }

        @Override
        void endBlockList() {
            ((KeyframesHandler)CSSParser.this.handler).endKeyframes();
        }

        @Override
        boolean isValidSelectorCharacter(int codePoint) {
            return codePoint == 37 || codePoint == 44 || codePoint == 46;
        }

        @Override
        boolean isValidNameCharacter(int codePoint) {
            return false;
        }
    }

    private class FontFeatureValuesTH
    extends NestedRuleTH {
        FontFeatureValuesTH(int offset, int bufSize) {
            super(offset, bufSize, "@font-feature-values", false);
        }

        @Override
        void processSelector(int index) {
            String selector = this.unescapeBuffer(index);
            if (selector.length() > 1 && selector.charAt(0) == '@') {
                ((FontFeatureValuesHandler)CSSParser.this.handler).startFeatureMap(selector.substring(1).trim());
            } else {
                this.handleError(index, (byte)33, "Bad feature name: " + selector);
            }
        }

        @Override
        void processName(int index, String name) {
            String[] familyName;
            for (String fontName : familyName = name.split("\\s*,\\s*")) {
                super.processName(index, fontName);
            }
            if (!this.parseError) {
                ((FontFeatureValuesHandler)CSSParser.this.handler).startFontFeatures(familyName);
            }
        }

        @Override
        void endBlock() {
            ((FontFeatureValuesHandler)CSSParser.this.handler).endFeatureMap();
        }

        @Override
        void endBlockList() {
            ((FontFeatureValuesHandler)CSSParser.this.handler).endFontFeatures();
        }

        @Override
        boolean isValidSelectorCharacter(int codePoint) {
            return codePoint == 64;
        }

        @Override
        boolean isValidNameCharacter(int codePoint) {
            return codePoint == 45;
        }
    }

    private class SupportsTokenHandler
    extends ConditionTokenHandler {
        private byte errorCode;
        private CSSParseException errorException;
        private final ExtendedCSSRule rule;

        SupportsTokenHandler(ExtendedCSSRule rule) {
            super(new SupportsConditionFactory());
            this.errorCode = 0;
            this.errorException = null;
            this.rule = rule;
            this.setPredicateHandler(new SupportsDelegateHandler());
        }

        BooleanCondition getCondition() {
            BooleanCondition condition = this.currentCond;
            if (condition != null) {
                while (condition.getParentCondition() != null) {
                    condition = condition.getParentCondition();
                }
            }
            return condition;
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                if (this.errorCode == 0) {
                    this.errorCode = errCode;
                    this.errorException = this.createException(index, errCode, message);
                    if (this.rule != null) {
                        this.rule.getParentStyleSheet().getErrorHandler().ruleParseError(this.rule, this.errorException);
                    } else {
                        throw this.errorException;
                    }
                }
                this.parseError = true;
            }
        }

        private class SupportsDelegateHandler
        extends DelegateHandler {
            private boolean readingValue;
            private short valueParendepth;

            SupportsDelegateHandler() {
                this.readingValue = false;
                this.valueParendepth = 0;
            }

            @Override
            public void word(int index, CharSequence word) {
                if (SupportsTokenHandler.this.buffer.length() != 0) {
                    if (!this.readingValue) {
                        SupportsTokenHandler.this.unexpectedTokenError(index, word);
                        return;
                    }
                    if (SupportsTokenHandler.this.prevcp == 32 || SupportsTokenHandler.this.prevcp == 13) {
                        SupportsTokenHandler.this.buffer.append(' ');
                    }
                }
                SupportsTokenHandler.this.buffer.append(word);
            }

            @Override
            public void openGroup(int index, int codepoint) {
                if (this.readingValue) {
                    SupportsTokenHandler.this.bufferAppend(codepoint);
                } else if (codepoint != 40) {
                    SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                } else if (SupportsTokenHandler.this.buffer.length() != 0) {
                    SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                } else {
                    SupportsTokenHandler.this.prevcp = codepoint;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void closeGroup(int index, int codepoint) {
                if (codepoint == 41) {
                    if (this.readingValue) {
                        if (this.valueParendepth == SupportsTokenHandler.this.getCurrentParenDepth()) {
                            String svalue = SupportsTokenHandler.this.buffer.toString();
                            ValueFactory factory = new ValueFactory();
                            try {
                                StyleValue value = factory.parseProperty(svalue);
                                ((DeclarationCondition)((Object)SupportsTokenHandler.this.currentCond)).setValue(value);
                            }
                            catch (DOMException e) {
                                SupportsTokenHandler.this.handleError(index, (byte)5, "Bad @supports condition value.");
                                SupportsTokenHandler.this.errorException.initCause((Throwable)e);
                                ((DeclarationCondition)((Object)SupportsTokenHandler.this.currentCond)).setValue(svalue);
                            }
                            SupportsTokenHandler.this.buffer.setLength(0);
                            this.readingValue = false;
                            SupportsTokenHandler.this.readingPredicate = false;
                            SupportsTokenHandler.this.escapedTokenIndex = -1;
                            return;
                        }
                        SupportsTokenHandler.this.bufferAppend(codepoint);
                        return;
                    }
                    SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                    return;
                }
                if (this.readingValue) {
                    SupportsTokenHandler.this.bufferAppend(codepoint);
                    return;
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                }
            }

            @Override
            public void character(int index, int codepoint) {
                if (!this.readingValue) {
                    if (codepoint == 58) {
                        BooleanCondition newCond = SupportsTokenHandler.this.conditionFactory.createPredicate(SupportsTokenHandler.this.buffer.toString());
                        if (SupportsTokenHandler.this.currentCond != null) {
                            SupportsTokenHandler.this.currentCond.addCondition(newCond);
                        }
                        SupportsTokenHandler.this.currentCond = newCond;
                        SupportsTokenHandler.this.buffer.setLength(0);
                        this.valueParendepth = SupportsTokenHandler.this.getCurrentParenDepth();
                        this.valueParendepth = (short)(this.valueParendepth - 1);
                        this.readingValue = true;
                        SupportsTokenHandler.this.escapedTokenIndex = -1;
                    } else {
                        SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 59) {
                    SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                } else {
                    SupportsTokenHandler.this.bufferAppend(codepoint);
                }
                SupportsTokenHandler.this.prevcp = codepoint;
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quoteCp) {
                if (this.readingValue) {
                    if (SupportsTokenHandler.this.buffer.length() != 0) {
                        SupportsTokenHandler.this.buffer.append(' ');
                    }
                    char c = (char)quoteCp;
                    SupportsTokenHandler.this.buffer.append(c).append(quoted).append(c);
                    SupportsTokenHandler.this.prevcp = 65;
                } else {
                    SupportsTokenHandler.this.handleError(index, (byte)9, "Unexpected: '" + quoted + '\'');
                }
            }

            @Override
            public void escaped(int index, int codepoint) {
                if (ParseHelper.isHexCodePoint(codepoint)) {
                    SupportsTokenHandler.this.setEscapedTokenStart(index);
                    SupportsTokenHandler.this.buffer.append('\\');
                }
                SupportsTokenHandler.this.bufferAppend(codepoint);
            }

            @Override
            public void separator(int index, int cp) {
                if (SupportsTokenHandler.this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(SupportsTokenHandler.this.buffer)) {
                    SupportsTokenHandler.this.buffer.append(' ');
                    return;
                }
            }

            @Override
            public void endOfStream(int len) {
                if (SupportsTokenHandler.this.readingPredicate) {
                    SupportsTokenHandler.this.handleError(len, (byte)10, "Unexpected end of file");
                } else if (SupportsTokenHandler.this.buffer.length() != 0) {
                    SupportsTokenHandler.this.handleError(len, (byte)9, "Unexpected token: " + SupportsTokenHandler.this.buffer);
                } else if (SupportsTokenHandler.this.currentCond == null) {
                    SupportsTokenHandler.this.handleError(len, (byte)10, "No condition found");
                }
            }
        }
    }

    private class MediaQueryTokenHandler
    extends ConditionTokenHandler {
        MediaQueryTokenHandler(MediaConditionFactory conditionFactory, MediaQueryHandler mqhandler) {
            super(conditionFactory);
            this.setPredicateHandler(new MediaQueryDelegateHandler(mqhandler));
        }

        @Override
        MediaQueryDelegateHandler getPredicateHandler() {
            return (MediaQueryDelegateHandler)super.getPredicateHandler();
        }

        @Override
        void processImplicitAnd(int index) {
            MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
            String medium = mqhelper.mediaType;
            if (medium == null) {
                if (this.buffer.length() != 0) {
                    mqhelper.processMediaType(index);
                } else {
                    this.unexpectedTokenError(index, "and");
                    return;
                }
            }
            this.currentCond = ((MediaConditionFactory)this.conditionFactory).createMediaTypePredicate(medium);
            this.processOperation(index, BooleanCondition.Type.AND, "and");
        }

        @Override
        BooleanCondition createOperation(BooleanCondition.Type opType) {
            if (opType == BooleanCondition.Type.AND) {
                return this.conditionFactory.createAndCondition();
            }
            if (this.getPredicateHandler().mediaType == null) {
                return this.conditionFactory.createOrCondition();
            }
            throw new DOMException(12, "Unexpected 'OR'");
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
                CSSParseException ex = this.createException(index, errCode, message);
                mqhelper.handler.invalidQuery(ex);
                this.parseError = true;
            }
        }

        @Override
        void handleWarning(int index, byte errCode, String message) {
            if (!this.parseError) {
                MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
                CSSParseException ex = this.createException(index, errCode, message);
                mqhelper.handler.compatQuery(ex);
                super.handleWarning(index, errCode, message);
            }
        }

        class MediaQueryDelegateHandler
        extends DelegateHandler {
            private final MediaQueryHandler handler;
            private byte stage;
            private boolean negativeQuery;
            private boolean spaceFound;
            private String mediaType;
            private String featureName;
            private String firstValue;
            private byte rangeType;
            private boolean functionToken;
            private static final int WORD_UNQUOTED = 0;

            private MediaQueryDelegateHandler(MediaQueryHandler handler) {
                this.stage = 0;
                this.negativeQuery = false;
                this.spaceFound = false;
                this.mediaType = null;
                this.featureName = null;
                this.firstValue = null;
                this.rangeType = 0;
                this.functionToken = false;
                this.handler = handler;
            }

            @Override
            public void word(int index, CharSequence word) {
                if (this.stage == 127) {
                    return;
                }
                if (this.functionToken) {
                    if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                        MediaQueryTokenHandler.this.buffer.append(' ');
                    }
                    MediaQueryTokenHandler.this.buffer.append(word);
                } else if (ParseHelper.equalsIgnoreCase(word, "not")) {
                    if (this.stage != 0) {
                        MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found 'not' at the wrong parsing stage");
                    } else {
                        this.negativeQuery = true;
                    }
                } else if (ParseHelper.equalsIgnoreCase(word, "only")) {
                    if (this.stage != 0) {
                        MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found 'only' at the wrong parsing stage");
                    } else {
                        this.handler.onlyPrefix();
                    }
                } else if (ParseHelper.equalsIgnoreCase(word, "or")) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found 'or'");
                } else if (!this.appendWord(index, word, 0)) {
                    return;
                }
                MediaQueryTokenHandler.this.prevcp = 65;
            }

            private boolean appendWord(int index, CharSequence word, int quote) {
                if (MediaQueryTokenHandler.this.buffer.length() != 0 && MediaQueryTokenHandler.this.escapedTokenIndex == -1 && (MediaQueryTokenHandler.this.prevcp == 32 || MediaQueryTokenHandler.this.prevcp == 13)) {
                    if (this.stage == 1) {
                        MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found white space between media");
                        return false;
                    }
                    this.spaceFound = true;
                    MediaQueryTokenHandler.this.buffer.append(' ');
                }
                if (quote == 0) {
                    MediaQueryTokenHandler.this.buffer.append(word);
                } else {
                    char c = (char)quote;
                    MediaQueryTokenHandler.this.buffer.append(c).append(word).append(c);
                }
                if (!this.functionToken) {
                    if (this.stage == 0) {
                        this.stage = 1;
                    } else if (this.stage == 5) {
                        this.stage = (byte)6;
                    }
                }
                return true;
            }

            @Override
            public void preBooleanHandling(int index, BooleanCondition.Type type) {
                switch (type) {
                    case AND: {
                        if (this.stage > 1) {
                            MediaQueryTokenHandler.this.handleError(index, (byte)33, "Found 'and' at the wrong parsing stage");
                            return;
                        }
                        if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                            this.processMediaType(index);
                        }
                    }
                    case OR: {
                        this.stage = (byte)2;
                        break;
                    }
                }
            }

            private void processMediaType(int index) {
                if (this.mediaType == null && MediaQueryTokenHandler.this.getCurrentParenDepth() == 0) {
                    this.mediaType = this.rawBuffer();
                    if (MediaQueryTokenHandler.this.currentCond != null && this.isEmptyNotCondition()) {
                        MediaQueryTokenHandler.this.currentCond = null;
                        this.negativeQuery = true;
                        this.handler.negativeQuery();
                    }
                    this.handler.mediaType(this.mediaType);
                }
            }

            private boolean isEmptyNotCondition() {
                return MediaQueryTokenHandler.this.currentCond.getType() == BooleanCondition.Type.NOT && MediaQueryTokenHandler.this.currentCond.getParentCondition() == null && MediaQueryTokenHandler.this.currentCond.getNestedCondition() == null;
            }

            @Override
            public void openGroup(int index, int codepoint) {
                if (codepoint == 40) {
                    if (MediaQueryTokenHandler.this.prevcp != 32 && MediaQueryTokenHandler.this.prevcp != 13) {
                        this.functionToken = true;
                        MediaQueryTokenHandler.this.buffer.append('(');
                    } else if (this.functionToken) {
                        MediaQueryTokenHandler.this.buffer.append('(');
                    } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                    } else if (this.stage == 2 || this.stage == 0) {
                        this.stage = (byte)3;
                    }
                    MediaQueryTokenHandler.this.parendepth = (short)(MediaQueryTokenHandler.this.parendepth + 1);
                } else {
                    MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                }
                MediaQueryTokenHandler.this.prevcp = codepoint;
            }

            @Override
            public void closeGroup(int index, int codepoint) {
                if (codepoint == 41) {
                    MediaQueryTokenHandler.this.parendepth = (short)(MediaQueryTokenHandler.this.parendepth - 1);
                    if (this.functionToken) {
                        MediaQueryTokenHandler.this.buffer.append(')');
                        this.functionToken = false;
                    } else {
                        if (this.stage == 6) {
                            String tempstr;
                            this.processBuffer(index);
                            if (this.firstValue != null && CSSParser.isKnownFeature(this.firstValue)) {
                                tempstr = this.firstValue;
                                this.firstValue = this.featureName;
                                this.featureName = tempstr;
                            } else if (!CSSParser.isKnownFeature(this.featureName)) {
                                if (CSSParser.isValidFeatureSyntax(this.firstValue)) {
                                    tempstr = this.firstValue;
                                    this.firstValue = this.featureName;
                                    this.featureName = tempstr;
                                } else {
                                    if (!CSSParser.isValidFeatureSyntax(this.featureName)) {
                                        MediaQueryTokenHandler.this.handleError(index, (byte)33, "Wrong feature expression near " + this.featureName + " " + this.firstValue + ")");
                                        MediaQueryTokenHandler.this.prevcp = codepoint;
                                        return;
                                    }
                                    this.reverseRangetype();
                                }
                            } else {
                                this.reverseRangetype();
                            }
                            ExtendedCSSPrimitiveValue value1 = CSSParser.this.parseMediaFeature(this.firstValue);
                            if (value1 == null) {
                                MediaQueryTokenHandler.this.handleError(index, (byte)5, this.firstValue);
                            } else {
                                this.handlePredicate(this.featureName, this.rangeType, value1);
                                if (value1.getPrimitiveType() == 0) {
                                    MediaQueryTokenHandler.this.handleWarning(index, (byte)-2, "Probable hack in media feature.");
                                }
                            }
                        } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                            if (this.stage == 4) {
                                ExtendedCSSPrimitiveValue value = CSSParser.this.parseMediaFeature(MediaQueryTokenHandler.this.buffer.toString());
                                if (value == null) {
                                    MediaQueryTokenHandler.this.handleError(index, (byte)5, MediaQueryTokenHandler.this.buffer.toString());
                                } else {
                                    this.handlePredicate(this.featureName, (byte)0, value);
                                    if (value.getPrimitiveType() == 0) {
                                        MediaQueryTokenHandler.this.handleWarning(index, (byte)-2, "Probable hack in media feature.");
                                    }
                                }
                            } else if (this.stage == 7) {
                                ExtendedCSSPrimitiveValue value1 = CSSParser.this.parseMediaFeature(this.firstValue);
                                ExtendedCSSPrimitiveValue value2 = CSSParser.this.parseMediaFeature(MediaQueryTokenHandler.this.buffer.toString());
                                if (value1 == null) {
                                    MediaQueryTokenHandler.this.handleError(index, (byte)5, this.firstValue);
                                } else if (value2 == null) {
                                    MediaQueryTokenHandler.this.handleError(index, (byte)5, MediaQueryTokenHandler.this.buffer.toString());
                                } else {
                                    this.handlePredicate(this.featureName, this.rangeType, value1, value2);
                                    if (value1.getPrimitiveType() == 0 || value2.getPrimitiveType() == 0) {
                                        MediaQueryTokenHandler.this.handleWarning(index, (byte)-2, "Probable hack in media feature.");
                                    }
                                }
                            } else if (this.stage == 3 && !this.spaceFound) {
                                this.handlePredicate(MediaQueryTokenHandler.this.buffer.toString(), (byte)0, null);
                            } else {
                                MediaQueryTokenHandler.this.handleError(index, (byte)32, MediaQueryTokenHandler.this.buffer.toString());
                            }
                            MediaQueryTokenHandler.this.buffer.setLength(0);
                            this.spaceFound = false;
                            MediaQueryTokenHandler.this.escapedTokenIndex = -1;
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        }
                        if (this.stage == 5) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else {
                            this.rangeType = 0;
                            this.stage = 1;
                        }
                        MediaQueryTokenHandler.this.readingPredicate = false;
                    }
                } else {
                    MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                }
                MediaQueryTokenHandler.this.prevcp = codepoint;
            }

            private void handlePredicate(String featureName, byte rangeType, ExtendedCSSPrimitiveValue value) {
                MediaFeaturePredicate predicate = (MediaFeaturePredicate)MediaQueryTokenHandler.this.conditionFactory.createPredicate(featureName);
                predicate.setRangeType(rangeType);
                predicate.setValue(value);
                if (MediaQueryTokenHandler.this.currentCond == null) {
                    MediaQueryTokenHandler.this.currentCond = predicate;
                } else {
                    MediaQueryTokenHandler.this.currentCond.addCondition(predicate);
                }
                this.clearPredicate();
            }

            private void handlePredicate(String featureName, byte rangeType, ExtendedCSSPrimitiveValue value1, ExtendedCSSPrimitiveValue value2) {
                MediaFeaturePredicate predicate = (MediaFeaturePredicate)MediaQueryTokenHandler.this.conditionFactory.createPredicate(featureName);
                predicate.setRangeType(rangeType);
                predicate.setValue(value1);
                predicate.setRangeSecondValue(value2);
                if (MediaQueryTokenHandler.this.currentCond == null) {
                    MediaQueryTokenHandler.this.currentCond = predicate;
                } else {
                    MediaQueryTokenHandler.this.currentCond.addCondition(predicate);
                }
                this.clearPredicate();
            }

            private void reverseRangetype() {
                if ((this.rangeType & 2) == 2) {
                    this.rangeType = (byte)(this.rangeType ^ 2);
                    this.rangeType = (byte)(this.rangeType | 4);
                } else if ((this.rangeType & 4) == 4) {
                    this.rangeType = (byte)(this.rangeType ^ 4);
                    this.rangeType = (byte)(this.rangeType | 2);
                }
            }

            @Override
            public void character(int index, int codepoint) {
                if (this.functionToken) {
                    if (MediaQueryTokenHandler.this.prevcp == 32) {
                        MediaQueryTokenHandler.this.buffer.append(' ');
                    }
                    MediaQueryTokenHandler.this.bufferAppend(codepoint);
                } else {
                    if (codepoint == 58) {
                        if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                            this.featureName = this.rawBuffer();
                            this.stage = (byte)4;
                        } else {
                            MediaQueryTokenHandler.this.handleError(index, (byte)33, "Empty feature name");
                        }
                    } else if (codepoint == 44) {
                        if (!MediaQueryTokenHandler.this.parseError) {
                            if (MediaQueryTokenHandler.this.parendepth != 0) {
                                MediaQueryTokenHandler.this.handleError(index, (byte)33, "Unmatched parenthesis");
                                return;
                            }
                            if (this.stage == 0) {
                                MediaQueryTokenHandler.this.handleError(index, (byte)33, "No media found");
                            }
                            this.processBuffer(index);
                            this.endQuery(index);
                        } else if (MediaQueryTokenHandler.this.parendepth == 0) {
                            this.handler.endQuery();
                            this.clearQuery();
                        }
                        this.handler.startQuery();
                    } else if (codepoint == 46) {
                        if (this.stage == 4 || this.stage == 3 || this.stage == 7 || this.functionToken) {
                            MediaQueryTokenHandler.this.buffer.append('.');
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, 46);
                        }
                    } else if (codepoint == 47) {
                        if (this.stage == 4 || this.stage == 3 || this.stage == 6 || this.stage == 7 || this.functionToken) {
                            MediaQueryTokenHandler.this.buffer.append('/');
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 59) {
                        MediaQueryTokenHandler.this.handleError(index, (byte)4, ";");
                    } else if (codepoint == 60) {
                        if (this.stage < 3 || this.rangeType > 3 && ((this.rangeType & 0x10) != 0 || (this.rangeType & 4) != 0)) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 2);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(index);
                            this.rangeType = (byte)(this.rangeType | 0x10);
                            this.stage = (byte)7;
                        }
                    } else if (codepoint == 61) {
                        if (this.stage < 3 || this.rangeType > 5 && (this.rangeType & 8) != 0) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 1);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(index);
                            this.rangeType = (byte)(this.rangeType | 8);
                            this.stage = (byte)7;
                        }
                    } else if (codepoint == 62 || this.rangeType >= 4 && ((this.rangeType & 0x20) != 0 || (this.rangeType & 2) != 0)) {
                        if (this.stage < 3) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 4);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(index);
                            this.rangeType = (byte)(this.rangeType | 0x20);
                            this.stage = (byte)7;
                        }
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                    }
                    if (this.stage == 5 && this.firstValue == null && MediaQueryTokenHandler.this.buffer.length() != 0) {
                        this.firstValue = this.rawBuffer();
                    }
                }
            }

            private void processBuffer(int index) {
                if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    if (this.stage == 1) {
                        this.processMediaType(index);
                        if (this.mediaType == null) {
                            MediaQueryTokenHandler.this.unexpectedTokenError(index, MediaQueryTokenHandler.this.buffer.toString());
                            MediaQueryTokenHandler.this.buffer.setLength(0);
                        }
                        MediaQueryTokenHandler.this.readingPredicate = false;
                    } else if (this.stage == 6) {
                        this.featureName = this.rawBuffer();
                    }
                }
            }

            private void endQuery(int index) {
                if (MediaQueryTokenHandler.this.currentCond != null) {
                    while (MediaQueryTokenHandler.this.currentCond.getParentCondition() != null) {
                        MediaQueryTokenHandler.this.currentCond = MediaQueryTokenHandler.this.currentCond.getParentCondition();
                    }
                    this.handler.condition(MediaQueryTokenHandler.this.currentCond);
                } else if (this.negativeQuery && this.mediaType == null) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)32, "Negative query without media.");
                }
                this.handler.endQuery();
                this.clearQuery();
            }

            private void clearQuery() {
                MediaQueryTokenHandler.this.currentCond = null;
                this.mediaType = null;
                this.stage = 0;
                MediaQueryTokenHandler.this.prevcp = 32;
                this.negativeQuery = false;
                MediaQueryTokenHandler.this.parseError = false;
                this.clearPredicate();
            }

            private void clearPredicate() {
                this.featureName = null;
                this.firstValue = null;
                this.rangeType = 0;
                this.spaceFound = false;
            }

            String rawBuffer() {
                this.spaceFound = false;
                return MediaQueryTokenHandler.this.rawBuffer();
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quoteCp) {
                MediaQueryTokenHandler.this.handleError(index, (byte)9, "Unexpected: '" + quoted + '\'');
            }

            @Override
            public void escaped(int index, int codepoint) {
                if (ParseHelper.isHexCodePoint(codepoint)) {
                    MediaQueryTokenHandler.this.setEscapedTokenStart(index);
                    MediaQueryTokenHandler.this.buffer.append('\\');
                }
                MediaQueryTokenHandler.this.bufferAppend(codepoint);
                if (this.stage == 5) {
                    this.stage = (byte)6;
                } else if (this.stage == 0) {
                    this.stage = 1;
                }
            }

            @Override
            public void separator(int index, int cp) {
                if (MediaQueryTokenHandler.this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(MediaQueryTokenHandler.this.buffer)) {
                    MediaQueryTokenHandler.this.buffer.append(' ');
                    return;
                }
            }

            @Override
            public void endOfStream(int len) {
                if (this.stage == 1) {
                    this.processBuffer(len);
                }
                if (MediaQueryTokenHandler.this.currentCond == null && this.mediaType == null) {
                    if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                        this.processMediaType(len);
                        if (this.mediaType == null) {
                            MediaQueryTokenHandler.this.unexpectedTokenError(len, MediaQueryTokenHandler.this.buffer.toString());
                            MediaQueryTokenHandler.this.buffer.setLength(0);
                        }
                        this.handler.endQuery();
                        this.clearQuery();
                    } else {
                        MediaQueryTokenHandler.this.handleError(len, (byte)10, "No valid query found");
                    }
                } else if (MediaQueryTokenHandler.this.readingPredicate || this.stage > 1) {
                    MediaQueryTokenHandler.this.handleError(len, (byte)10, "Unexpected end of file");
                    this.handler.endQuery();
                } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    MediaQueryTokenHandler.this.handleError(len, (byte)9, "Unexpected token: " + MediaQueryTokenHandler.this.buffer);
                    this.handler.endQuery();
                } else if (MediaQueryTokenHandler.this.currentCond != null && this.isEmptyNotCondition()) {
                    MediaQueryTokenHandler.this.handleError(len, (byte)10, "No valid query found");
                    this.handler.endQuery();
                } else {
                    this.endQuery(len);
                }
            }
        }
    }

    class SelectorTokenHandler
    extends CSSTokenHandler {
        NSACSelectorFactory factory;
        private Parser2.NamespaceMap nsMap;
        CSSTokenHandler.MySelectorListImpl selist;
        Selector currentsel;
        private String namespacePrefix;
        byte stage;
        private boolean functionToken;
        private static final byte STAGE_COMBINATOR_OR_END = 2;
        private static final byte STAGE_ATTR_START = 4;
        private static final byte STAGE_ATTR_EXPECT_SYMBOL_OR_CLOSE = 7;
        private static final byte STAGE_ATTR_SYMBOL = 5;
        private static final byte STAGE_ATTR_POST_SYMBOL = 6;
        private static final byte STAGE_EXPECT_ID_OR_CLASSNAME = 8;
        private static final byte STAGE_EXPECT_PSEUDOELEM_NAME = 9;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_NAME = 10;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_ARGUMENT = 11;

        SelectorTokenHandler() {
            this(new NSACSelectorFactory());
        }

        SelectorTokenHandler(InputSource source, Parser2.NamespaceMap nsMap) {
            super(source);
            this.selist = new CSSTokenHandler.MySelectorListImpl();
            this.currentsel = null;
            this.namespacePrefix = null;
            this.stage = 0;
            this.factory = new NSACSelectorFactory();
            this.nsMap = nsMap == null ? this.factory : nsMap;
            this.buffer = new StringBuilder(64);
        }

        SelectorTokenHandler(NSACSelectorFactory factory) {
            super(null);
            this.selist = new CSSTokenHandler.MySelectorListImpl();
            this.currentsel = null;
            this.namespacePrefix = null;
            this.stage = 0;
            this.factory = factory;
            this.nsMap = factory;
            this.buffer = new StringBuilder(64);
        }

        SelectorList getSelectorList() {
            return this.selist;
        }

        @Override
        public void word(int index, CharSequence word) {
            if (this.buffer.length() != 0 && (this.prevcp == 32 || this.prevcp == 13)) {
                this.buffer.append(' ');
            }
            if (this.stage == 4 && this.prevcp != 65 && this.prevcp != 124) {
                this.unexpectedTokenError(index, word);
            } else if (this.stage == 0) {
                this.stage = 1;
                this.buffer.append(word);
            } else if (this.stage == 2) {
                this.buffer.append(word);
                this.newDescendantSelector((short)10);
                this.stage = 1;
            } else if (this.stage == 6 && this.prevcp == 32) {
                if (word.length() == 1) {
                    char c = word.charAt(0);
                    if (c == 'i' || c == 'I') {
                        this.setAttributeConditionFlag(AttributeCondition2.Flag.CASE_I);
                    } else if (c == 's' || c == 'S') {
                        this.setAttributeConditionFlag(AttributeCondition2.Flag.CASE_S);
                    } else {
                        this.handleError(index, (byte)4, "Expected 'i', found: '" + c + '\'');
                    }
                    if (this.buffer.length() != 0) {
                        this.handleError(index, (byte)9, "Expected 'i', found: '" + this.buffer.toString() + '\'');
                        this.buffer.setLength(0);
                    }
                } else {
                    this.handleError(index, (byte)9, "Expected 'i', found: '" + word + "'");
                }
            } else if (this.stage == 1) {
                if (this.prevcp != 42) {
                    this.buffer.append(word);
                } else {
                    this.unexpectedTokenError(index, word);
                }
            } else if (this.stage != 7) {
                this.buffer.append(word);
            } else {
                this.unexpectedTokenError(index, word);
            }
            this.prevcp = 65;
        }

        @Override
        public void separator(int index, int codepoint) {
            if (!this.parseError) {
                if (this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                    this.buffer.append(' ');
                    return;
                }
                if (this.prevcp == 58 || this.prevcp == 46 || this.prevcp == 35 || this.prevcp == 124 && this.getActiveSelector() == null) {
                    this.unexpectedCharError(index, codepoint);
                    return;
                }
                if (this.stage == 5) {
                    if (this.buffer.length() != 0) {
                        this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                        this.stage = (byte)6;
                    }
                } else if (this.stage == 1 || this.stage == 8 || this.stage == 9 || this.stage == 10) {
                    this.processBuffer(index, codepoint, false);
                    if (this.prevcp == 65 || this.prevcp == 42 || this.prevcp == 41 || this.prevcp == 93) {
                        this.stage = (byte)2;
                    }
                } else if (this.stage == 4) {
                    if (this.buffer.length() != 0) {
                        this.stage = (byte)7;
                    }
                    return;
                }
                if (this.prevcp != 44) {
                    this.prevcp = 32;
                }
            }
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quoteChar) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(index, quoted);
                this.stage = (byte)6;
            } else if (this.stage == 11) {
                if (this.buffer.length() != 0 && (this.prevcp == 32 || this.prevcp == 13)) {
                    this.buffer.append(' ');
                }
                char c = (char)quoteChar;
                this.buffer.append(c).append(quoted).append(c);
            } else {
                char c = (char)quoteChar;
                StringBuilder buf = new StringBuilder(quoted.length() + 2);
                buf.append(c).append(quoted).append(c);
                this.unexpectedTokenError(index, buf.toString());
            }
            this.prevcp = 65;
        }

        @Override
        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(index, quoted);
                this.stage = (byte)6;
            } else {
                this.handleError(index, (byte)9, "Quoted string contained unexpected control character: \"" + quoted + '\"');
            }
            this.prevcp = 65;
        }

        private void setAttributeSelectorValue(int index, CharSequence value) {
            NSACSelectorFactory.AttributeConditionImpl attrcond;
            SimpleSelector simple;
            Condition cond = null;
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                simple = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                if (!(simple instanceof NSACSelectorFactory.ConditionalSelectorImpl)) {
                    throw new IllegalStateException("Descendant selector has no conditional simple selector");
                }
                cond = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).condition;
            } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                simple = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                if (!(simple instanceof NSACSelectorFactory.ConditionalSelectorImpl)) {
                    throw new IllegalStateException("Descendant selector has no conditional simple selector");
                }
                cond = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).condition;
            } else if (this.currentsel instanceof NSACSelectorFactory.ConditionalSelectorImpl) {
                cond = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).condition;
            }
            if (cond instanceof NSACSelectorFactory.CombinatorConditionImpl) {
                cond = ((NSACSelectorFactory.CombinatorConditionImpl)cond).getSecondCondition();
            }
            if (cond instanceof NSACSelectorFactory.AttributeConditionImpl && (attrcond = (NSACSelectorFactory.AttributeConditionImpl)cond) != null) {
                if (attrcond.value == null) {
                    attrcond.value = value.toString();
                } else {
                    StringBuilder buf = new StringBuilder(attrcond.value.length() + value.length() + 1);
                    buf.append(attrcond.value);
                    if (this.prevcp == 32 || this.prevcp == 13) {
                        buf.append(' ');
                    }
                    attrcond.value = buf.append(value).toString();
                }
                return;
            }
            this.handleError(index, (byte)9, "Unexpected token in selector: <" + value + ">");
        }

        private void setAttributeConditionFlag(AttributeCondition2.Flag flag) {
            Selector simple = this.getActiveSelector();
            if (simple == null || simple.getSelectorType() != 0) {
                throw new IllegalStateException("Processing attribute modifier of non-conditional selector");
            }
            Condition cond = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).getCondition();
            if (cond.getConditionType() == 0) {
                cond = ((CombinatorCondition)cond).getSecondCondition();
            }
            if (cond.getConditionType() != 4) {
                throw new IllegalStateException("Processing attribute modifier of non-attribute conditional selector");
            }
            ((NSACSelectorFactory.AttributeConditionImpl)cond).setFlag(flag);
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 123) {
                this.handleLeftCurlyBracket(index);
            } else {
                if (this.stage == 11) {
                    this.bufferAppend(codepoint);
                    this.prevcp = codepoint;
                    if (codepoint == 40) {
                        this.parendepth = (short)(this.parendepth + 1);
                    }
                    return;
                }
                if (codepoint == 40) {
                    if (this.prevcp != 65 || this.buffer.length() == 0 || this.stage != 10) {
                        this.unexpectedCharError(index, codepoint);
                    } else {
                        this.newConditionalSelector(index, codepoint, (short)10);
                        if (!this.parseError) {
                            this.stage = (byte)11;
                            this.functionToken = true;
                        }
                    }
                    this.parendepth = (short)(this.parendepth + 1);
                } else if (codepoint == 91) {
                    if (this.prevcp != 65 && this.prevcp != 42 && this.prevcp != 44 && this.prevcp != 32 && this.prevcp != 93 && this.prevcp != 41 && this.prevcp != 43 && this.prevcp != 62 && this.prevcp != 125 && this.prevcp != 126 && this.prevcp != 124) {
                        this.unexpectedCharError(index, codepoint);
                    } else {
                        this.processBuffer(index, codepoint, false);
                        this.stage = (byte)4;
                        this.prevcp = 65;
                        return;
                    }
                }
            }
            this.prevcp = codepoint;
        }

        protected void handleLeftCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '{'");
        }

        protected void handleRightCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '}'");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void closeGroup(int index, int codepoint) {
            block35: {
                block36: {
                    block34: {
                        block37: {
                            block38: {
                                if (codepoint != 41) break block36;
                                this.parendepth = (short)(this.parendepth - 1);
                                if (this.stage != 11) break block37;
                                if (this.parendepth != 0) {
                                    this.bufferAppend(codepoint);
                                    this.prevcp = codepoint;
                                    return;
                                }
                                Selector sel = this.getActiveSelector();
                                if (sel.getSelectorType() != 0) break block38;
                                Condition cond = ((NSACSelectorFactory.ConditionalSelectorImpl)sel).condition;
                                cond = this.getActiveCondition(cond);
                                short condtype = cond.getConditionType();
                                if (this.buffer.length() != 0) {
                                    if (condtype == 17) {
                                        try {
                                            ((NSACSelectorFactory.SelectorArgumentConditionImpl)cond).arguments = CSSParser.this.parseSelectorArgument(this.rawBuffer(), this.factory);
                                        }
                                        catch (CSSParseException e) {
                                            byte errCode = ((Object)((Object)e)).getClass() == CSSNamespaceParseException.class ? (byte)15 : 32;
                                            CSSParseException ex = this.createException(index, errCode, e.getMessage());
                                            if (CSSParser.this.errorHandler == null) {
                                                throw ex;
                                            }
                                            CSSParser.this.errorHandler.error(ex);
                                            this.parseError = true;
                                            this.stage = (byte)127;
                                        }
                                    } else if (condtype == 3) {
                                        String arg;
                                        if (((NSACSelectorFactory.PositionalConditionImpl)cond).hasArgument() && !this.parsePositionalArgument((NSACSelectorFactory.PositionalConditionImpl)cond, arg = this.rawBuffer())) {
                                            this.handleError(index, (byte)32, "Wrong subexpression: " + arg);
                                        }
                                    } else if (condtype == 6) {
                                        int len;
                                        String s = this.unescapeBuffer(index);
                                        if (s.charAt((len = s.length()) - 1) == ',') {
                                            this.handleError(index - 2, (byte)9, "Unexpected functional argument: " + s);
                                            return;
                                        }
                                        ((NSACSelectorFactory.LangConditionImpl)cond).lang = s;
                                    } else if (condtype == 10) {
                                        String s = this.unescapeBuffer(index);
                                        if (!this.isValidIdentifier(s)) {
                                            this.handleError(index - s.length() - 1, (byte)9, "Unexpected functional argument: " + s);
                                            return;
                                        }
                                        ((NSACSelectorFactory.AttributeConditionImpl)cond).value = s;
                                    }
                                    this.buffer.setLength(0);
                                    this.stage = 1;
                                    break block34;
                                } else if (condtype == 6 || condtype == 17 || condtype == 3) {
                                    this.unexpectedCharError(index, codepoint);
                                    break block34;
                                } else {
                                    this.unexpectedCharError(index - 1, codepoint);
                                }
                                break block34;
                            }
                            this.unexpectedCharError(index, codepoint);
                            break block34;
                        }
                        this.unexpectedCharError(index, codepoint);
                    }
                    if (this.functionToken) {
                        this.functionToken = false;
                    }
                    break block35;
                }
                if (codepoint == 125) {
                    this.handleRightCurlyBracket(index);
                } else {
                    if (this.stage == 11) {
                        this.bufferAppend(codepoint);
                        this.prevcp = codepoint;
                        return;
                    }
                    if (codepoint == 93) {
                        if (this.stage == 6) {
                            if (this.buffer.length() != 0) {
                                this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                            }
                            this.stage = 1;
                        } else if (this.stage == 4 || this.stage == 7) {
                            if (this.buffer.length() != 0) {
                                this.newConditionalSelector(index, codepoint, (short)4);
                                this.stage = 1;
                            } else {
                                this.handleError(index, (byte)4, "Unexpected ']', expected attribute name");
                            }
                        } else if (this.stage == 5) {
                            if (this.buffer.length() != 0) {
                                this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                                this.stage = 1;
                            } else {
                                this.handleError(index, (byte)4, "Unexpected ']', expected attribute value");
                            }
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    }
                }
            }
            this.prevcp = codepoint;
        }

        private Selector getActiveSelector() {
            Object sel = this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl ? ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector() : (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl ? ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector() : this.currentsel);
            return sel;
        }

        private Condition getActiveCondition(Condition cond) {
            while (cond.getConditionType() == 0) {
                cond = ((NSACSelectorFactory.CombinatorConditionImpl)cond).getSecondCondition();
            }
            return cond;
        }

        @Override
        String unescapeBuffer(int index) {
            String s;
            if (this.namespacePrefix == null) {
                s = this.unescapeStringValue(index);
            } else {
                this.handleError(index - this.namespacePrefix.length() - 1, (byte)9, "Unexpected token: " + this.namespacePrefix);
                this.namespacePrefix = null;
                s = "";
            }
            this.buffer.setLength(0);
            this.escapedTokenIndex = -1;
            return s;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processBuffer(int index, int triggerCp, boolean lastStage) {
            if (this.prevcp == 42) {
                if (this.currentsel != null) {
                    if (this.currentsel.getSelectorType() == 1) return;
                }
                this.setSimpleSelector(index, (SimpleSelector)this.factory.getUniversalSelector(this.namespacePrefix));
                return;
            }
            if (this.stage == 2) {
                if (lastStage) return;
                this.newDescendantSelector((short)10);
                if (this.buffer.length() == 0) return;
                NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                String raw = this.buffer.toString();
                String s = this.unescapeBuffer(index);
                if (this.isValidIdentifier(raw)) {
                    sel.localName = s;
                    this.stage = 1;
                    return;
                }
                this.handleError(index - raw.length(), (byte)7, "Invalid identifier: " + raw);
                return;
            }
            if (this.buffer.length() != 0) {
                if (this.stage == 1) {
                    String uri;
                    NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                    if (this.namespacePrefix == null) {
                        uri = this.getDefaultNamespaceURI();
                    } else {
                        uri = this.getNamespaceURI(index);
                        if (this.parseError) {
                            return;
                        }
                    }
                    sel.namespaceUri = uri;
                    String raw = this.buffer.toString();
                    String s = this.unescapeBuffer(index);
                    if (this.isValidIdentifier(raw)) {
                        sel.localName = s;
                        return;
                    }
                    this.handleError(index - raw.length(), (byte)7, "Invalid identifier: " + raw);
                    return;
                }
                if (this.stage == 8) {
                    String raw = this.buffer.toString();
                    String s = this.unescapeBuffer(index);
                    if (this.isValidIdentifier(raw)) {
                        this.setAttributeSelectorValue(index, s);
                        this.stage = 1;
                        return;
                    }
                    this.handleError(index - raw.length(), (byte)7, "Invalid class name: " + raw);
                    return;
                }
                if (this.stage == 10) {
                    this.newConditionalSelector(index, triggerCp, (short)10);
                    this.stage = 1;
                    return;
                }
                if (this.stage == 9) {
                    this.newConditionalSelector(index, triggerCp, (short)18);
                    this.stage = 1;
                    return;
                }
                if (this.stage == 11) {
                    return;
                }
                if (this.stage == 6) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                    return;
                }
                this.handleError(index, (byte)9, "Unexpected: <" + this.buffer + ">");
                this.buffer.setLength(0);
                return;
            }
            if (this.namespacePrefix != null) {
                this.handleError(index - this.namespacePrefix.length() - 1, (byte)9, "Unexpected: " + this.namespacePrefix + "|");
                this.namespacePrefix = null;
                return;
            }
            if (this.stage <= 1) return;
            if (this.stage == 11) return;
            this.unexpectedCharError(index, triggerCp);
        }

        @Override
        public void character(int index, int codepoint) {
            if (!this.skipCharacterHandling()) {
                if (this.stage == 11) {
                    if (codepoint == 44 && (this.prevcp == 44 || this.buffer.length() == 0)) {
                        this.unexpectedCharError(index, codepoint);
                        return;
                    }
                    if ((this.prevcp == 32 || this.prevcp == 13) && this.buffer.length() != 0) {
                        this.buffer.append(' ');
                    }
                    this.bufferAppend(codepoint);
                } else if (this.stage == 4 || this.stage == 7) {
                    if (codepoint == 124) {
                        if (this.stage == 4) {
                            if (this.namespacePrefix == null) {
                                this.readNamespacePrefix(index, codepoint);
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else if (this.prevcp != 65) {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 61) {
                        if (this.prevcp == 124 && this.namespacePrefix != null && this.buffer.length() == 0) {
                            this.buffer.append(this.namespacePrefix);
                            this.namespacePrefix = null;
                        }
                        if (this.prevcp == 124) {
                            this.newConditionalSelector(index, codepoint, (short)8);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 126) {
                            this.newConditionalSelector(index, codepoint, (short)7);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 36) {
                            this.newConditionalSelector(index, codepoint, (short)15);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 94) {
                            this.newConditionalSelector(index, codepoint, (short)14);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 42) {
                            this.newConditionalSelector(index, codepoint, (short)16);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 65) {
                            this.newConditionalSelector(index, codepoint, (short)4);
                            this.stage = (byte)5;
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if ((this.buffer.length() == 0 && this.namespacePrefix == null || codepoint != 126 && codepoint != 36 && codepoint != 94) && codepoint != 42) {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 42) {
                    if (this.stage == 0) {
                        this.stage = 1;
                    } else if (this.stage == 2) {
                        this.newDescendantSelector((short)10);
                        ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = this.factory.getUniversalSelector(this.namespacePrefix);
                        this.namespacePrefix = null;
                        this.stage = 1;
                    } else if (this.stage == 1 && this.namespacePrefix != null && this.prevcp == 124) {
                        this.setSimpleSelector(index, (SimpleSelector)this.factory.createUniversalSelector(this.getNamespaceURI(index)));
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else {
                    if (this.prevcp == 124) {
                        if (codepoint == 124) {
                            this.handleColumnCombinator(index);
                            this.prevcp = 32;
                            return;
                        }
                        this.unexpectedCharError(index, codepoint);
                        return;
                    }
                    if (codepoint == 126) {
                        if (this.stage == 2) {
                            this.stage = 1;
                        } else {
                            this.processBuffer(index, codepoint, false);
                        }
                        this.newSiblingSelector(index, (short)13, codepoint);
                    } else if (codepoint == 46) {
                        if (this.stage != 8 || this.buffer.length() != 0) {
                            this.processBuffer(index, codepoint, false);
                            this.newConditionalSelector(index, codepoint, (short)9);
                            this.stage = (byte)8;
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 35) {
                        if (this.stage != 8 || this.buffer.length() != 0) {
                            this.processBuffer(index, codepoint, false);
                            this.newConditionalSelector(index, codepoint, (short)5);
                            this.stage = (byte)8;
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 58) {
                        if (this.prevcp == 58) {
                            this.stage = (byte)9;
                        } else {
                            this.processBuffer(index, codepoint, false);
                            this.stage = (byte)10;
                        }
                    } else if (codepoint == 62) {
                        if (this.stage == 2) {
                            this.stage = 1;
                        }
                        this.processBuffer(index, codepoint, false);
                        if (this.stage < 2) {
                            this.newDescendantSelector(index, (short)11, codepoint);
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 43) {
                        if (this.stage == 2) {
                            this.stage = 1;
                        }
                        this.processBuffer(index, codepoint, false);
                        this.newSiblingSelector(index, (short)12, codepoint);
                    } else if (codepoint == 124) {
                        if (this.stage == 8 || this.stage == 10 || this.stage == 9) {
                            this.processBuffer(index, codepoint, false);
                        } else if (this.stage == 2) {
                            this.stage = 1;
                        } else if (this.stage == 1 && this.namespacePrefix == null) {
                            this.readNamespacePrefix(index, codepoint);
                        } else if (this.stage == 0 && this.namespacePrefix == null && this.buffer.length() == 0) {
                            this.namespacePrefix = "";
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 44) {
                        if (this.functionToken) {
                            if (this.prevcp == 44) {
                                this.unexpectedCharError(index, codepoint);
                            } else {
                                this.buffer.append(',');
                            }
                        } else {
                            this.processBuffer(index, codepoint, true);
                            if (!this.parseError) {
                                if (this.addCurrentSelector(index)) {
                                    this.stage = 0;
                                } else {
                                    this.unexpectedCharError(index, codepoint);
                                }
                            }
                        }
                    } else if (codepoint == 64) {
                        this.handleAtKeyword(index);
                    } else if (codepoint == 45) {
                        this.buffer.append('-');
                    } else if (codepoint == 95) {
                        this.buffer.append('_');
                    } else if (this.stage < 8 || this.isUnexpectedCharacter(codepoint)) {
                        this.unexpectedCharError(index, codepoint);
                    } else {
                        this.bufferAppend(codepoint);
                    }
                }
            }
            this.prevcp = codepoint;
        }

        boolean skipCharacterHandling() {
            return this.parseError;
        }

        private void handleColumnCombinator(int index) {
            if (this.stage == 1) {
                if (this.currentsel == null) {
                    NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                    if (this.namespacePrefix != null) {
                        sel.localName = this.namespacePrefix;
                        this.namespacePrefix = null;
                    } else if (this.buffer.length() != 0) {
                        sel.localName = this.unescapeBuffer(index);
                    } else {
                        this.unexpectedCharError(index, 124);
                        return;
                    }
                }
                this.newDescendantSelector(index, (short)14, 124);
            } else if (this.stage == 0 && this.buffer.length() == 0 && this.currentsel == null) {
                this.namespacePrefix = null;
                this.newDescendantSelector(index, (short)14, 124);
            } else {
                this.unexpectedCharError(index, 124);
            }
        }

        private boolean isUnexpectedCharacter(int cp) {
            return cp == 33 || cp == 36 || cp == 37 || cp == 38 || cp == 47 || cp >= 59 && cp <= 63 || cp == 94 || cp == 96;
        }

        private void readNamespacePrefix(int index, int codepoint) {
            if (this.prevcp == 65) {
                this.namespacePrefix = this.unescapeBuffer(index);
            } else if (this.prevcp == 42 && this.buffer.length() == 0) {
                this.namespacePrefix = "*";
            } else {
                this.unexpectedCharError(index, codepoint);
            }
        }

        protected void handleAtKeyword(int index) {
            this.unexpectedCharError(index, 64);
        }

        private void newConditionalSelector(int index, int triggerCp, short condtype) {
            Condition condition;
            String name = this.rawBuffer();
            String lcname = name.toLowerCase(Locale.ROOT).intern();
            if (condtype == 10) {
                if ("lang".equals(lcname)) {
                    condition = this.factory.createCondition((short)6);
                } else if ("first-child".equals(lcname)) {
                    if (triggerCp == 40) {
                        this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                        return;
                    }
                    condition = this.factory.createPositionalCondition();
                } else if ("nth-child".equals(lcname)) {
                    condition = this.factory.createPositionalCondition(true);
                } else if ("last-child".equals(lcname)) {
                    if (triggerCp == 40) {
                        this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                        return;
                    }
                    condition = this.factory.createPositionalCondition();
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                } else if ("nth-last-child".equals(lcname)) {
                    condition = this.factory.createPositionalCondition(true);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                } else if ("first-of-type".equals(lcname)) {
                    condition = this.factory.createPositionalCondition();
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                } else if ("last-of-type".equals(lcname)) {
                    if (triggerCp == 40) {
                        this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                        return;
                    }
                    condition = this.factory.createPositionalCondition();
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).offset = 1;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                } else if ("nth-of-type".equals(lcname)) {
                    condition = this.factory.createPositionalCondition(true);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                } else if ("nth-last-of-type".equals(lcname)) {
                    condition = this.factory.createPositionalCondition(true);
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).oftype = true;
                    ((NSACSelectorFactory.PositionalConditionImpl)condition).forwardCondition = false;
                } else if ("only-child".equals(lcname)) {
                    if (triggerCp == 40) {
                        this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                        return;
                    }
                    condition = this.factory.createCondition((short)11);
                } else if ("only-of-type".equals(lcname)) {
                    if (triggerCp == 40) {
                        this.handleError(index, (byte)4, "Positional pseudo-class cannot have argument");
                        return;
                    }
                    condition = this.factory.createCondition((short)12);
                } else if ("not".equals(lcname) || "is".equals(lcname) || "has".equals(lcname) || "where".equals(lcname)) {
                    if (triggerCp != 40) {
                        StringBuilder buf = new StringBuilder(name.length() * 2 + 26);
                        buf.append("Expected ':").append(name).append("(', found ':").append(name).append(Character.toChars(triggerCp)).append('\'');
                        this.handleError(index, (byte)4, buf.toString());
                        return;
                    }
                    condition = this.factory.createCondition((short)17);
                    ((NSACSelectorFactory.SelectorArgumentConditionImpl)condition).setName(lcname);
                } else {
                    if ("first-line".equals(lcname) || "first-letter".equals(lcname) || "before".equals(lcname) || "after".equals(lcname)) {
                        condtype = (short)18;
                    }
                    condition = this.factory.createCondition(condtype);
                }
            } else {
                condition = this.factory.createCondition(condtype);
            }
            if (name.length() != 0 && condition instanceof NSACSelectorFactory.AttributeConditionImpl) {
                switch (condition.getConditionType()) {
                    case 4: 
                    case 7: 
                    case 8: 
                    case 14: 
                    case 15: 
                    case 16: {
                        if (this.namespacePrefix != null) {
                            ((NSACSelectorFactory.AttributeConditionImpl)condition).namespaceURI = this.getNamespaceURI(index);
                        }
                    }
                    case 10: {
                        if (this.isValidIdentifier(name)) {
                            ((NSACSelectorFactory.AttributeConditionImpl)condition).localName = this.safeUnescapeIdentifier(index, name);
                            break;
                        }
                        this.handleError(index - name.length(), (byte)7, "Invalid pseudo-class: " + name);
                        return;
                    }
                    case 18: {
                        if (!this.isValidIdentifier(name)) {
                            this.handleError(index - name.length(), (byte)7, "Invalid pseudo-element: " + name);
                            return;
                        }
                        if (triggerCp == 40) {
                            this.handleError(index, (byte)4, "Invalid pseudo-element declaration: " + name + '(');
                            return;
                        }
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).localName = this.safeUnescapeIdentifier(index, name);
                        break;
                    }
                    default: {
                        ((NSACSelectorFactory.AttributeConditionImpl)condition).value = lcname;
                    }
                }
            }
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                SimpleSelector simple = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                if (simple != null && simple.getSelectorType() == 0) {
                    NSACSelectorFactory.CombinatorConditionImpl andcond = (NSACSelectorFactory.CombinatorConditionImpl)this.factory.createCondition((short)0);
                    andcond.first = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).getCondition();
                    andcond.second = condition;
                    ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.ConditionalSelectorImpl)simple).getSimpleSelector(), (Condition)andcond);
                } else {
                    ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector, condition);
                }
            } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                SimpleSelector simple = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                if (simple != null && simple.getSelectorType() == 0) {
                    NSACSelectorFactory.CombinatorConditionImpl andcond = (NSACSelectorFactory.CombinatorConditionImpl)this.factory.createCondition((short)0);
                    andcond.first = ((NSACSelectorFactory.ConditionalSelectorImpl)simple).getCondition();
                    andcond.second = condition;
                    ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.ConditionalSelectorImpl)simple).getSimpleSelector(), (Condition)andcond);
                } else {
                    ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector = this.factory.createConditionalSelector(((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector, condition);
                }
            } else if (this.currentsel != null && this.currentsel.getSelectorType() == 0) {
                NSACSelectorFactory.CombinatorConditionImpl andcond = (NSACSelectorFactory.CombinatorConditionImpl)this.factory.createCondition((short)0);
                andcond.first = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getCondition();
                andcond.second = condition;
                this.currentsel = this.factory.createConditionalSelector(((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getSimpleSelector(), (Condition)andcond);
            } else {
                this.currentsel = this.factory.createConditionalSelector((SimpleSelector)this.currentsel, condition);
            }
        }

        private boolean parsePositionalArgument(NSACSelectorFactory.PositionalConditionImpl cond, String expression) {
            MyAnBExpression expr = new MyAnBExpression();
            try {
                expr.parse(expression);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            cond.offset = expr.getOffset();
            cond.slope = expr.getStep();
            cond.ofList = expr.getSelectorList();
            cond.hasKeyword = expr.isKeyword();
            return true;
        }

        private String getDefaultNamespaceURI() {
            String uri = this.nsMap.getNamespaceURI("");
            if (uri != null && this.factory != this.nsMap) {
                this.factory.registerNamespacePrefix("", uri);
            }
            return uri;
        }

        private String getNamespaceURI(int index) {
            String uri;
            if (this.namespacePrefix.length() != 0) {
                uri = this.nsMap.getNamespaceURI(this.namespacePrefix);
                if (uri != null) {
                    if (this.factory != this.nsMap) {
                        this.factory.registerNamespacePrefix(this.namespacePrefix, uri);
                    }
                } else if (!this.namespacePrefix.equals("*")) {
                    this.handleError(index - this.buffer.length() - this.namespacePrefix.length() - 1, (byte)15, "Unknown namespace prefix: " + this.namespacePrefix);
                }
            } else {
                uri = "";
            }
            this.namespacePrefix = null;
            return uri;
        }

        private NSACSelectorFactory.ElementSelectorImpl newElementSelector(int index) {
            NSACSelectorFactory.ElementSelectorImpl elemsel = this.factory.createElementSelector();
            this.setSimpleSelector(index, (SimpleSelector)elemsel);
            return elemsel;
        }

        private void setSimpleSelector(int index, SimpleSelector simple) {
            if (this.currentsel instanceof NSACSelectorFactory.DescendantSelectorImpl) {
                ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).simpleSelector = simple;
            } else if (this.currentsel instanceof NSACSelectorFactory.SiblingSelectorImpl) {
                ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).siblingSelector = simple;
            } else if (this.currentsel != null) {
                this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token after '" + this.currentsel.toString() + "': " + simple.toString());
            } else {
                this.currentsel = simple;
            }
        }

        protected void newDescendantSelector(int index, short type, int triggerCp) {
            if (this.currentsel != null && this.isValidCurrentSelector()) {
                this.newDescendantSelector(type);
            } else {
                this.unexpectedCharError(index, triggerCp);
            }
        }

        void newDescendantSelector(short type) {
            this.currentsel = this.factory.createDescendantSelector(type, this.currentsel);
            this.stage = 0;
        }

        protected void newSiblingSelector(int index, short type, int triggerCp) {
            if (this.currentsel != null && this.isValidCurrentSelector()) {
                this.newSiblingSelector(type);
            } else {
                this.unexpectedCharError(index, triggerCp);
            }
        }

        void newSiblingSelector(short type) {
            this.currentsel = this.factory.createSiblingSelector(type, this.currentsel);
            this.stage = 0;
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (this.stage == 4 || this.stage == 6 || this.stage == 8 || this.stage == 11 || this.stage == 0 || this.stage == 2) {
                Selector sel;
                if (ParseHelper.isHexCodePoint(codepoint)) {
                    this.setEscapedTokenStart(index);
                    this.buffer.append('\\');
                } else if (this.stage == 11 && (sel = this.getActiveSelector()).getSelectorType() == 0) {
                    Condition cond = ((NSACSelectorFactory.ConditionalSelectorImpl)sel).condition;
                    if ((cond = this.getActiveCondition(cond)).getConditionType() == 17) {
                        this.buffer.append('\\');
                    }
                }
                this.bufferAppend(codepoint);
                if (this.stage == 0) {
                    this.stage = 1;
                }
                this.prevcp = 65;
            } else if (this.stage == 5) {
                this.bufferAppend(codepoint);
                this.stage = (byte)6;
            } else {
                this.unexpectedCharError(index - 1, 92);
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (this.stage == 0) {
                super.commented(index, commentType, comment);
            }
        }

        @Override
        public void endOfStream(int len) {
            this.processBuffer(len, 32, true);
            if (!this.parseError && !this.addCurrentSelector(len)) {
                this.handleError(len, (byte)10, "Unexpected end of stream");
            }
        }

        boolean addCurrentSelector(int index) {
            if (this.currentsel != null) {
                if (this.isValidCurrentSelector()) {
                    this.selist.add(this.currentsel, index);
                    this.currentsel = null;
                    return true;
                }
                this.selist.clear();
                this.currentsel = null;
            }
            return false;
        }

        boolean isValidCurrentSelector() {
            SimpleSelector last = null;
            switch (this.currentsel.getSelectorType()) {
                case 10: 
                case 11: 
                case 14: {
                    last = ((NSACSelectorFactory.DescendantSelectorImpl)this.currentsel).getSimpleSelector();
                    break;
                }
                case 12: 
                case 13: {
                    last = ((NSACSelectorFactory.SiblingSelectorImpl)this.currentsel).getSiblingSelector();
                    break;
                }
                case 0: {
                    Condition cond = ((NSACSelectorFactory.ConditionalSelectorImpl)this.currentsel).getCondition();
                    short condtype = cond.getConditionType();
                    while (condtype == 0) {
                        if ((cond = ((CombinatorCondition)cond).getSecondCondition()) == null) {
                            return false;
                        }
                        condtype = cond.getConditionType();
                    }
                    switch (condtype) {
                        case 4: 
                        case 10: 
                        case 18: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getLocalName() != null) break;
                            return false;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 14: 
                        case 15: 
                        case 16: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getValue() != null) break;
                            return false;
                        }
                        case 6: {
                            if (((NSACSelectorFactory.LangConditionImpl)cond).getLang() != null) break;
                            return false;
                        }
                        case 17: {
                            if (((NSACSelectorFactory.SelectorArgumentConditionImpl)cond).getSelectors() != null) break;
                            return false;
                        }
                    }
                }
                default: {
                    return true;
                }
            }
            return last != null;
        }

        protected boolean isValidSelectorList() {
            return !this.selist.isEmpty() && this.currentsel == null;
        }

        @Override
        void resetHandler() {
            super.resetHandler();
            this.stage = 0;
            this.functionToken = false;
            this.escapedTokenIndex = -1;
            this.buffer.setLength(0);
            this.namespacePrefix = null;
            this.currentsel = null;
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            if (errCode == 1) {
                index -= context.length() + 1;
            }
            super.error(index, errCode, context);
            this.selist.clear();
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                this.stage = (byte)127;
                if (this.prevcp == this.endcp && this.endcp != -1) {
                    throw this.createException(index, errCode, "Expected end of file, found " + new String(Character.toChars(this.prevcp)));
                }
                throw this.createException(index, errCode, message);
            }
        }

        class MyAnBExpression
        extends AnBExpression {
            MyAnBExpression() {
            }

            @Override
            protected SelectorList parseSelector(String selText) {
                CSSParser parser = new CSSParser();
                return parser.parseSelectors(selText, SelectorTokenHandler.this.factory);
            }
        }
    }

    private class SelectorArgumentTokenHandler
    extends SelectorTokenHandler {
        SelectorArgumentTokenHandler(NSACSelectorFactory factory) {
            super(factory);
        }

        @Override
        protected void newDescendantSelector(int index, short type, int triggerCp) {
            if (this.currentsel == null) {
                this.currentsel = this.factory.createScopeSelector();
            } else if (!this.isValidCurrentSelector()) {
                this.unexpectedCharError(index, triggerCp);
                return;
            }
            this.newDescendantSelector(type);
        }

        @Override
        protected void newSiblingSelector(int index, short type, int triggerCp) {
            if (this.currentsel == null) {
                this.currentsel = this.factory.createScopeSelector();
            } else if (!this.isValidCurrentSelector()) {
                this.unexpectedCharError(index, triggerCp);
                return;
            }
            this.newSiblingSelector(type);
        }
    }

    class PropertyTokenHandler
    extends DeclarationTokenHandler {
        PropertyTokenHandler(InputSource source) {
            super(source, null);
            this.propertyName = "";
        }

        PropertyTokenHandler(String propertyName) {
            super(null, ShorthandDatabase.getInstance());
            this.propertyName = propertyName;
        }

        @Override
        protected void handleAtKeyword(int index) {
            throw this.createException(index, (byte)4, "Unexpected '@'");
        }

        @Override
        protected void handleSemicolon(int index) {
            this.handleError(index, (byte)4, "Unexpected ';'");
        }

        @Override
        public void endOfStream(int len) {
            if (this.parendepth != 0) {
                this.handleError(len, (byte)6, "Unmatched parenthesis");
            } else {
                this.processBuffer(len);
                if (this.getLexicalUnit() == null) {
                    this.handleError(len, (byte)32, "No value found");
                }
            }
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            if (this.prevcp == this.endcp && this.endcp != -1) {
                throw this.createException(index, errCode, "Expected end of file, found " + new String(Character.toChars(this.prevcp)));
            }
            throw this.createException(index, errCode, message);
        }
    }

    private static class MySACMediaList
    implements SACMediaList {
        String[] list;

        MySACMediaList(String[] list) {
            this.list = list;
        }

        public int getLength() {
            return this.list.length;
        }

        public String item(int index) {
            if (index < 0 || index >= this.list.length) {
                return null;
            }
            return this.list[index].trim();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.list.length != 0) {
                buf.append(this.list[0].trim());
            }
            for (int i = 1; i < this.list.length; ++i) {
                buf.append(',').append(this.list[i].trim());
            }
            return buf.toString();
        }
    }

    static class LocatorImpl
    implements Locator {
        int line;
        int column;
        String uri;

        LocatorImpl(int line, int column, String uri) {
            this.line = line;
            this.column = column;
            this.uri = uri;
        }

        public String getURI() {
            return this.uri;
        }

        public int getLineNumber() {
            return this.line;
        }

        public int getColumnNumber() {
            return this.column;
        }
    }

    abstract class CSSTokenHandler
    implements TokenHandler {
        int line = 1;
        int prevlinelength = -1;
        int prevcp = 32;
        int endcp = -1;
        short parendepth = 0;
        StringBuilder buffer;
        int escapedTokenIndex = -1;
        boolean parseError = false;
        private final InputSource source;

        CSSTokenHandler(InputSource source) {
            this.source = source;
        }

        @Override
        public void tokenControl(TokenControl control) {
        }

        @Override
        public void control(int index, int codepoint) {
            if (codepoint == 10) {
                this.separator(index, codepoint);
                if (this.prevcp != 13) {
                    ++this.line;
                    this.prevlinelength = index;
                } else {
                    ++this.prevlinelength;
                }
            } else if (codepoint == 12) {
                this.separator(index, codepoint);
                ++this.line;
                this.prevlinelength = index;
            } else if (codepoint == 13) {
                ++this.line;
                this.prevlinelength = index;
                this.prevcp = codepoint;
            } else if (codepoint == 9) {
                this.separator(index, codepoint);
            } else if (codepoint < 128) {
                this.unexpectedCharError(index, codepoint);
            } else {
                this.highControl(index, codepoint);
            }
        }

        protected void highControl(int index, int codepoint) {
            if (!this.parseError) {
                this.handleError(index, (byte)4, "Unexpected control: " + codepoint);
            }
        }

        @Override
        public void quotedNewlineChar(int index, int codepoint) {
            if (codepoint == 10) {
                if (this.prevcp != 13) {
                    ++this.line;
                    this.prevlinelength = index;
                }
            } else if (codepoint == 12) {
                ++this.line;
                this.prevlinelength = index;
            } else if (codepoint == 13) {
                ++this.line;
                this.prevlinelength = index;
                this.prevcp = codepoint;
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (commentType == 0) {
                CSSParser.this.handler.comment(comment);
            }
        }

        void setEscapedTokenStart(int index) {
            if (this.escapedTokenIndex == -1) {
                this.escapedTokenIndex = index - 1;
            }
        }

        void bufferAppend(int codepoint) {
            this.buffer.append(Character.toChars(codepoint));
        }

        String rawBuffer() {
            this.escapedTokenIndex = -1;
            String s = this.buffer.toString();
            this.buffer.setLength(0);
            return s;
        }

        String unescapeBuffer(int index) {
            String s = this.unescapeStringValue(index);
            this.buffer.setLength(0);
            this.escapedTokenIndex = -1;
            return s;
        }

        String unescapeStringValue(int index) {
            String s;
            if (this.escapedTokenIndex != -1) {
                int escsz = index - this.escapedTokenIndex;
                int rawlen = this.buffer.length() - escsz;
                if (rawlen <= 0) {
                    s = this.safeUnescapeIdentifier(index, this.buffer.toString());
                } else {
                    CharSequence rawseq = this.buffer.subSequence(0, rawlen);
                    s = rawseq + this.safeUnescapeIdentifier(index, this.buffer.substring(rawlen));
                }
            } else {
                s = this.buffer.toString();
            }
            return s;
        }

        String safeUnescapeIdentifier(int index, String inputString) {
            return ParseHelper.unescapeStringValue(inputString, true, true);
        }

        String unescapeIdentifier(int index, String inputString) throws DOMNullCharacterException {
            return ParseHelper.unescapeStringValue(inputString, true, false);
        }

        boolean isValidIdentifier(String s) {
            char c = s.charAt(0);
            if (c != '-') {
                return !Character.isDigit(c);
            }
            return s.length() > 1 && !Character.isDigit(c = s.charAt(1)) || c == '\\';
        }

        void resetHandler() {
            this.prevcp = 32;
            this.parendepth = 0;
            this.parseError = false;
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            this.handleError(index, errCode, "Syntax error near " + context);
        }

        protected void handleError(int index, byte errCode, String message) {
            if (!this.parseError) {
                if (CSSParser.this.errorHandler != null) {
                    if (this.prevcp == this.endcp) {
                        CSSParser.this.errorHandler.fatalError(this.createException(index, errCode, "Expected end of file"));
                    } else {
                        CSSParser.this.errorHandler.error(this.createException(index, errCode, message));
                    }
                } else {
                    throw this.createException(index, errCode, message);
                }
                this.parseError = true;
            }
        }

        void unexpectedCharError(int index, int codepoint) {
            this.handleError(index, (byte)4, "Unexpected '" + new String(Character.toChars(codepoint)) + "'");
        }

        void unexpectedTokenError(int index, CharSequence token) {
            this.handleError(index, (byte)9, "Unexpected: " + token);
        }

        void handleWarning(int index, byte errCode, String message) {
            if (!this.parseError && CSSParser.this.errorHandler != null) {
                CSSParser.this.errorHandler.warning(this.createException(index, errCode, message));
            }
        }

        protected String getSourceURI() {
            if (this.source != null) {
                return this.source.getURI();
            }
            return null;
        }

        CSSParseException createException(int index, byte errCode, String message) {
            LocatorImpl locator = new LocatorImpl(this.line, index - this.prevlinelength, this.getSourceURI());
            if (errCode == 15) {
                return new CSSNamespaceParseException(message, locator);
            }
            return new CSSParseException(message, (Locator)locator);
        }

        void endDocument() {
            if (CSSParser.this.handler != null) {
                CSSParser.this.handler.endDocument(this.source);
            }
        }

        class MySelectorListImpl
        extends SelectorListImpl {
            private static final long serialVersionUID = 1L;

            MySelectorListImpl() {
            }

            public boolean add(Selector sel, int index) {
                if (this.add(sel)) {
                    return true;
                }
                if (CSSParser.this.errorHandler != null) {
                    int selsz;
                    try {
                        selsz = sel.toString().length();
                    }
                    catch (RuntimeException e) {
                        selsz = 1;
                    }
                    String message = "Duplicate selector in list";
                    try {
                        message = message + ": " + sel.toString();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    CSSParser.this.errorHandler.warning(CSSTokenHandler.this.createException(index - selsz, (byte)-1, message));
                }
                return false;
            }
        }
    }

    public static interface DeclarationRuleHandler
    extends DocumentHandler {
        public void startAtRule(String var1, String var2);

        public void endAtRule();
    }

    abstract class NestedRuleTH
    extends CSSTokenHandler {
        private final String blockRuleName;
        private final boolean singleName;
        private final int offset;
        private byte stage;
        private int curlyBracketDepth;
        private final DeclarationTokenHandler declarationHandler;
        private static final byte STAGE_WAIT_NAME = 1;
        private static final byte STAGE_WAIT_BLOCK_LIST = 2;
        private static final byte STAGE_WAIT_SELECTOR = 3;
        private static final byte STAGE_FOUND_SELECTOR = 4;
        private static final byte STAGE_DECLARATION_LIST = 5;
        private static final byte STAGE_END_BLOCK_LIST = 6;
        static final byte STAGE_SELECTOR_ERROR = 9;

        NestedRuleTH(int offset, int bufSize, String blockRuleName, boolean singleName) {
            super(null);
            this.stage = 1;
            this.curlyBracketDepth = 0;
            this.offset = offset;
            this.blockRuleName = blockRuleName;
            this.singleName = singleName;
            this.declarationHandler = new NestedRuleDeclarationTokenHandler();
            this.buffer = new StringBuilder(bufSize);
        }

        void setStage(byte stage) {
            this.stage = stage;
        }

        @Override
        public void word(int index, CharSequence word) {
            if (this.stage == 5) {
                this.declarationHandler.word(index, word);
            } else if (this.stage == 2 || this.stage == 6) {
                this.unexpectedTokenError(index, word);
            } else if (!this.parseError) {
                this.buffer.append(word);
                if (this.stage == 3) {
                    this.stage = (byte)4;
                }
                this.prevcp = 65;
            }
        }

        @Override
        public void separator(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.separator(index, codePoint);
            } else {
                if (this.buffer.length() != 0) {
                    if (this.stage == 1 && this.singleName && (this.escapedTokenIndex == -1 || this.prevcp == 32)) {
                        this.stage = (byte)2;
                    }
                    if (this.prevcp != 32) {
                        this.buffer.append(' ');
                    }
                }
                this.prevcp = 32;
            }
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quoteCp) {
            if (this.stage == 5) {
                this.declarationHandler.quoted(index, quoted, quoteCp);
            } else if (this.stage == 1) {
                if (this.singleName) {
                    if (this.buffer.length() == 0) {
                        this.buffer.append(quoted);
                        this.stage = (byte)2;
                        this.prevcp = 65;
                    } else {
                        this.handleError(index, (byte)9, this.blockRuleName + " name must be a single identifier or string");
                    }
                } else {
                    this.buffer.append(quoted);
                }
            } else {
                this.handleError(index, (byte)9, "Expected " + this.blockRuleName + " selector, found '" + quoted + "'");
            }
        }

        @Override
        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            this.quoted(index, quoted, quoteCp);
        }

        @Override
        public void openGroup(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.openGroup(index, codePoint);
                if (codePoint == 123) {
                    ++this.curlyBracketDepth;
                }
            } else {
                if (codePoint == 123) {
                    ++this.curlyBracketDepth;
                    if (this.stage == 1 || this.stage == 2) {
                        if (this.buffer.length() != 0) {
                            this.processName(index, this.unescapeBuffer(index).trim());
                            if (!this.parseError) {
                                this.prevcp = codePoint;
                                this.stage = (byte)3;
                            }
                        } else {
                            this.handleError(index, (byte)4, this.blockRuleName + " must have a name.");
                        }
                    } else if (this.stage == 4) {
                        this.processSelector(index);
                        this.prevcp = codePoint;
                        this.declarationHandler.curlyBracketDepth = 1;
                        this.stage = (byte)5;
                    }
                    return;
                }
                this.handleError(index, (byte)4, "Unexpected char: " + new String(Character.toChars(codePoint)));
            }
        }

        void processName(int index, String name) {
            if ("initial".equalsIgnoreCase(name) || "inherit".equalsIgnoreCase(name) || "unset".equalsIgnoreCase(name) || "none".equalsIgnoreCase(name) || "revert".equalsIgnoreCase(name)) {
                this.handleError(index, (byte)7, "A CSS keyword is not a valid custom ident.");
            }
        }

        abstract void processSelector(int var1);

        abstract void endBlock();

        abstract void endBlockList();

        @Override
        public void closeGroup(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.closeGroup(index, codePoint);
                if (codePoint == 125) {
                    --this.curlyBracketDepth;
                    if (this.curlyBracketDepth == 1) {
                        this.endBlock();
                        this.stage = (byte)3;
                    }
                }
                this.prevcp = codePoint;
            } else {
                if (codePoint == 125) {
                    --this.curlyBracketDepth;
                    if (this.curlyBracketDepth == 0) {
                        this.endBlockList();
                        this.stage = (byte)6;
                        this.prevcp = codePoint;
                    } else if (this.curlyBracketDepth == 1 && this.stage == 9) {
                        this.stage = (byte)3;
                        this.parseError = false;
                    }
                    return;
                }
                this.handleError(index, (byte)4, "Unexpected char: " + new String(Character.toChars(codePoint)));
            }
        }

        @Override
        public void character(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.character(index, codePoint);
            } else {
                char[] chars = Character.toChars(codePoint);
                if (this.stage == 3 || this.stage == 4) {
                    if (this.isValidSelectorCharacter(codePoint)) {
                        this.buffer.append(chars);
                        this.prevcp = codePoint;
                        return;
                    }
                    this.stage = (byte)9;
                } else if (this.stage == 1 && (this.isValidNameCharacter(codePoint) || !this.singleName && codePoint == 44)) {
                    this.buffer.append(chars);
                    this.prevcp = codePoint;
                    return;
                }
                this.handleError(index, (byte)4, "Unexpected char: " + new String(chars));
            }
        }

        abstract boolean isValidSelectorCharacter(int var1);

        abstract boolean isValidNameCharacter(int var1);

        @Override
        public void escaped(int index, int codePoint) {
            if (this.stage == 5) {
                this.declarationHandler.escaped(index, codePoint);
            } else {
                char[] chars = Character.toChars(codePoint);
                if (this.stage == 2 || this.stage == 6) {
                    this.unexpectedTokenError(index, new String(chars));
                } else if (!this.parseError) {
                    if (ParseHelper.isHexCodePoint(codePoint)) {
                        this.setEscapedTokenStart(index);
                        this.buffer.append('\\');
                    }
                    this.buffer.append(chars);
                    if (this.stage == 3) {
                        this.stage = (byte)4;
                    }
                    this.prevcp = 65;
                }
            }
        }

        @Override
        public void endOfStream(int len) {
            if (this.curlyBracketDepth != 0) {
                if (this.stage == 5) {
                    this.declarationHandler.endOfStream(len);
                    this.endBlock();
                    this.endBlockList();
                } else {
                    if (this.stage == 6) {
                        return;
                    }
                    if (this.stage == 3 || this.stage == 4) {
                        this.endBlockList();
                    }
                }
                this.handleError(len, (byte)10, "Unexpected end of " + this.blockRuleName + " rule.");
            } else if (this.stage != 6) {
                this.handleError(len, (byte)10, "Malformed " + this.blockRuleName + " rule.");
            }
        }

        @Override
        public void control(int index, int codepoint) {
            super.control(this.offset + index, codepoint);
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (!this.parseError && this.buffer.length() == 0 && this.curlyBracketDepth == 1 && this.parendepth == 0 && this.stage == 3) {
                super.commented(index, commentType, comment);
            }
        }

        @Override
        CSSParseException createException(int index, byte errCode, String message) {
            return super.createException(this.offset + index, errCode, message);
        }

        private class NestedRuleDeclarationTokenHandler
        extends DeclarationTokenHandler {
            private NestedRuleDeclarationTokenHandler() {
                super(null, null);
            }

            @Override
            protected void handleRightCurlyBracket(int index) {
                this.resetHandler();
                NestedRuleTH.this.stage = (byte)3;
                NestedRuleTH.this.prevcp = 125;
            }

            @Override
            public void control(int index, int codepoint) {
                NestedRuleTH.this.control(index, codepoint);
            }

            @Override
            CSSParseException createException(int index, byte errCode, String message) {
                return NestedRuleTH.this.createException(index, errCode, message);
            }
        }
    }

    private static class SACMediaListWrapper {
        private final SACMediaList mediaList;
        private final SACMediaListWrapper parent;

        SACMediaListWrapper(SACMediaList mediaList, SACMediaListWrapper parent) {
            this.mediaList = mediaList;
            this.parent = parent;
        }

        public SACMediaList getMediaList() {
            return this.mediaList;
        }

        SACMediaListWrapper getParent() {
            return this.parent;
        }

        public String toString() {
            return this.mediaList != null ? this.mediaList.toString() : "";
        }
    }

    private static class MySACAllMediaList
    implements SACMediaList {
        MySACAllMediaList() {
        }

        public int getLength() {
            return 1;
        }

        public String item(int index) {
            if (index != 0) {
                return null;
            }
            return "all";
        }

        public String toString() {
            return "all";
        }
    }

    private class ConditionTokenHandler
    extends CSSTokenHandler {
        final BooleanConditionFactory conditionFactory;
        BooleanCondition currentCond;
        private int opDepthIndex;
        private final short[] opParenDepth;
        private DelegateHandler predicateHandler;
        boolean readingPredicate;

        ConditionTokenHandler(BooleanConditionFactory conditionFactory) {
            super(null);
            this.currentCond = null;
            this.opDepthIndex = 0;
            this.opParenDepth = new short[32];
            this.readingPredicate = false;
            this.conditionFactory = conditionFactory;
            this.buffer = new StringBuilder(64);
        }

        DelegateHandler getPredicateHandler() {
            return this.predicateHandler;
        }

        void setPredicateHandler(DelegateHandler predicateHandler) {
            this.predicateHandler = predicateHandler;
        }

        @Override
        public void word(int index, CharSequence word) {
            if (!this.parseError) {
                if (!this.readingPredicate) {
                    if (this.buffer.length() == 0) {
                        this.processWord(index, word.toString());
                    } else {
                        this.unexpectedTokenError(index, word);
                    }
                } else if (this.getCurrentParenDepth() > 1) {
                    this.predicateHandler.word(index, word);
                } else {
                    this.processWord(index, word.toString());
                }
                this.prevcp = 65;
            }
        }

        private void processWord(int index, String word) {
            String lctoken = word.toLowerCase(Locale.ROOT);
            if ("not".equals(lctoken)) {
                this.predicateHandler.preBooleanHandling(index, BooleanCondition.Type.NOT);
                BooleanCondition newCond = this.conditionFactory.createNotCondition();
                if (this.currentCond != null) {
                    this.currentCond.addCondition(newCond);
                }
                this.setNestedCondition(newCond);
            } else if ("and".equals(lctoken)) {
                this.predicateHandler.preBooleanHandling(index, BooleanCondition.Type.AND);
                if (this.currentCond != null) {
                    this.processOperation(index, BooleanCondition.Type.AND, word);
                } else {
                    this.processImplicitAnd(index);
                }
            } else if ("or".equals(lctoken)) {
                if (this.currentCond != null) {
                    this.predicateHandler.preBooleanHandling(index, BooleanCondition.Type.OR);
                    try {
                        this.processOperation(index, BooleanCondition.Type.OR, word);
                    }
                    catch (DOMException e) {
                        this.unexpectedTokenError(index, word);
                    }
                } else {
                    this.unexpectedTokenError(index, word);
                }
            } else {
                this.readingPredicate = true;
                this.predicateHandler.word(index, word);
            }
        }

        void processOperation(int index, BooleanCondition.Type opType, String opname) {
            BooleanCondition operation = this.currentCond.getParentCondition();
            BooleanCondition.Type curType = this.currentCond.getType();
            if (curType == BooleanCondition.Type.PREDICATE) {
                if (operation == null) {
                    BooleanCondition newCond = this.createOperation(opType);
                    newCond.addCondition(this.currentCond);
                    this.setNestedCondition(newCond);
                } else if (operation.getType() == opType) {
                    this.currentCond = operation;
                } else {
                    BooleanCondition newCond = this.createOperation(opType);
                    if (this.opParenDepth[this.opDepthIndex] != 0) {
                        BooleanCondition oldCond = operation.replaceLast(newCond);
                        newCond.addCondition(oldCond);
                    } else {
                        newCond.addCondition(operation);
                    }
                    this.setNestedCondition(newCond);
                }
            } else if (curType == BooleanCondition.Type.NOT) {
                if (operation != null) {
                    BooleanCondition newCond = this.createOperation(opType);
                    BooleanCondition oldCond = operation.replaceLast(newCond);
                    newCond.addCondition(oldCond);
                    this.setNestedCondition(newCond);
                } else {
                    this.unexpectedTokenError(index, opname);
                }
            } else if (curType != opType) {
                this.unexpectedTokenError(index, opname);
            }
        }

        BooleanCondition createOperation(BooleanCondition.Type opType) {
            if (opType == BooleanCondition.Type.AND) {
                return this.conditionFactory.createAndCondition();
            }
            return this.conditionFactory.createOrCondition();
        }

        private void setNestedCondition(BooleanCondition newCond) {
            this.currentCond = newCond;
            ++this.opDepthIndex;
        }

        void processImplicitAnd(int index) {
            this.unexpectedTokenError(index, "and");
        }

        @Override
        public void openGroup(int index, int codepoint) {
            if (codepoint == 40) {
                int n = this.opDepthIndex;
                this.opParenDepth[n] = (short)(this.opParenDepth[n] + 1);
            }
            this.predicateHandler.openGroup(index, codepoint);
            this.readingPredicate = true;
            this.prevcp = codepoint;
        }

        @Override
        public void closeGroup(int index, int codepoint) {
            if (codepoint == 41) {
                int n = this.opDepthIndex;
                this.opParenDepth[n] = (short)(this.opParenDepth[n] - 1);
                if (this.opParenDepth[this.opDepthIndex] < 0) {
                    this.unexpectedCharError(index, codepoint);
                } else if (this.buffer.length() != 0) {
                    if (this.readingPredicate) {
                        this.predicateHandler.closeGroup(index, codepoint);
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                }
                if (this.opParenDepth[this.opDepthIndex] == 0 && this.currentCond != null && this.opDepthIndex != 0) {
                    --this.opDepthIndex;
                    if (this.currentCond.getParentCondition() != null) {
                        this.currentCond = this.currentCond.getParentCondition();
                    }
                }
                this.prevcp = codepoint;
            } else if (this.readingPredicate) {
                this.predicateHandler.closeGroup(index, codepoint);
                this.prevcp = codepoint;
            } else {
                this.unexpectedCharError(index, codepoint);
            }
        }

        short getCurrentParenDepth() {
            return this.opParenDepth[this.opDepthIndex];
        }

        @Override
        public void character(int index, int codepoint) {
            if (!this.parseError) {
                if (!this.readingPredicate) {
                    if (codepoint == 44) {
                        this.predicateHandler.character(index, codepoint);
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else {
                    this.predicateHandler.character(index, codepoint);
                }
            } else if (codepoint == 44) {
                this.predicateHandler.character(index, codepoint);
            }
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quoteCp) {
            if (!this.parseError) {
                if (this.readingPredicate) {
                    this.predicateHandler.quoted(index, quoted, quoteCp);
                    this.prevcp = 65;
                } else {
                    this.handleError(index, (byte)9, "Unexpected: '" + quoted + '\'');
                }
            }
        }

        @Override
        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            this.quoted(index, quoted, quoteCp);
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (!this.parseError) {
                if (this.readingPredicate) {
                    this.predicateHandler.escaped(index, codepoint);
                } else if (this.prevcp == 40) {
                    this.readingPredicate = true;
                    this.predicateHandler.escaped(index, codepoint);
                } else {
                    this.handleError(index, (byte)9, "Unexpected escaped character: \\u" + Integer.toHexString(codepoint));
                }
                this.prevcp = codepoint;
            }
        }

        @Override
        public void separator(int index, int codepoint) {
            if (!this.parseError) {
                if (this.readingPredicate) {
                    this.predicateHandler.separator(index, codepoint);
                }
                this.prevcp = 32;
            }
        }

        @Override
        public void control(int index, int codepoint) {
            super.control(index, codepoint);
            if (this.escapedTokenIndex != -1 && CSSParser.bufferEndsWithEscapedCharOrWS(this.buffer)) {
                this.escapedTokenIndex = -1;
                this.buffer.append(' ');
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
        }

        @Override
        public void endOfStream(int len) {
            if (this.opParenDepth[this.opDepthIndex] != 0) {
                this.handleError(len, (byte)6, "Unmatched parenthesis");
            } else if (!this.parseError) {
                this.predicateHandler.endOfStream(len);
            }
        }

        @Override
        protected void handleError(int index, byte errCode, String message) {
            throw this.createException(index, errCode, message);
        }
    }

    private abstract class DelegateHandler
    implements TokenHandler {
        private DelegateHandler() {
        }

        public void preBooleanHandling(int index, BooleanCondition.Type type) {
        }

        @Override
        public void tokenControl(TokenControl control) {
        }

        @Override
        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
        }

        @Override
        public void quotedNewlineChar(int index, int codePoint) {
        }

        @Override
        public void control(int index, int codePoint) {
        }

        @Override
        public void commented(int index, int commentType, String comment) {
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
        }
    }
}

