/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.LexicalUnit2;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;

class LexicalUnitImpl
implements LexicalUnit2 {
    private short unitType;
    int intValue = 0;
    float floatValue = 0.0f;
    String dimensionUnitText = "";
    String value = null;
    String identCssText = null;
    LexicalUnitImpl previousLexicalUnit = null;
    LexicalUnitImpl nextLexicalUnit = null;
    LexicalUnitImpl parameters = null;
    LexicalUnitImpl ownerLexicalUnit = null;

    public LexicalUnitImpl(short unitType) {
        this.unitType = unitType;
    }

    public short getLexicalUnitType() {
        return this.unitType;
    }

    void setUnitType(short unitType) {
        this.unitType = unitType;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    public int getIntegerValue() {
        return this.intValue;
    }

    public float getFloatValue() {
        return this.floatValue;
    }

    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    public String getFunctionName() {
        return this.value;
    }

    public LexicalUnit getParameters() {
        if (this.unitType != 40) {
            return this.parameters;
        }
        return null;
    }

    public String getStringValue() {
        if (this.unitType == 37) {
            StringBuilder buf = new StringBuilder();
            LexicalUnitImpl lu = this.parameters;
            if (lu != null) {
                buf.append(((Object)lu).toString());
            }
            return buf.toString();
        }
        return this.value;
    }

    public LexicalUnit getSubValues() {
        if (this.unitType == 40 || this.unitType == 39) {
            return this.parameters;
        }
        return null;
    }

    void addFunctionParameter(LexicalUnitImpl paramUnit) {
        paramUnit.ownerLexicalUnit = this;
        if (this.parameters == null) {
            this.parameters = paramUnit;
        } else {
            LexicalUnitImpl lu = this.parameters;
            while (lu.getNextLexicalUnit() != null) {
                lu = lu.getNextLexicalUnit();
            }
            LexicalUnitImpl luimpl = lu;
            luimpl.nextLexicalUnit = paramUnit;
            paramUnit.previousLexicalUnit = luimpl;
        }
    }

    void reset() {
        this.intValue = 0;
        this.floatValue = 0.0f;
        this.dimensionUnitText = "";
        this.parameters = null;
        this.nextLexicalUnit = null;
    }

    @Override
    public String getCssText() {
        return this.currentToString().toString();
    }

    public String toString() {
        if (this.nextLexicalUnit == null) {
            return this.currentToString().toString();
        }
        StringBuilder buf = new StringBuilder();
        LexicalUnitImpl lu = this;
        boolean needSpaces = false;
        while (lu != null) {
            switch (lu.getLexicalUnitType()) {
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 68: {
                    needSpaces = false;
                }
                case 0: {
                    break;
                }
                case 69: {
                    needSpaces = true;
                    break;
                }
                default: {
                    if (needSpaces) {
                        buf.append(' ');
                        break;
                    }
                    needSpaces = true;
                }
            }
            buf.append(lu.currentToString());
            lu = lu.nextLexicalUnit;
        }
        return buf.toString();
    }

    private CharSequence currentToString() {
        switch (this.unitType) {
            case 13: {
                return Integer.toString(this.intValue);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                StringBuilder buf = new StringBuilder();
                if (this.floatValue % 1.0f != 0.0f) {
                    buf.append(String.format(Locale.ROOT, "%s", Float.valueOf(this.floatValue)));
                } else {
                    buf.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(this.floatValue)));
                }
                if (this.dimensionUnitText != null) {
                    buf.append(this.dimensionUnitText);
                }
                return buf.toString();
            }
            case 27: {
                if (this.identCssText != null) {
                    return this.identCssText;
                }
            }
            case 25: 
            case 26: 
            case 37: 
            case 38: 
            case 41: {
                StringBuilder buf = new StringBuilder();
                buf.append(this.value).append('(');
                LexicalUnitImpl lu = this.parameters;
                if (lu != null) {
                    buf.append(((Object)lu).toString());
                }
                buf.append(')');
                return buf.toString();
            }
            case 40: {
                StringBuilder buf = new StringBuilder();
                buf.append('(');
                LexicalUnitImpl lu = this.parameters;
                if (lu != null) {
                    buf.append(((Object)lu).toString());
                }
                buf.append(')');
                return buf.toString();
            }
            case 35: {
                return this.identCssText != null ? this.identCssText : this.value;
            }
            case 36: {
                return this.identCssText;
            }
            case 24: {
                String quri = this.identCssText != null ? this.identCssText : ParseHelper.quote(this.value, '\'');
                return "url(" + quri + ")";
            }
            case 12: {
                return "inherit";
            }
            case 73: {
                if (this.value == null) {
                    return "element(#)";
                }
                int len = this.value.length();
                StringBuilder buf = new StringBuilder(len + 10);
                buf.append("element(#").append(this.value).append(')');
                return buf.toString();
            }
            case 39: {
                StringBuilder buf = new StringBuilder();
                LexicalUnitImpl lu = this.parameters;
                if (lu != null) {
                    if (lu.getLexicalUnitType() == 13) {
                        buf.append("U+").append(Integer.toHexString(lu.getIntegerValue()));
                    } else {
                        buf.append("U+").append(lu.getStringValue());
                    }
                    lu = lu.getNextLexicalUnit();
                    if (lu != null) {
                        buf.append('-');
                        if (lu.getLexicalUnitType() == 13) {
                            buf.append(Integer.toHexString(lu.getIntegerValue()));
                        } else {
                            buf.append(lu.getStringValue());
                        }
                    }
                }
                return buf.toString();
            }
            case 70: {
                return this.getStringValue();
            }
            case 0: {
                return ",";
            }
            case 6: {
                return "^";
            }
            case 10: {
                return ">=";
            }
            case 8: {
                return ">";
            }
            case 9: {
                return "<=";
            }
            case 7: {
                return "<";
            }
            case 2: {
                return "-";
            }
            case 5: {
                return "%";
            }
            case 3: {
                return "*";
            }
            case 1: {
                return "+";
            }
            case 4: {
                return "/";
            }
            case 11: {
                return "~";
            }
            case 68: {
                return "[";
            }
            case 69: {
                return "]";
            }
            case 71: 
            case 72: {
                return ParseHelper.escapeControl(this.value);
            }
        }
        return "";
    }
}

