/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSAttrValue;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class AttrValue
extends AbstractTextValue
implements CSSAttrValue {
    private String attrname = null;
    private String typeval = null;
    private StyleValue fallback = null;
    private final byte flags;

    public AttrValue(byte flags) {
        super((short)22);
        this.flags = flags;
    }

    protected AttrValue(AttrValue copied) {
        super(copied);
        this.attrname = copied.attrname;
        this.typeval = copied.typeval;
        this.fallback = copied.fallback;
        this.flags = copied.flags;
    }

    @Override
    public String getAttributeName() {
        return this.attrname;
    }

    @Override
    public String getAttributeType() {
        return this.typeval;
    }

    @Override
    public StyleValue getFallback() {
        return this.fallback;
    }

    public static PrimitiveValue defaultFallback(String valueType) {
        PrimitiveValue defaultFallback = null;
        if (valueType == null || "string".equalsIgnoreCase(valueType)) {
            defaultFallback = new StringValue();
            ((PrimitiveValue)defaultFallback).setStringValue((short)19, "");
        } else if ("color".equalsIgnoreCase(valueType)) {
            defaultFallback = new IdentifierValue("currentColor");
        } else if ("integer".equalsIgnoreCase(valueType) || "number".equalsIgnoreCase(valueType) || "length".equalsIgnoreCase(valueType)) {
            defaultFallback = NumberValue.createCSSNumberValue((short)1, 0.0f);
        } else if ("angle".equalsIgnoreCase(valueType)) {
            defaultFallback = NumberValue.createCSSNumberValue((short)11, 0.0f);
        } else if ("time".equalsIgnoreCase(valueType)) {
            defaultFallback = NumberValue.createCSSNumberValue((short)15, 0.0f);
        } else if ("frequency".equalsIgnoreCase(valueType)) {
            defaultFallback = NumberValue.createCSSNumberValue((short)16, 0.0f);
        } else if ("%".equalsIgnoreCase(valueType)) {
            defaultFallback = NumberValue.createCSSNumberValue((short)2, 0.0f);
        } else {
            short pType;
            String lctypeval = valueType.toLowerCase(Locale.ROOT).intern();
            short sacUnit = ParseHelper.unitFromString(lctypeval);
            if (sacUnit != 42 && (pType = ValueFactory.domPrimitiveType(sacUnit)) != 0) {
                if (NumberValue.isLengthUnitType(pType)) {
                    defaultFallback = NumberValue.createCSSNumberValue((short)1, 0.0f);
                } else if (NumberValue.isAngleUnitType(pType)) {
                    defaultFallback = NumberValue.createCSSNumberValue((short)11, 0.0f);
                } else if (pType == 15 || pType == 14) {
                    defaultFallback = NumberValue.createCSSNumberValue((short)15, 0.0f);
                } else if (pType == 16 || pType == 17) {
                    defaultFallback = NumberValue.createCSSNumberValue((short)16, 0.0f);
                }
            }
        }
        return defaultFallback;
    }

    @Override
    public String getStringValue() {
        if (this.typeval == null && this.fallback == null) {
            return this.attrname;
        }
        StringBuilder buf = new StringBuilder(this.attrname.length() + 32);
        buf.append(this.attrname);
        if (this.typeval != null) {
            buf.append(' ');
            buf.append(this.typeval);
        }
        if (this.fallback != null) {
            buf.append(", ");
            buf.append(this.fallback.getCssText());
        }
        return buf.toString();
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        this.checkModifiableProperty();
        if (stringType != 22) {
            throw new DOMException(13, "This value is an attribute. To have a new type, set it at the style-declaration level.");
        }
        this.typeval = null;
        this.fallback = null;
        this.parseAttrValues(stringValue);
        this.setPlainCssText("attr(" + stringValue + ')');
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter sw = new BufferSimpleWriter(32);
        try {
            this.writeCssText(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("attr(");
        wri.write(this.attrname);
        if (this.typeval != null) {
            wri.write(' ');
            wri.write(this.typeval);
        }
        if (this.fallback != null) {
            wri.write(", ");
            this.fallback.writeCssText(wri);
        }
        wri.write(')');
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        StringBuilder buf = new StringBuilder(32);
        buf.append("attr(");
        buf.append(this.attrname);
        if (this.typeval != null) {
            buf.append(' ');
            buf.append(this.typeval);
        }
        if (this.fallback != null) {
            buf.append(',');
            buf.append(this.fallback.getMinifiedCssText(propertyName));
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory factory = new ValueFactory(this.flags);
        StyleValue cssval = factory.parseProperty(cssText);
        if (cssval == null || cssval.getCssValueType() != 1 || ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() != 22) {
            throw new DOMException(13, "Not an attr value.");
        }
        AttrValue attr = (AttrValue)cssval;
        this.attrname = attr.attrname;
        this.typeval = attr.typeval;
        this.fallback = attr.fallback;
        this.setPlainCssText(cssval.getCssText());
    }

    private void parseAttrValues(String attr) throws DOMException {
        StringTokenizer st;
        int len = attr.length();
        int idx = attr.indexOf(44);
        int idxp1 = idx + 1;
        if (idxp1 == len) {
            this.badSyntax(attr);
        }
        if (idxp1 != 0) {
            ValueFactory factory = new ValueFactory(this.flags);
            String s = attr.substring(idxp1, len).trim();
            StyleValue value = factory.parseProperty(s);
            if (value.getCssValueType() != 1) {
                StringValue sval = new StringValue(this.flags);
                sval.setStringValue((short)19, s);
                this.fallback = sval;
            } else {
                this.fallback = value;
                if (PrimitiveValue.isOrContainsType(this.fallback, (short)22)) {
                    this.badSyntax(attr);
                }
            }
        }
        if (idx == -1) {
            idx = len;
        }
        if (!(st = new StringTokenizer(attr.substring(0, idx))).hasMoreTokens()) {
            this.badSyntax(attr);
        }
        this.attrname = st.nextToken();
        this.attrname = ParseHelper.parseIdent(this.attrname);
        if (st.hasMoreTokens()) {
            this.typeval = st.nextToken();
            if (st.hasMoreTokens()) {
                this.badSyntax(attr);
            }
        }
    }

    private void badSyntax(String attr) throws DOMException {
        throw new DOMException(12, "Bad attr(): " + attr);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.attrname == null ? 0 : this.attrname.hashCode());
        result = 31 * result + (this.fallback == null ? 0 : this.fallback.hashCode());
        result = 31 * result + (this.typeval == null ? 0 : this.typeval.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttrValue other = (AttrValue)obj;
        if (this.attrname == null ? other.attrname != null : !this.attrname.equals(other.attrname)) {
            return false;
        }
        if (this.fallback == null ? other.fallback != null : !this.fallback.equals(other.fallback)) {
            return false;
        }
        return !(this.typeval == null ? other.typeval != null : !this.typeval.equals(other.typeval));
    }

    @Override
    public AttrValue clone() {
        return new AttrValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            String strval = lunit.getStringValue();
            AttrValue.this.setPlainCssText("attr(" + strval + ')');
            AttrValue.this.parseAttrValues(strval);
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

