/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class CalcValue
extends ExpressionValue {
    public CalcValue() {
    }

    protected CalcValue(CalcValue copied) {
        super(copied);
    }

    @Override
    public String getStringValue() throws DOMException {
        return "calc";
    }

    @Override
    protected boolean isInvalidOperand(PrimitiveValue primi, short lutype, short lastlutype) {
        if (super.isInvalidOperand(primi, lutype, lastlutype)) {
            return true;
        }
        if (primi instanceof NumberValue) {
            return lastlutype == 40;
        }
        return lutype != 41 && lutype != 37;
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(15, "Must retrieve individual operands and compute result");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + "calc".hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public String getCssText() {
        String s = this.getExpression().getCssText();
        StringBuilder buf = new StringBuilder(s.length() + 7);
        buf.append("calc(").append(s).append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String pname) {
        String s = this.getExpression().getMinifiedCssText();
        StringBuilder buf = new StringBuilder(s.length() + 6);
        buf.append("calc(").append(s).append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("calc(");
        wri.write(this.getExpression().getCssText());
        wri.write(')');
    }

    @Override
    public CalcValue clone() {
        return new CalcValue(this);
    }
}

