/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class ColorValue
extends AbstractTextValue {
    public static final NumberValue opaqueAlpha;
    private CSSRGBColor color = null;
    private RGBAColor.ColorSpace colorSpace = RGBAColor.ColorSpace.RGB;
    private boolean systemDefault = false;
    private boolean commaSyntax = false;

    ColorValue() {
        super((short)25);
        this.color = new CSSRGBColor();
    }

    protected ColorValue(ColorValue copied) {
        super(copied);
        this.color = copied.color.clone();
        this.colorSpace = copied.colorSpace;
        this.systemDefault = copied.systemDefault;
    }

    public void setSystemDefault() {
        this.systemDefault = true;
    }

    @Override
    public boolean isSystemDefault() {
        return this.systemDefault;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory factory = new ValueFactory();
        StyleValue value = factory.parseProperty(cssText);
        if (value.getCssValueType() == 1) {
            short ptype = ((CSSPrimitiveValue)((Object)value)).getPrimitiveType();
            if (ptype == 21) {
                String ident = ((CSSPrimitiveValue)((Object)value)).getStringValue().toLowerCase(Locale.ROOT);
                String colorspec = ColorIdentifiers.getInstance().getColor(ident);
                if (colorspec != null) {
                    value = factory.parseProperty(colorspec);
                } else if ("transparent".equals(ident)) {
                    value = factory.parseProperty("rgba(0,0,0,0)");
                } else {
                    this.failSetCssText();
                }
            } else if (ptype != 25) {
                this.failSetCssText();
            }
            this.setPlainCssText(cssText);
            this.set((ColorValue)value);
        } else {
            this.failSetCssText();
        }
    }

    private void failSetCssText() {
        throw new DOMException(13, "This property can only be set to a color value");
    }

    private void set(ColorValue setfrom) {
        this.color = setfrom.color;
        this.colorSpace = setfrom.colorSpace;
        this.systemDefault = setfrom.systemDefault;
    }

    public RGBAColor.ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public String getCssText() {
        String css;
        if (this.colorSpace == RGBAColor.ColorSpace.HSL && (css = this.color.toHSLString()) != null) {
            return css;
        }
        return this.getRGBColorValue().toString();
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        String css;
        if (this.colorSpace == RGBAColor.ColorSpace.HSL && this.color.getAlpha().getFloatValue((short)1) != 1.0f && (css = this.color.toHSLMinifiedString()) != null) {
            return css;
        }
        return ((CSSRGBColor)this.getRGBColorValue()).toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        String css;
        if (this.colorSpace == RGBAColor.ColorSpace.HSL && (css = this.color.toHSLString()) != null) {
            wri.write(css);
            return;
        }
        wri.write(this.getRGBColorValue().toString());
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.getCssText();
    }

    @Override
    public RGBAColor getRGBColorValue() throws DOMException {
        if (this.color.red == null || this.color.green == null || this.color.blue == null) {
            throw new DOMException(11, "Color not set");
        }
        return this.color;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    void translateHSL(float hue, float sat, float light) {
        if (hue > 1.0f) {
            hue -= (float)Math.floor(hue);
        } else if (hue < 0.0f) {
            hue = hue - (float)Math.floor(hue) + 1.0f;
        }
        float m2 = light <= 0.5f ? light * (sat + 1.0f) : light + sat - light * sat;
        float m1 = light * 2.0f - m2;
        NumberValue red = new NumberValue();
        red.setFloatValue((short)2, ColorValue.hueToRgb(m1, m2, hue + 0.33333334f));
        NumberValue green = new NumberValue();
        green.setFloatValue((short)2, ColorValue.hueToRgb(m1, m2, hue));
        NumberValue blue = new NumberValue();
        blue.setFloatValue((short)2, ColorValue.hueToRgb(m1, m2, hue - 0.33333334f));
        this.color.red = red;
        this.color.green = green;
        this.color.blue = blue;
    }

    private static float hueToRgb(float m1, float m2, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        } else if (h > 1.0f) {
            h -= 1.0f;
        }
        if (h * 6.0f < 1.0f) {
            return (m1 + (m2 - m1) * h * 6.0f) * 100.0f;
        }
        if (h * 2.0f < 1.0f) {
            return m2 * 100.0f;
        }
        if (h * 3.0f < 2.0f) {
            return (m1 + (m2 - m1) * (0.6666667f - h) * 6.0f) * 100.0f;
        }
        return m1 * 100.0f;
    }

    void translateHWB(float hue, float whiteness, float blackness) {
        float b;
        float g;
        float r;
        if (hue > 1.0f) {
            hue -= (float)Math.floor(hue);
        } else if (hue < 0.0f) {
            hue = hue - (float)Math.floor(hue) + 1.0f;
        }
        float fh = (float)Math.floor(hue *= 6.0f);
        float f = hue - fh;
        int ifh = (int)fh;
        if (ifh % 2 == 1) {
            f = 1.0f - f;
        }
        float value = 1.0f - blackness;
        float wv = whiteness + f * (value - whiteness);
        switch (ifh) {
            case 1: {
                r = wv;
                g = value;
                b = whiteness;
                break;
            }
            case 2: {
                r = whiteness;
                g = value;
                b = wv;
                break;
            }
            case 3: {
                r = whiteness;
                g = wv;
                b = value;
                break;
            }
            case 4: {
                r = wv;
                g = whiteness;
                b = value;
                break;
            }
            case 5: {
                r = value;
                g = whiteness;
                b = wv;
                break;
            }
            default: {
                r = value;
                g = wv;
                b = whiteness;
            }
        }
        NumberValue red = new NumberValue();
        red.setFloatValue((short)1, Math.round(r * 255.0f));
        NumberValue green = new NumberValue();
        green.setFloatValue((short)1, Math.round(g * 255.0f));
        NumberValue blue = new NumberValue();
        blue.setFloatValue((short)1, Math.round(b * 255.0f));
        this.color.red = red;
        this.color.green = green;
        this.color.blue = blue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ColorValue)) {
            return false;
        }
        ColorValue other = (ColorValue)obj;
        return !(this.color == null ? other.color != null : !this.color.equals(other.color));
    }

    @Override
    public ColorValue clone() {
        return new ColorValue(this);
    }

    static {
        NumberValue alpha = new NumberValue();
        alpha.setFloatValue((short)1, 1.0f);
        opaqueAlpha = alpha.immutable();
    }

    class CSSRGBColor
    implements RGBAColor {
        private PrimitiveValue red = null;
        private PrimitiveValue green = null;
        private PrimitiveValue blue = null;
        private PrimitiveValue alpha = opaqueAlpha;

        CSSRGBColor() {
        }

        public void setRed(PrimitiveValue red) {
            this.red = red;
        }

        @Override
        public PrimitiveValue getRed() {
            return this.red;
        }

        public void setGreen(PrimitiveValue green) {
            this.green = green;
        }

        @Override
        public PrimitiveValue getGreen() {
            return this.green;
        }

        public void setBlue(PrimitiveValue blue) {
            this.blue = blue;
        }

        @Override
        public PrimitiveValue getBlue() {
            return this.blue;
        }

        public void setAlpha(PrimitiveValue alpha) {
            this.alpha = alpha;
        }

        @Override
        public PrimitiveValue getAlpha() {
            return this.alpha;
        }

        public String toString() {
            return this.toString(false);
        }

        String toMinifiedString() {
            return this.toString(true);
        }

        String toString(boolean minify) {
            StringBuilder buf;
            boolean nonOpaque;
            int r = this.red.getPrimitiveType() == 2 ? Math.round(this.red.getFloatValue((short)2) * 2.55f) : Math.round(this.red.getFloatValue((short)1));
            int g = this.green.getPrimitiveType() == 2 ? Math.round(this.green.getFloatValue((short)2) * 2.55f) : Math.round(this.green.getFloatValue((short)1));
            int b = this.blue.getPrimitiveType() == 2 ? Math.round(this.blue.getFloatValue((short)2) * 2.55f) : Math.round(this.blue.getFloatValue((short)1));
            boolean bl = nonOpaque = this.getFloatAlpha() != 1.0f;
            if (nonOpaque || r > 255 || g > 255 || b > 255) {
                if (minify) {
                    if (ColorValue.this.commaSyntax) {
                        return this.minifiedOldFunctionalString(nonOpaque);
                    }
                    return this.minifiedFunctionalString(nonOpaque);
                }
                if (ColorValue.this.commaSyntax) {
                    return this.oldFunctionalString(nonOpaque);
                }
                return this.functionalString(nonOpaque);
            }
            String hexr = Integer.toHexString(r);
            String hexg = Integer.toHexString(g);
            String hexb = Integer.toHexString(b);
            if (r != 0 && this.notSameChar(hexr) || g != 0 && this.notSameChar(hexg) || b != 0 && this.notSameChar(hexb)) {
                buf = new StringBuilder(7);
                buf.append('#');
                if (hexr.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexr);
                if (hexg.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexg);
                if (hexb.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexb);
            } else {
                buf = new StringBuilder(4);
                buf.append('#');
                buf.append(hexr.charAt(0));
                buf.append(hexg.charAt(0));
                buf.append(hexb.charAt(0));
            }
            return buf.toString();
        }

        private String minifiedFunctionalString(boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(21);
            buf.append("rgb(");
            this.appendComponentCssText(buf, this.red, true).append(' ');
            this.appendComponentCssText(buf, this.green, true).append(' ');
            this.appendComponentCssText(buf, this.blue, true);
            if (nonOpaque) {
                buf.append('/');
                this.appendAlphaChannelMinified(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        private String minifiedOldFunctionalString(boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(24);
            if (nonOpaque) {
                buf.append("rgba(");
            } else {
                buf.append("rgb(");
            }
            this.appendComponentCssText(buf, this.red, true).append(',');
            this.appendComponentCssText(buf, this.green, true).append(',');
            this.appendComponentCssText(buf, this.blue, true);
            if (nonOpaque) {
                buf.append(',');
                this.appendAlphaChannelMinified(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        private String functionalString(boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(23);
            buf.append("rgb(");
            this.appendComponentCssText(buf, this.red, false).append(' ');
            this.appendComponentCssText(buf, this.green, false).append(' ');
            this.appendComponentCssText(buf, this.blue, false);
            if (nonOpaque) {
                buf.append(" / ");
                this.appendAlphaChannel(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        private String oldFunctionalString(boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(25);
            if (nonOpaque) {
                buf.append("rgba(");
            } else {
                buf.append("rgb(");
            }
            this.appendComponentCssText(buf, this.red, false).append(", ");
            this.appendComponentCssText(buf, this.green, false).append(", ");
            this.appendComponentCssText(buf, this.blue, false);
            if (nonOpaque) {
                buf.append(", ");
                this.appendAlphaChannel(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        private StringBuilder appendComponentCssText(StringBuilder buf, PrimitiveValue component, boolean minify) {
            if (ColorValue.this.colorSpace == RGBAColor.ColorSpace.RGB || component.getPrimitiveType() != 2) {
                return buf.append(component.getCssText());
            }
            float val = component.getFloatValue((short)2);
            float rval = (float)(Math.rint(val * 10.0f) * (double)0.1f);
            if (rval == 0.0f && minify) {
                return buf.append('0');
            }
            double rintValue = Math.rint(val);
            String strVal = (double)rval == rintValue ? Integer.toString((int)rval) : Float.toString(rval);
            return buf.append(strVal).append('%');
        }

        private StringBuilder appendAlphaChannel(StringBuilder buf) {
            String text;
            if (this.alpha.getPrimitiveType() == 1) {
                float f = this.alpha.getFloatValue((short)1);
                text = this.formattedNumber(f);
            } else {
                text = this.alpha.getCssText();
            }
            return buf.append(text);
        }

        private StringBuilder appendAlphaChannelMinified(StringBuilder buf) {
            String text;
            if (this.alpha.getPrimitiveType() == 1) {
                float f = this.alpha.getFloatValue((short)1);
                text = this.formattedNumberMinified(f);
            } else {
                text = this.alpha.getMinifiedCssText("");
            }
            return buf.append(text);
        }

        private String formattedNumber(float f) {
            NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
            format.setMaximumFractionDigits(3);
            format.setMinimumFractionDigits(0);
            return format.format(f);
        }

        private String formattedNumberMinified(float f) {
            NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
            format.setMaximumFractionDigits(3);
            format.setMinimumFractionDigits(0);
            format.setMinimumIntegerDigits(0);
            return format.format(f);
        }

        private boolean notSameChar(String hexr) {
            return hexr.length() == 1 || hexr.charAt(0) != hexr.charAt(1);
        }

        Hsl toHSL() {
            float h;
            float max;
            float b;
            float g;
            float r;
            if (this.red.getPrimitiveType() == 2) {
                r = this.red.getFloatValue((short)2) * 0.01f;
            } else {
                r = this.red.getFloatValue((short)1);
                r /= 255.0f;
            }
            if (this.green.getPrimitiveType() == 2) {
                g = this.green.getFloatValue((short)2) * 0.01f;
            } else {
                g = this.green.getFloatValue((short)1);
                g /= 255.0f;
            }
            if (this.blue.getPrimitiveType() == 2) {
                b = this.blue.getFloatValue((short)2) * 0.01f;
            } else {
                b = this.blue.getFloatValue((short)1);
                b /= 255.0f;
            }
            if (r > 1.0f || g > 1.0f || b > 1.0f) {
                return null;
            }
            boolean maxr = false;
            boolean maxg = false;
            if (g > r) {
                max = g;
                maxg = true;
            } else {
                max = r;
                maxr = true;
            }
            if (b > max) {
                max = b;
                maxr = false;
                maxg = false;
            }
            float min = Math.min(r, g);
            if (max == (min = Math.min(min, b))) {
                h = 0.0f;
            } else if (maxr) {
                h = (g - b) / (max - min) * 60.0f + 360.0f;
                if ((h = (float)Math.IEEEremainder(h, 360.0)) < 0.0f) {
                    h += 360.0f;
                }
            } else if (maxg) {
                h = (b - r) / (max - min) * 60.0f + 120.0f;
                if (h < 0.0f) {
                    h += 360.0f;
                }
            } else {
                h = (r - g) / (max - min) * 60.0f + 240.0f;
                if (h < 0.0f) {
                    h += 360.0f;
                }
            }
            float l = (max + min) * 0.5f;
            Hsl hsl = new Hsl();
            hsl.s = max != min ? (l <= 0.5f ? Math.round((max - min) / l * 50.0f) : Math.round((max - min) / (1.0f - l) * 50.0f)) : 0;
            hsl.h = Math.round(h);
            if (hsl.h == 360) {
                hsl.h = 0;
            }
            hsl.l = Math.round(l * 100.0f);
            return hsl;
        }

        String toHSLString() {
            boolean nonOpaque;
            Hsl hsl = this.toHSL();
            if (hsl == null) {
                return null;
            }
            boolean bl = nonOpaque = this.getFloatAlpha() != 1.0f;
            if (ColorValue.this.commaSyntax) {
                return this.oldHSLString(hsl, nonOpaque);
            }
            return this.hslString(hsl, nonOpaque);
        }

        private String oldHSLString(Hsl hsl, boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(22);
            if (nonOpaque) {
                buf.append("hsla(");
            } else {
                buf.append("hsl(");
            }
            buf.append(Integer.toString(hsl.h)).append(", ").append(Integer.toString(hsl.s)).append('%').append(", ").append(Integer.toString(hsl.l)).append('%');
            if (nonOpaque) {
                buf.append(", ");
                this.appendAlphaChannel(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        private String hslString(Hsl hsl, boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(20);
            buf.append("hsl(").append(Integer.toString(hsl.h)).append(' ').append(Integer.toString(hsl.s)).append('%').append(' ').append(Integer.toString(hsl.l)).append('%');
            if (nonOpaque) {
                buf.append(" / ");
                this.appendAlphaChannel(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        String toHSLMinifiedString() {
            boolean nonOpaque;
            Hsl hsl = this.toHSL();
            if (hsl == null) {
                return null;
            }
            boolean bl = nonOpaque = this.getFloatAlpha() != 1.0f;
            if (ColorValue.this.commaSyntax) {
                return this.oldHSLMinifiedString(hsl, nonOpaque);
            }
            return this.hslMinifiedString(hsl, nonOpaque);
        }

        private String oldHSLMinifiedString(Hsl hsl, boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(21);
            if (nonOpaque) {
                buf.append("hsla(");
            } else {
                buf.append("hsl(");
            }
            buf.append(Integer.toString(hsl.h)).append(',').append(Integer.toString(hsl.s)).append('%').append(',').append(Integer.toString(hsl.l)).append('%');
            if (nonOpaque) {
                buf.append(',');
                this.appendAlphaChannelMinified(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        private String hslMinifiedString(Hsl hsl, boolean nonOpaque) {
            StringBuilder buf = new StringBuilder(20);
            buf.append("hsl(").append(Integer.toString(hsl.h)).append(' ').append(Integer.toString(hsl.s)).append('%').append(' ').append(Integer.toString(hsl.l)).append('%');
            if (nonOpaque) {
                buf.append('/');
                this.appendAlphaChannelMinified(buf);
            }
            buf.append(')');
            return buf.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.blue == null ? 0 : this.colorComponentHashCode(this.blue));
            result = 31 * result + (this.green == null ? 0 : this.colorComponentHashCode(this.green));
            result = 31 * result + (this.red == null ? 0 : this.colorComponentHashCode(this.red));
            result = 31 * result + this.alpha.hashCode();
            return result * 31;
        }

        private int colorComponentHashCode(PrimitiveValue comp) {
            float value = comp.getPrimitiveType() == 2 ? comp.getFloatValue((short)2) * 2.55f : comp.getFloatValue((short)1);
            return Float.floatToIntBits(value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CSSRGBColor)) {
                return false;
            }
            CSSRGBColor other = (CSSRGBColor)obj;
            if (this.blue == null ? other.blue != null : !this.blue.equals(other.blue)) {
                return false;
            }
            if (this.green == null ? other.green != null : !this.green.equals(other.green)) {
                return false;
            }
            if (this.red == null ? other.red != null : !this.red.equals(other.red)) {
                return false;
            }
            return Float.floatToIntBits(other.getFloatAlpha()) == Float.floatToIntBits(this.getFloatAlpha());
        }

        private float getFloatAlpha() {
            return this.alpha.getFloatValue((short)1);
        }

        public CSSRGBColor clone() {
            CSSRGBColor clon = new CSSRGBColor();
            clon.red = this.red.clone();
            clon.green = this.green.clone();
            clon.blue = this.blue.clone();
            clon.setAlpha(this.alpha.clone());
            return clon;
        }
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            ValueFactory factory = new ValueFactory();
            LexicalUnit lu = lunit.getParameters();
            String func = lunit.getFunctionName();
            try {
                if ("rgb".equalsIgnoreCase(func) || "rgba".equalsIgnoreCase(func)) {
                    PrimitiveValue basiccolor = factory.createCSSPrimitiveValue(lu, false);
                    ColorValue.this.color.setRed(basiccolor);
                    lu = lu.getNextLexicalUnit();
                    if (ColorValue.this.commaSyntax = lu.getLexicalUnitType() == 0) {
                        lu = lu.getNextLexicalUnit();
                    }
                    basiccolor = factory.createCSSPrimitiveValue(lu, false);
                    ColorValue.this.color.setGreen(basiccolor);
                    if (ColorValue.this.commaSyntax) {
                        lu = lu.getNextLexicalUnit();
                    }
                    lu = lu.getNextLexicalUnit();
                    basiccolor = factory.createCSSPrimitiveValue(lu, false);
                    ColorValue.this.color.setBlue(basiccolor);
                    lu = lu.getNextLexicalUnit();
                    if (lu != null) {
                        lu = lu.getNextLexicalUnit();
                        ColorValue.this.color.setAlpha(factory.createCSSPrimitiveValue(lu, false));
                        lu = lu.getNextLexicalUnit();
                    }
                    ColorValue.this.colorSpace = RGBAColor.ColorSpace.RGB;
                } else if ("hsl".equalsIgnoreCase(func) || "hsla".equalsIgnoreCase(func)) {
                    PrimitiveValue basiccolor = factory.createCSSPrimitiveValue(lu, false);
                    float hue = basiccolor.getFloatValue((short)11) / 360.0f;
                    if (ColorValue.this.commaSyntax = (lu = lu.getNextLexicalUnit()).getLexicalUnitType() == 0) {
                        lu = lu.getNextLexicalUnit();
                    }
                    basiccolor = factory.createCSSPrimitiveValue(lu, false);
                    float sat = basiccolor.getFloatValue((short)2) / 100.0f;
                    if (ColorValue.this.commaSyntax) {
                        lu = lu.getNextLexicalUnit();
                    }
                    lu = lu.getNextLexicalUnit();
                    basiccolor = factory.createCSSPrimitiveValue(lu, false);
                    float light = basiccolor.getFloatValue((short)2) / 100.0f;
                    if ((lu = lu.getNextLexicalUnit()) != null) {
                        lu = lu.getNextLexicalUnit();
                        ColorValue.this.color.setAlpha(factory.createCSSPrimitiveValue(lu, false));
                        lu = lu.getNextLexicalUnit();
                    }
                    ColorValue.this.translateHSL(hue, sat, light);
                    ColorValue.this.colorSpace = RGBAColor.ColorSpace.HSL;
                } else if ("hwb".equalsIgnoreCase(func)) {
                    PrimitiveValue basiccolor = factory.createCSSPrimitiveValue(lu, false);
                    float hue = basiccolor.getFloatValue((short)11) / 360.0f;
                    boolean commaSyntax = (lu = lu.getNextLexicalUnit()).getLexicalUnitType() == 0;
                    if (commaSyntax) {
                        lu = lu.getNextLexicalUnit();
                    }
                    basiccolor = factory.createCSSPrimitiveValue(lu, false);
                    float whiteness = basiccolor.getFloatValue((short)2) / 100.0f;
                    if (commaSyntax) {
                        lu = lu.getNextLexicalUnit();
                    }
                    lu = lu.getNextLexicalUnit();
                    basiccolor = factory.createCSSPrimitiveValue(lu, false);
                    float blackness = basiccolor.getFloatValue((short)2) / 100.0f;
                    if ((lu = lu.getNextLexicalUnit()) != null) {
                        lu = lu.getNextLexicalUnit();
                        ColorValue.this.color.setAlpha(factory.createCSSPrimitiveValue(lu, false));
                        lu = lu.getNextLexicalUnit();
                    }
                    ColorValue.this.translateHWB(hue, whiteness, blackness);
                    ColorValue.this.colorSpace = RGBAColor.ColorSpace.HWB;
                }
            }
            catch (RuntimeException e) {
                throw new DOMException(12, "Bad value: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }

    private static class Hsl {
        int h;
        int s;
        int l;

        private Hsl() {
        }
    }
}

