/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.property.AbstractCounterValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

class CounterValue
extends AbstractCounterValue {
    public CounterValue() {
        super((short)23);
    }

    protected CounterValue(CounterValue copied) {
        super(copied);
    }

    @Override
    public CounterValue clone() {
        return new CounterValue(this);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        String listStyle;
        StringBuilder buf = new StringBuilder();
        buf.append("counter(").append(this.getName());
        PrimitiveValue style = this.getCounterStyle();
        if (style != null && !"decimal".equalsIgnoreCase(listStyle = style.getCssText())) {
            buf.append(',').append(' ').append(listStyle);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        String listStyle;
        StringBuilder buf = new StringBuilder();
        buf.append("counter(").append(this.getName());
        PrimitiveValue style = this.getCounterStyle();
        if (style != null && !"decimal".equalsIgnoreCase(listStyle = style.getCssText())) {
            buf.append(',').append(listStyle);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("counter(");
        wri.write(this.getName());
        PrimitiveValue listStyle = this.getCounterStyle();
        if (listStyle != null && !CounterValue.isCSSIdentifier(listStyle, "decimal")) {
            wri.write(", ");
            listStyle.writeCssText(wri);
        }
        wri.write(')');
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(CounterValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            CounterValue.this.setName(lu.getStringValue());
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                if (lu.getLexicalUnitType() == 0) {
                    short lutype;
                    if ((lu = lu.getNextLexicalUnit()) == null) {
                        this.badSyntax(lunit);
                    }
                    if ((lutype = lu.getLexicalUnitType()) == 35 || lutype == 41 && "symbols".equalsIgnoreCase(lu.getFunctionName())) {
                        ValueFactory vf = new ValueFactory();
                        PrimitiveValue.LexicalSetter item = vf.createCSSPrimitiveValueItem(lu, false);
                        CounterValue.this.setCounterStyle(item.getCSSValue());
                        if (item.getNextLexicalUnit() != null) {
                            this.badSyntax(lunit);
                        }
                    } else {
                        this.badSyntax(lunit);
                    }
                } else {
                    this.badSyntax(lunit);
                }
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void badSyntax(LexicalUnit lunit) {
            throw new DOMException(12, "Bad counter syntax: " + lunit.toString());
        }
    }
}

