/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSCountersValue;
import io.sf.carte.doc.style.css.property.AbstractCounterValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

class CountersValue
extends AbstractCounterValue
implements CSSCountersValue {
    private String separator = "";

    public CountersValue() {
        super((short)134);
    }

    protected CountersValue(CountersValue copied) {
        super(copied);
        this.separator = copied.separator;
    }

    @Override
    public CountersValue clone() {
        return new CountersValue(this);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public String getCssText() {
        String listStyle;
        StringBuilder buf = new StringBuilder();
        buf.append("counters(").append(this.getName());
        String separator = this.getSeparator();
        buf.append(", ");
        CountersValue.quoteSeparator(separator, buf);
        PrimitiveValue style = this.getCounterStyle();
        if (style != null && !"decimal".equalsIgnoreCase(listStyle = style.getCssText())) {
            buf.append(", ").append(listStyle);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        String listStyle;
        StringBuilder buf = new StringBuilder();
        buf.append("counters(").append(this.getName());
        String separator = this.getSeparator();
        buf.append(',');
        CountersValue.quoteSeparator(separator, buf);
        PrimitiveValue style = this.getCounterStyle();
        if (style != null && !"decimal".equalsIgnoreCase(listStyle = style.getCssText())) {
            buf.append(',').append(listStyle);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("counters(");
        wri.write(this.getName());
        String separator = this.getSeparator();
        wri.write(", ");
        if (!separator.contains("'")) {
            wri.write('\'');
            wri.write(separator);
            wri.write('\'');
        } else {
            wri.write('\"');
            wri.write(separator);
            wri.write('\"');
        }
        PrimitiveValue listStyle = this.getCounterStyle();
        if (listStyle != null && !CountersValue.isCSSIdentifier(listStyle, "decimal")) {
            wri.write(", ");
            listStyle.writeCssText(wri);
        }
        wri.write(')');
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CountersValue other = (CountersValue)obj;
        return !(this.separator == null ? other.separator != null : !this.separator.equals(other.separator));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.separator == null ? 0 : this.separator.hashCode());
        return result;
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            CountersValue.this.setName(lu.getStringValue());
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                if (lu.getLexicalUnitType() == 0) {
                    if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() != 36) {
                        this.badSyntax(lunit);
                    }
                    CountersValue.this.setSeparator(lu.getStringValue());
                    lu = lu.getNextLexicalUnit();
                    if (lu != null) {
                        if (lu.getLexicalUnitType() == 0) {
                            short lutype;
                            if ((lu = lu.getNextLexicalUnit()) == null) {
                                this.badSyntax(lunit);
                            }
                            if ((lutype = lu.getLexicalUnitType()) == 35 || lutype == 41 && "symbols".equalsIgnoreCase(lu.getFunctionName())) {
                                ValueFactory vf = new ValueFactory();
                                PrimitiveValue.LexicalSetter item = vf.createCSSPrimitiveValueItem(lu, false);
                                CountersValue.this.setCounterStyle(item.getCSSValue());
                                if (item.getNextLexicalUnit() != null) {
                                    this.badSyntax(lunit);
                                }
                            } else {
                                this.badSyntax(lunit);
                            }
                        } else {
                            this.badSyntax(lunit);
                        }
                    }
                } else {
                    this.badSyntax(lunit);
                }
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void badSyntax(LexicalUnit lunit) {
            throw new DOMException(12, "Bad counters syntax: " + lunit.toString());
        }
    }
}

