/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSCustomPropertyValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class CustomPropertyValue
extends PrimitiveValue
implements CSSCustomPropertyValue {
    private String name = null;
    private StyleValue fallback = null;
    private boolean expectInteger = false;

    CustomPropertyValue() {
        super((short)128);
        this.fallback = null;
    }

    CustomPropertyValue(StyleValue fallback) {
        super((short)128);
        this.fallback = fallback;
    }

    protected CustomPropertyValue(CustomPropertyValue copied) {
        super(copied);
        this.name = copied.name;
        this.fallback = copied.fallback;
    }

    @Override
    public StyleValue getFallback() {
        return this.fallback;
    }

    public boolean isExpectingInteger() {
        return this.expectInteger;
    }

    @Override
    public void setExpectInteger() {
        this.expectInteger = true;
        if (this.fallback != null) {
            if (this.fallback.getCssValueType() != 1) {
                super.setExpectInteger();
            } else {
                ((PrimitiveValue)this.fallback).setExpectInteger();
            }
        }
    }

    @Override
    public String getCssText() {
        String ftext;
        int sz = this.name.length();
        if (this.fallback == null) {
            sz += 2;
            ftext = null;
        } else {
            ftext = this.fallback.getCssText();
            sz += 4 + ftext.length();
        }
        StringBuilder buf = new StringBuilder(sz);
        buf.append("var(");
        buf.append(this.name);
        if (ftext != null) {
            buf.append(", ");
            buf.append(ftext);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("var(");
        wri.write(this.name);
        if (this.fallback != null) {
            wri.write(", ");
            this.fallback.writeCssText(wri);
        }
        wri.write(')');
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        String ftext;
        int sz = this.name.length();
        if (this.fallback == null) {
            sz += 2;
            ftext = null;
        } else {
            ftext = this.fallback.getMinifiedCssText(propertyName);
            sz += 3 + ftext.length();
        }
        StringBuilder buf = new StringBuilder(sz);
        buf.append("var(");
        buf.append(this.name);
        if (ftext != null) {
            buf.append(',');
            buf.append(ftext);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory factory = new ValueFactory();
        StyleValue cssval = factory.parseProperty(cssText);
        if (cssval == null || cssval.getCssValueType() != 1 || ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() != 128) {
            throw new DOMException(13, "Not a custom property value.");
        }
        CustomPropertyValue customp = (CustomPropertyValue)cssval;
        this.name = customp.getStringValue();
        this.fallback = customp.fallback;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.fallback == null ? 0 : this.fallback.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomPropertyValue other = (CustomPropertyValue)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.fallback == null ? other.fallback != null : !this.fallback.equals(other.fallback));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStringValue() {
        return this.name;
    }

    @Override
    public CustomPropertyValue clone() {
        return new CustomPropertyValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            CustomPropertyValue.this.name = lu.getStringValue();
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

