/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.nsac.LexicalUnit2;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

class ElementReferenceValue
extends PrimitiveValue {
    private String refname = null;

    ElementReferenceValue() {
        super((short)133);
    }

    protected ElementReferenceValue(ElementReferenceValue copied) {
        super(copied);
        this.refname = copied.refname;
    }

    @Override
    public String getCssText() {
        return "element(#" + this.refname + ")";
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("element(#");
        wri.write(this.refname);
        wri.write(')');
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        LexicalUnit2 lu;
        this.checkModifiableProperty();
        InputSource source = new InputSource((Reader)new StringReader(cssText));
        CSSParser parser = new CSSParser();
        try {
            lu = parser.parsePropertyValue(source);
        }
        catch (IOException e) {
            lu = null;
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(5, "Bad element reference: " + cssText);
            ex.initCause(e);
            throw ex;
        }
        if (lu.getLexicalUnitType() != 73 || lu.getNextLexicalUnit() != null) {
            throw new DOMException(13, "Not an element reference: " + cssText);
        }
        PrimitiveValue.LexicalSetter setter = this.newLexicalSetter();
        setter.setLexicalUnit(lu);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.refname == null ? 0 : this.refname.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementReferenceValue other = (ElementReferenceValue)obj;
        return !(this.refname == null ? other.refname != null : !this.refname.equals(other.refname));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getStringValue() {
        return this.refname;
    }

    @Override
    public ElementReferenceValue clone() {
        return new ElementReferenceValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            ElementReferenceValue.this.refname = lunit.getStringValue();
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

