/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSEnvVariableValue;
import io.sf.carte.doc.style.css.ExtendedCSSValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class EnvVariableValue
extends PrimitiveValue
implements CSSEnvVariableValue {
    private String name = null;
    private StyleValue fallback = null;

    EnvVariableValue() {
        super((short)129);
    }

    protected EnvVariableValue(EnvVariableValue copied) {
        super(copied);
        this.name = copied.name;
        if (copied.fallback != null) {
            this.fallback = copied.fallback.clone();
        }
    }

    @Override
    public String getCssText() {
        StringBuilder buf = new StringBuilder();
        buf.append("env(").append(this.name);
        if (this.fallback != null) {
            buf.append(", ").append(this.fallback.getCssText());
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        StringBuilder buf = new StringBuilder();
        buf.append("env(").append(this.name);
        if (this.fallback != null) {
            buf.append(',').append(this.fallback.getMinifiedCssText(propertyName));
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write("env(");
        wri.write(this.name);
        if (this.fallback != null) {
            wri.write(", ");
            this.fallback.writeCssText(wri);
        }
        wri.write(')');
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory factory = new ValueFactory();
        StyleValue cssval = factory.parseProperty(cssText);
        if (cssval == null || cssval.getCssValueType() != 1 || ((CSSPrimitiveValue)((Object)cssval)).getPrimitiveType() != 129) {
            throw new DOMException(13, "Not an environment variable value.");
        }
        EnvVariableValue env = (EnvVariableValue)cssval;
        this.name = env.getName();
        this.fallback = env.fallback;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fallback == null ? 0 : this.fallback.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnvVariableValue other = (EnvVariableValue)obj;
        if (this.fallback == null ? other.fallback != null : !this.fallback.equals(other.fallback)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStringValue() {
        return this.name;
    }

    @Override
    public ExtendedCSSValue getFallback() {
        return this.fallback;
    }

    @Override
    public EnvVariableValue clone() {
        return new EnvVariableValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            if (lu == null || lu.getLexicalUnitType() != 35) {
                throw new DOMException(17, "Variable name must be an identifier");
            }
            EnvVariableValue.this.name = lu.getStringValue();
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                short type = lu.getLexicalUnitType();
                lu = lu.getNextLexicalUnit();
                if (type != 0 || lu == null) {
                    throw new DOMException(5, "Unexpected character");
                }
                ValueFactory factory = new ValueFactory();
                EnvVariableValue.this.fallback = factory.createCSSValue(lu);
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

