/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.ExtendedCSSPrimitiveValue;
import io.sf.carte.doc.style.css.ExtendedCSSValue;
import io.sf.carte.doc.style.css.ExtendedCSSValueList;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.Unit;
import java.util.Iterator;
import org.w3c.dom.DOMException;

public class Evaluator {
    public ExtendedCSSPrimitiveValue evaluateFunction(CSSFunctionValue function) throws DOMException {
        Unit resultUnit = new Unit();
        ExtendedCSSPrimitiveValue result = this.evaluateFunction(function, resultUnit);
        if (Math.abs(resultUnit.getExponent()) > 1) {
            throw new DOMException(17, "Resulting unit is not valid CSS unit.");
        }
        return result;
    }

    ExtendedCSSPrimitiveValue evaluateFunction(CSSFunctionValue function, Unit resultUnit) throws DOMException {
        String name = function.getFunctionName();
        if ("max".equalsIgnoreCase(name)) {
            return this.functionMax(function.getArguments(), resultUnit);
        }
        if ("min".equalsIgnoreCase(name)) {
            return this.functionMin(function.getArguments(), resultUnit);
        }
        if ("clamp".equalsIgnoreCase(name)) {
            return this.functionClamp(function.getArguments(), resultUnit);
        }
        if ("sin".equalsIgnoreCase(name)) {
            return this.functionSin(function.getArguments(), resultUnit);
        }
        if ("cos".equalsIgnoreCase(name)) {
            return this.functionCos(function.getArguments(), resultUnit);
        }
        if ("tan".equalsIgnoreCase(name)) {
            return this.functionTan(function.getArguments(), resultUnit);
        }
        if ("asin".equalsIgnoreCase(name)) {
            return this.functionASin(function.getArguments(), resultUnit);
        }
        if ("acos".equalsIgnoreCase(name)) {
            return this.functionACos(function.getArguments(), resultUnit);
        }
        if ("atan".equalsIgnoreCase(name)) {
            return this.functionATan(function.getArguments(), resultUnit);
        }
        if ("atan2".equalsIgnoreCase(name)) {
            return this.functionATan2(function.getArguments(), resultUnit);
        }
        if ("pow".equalsIgnoreCase(name)) {
            return this.functionPow(function.getArguments(), resultUnit);
        }
        if ("sqrt".equalsIgnoreCase(name)) {
            return this.functionSqrt(function.getArguments(), resultUnit);
        }
        if ("hypot".equalsIgnoreCase(name)) {
            return this.functionHypot(function.getArguments(), resultUnit);
        }
        function = function.clone();
        LinkedCSSValueList args = function.getArguments();
        int sz = args.getLength();
        for (int i = 0; i < sz; ++i) {
            StyleValue value = args.item(i);
            if (value.getCssValueType() != 1) continue;
            args.set(i, (StyleValue)((Object)this.absoluteValue((ExtendedCSSPrimitiveValue)((Object)value))));
        }
        return function;
    }

    private ExtendedCSSPrimitiveValue functionMax(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        short firstUnit;
        if (arguments.getLength() == 0) {
            throw new DOMException(12, "max() functions take at least one argument");
        }
        Iterator it = arguments.iterator();
        ExtendedCSSValue arg = (ExtendedCSSValue)it.next();
        this.enforcePrimitiveType(arg);
        float max = this.floatValue((ExtendedCSSPrimitiveValue)arg, resultUnit);
        short maxUnit = firstUnit = resultUnit.getUnitType();
        float maxInSpecifiedUnit = max;
        while (it.hasNext()) {
            arg = (ExtendedCSSValue)it.next();
            this.enforcePrimitiveType(arg);
            float partial = this.floatValue((ExtendedCSSPrimitiveValue)arg, resultUnit);
            float partialInFirstUnit = NumberValue.floatValueConversion(partial, resultUnit.getUnitType(), firstUnit);
            if (!(max < partialInFirstUnit)) continue;
            max = partialInFirstUnit;
            maxInSpecifiedUnit = partial;
            maxUnit = resultUnit.getUnitType();
        }
        NumberValue value = new NumberValue();
        value.setFloatValue(maxUnit, maxInSpecifiedUnit);
        return value;
    }

    private void enforcePrimitiveType(ExtendedCSSValue arg) throws DOMException {
        if (arg.getCssValueType() != 1) {
            throw new DOMException(12, "Unexpected value: " + arg.getCssText());
        }
    }

    private ExtendedCSSPrimitiveValue functionMin(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        short firstUnit;
        if (arguments.getLength() == 0) {
            throw new DOMException(12, "min() functions take at least one argument");
        }
        Iterator it = arguments.iterator();
        ExtendedCSSValue arg = (ExtendedCSSValue)it.next();
        this.enforcePrimitiveType(arg);
        float min = this.floatValue((ExtendedCSSPrimitiveValue)arg, resultUnit);
        short minUnit = firstUnit = resultUnit.getUnitType();
        float minInSpecifiedUnit = min;
        while (it.hasNext()) {
            arg = (ExtendedCSSValue)it.next();
            this.enforcePrimitiveType(arg);
            float partial = this.floatValue((ExtendedCSSPrimitiveValue)arg, resultUnit);
            float partialInFirstUnit = NumberValue.floatValueConversion(partial, resultUnit.getUnitType(), firstUnit);
            if (!(min > partialInFirstUnit)) continue;
            min = partialInFirstUnit;
            minInSpecifiedUnit = partial;
            minUnit = resultUnit.getUnitType();
        }
        NumberValue value = new NumberValue();
        value.setFloatValue(minUnit, minInSpecifiedUnit);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionClamp(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 3) {
            throw new DOMException(12, "Clamp functions take three arguments");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 1);
        float result = this.floatValue(arg, resultUnit);
        short centralUnit = resultUnit.getUnitType();
        arg = this.primitiveArgument(arguments, 0);
        float min = this.floatValue(arg, resultUnit);
        min = NumberValue.floatValueConversion(min, resultUnit.getUnitType(), centralUnit);
        arg = this.primitiveArgument(arguments, 2);
        float max = this.floatValue(arg, resultUnit);
        if (result > (max = NumberValue.floatValueConversion(max, resultUnit.getUnitType(), centralUnit))) {
            result = max;
        }
        if (result < min) {
            result = min;
        }
        NumberValue value = new NumberValue();
        value.setFloatValue(centralUnit, result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionSin(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "sin() functions take one argument");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        float fval = this.floatValue(arg, resultUnit);
        fval = NumberValue.floatValueConversion(fval, resultUnit.getUnitType(), (short)12);
        float result = (float)Math.sin(fval);
        resultUnit.setUnitType((short)1);
        NumberValue value = new NumberValue();
        value.setFloatValue((short)1, result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionCos(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "cos() functions take one argument");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        float fval = this.floatValue(arg, resultUnit);
        fval = NumberValue.floatValueConversion(fval, resultUnit.getUnitType(), (short)12);
        float result = (float)Math.cos(fval);
        resultUnit.setUnitType((short)1);
        NumberValue value = new NumberValue();
        value.setFloatValue((short)1, result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionTan(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "tan() functions take one argument");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        float fval = this.floatValue(arg, resultUnit);
        fval = NumberValue.floatValueConversion(fval, resultUnit.getUnitType(), (short)12);
        float result = (float)Math.tan(fval);
        resultUnit.setUnitType((short)1);
        NumberValue value = new NumberValue();
        value.setFloatValue((short)1, result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionASin(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "asin() functions take one argument");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        float result = (float)Math.asin(this.floatValue(arg, resultUnit));
        if (resultUnit.getExponent() != 0) {
            throw new DOMException(12, "asin() argument must be dimensionless");
        }
        resultUnit.setUnitType((short)12);
        NumberValue value = new NumberValue();
        value.setFloatValue((short)12, result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionACos(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "acos() functions take one argument");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        float result = (float)Math.acos(this.floatValue(arg, resultUnit));
        if (resultUnit.getExponent() != 0) {
            throw new DOMException(12, "acos() argument must be dimensionless");
        }
        resultUnit.setUnitType((short)12);
        NumberValue value = new NumberValue();
        value.setFloatValue((short)12, result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionATan(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "atan() functions take one argument");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        float f1 = this.floatValue(arg, resultUnit);
        if (resultUnit.getExponent() != 0) {
            throw new DOMException(12, "atan() argument must be dimensionless");
        }
        float result = (float)Math.atan(f1);
        resultUnit.setUnitType((short)12);
        NumberValue value = new NumberValue();
        value.setFloatValue((short)12, result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionATan2(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 2) {
            throw new DOMException(12, "atan2() functions take two arguments");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        ExtendedCSSPrimitiveValue arg2 = this.primitiveArgument(arguments, 1);
        float f1 = this.floatValue(arg, resultUnit);
        if (resultUnit.getUnitType() != 1) {
            throw new DOMException(12, "atan2() arguments must be dimensionless");
        }
        float f2 = this.floatValue(arg2, resultUnit);
        if (resultUnit.getExponent() != 0) {
            throw new DOMException(12, "atan2() arguments must be dimensionless");
        }
        float result = (float)Math.atan2(f1, f2);
        resultUnit.setUnitType((short)12);
        NumberValue value = new NumberValue();
        value.setFloatValue((short)12, result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionPow(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 2) {
            throw new DOMException(12, "pow() functions take two arguments");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        ExtendedCSSPrimitiveValue arg2 = this.primitiveArgument(arguments, 1);
        resultUnit.setUnitType(arg.getPrimitiveType());
        float base = this.floatValue(arg, resultUnit);
        Unit expUnit = new Unit();
        float exponent = this.floatValue(arg2, expUnit);
        if (expUnit.getExponent() != 0) {
            throw new DOMException(12, "pow() exponent cannot have a dimension");
        }
        float result = (float)Math.pow(base, exponent);
        resultUnit.setExponent(resultUnit.getExponent() * Math.round(exponent));
        NumberValue value = new NumberValue();
        value.setFloatValue(resultUnit.getUnitType(), result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionSqrt(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        if (arguments.getLength() != 1) {
            throw new DOMException(12, "sqrt() functions take one argument");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        float result = (float)Math.sqrt(this.floatValue(arg, resultUnit));
        NumberValue value = new NumberValue();
        int exp = resultUnit.getExponent();
        if (exp % 2 != 0) {
            throw new DOMException(15, "invalid CSS unit in sqrt() function");
        }
        resultUnit.setExponent(exp / 2);
        value.setFloatValue(resultUnit.getUnitType(), result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionHypot(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        int len = arguments.getLength();
        if (len == 2) {
            return this.functionHypot2(arguments, resultUnit);
        }
        if (len == 0) {
            throw new DOMException(12, "hypot() functions need at least one argument.");
        }
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        float partial = this.floatValue(arg, resultUnit);
        double result = partial * partial;
        short firstUnit = resultUnit.getUnitType();
        for (int i = 1; i < len; ++i) {
            arg = this.primitiveArgument(arguments, i);
            partial = this.floatValue(arg, resultUnit);
            if (firstUnit != resultUnit.getUnitType()) {
                partial = NumberValue.floatValueConversion(partial, resultUnit.getUnitType(), firstUnit);
            }
            result += (double)(partial * partial);
        }
        result = Math.sqrt(result);
        NumberValue value = new NumberValue();
        value.setFloatValue(firstUnit, (float)result);
        return value;
    }

    private ExtendedCSSPrimitiveValue functionHypot2(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, Unit resultUnit) throws DOMException {
        ExtendedCSSPrimitiveValue arg = this.primitiveArgument(arguments, 0);
        ExtendedCSSPrimitiveValue arg2 = this.primitiveArgument(arguments, 1);
        Unit arg2Type = new Unit();
        float f1 = this.floatValue(arg, resultUnit);
        float f2 = this.floatValue(arg2, arg2Type);
        if (resultUnit.getUnitType() != arg2Type.getUnitType()) {
            f2 = NumberValue.floatValueConversion(f2, arg2Type.getUnitType(), resultUnit.getUnitType());
        }
        float result = (float)Math.hypot(f1, f2);
        NumberValue value = new NumberValue();
        value.setFloatValue(resultUnit.getUnitType(), result);
        return value;
    }

    private ExtendedCSSPrimitiveValue primitiveArgument(ExtendedCSSValueList<? extends ExtendedCSSValue> arguments, int index) {
        ExtendedCSSValue arg = arguments.item(index);
        this.enforcePrimitiveType(arg);
        return (ExtendedCSSPrimitiveValue)arg;
    }

    private float floatValue(ExtendedCSSPrimitiveValue value, Unit resultUnit) throws DOMException {
        float result;
        value = this.evaluate(value, resultUnit);
        short resultType = resultUnit.getUnitType();
        short type = value.getPrimitiveType();
        if (type == 1) {
            result = value.getFloatValue((short)1);
        } else if (type != 2) {
            result = value.getFloatValue(resultType);
        } else {
            result = this.percentage(value, (short)9);
            resultUnit.setUnitType((short)9);
        }
        return result;
    }

    public ExtendedCSSPrimitiveValue evaluateExpression(ExpressionValue calc) throws DOMException {
        Unit resultUnit = new Unit();
        ExtendedCSSPrimitiveValue result = this.evaluateExpression(calc.getExpression(), resultUnit);
        if (Math.abs(resultUnit.getExponent()) > 1) {
            throw new DOMException(17, "Resulting unit is not valid CSS unit.");
        }
        if (calc.mustRoundResult() && result.isCalculatedNumber()) {
            ((NumberValue)result).roundToInteger();
        }
        return result;
    }

    ExtendedCSSPrimitiveValue evaluateExpression(CSSExpression expression, Unit resultUnit) throws DOMException {
        float result;
        switch (expression.getPartType()) {
            case SUM: {
                AlgebraicExpression sum = (AlgebraicExpression)expression;
                result = this.sum(sum, resultUnit);
                if (expression.getParentExpression() != null || !expression.isInverseOperation()) break;
                result = -result;
                break;
            }
            case PRODUCT: {
                AlgebraicExpression prod = (AlgebraicExpression)expression;
                result = this.multiply(prod, resultUnit);
                break;
            }
            default: {
                return this.evaluate(((CSSOperandExpression)expression).getOperand(), resultUnit);
            }
        }
        NumberValue value = new NumberValue();
        value.setFloatValue(resultUnit.getUnitType(), result);
        value.setCalculatedNumber(true);
        value.setAbsolutizedUnit();
        return value;
    }

    private float sum(AlgebraicExpression sumop, Unit resultUnit) throws DOMException {
        int len = sumop.getLength();
        if (len == 0) {
            throw new DOMException(12, "Sum without operands.");
        }
        CSSExpression op = sumop.item(0);
        float result = this.floatValue(this.evaluateExpression(op, resultUnit), resultUnit);
        if (op.isInverseOperation()) {
            result = -result;
        }
        short firstUnit = resultUnit.getUnitType();
        for (int i = 1; i < len; ++i) {
            op = sumop.item(i);
            float partial = this.floatValue(this.evaluateExpression(op, resultUnit), resultUnit);
            short partialUnit = resultUnit.getUnitType();
            if (firstUnit != partialUnit) {
                partial = NumberValue.floatValueConversion(partial, partialUnit, firstUnit);
            }
            if (op.isInverseOperation()) {
                result -= partial;
                continue;
            }
            result += partial;
        }
        resultUnit.setUnitType(firstUnit);
        return result;
    }

    private float multiply(AlgebraicExpression product, Unit resultUnit) throws DOMException {
        float result = 1.0f;
        short firstUnit = 1;
        int unitExp = 0;
        int len = product.getLength();
        for (int i = 0; i < len; ++i) {
            CSSExpression op = product.item(i);
            ExtendedCSSPrimitiveValue partialValue = this.evaluateExpression(op, resultUnit);
            float partial = this.floatValue(partialValue, resultUnit);
            short partialUnit = resultUnit.getUnitType();
            if (partialUnit != 1) {
                if (firstUnit == 1) {
                    firstUnit = partialUnit;
                } else {
                    try {
                        partial = NumberValue.floatValueConversion(partial, partialUnit, firstUnit);
                    }
                    catch (DOMException e) {
                        if (op.isInverseOperation()) {
                            throw e;
                        }
                        partial = this.unitCancellation(partial, partialUnit, firstUnit, e);
                        if (--unitExp == 0) {
                            firstUnit = 1;
                        }
                        result *= partial;
                        continue;
                    }
                    partialUnit = firstUnit;
                }
            }
            if (op.isInverseOperation()) {
                if (partialUnit != 1) {
                    firstUnit = --unitExp != 0 ? partialUnit : (short)1;
                }
                if (!Float.isNaN(result /= partial)) continue;
                throw new DOMException(15, "Found NaN.");
            }
            if (partialUnit != 1) {
                firstUnit = ++unitExp != 0 ? partialUnit : (short)1;
            }
            result *= partial;
        }
        if (unitExp < 0) {
            if (firstUnit == 16) {
                firstUnit = 15;
                unitExp = -unitExp;
            } else if (firstUnit == 17) {
                firstUnit = 14;
                unitExp = -unitExp;
            } else if (firstUnit == 15) {
                firstUnit = 16;
                unitExp = -unitExp;
            } else if (firstUnit == 14) {
                firstUnit = 17;
                unitExp = -unitExp;
            }
        }
        resultUnit.setUnitType(firstUnit);
        resultUnit.setExponent(unitExp);
        return result;
    }

    private float unitCancellation(float partial, short partialUnit, short firstUnit, DOMException exception) throws DOMException {
        if (partialUnit == 15 || partialUnit == 14) {
            if (firstUnit == 16) {
                return NumberValue.floatValueConversion(partial, partialUnit, (short)15);
            }
            if (firstUnit == 17) {
                return NumberValue.floatValueConversion(partial, partialUnit, (short)14);
            }
        } else if (partialUnit == 16 || partialUnit == 17) {
            if (firstUnit == 15) {
                return NumberValue.floatValueConversion(partial, partialUnit, (short)16);
            }
            if (firstUnit == 14) {
                return NumberValue.floatValueConversion(partial, partialUnit, (short)17);
            }
        }
        throw exception;
    }

    private ExtendedCSSPrimitiveValue evaluate(ExtendedCSSPrimitiveValue partialValue, Unit resultUnit) {
        short pType = partialValue.getPrimitiveType();
        if (pType == 127) {
            partialValue = this.evaluateFunction((CSSFunctionValue)partialValue, resultUnit);
        } else if (pType == 101) {
            CSSExpression expr = ((ExpressionValue)partialValue).getExpression();
            partialValue = this.evaluateExpression(expr, resultUnit);
        } else {
            partialValue = this.absoluteValue(partialValue);
            resultUnit.setUnitType(partialValue.getPrimitiveType());
        }
        return partialValue;
    }

    protected ExtendedCSSPrimitiveValue absoluteValue(ExtendedCSSPrimitiveValue partialValue) {
        return partialValue;
    }

    protected float percentage(ExtendedCSSPrimitiveValue value, short resultType) throws DOMException {
        throw new DOMException(9, "Unexpected percentage in calc()");
    }
}

